/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.api.TableException;

public class RexWindowBoundJsonSerializer
extends StdSerializer<RexWindowBound> {
    public static final String FIELD_NAME_KIND = "kind";
    public static final String KIND_CURRENT_ROW = "CURRENT_ROW";
    public static final String KIND_UNBOUNDED_PRECEDING = "UNBOUNDED_PRECEDING";
    public static final String KIND_UNBOUNDED_FOLLOWING = "UNBOUNDED_FOLLOWING";
    public static final String KIND_BOUNDED_WINDOW = "BOUNDED_WINDOW";
    public static final String FIELD_NAME_IS_PRECEDING = "isPreceding";
    public static final String FIELD_NAME_IS_FOLLOWING = "isFollowing";
    public static final String FIELD_NAME_OFFSET = "offset";

    public RexWindowBoundJsonSerializer() {
        super(RexWindowBound.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serialize(RexWindowBound rexWindowBound, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        gen.writeStartObject();
        if (rexWindowBound.isCurrentRow()) {
            gen.writeStringField(FIELD_NAME_KIND, KIND_CURRENT_ROW);
        } else if (rexWindowBound.isUnbounded()) {
            if (rexWindowBound.isPreceding()) {
                gen.writeStringField(FIELD_NAME_KIND, KIND_UNBOUNDED_PRECEDING);
            } else {
                if (!rexWindowBound.isFollowing()) throw new TableException("Unknown RexWindowBound: " + rexWindowBound);
                gen.writeStringField(FIELD_NAME_KIND, KIND_UNBOUNDED_FOLLOWING);
            }
        } else {
            gen.writeStringField(FIELD_NAME_KIND, KIND_BOUNDED_WINDOW);
            if (rexWindowBound.isPreceding()) {
                gen.writeBooleanField(FIELD_NAME_IS_PRECEDING, true);
            } else {
                if (!rexWindowBound.isFollowing()) throw new TableException("Unknown RexWindowBound: " + rexWindowBound);
                gen.writeBooleanField(FIELD_NAME_IS_FOLLOWING, true);
            }
            gen.writeObjectField(FIELD_NAME_OFFSET, (Object)rexWindowBound.getOffset());
        }
        gen.writeEndObject();
    }
}

