/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.flink.table.planner.plan.nodes.ExpressionFormat$;
import org.apache.flink.table.planner.plan.nodes.FlinkRelNode;
import org.apache.flink.table.planner.plan.utils.RelDescriptionWriterImpl;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;

public abstract class FlinkRelNode$class {
    public static String getRelDetailedDescription(FlinkRelNode $this) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        RelDescriptionWriterImpl relWriter = new RelDescriptionWriterImpl(pw);
        $this.explain(relWriter);
        return sw.toString();
    }

    public static String getExpressionString(FlinkRelNode $this, RexNode expr, List inFields, Option localExprsTable) {
        return $this.getExpressionString(expr, (List<String>)inFields, (Option<List<RexNode>>)localExprsTable, ExpressionFormat$.MODULE$.Prefix());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getExpressionString(FlinkRelNode $this, RexNode expr, List inFields, Option localExprsTable, Enumeration.Value expressionFormat) {
        boolean bl = false;
        RexLocalRef rexLocalRef = null;
        RexNode rexNode = expr;
        if (rexNode instanceof RexPatternFieldRef) {
            RexPatternFieldRef rexPatternFieldRef = (RexPatternFieldRef)rexNode;
            String alpha = rexPatternFieldRef.getAlpha();
            String field = (String)JavaConversions$.MODULE$.seqAsJavaList((Seq)inFields).get(rexPatternFieldRef.getIndex());
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{alpha, field}));
        }
        if (rexNode instanceof RexInputRef) {
            RexInputRef rexInputRef = (RexInputRef)rexNode;
            return (String)JavaConversions$.MODULE$.seqAsJavaList((Seq)inFields).get(rexInputRef.getIndex());
        }
        if (rexNode instanceof RexLiteral) {
            RexLiteral rexLiteral = (RexLiteral)rexNode;
            return rexLiteral.toString();
        }
        if (rexNode instanceof RexLocalRef) {
            bl = true;
            rexLocalRef = (RexLocalRef)rexNode;
            if (localExprsTable.isEmpty()) {
                throw new IllegalArgumentException("Encountered RexLocalRef without local expression table");
            }
        }
        if (bl) {
            RexNode lExpr = (RexNode)((LinearSeqOptimized)localExprsTable.get()).apply(rexLocalRef.getIndex());
            return $this.getExpressionString(lExpr, (List<String>)inFields, (Option<List<RexNode>>)localExprsTable, expressionFormat);
        }
        if (rexNode instanceof RexCall) {
            String string2;
            String string3;
            RexCall rexCall = (RexCall)rexNode;
            String op = rexCall.getOperator().toString();
            Buffer ops = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(rexCall.getOperands()).map((Function1)new Serializable($this, inFields, localExprsTable, expressionFormat){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FlinkRelNode $outer;
                private final List inFields$1;
                private final Option localExprsTable$1;
                private final Enumeration.Value expressionFormat$1;

                public final String apply(RexNode x$1) {
                    return this.$outer.getExpressionString(x$1, (List<String>)this.inFields$1, (Option<List<RexNode>>)this.localExprsTable$1, this.expressionFormat$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.inFields$1 = inFields$1;
                    this.localExprsTable$1 = localExprsTable$1;
                    this.expressionFormat$1 = expressionFormat$1;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            SqlOperator sqlOperator = rexCall.getOperator();
            if (sqlOperator instanceof SqlAsOperator) {
                string3 = (String)ops.head();
                return string3;
            }
            if (JavaConversions$.MODULE$.bufferAsJavaList(ops).size() == 1) {
                String string4;
                String operand = (String)ops.head();
                Enumeration.Value value2 = expressionFormat;
                Enumeration.Value value3 = ExpressionFormat$.MODULE$.Infix();
                Enumeration.Value value4 = value2;
                if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                    SqlKind sqlKind = rexCall.getKind();
                    boolean bl2 = ((Object)((Object)SqlKind.IS_FALSE)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.IS_NOT_FALSE)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.IS_TRUE)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.IS_NOT_TRUE)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.IS_UNKNOWN)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.IS_NULL)).equals((Object)sqlKind) ? true : ((Object)((Object)SqlKind.IS_NOT_NULL)).equals((Object)sqlKind))))));
                    String string5 = bl2 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operand, op})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{op, operand}));
                    string4 = string5;
                } else {
                    Enumeration.Value value5 = ExpressionFormat$.MODULE$.PostFix();
                    Enumeration.Value value6 = value2;
                    if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                        string4 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operand, op}));
                    } else {
                        Enumeration.Value value7 = ExpressionFormat$.MODULE$.Prefix();
                        Enumeration.Value value8 = value2;
                        if (value7 == null) {
                            if (value8 != null) {
                                throw new MatchError((Object)value2);
                            }
                        } else if (!value7.equals(value8)) throw new MatchError((Object)value2);
                        string4 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{op, operand}));
                    }
                }
                string2 = string4;
            } else {
                String string6;
                SqlKind sqlKind = rexCall.getKind();
                boolean bl3 = ((Object)((Object)SqlKind.TIMES)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.DIVIDE)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.PLUS)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.MINUS)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.LESS_THAN)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.LESS_THAN_OR_EQUAL)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.GREATER_THAN)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.GREATER_THAN_OR_EQUAL)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.EQUALS)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.NOT_EQUALS)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.OR)).equals((Object)sqlKind) ? true : ((Object)((Object)SqlKind.AND)).equals((Object)sqlKind)))))))))));
                if (bl3) {
                    String string7;
                    Enumeration.Value value9 = expressionFormat;
                    Enumeration.Value value10 = ExpressionFormat$.MODULE$.Infix();
                    Enumeration.Value value11 = value9;
                    if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                        string7 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ops.mkString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{op})))}));
                    } else {
                        Enumeration.Value value12 = ExpressionFormat$.MODULE$.PostFix();
                        Enumeration.Value value13 = value9;
                        if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                            string7 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ops.mkString(", "), op}));
                        } else {
                            Enumeration.Value value14 = ExpressionFormat$.MODULE$.Prefix();
                            Enumeration.Value value15 = value9;
                            if (value14 == null) {
                                if (value15 != null) {
                                    throw new MatchError((Object)value9);
                                }
                            } else if (!value14.equals(value15)) throw new MatchError((Object)value9);
                            string7 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{op, ops.mkString(", ")}));
                        }
                    }
                    string6 = string7;
                } else {
                    string6 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{op, ops.mkString(", ")}));
                }
                string2 = string6;
            }
            string3 = string2;
            return string3;
        }
        if (rexNode instanceof RexFieldAccess) {
            RexFieldAccess rexFieldAccess = (RexFieldAccess)rexNode;
            String referenceExpr = $this.getExpressionString(rexFieldAccess.getReferenceExpr(), (List<String>)inFields, (Option<List<RexNode>>)localExprsTable, expressionFormat);
            String field = rexFieldAccess.getField().getName();
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{referenceExpr, field}));
        }
        if (!(rexNode instanceof RexCorrelVariable)) throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown expression type '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expr.getClass(), expr})));
        RexCorrelVariable rexCorrelVariable = (RexCorrelVariable)rexNode;
        return rexCorrelVariable.toString();
    }

    public static void $init$(FlinkRelNode $this) {
    }
}

