/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.util.Collections;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.delegation.PlannerFactory;
import org.apache.flink.table.planner.delegation.BatchPlanner;
import org.apache.flink.table.planner.delegation.StreamPlanner;

@Internal
public final class DefaultPlannerFactory
implements PlannerFactory {
    public String factoryIdentifier() {
        return "default";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Collections.emptySet();
    }

    public Planner create(PlannerFactory.Context context) {
        RuntimeExecutionMode runtimeExecutionMode = (RuntimeExecutionMode)context.getTableConfig().getConfiguration().get(ExecutionOptions.RUNTIME_MODE);
        switch (runtimeExecutionMode) {
            case STREAMING: {
                return new StreamPlanner(context.getExecutor(), context.getTableConfig(), context.getFunctionCatalog(), context.getCatalogManager());
            }
            case BATCH: {
                return new BatchPlanner(context.getExecutor(), context.getTableConfig(), context.getFunctionCatalog(), context.getCatalogManager());
            }
        }
        throw new TableException(String.format("Unknown runtime mode '%s'. This is a bug. Please consider filing an issue.", runtimeExecutionMode));
    }
}

