/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeTransform;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class SqlTypeTransformCascade
implements SqlReturnTypeInference {
    private final SqlReturnTypeInference rule;
    private final ImmutableList<SqlTypeTransform> transforms;

    public SqlTypeTransformCascade(SqlReturnTypeInference rule, SqlTypeTransform ... transforms) {
        Preconditions.checkArgument(transforms.length > 0);
        this.rule = Objects.requireNonNull(rule);
        this.transforms = ImmutableList.copyOf(transforms);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataType ret = this.rule.inferReturnType(opBinding);
        if (ret == null) {
            return null;
        }
        for (SqlTypeTransform transform2 : this.transforms) {
            ret = transform2.transformType(opBinding, ret);
        }
        return ret;
    }
}

