/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class ObjectCacheTable<K, T> {
    private Map<K, T> m_hashTable = Collections.synchronizedMap(new HashMap());
    private Object[] m_lru;
    private boolean[] m_places;
    private int m_index;

    public ObjectCacheTable(int maxSize) {
        this.m_lru = new Object[maxSize];
        this.m_places = new boolean[maxSize];
        this.m_index = 0;
        for (int i = 0; i < maxSize; ++i) {
            this.m_places[i] = false;
        }
    }

    boolean contains(K key) {
        return this.m_hashTable.containsKey(key);
    }

    T get(K key) {
        return this.m_hashTable.get(key);
    }

    void add(K key, T value2) {
        if (this.m_places[this.m_index]) {
            this.m_places[this.m_index] = false;
            this.m_hashTable.remove(this.m_lru[this.m_index]);
        }
        this.m_hashTable.put(key, value2);
        this.m_lru[this.m_index] = key;
        this.m_places[this.m_index] = true;
        this.m_index = (this.m_index + 1) % this.m_lru.length;
    }
}

