/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.util.ArrayList;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.calcite.schema.Schema;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.expressions.resolver.ExpressionResolver;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.catalog.CatalogManagerCalciteSchema;
import org.apache.flink.table.planner.delegation.ParserImpl;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.utils.CatalogManagerMocks;

public class PlannerMocks {
    public static FlinkPlannerImpl createDefaultPlanner() {
        TableConfig tableConfig = new TableConfig();
        CatalogManager catalogManager = CatalogManagerMocks.createEmptyCatalogManager();
        ModuleManager moduleManager = new ModuleManager();
        FunctionCatalog functionCatalog = new FunctionCatalog(tableConfig, catalogManager, moduleManager);
        PlannerContext plannerContext = new PlannerContext(false, tableConfig, functionCatalog, catalogManager, CalciteSchemaBuilder.asRootSchema((Schema)new CatalogManagerCalciteSchema(catalogManager, true)), new ArrayList());
        FlinkPlannerImpl planner = plannerContext.createFlinkPlanner(catalogManager.getCurrentCatalog(), catalogManager.getCurrentDatabase());
        ParserImpl parser = new ParserImpl(catalogManager, () -> planner, () -> ((FlinkPlannerImpl)planner).parser(), plannerContext.getSqlExprToRexConverterFactory());
        catalogManager.initSchemaResolver(true, ExpressionResolver.resolverFor((TableConfig)tableConfig, name -> {
            throw new UnsupportedOperationException();
        }, (FunctionLookup)functionCatalog.asLookup(arg_0 -> ((Parser)parser).parseIdentifier(arg_0)), (DataTypeFactory)catalogManager.getDataTypeFactory(), (arg_0, arg_1, arg_2) -> ((Parser)parser).parseSqlExpression(arg_0, arg_1, arg_2), (QueryOperation[])new QueryOperation[0]));
        return planner;
    }

    private PlannerMocks() {
    }
}

