/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.table;

import java.io.File;
import java.util.TimeZone;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.GroupWindow;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Tumble;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment$;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.stream.table.LegacyTableSinkITCase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendTableSink;
import org.apache.flink.table.planner.runtime.utils.TestingRetractTableSink;
import org.apache.flink.table.planner.runtime.utils.TestingUpsertTableSink;
import org.apache.flink.table.planner.utils.MemoryTableSourceSinkUtil$;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.sinks.CsvTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.utils.LegacyRowResource;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001%\t)B*Z4bGf$\u0016M\u00197f'&t7.\u0013+DCN,'BA\u0002\u0005\u0003\u0015!\u0018M\u00197f\u0015\t)a!\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u000f!\tqA];oi&lWM\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0002\f\u0015\taQ\"A\u0003gY&t7N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0003\u0001M\u0001\"\u0001F\r\u000e\u0003UQ!AF\f\u0002\tU$\u0018\u000e\u001c\u0006\u00031-\tA\u0001^3ti&\u0011!$\u0006\u0002\u0011\u0003\n\u001cHO]1diR+7\u000f\u001e\"bg\u0016DQ\u0001\b\u0001\u0005\u0002u\ta\u0001P5oSRtD#\u0001\u0010\u0011\u0005}\u0001Q\"\u0001\u0002\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002\u001dU\u001cXm\u001d'fO\u0006\u001c\u0017PU8xgV\t1\u0005\u0005\u0002%O5\tQE\u0003\u0002'\u0015\u0005)Q\u000f^5mg&\u0011\u0001&\n\u0002\u0012\u0019\u0016<\u0017mY=S_^\u0014Vm]8ve\u000e,\u0007F\u0001\u0011+!\tYc&D\u0001-\u0015\tis\"A\u0003kk:LG/\u0003\u00020Y\t!!+\u001e7f\u0011\u0015\t\u0004\u0001\"\u00013\u0003M!Xm\u001d;TiJ,\u0017-\u001c+bE2,7+\u001b8l)\u0005\u0019\u0004C\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$\u0001B+oSRD#\u0001\r\u001e\u0011\u0005-Z\u0014B\u0001\u001f-\u0005\u0011!Vm\u001d;\t\u000by\u0002A\u0011\u0001\u001a\u00027Q,7\u000f^!qa\u0016tGmU5oW>s\u0017\t\u001d9f]\u0012$\u0016M\u00197fQ\ti$\bC\u0003B\u0001\u0011\u0005!'A\u000euKN$\u0018\t\u001d9f]\u0012\u001c\u0016N\\6XSRDg*Z:uK\u0012\u0014vn\u001e\u0015\u0003\u0001jBQ\u0001\u0012\u0001\u0005\u0002I\nq\u0005^3ti\u0006\u0003\b/\u001a8e'&t7n\u00148BaB,g\u000e\u001a+bE2,gi\u001c:J]:,'OS8j]\"\u00121I\u000f\u0005\u0006\u000f\u0002!\tAM\u0001\u001fi\u0016\u001cHOU3ue\u0006\u001cGoU5oW>sW\u000b\u001d3bi&tw\rV1cY\u0016D#A\u0012\u001e\t\u000b)\u0003A\u0011\u0001\u001a\u00029Q,7\u000f\u001e*fiJ\f7\r^*j].|e.\u00119qK:$G+\u00192mK\"\u0012\u0011J\u000f\u0005\u0006\u001b\u0002!\tAM\u0001)i\u0016\u001cH/\u00169tKJ$8+\u001b8l\u001f:,\u0006\u000fZ1uS:<G+\u00192mK^KG\u000f\u001b$vY2\\U-\u001f\u0015\u0003\u0019jBQ\u0001\u0015\u0001\u0005\u0002I\n!\u0006^3tiV\u00038/\u001a:u'&t7n\u00148BaB,g\u000eZ5oOR\u000b'\r\\3XSRDg)\u001e7m\u0017\u0016L\u0018\u0007\u000b\u0002Pu!)1\u000b\u0001C\u0001e\u0005QC/Z:u+B\u001cXM\u001d;TS:\\wJ\\!qa\u0016tG-\u001b8h)\u0006\u0014G.Z,ji\"4U\u000f\u001c7LKf\u0014\u0004F\u0001*;\u0011\u00151\u0006\u0001\"\u00013\u00035\"Xm\u001d;VaN,'\u000f^*j].|e.\u00119qK:$\u0017N\\4UC\ndWmV5uQ>,HOR;mY.+\u00170\r\u0015\u0003+jBQ!\u0017\u0001\u0005\u0002I\nQ\u0006^3tiV\u00038/\u001a:u'&t7n\u00148BaB,g\u000eZ5oOR\u000b'\r\\3XSRDw.\u001e;Gk2d7*Z=3Q\tA&\bC\u0003]\u0001\u0011\u0005!'\u0001\ruKN$X\u000b]:feR\u001c\u0016N\\6XSRDg)\u001b7uKJD#a\u0017\u001e\t\u000b}\u0003A\u0011\u0001\u001a\u0002=Q,7\u000f\u001e+p\u0003B\u0004XM\u001c3TiJ,\u0017-\\'vYRL'k\\<uS6,\u0007\u0006\u00020;C\n\f\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002GB\u0011AmZ\u0007\u0002K*\u0011aMC\u0001\u0004CBL\u0017B\u00015f\u00059!\u0016M\u00197f\u000bb\u001cW\r\u001d;j_:DQA\u001b\u0001\u0005\u0002I\nq\u0004^3tiR{'+\u001a;sC\u000e$8\u000b\u001e:fC6lU\u000f\u001c;j%><H/[7fQ\u0011I'(\u00192\t\u000b5\u0004A\u0011\u0001\u001a\u0002AQ,7\u000f\u001e#fG&l\u0017\r\\!qa\u0016tGm\u0015;sK\u0006lG+\u00192mKNKgn\u001b\u0015\u0003Yj\u0002")
public class LegacyTableSinkITCase
extends AbstractTestBase {
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("id");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("num");
    private static Symbol symbol$6 = Symbol$.MODULE$.apply("text");
    private static Symbol symbol$7 = Symbol$.MODULE$.apply("rowtime");
    private static Symbol symbol$8 = Symbol$.MODULE$.apply("w");
    private static Symbol symbol$9 = Symbol$.MODULE$.apply("t");
    private static Symbol symbol$10 = Symbol$.MODULE$.apply("icnt");
    private static Symbol symbol$11 = Symbol$.MODULE$.apply("nsum");
    private static Symbol symbol$12 = Symbol$.MODULE$.apply("d");
    private static Symbol symbol$13 = Symbol$.MODULE$.apply("e");
    private static Symbol symbol$14 = Symbol$.MODULE$.apply("f");
    private static Symbol symbol$15 = Symbol$.MODULE$.apply("g");
    private static Symbol symbol$16 = Symbol$.MODULE$.apply("h");
    private static Symbol symbol$17 = Symbol$.MODULE$.apply("len");
    private static Symbol symbol$18 = Symbol$.MODULE$.apply("cTrue");
    private static Symbol symbol$19 = Symbol$.MODULE$.apply("count");
    private static Symbol symbol$20 = Symbol$.MODULE$.apply("lencnt");
    private static Symbol symbol$21 = Symbol$.MODULE$.apply("window_end");
    private static Symbol symbol$22 = Symbol$.MODULE$.apply("wstart");
    private static Symbol symbol$23 = Symbol$.MODULE$.apply("wend");
    private static Symbol symbol$24 = Symbol$.MODULE$.apply("cnt");
    private static Symbol symbol$25 = Symbol$.MODULE$.apply("rowtime2");

    @Rule
    public LegacyRowResource usesLegacyRows() {
        return LegacyRowResource.INSTANCE;
    }

    @Test
    public void testStreamTableSink() {
        File tmpFile = File.createTempFile("flink-table-sink-test", ".tmp");
        tmpFile.delete();
        tmpFile.deleteOnExit();
        String path = tmpFile.toURI().toString();
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        env.setParallelism(4);
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("csvSink", new CsvTableSink(path).configure((String[])((Object[])new String[]{"nullableCol", "c", "b"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.STRING(), Types.SQL_TIMESTAMP()})));
        DataStream input = env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$18 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$18 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignAscendingTimestamps((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple3<Object, Object, String> x$1) {
                return BoxesRunTime.unboxToLong((Object)x$1._2());
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, String> apply(Tuple3<Object, Object, String> x) {
                return x;
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$19 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$19 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).setParallelism(4);
        Table table = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(input).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$2).rowtime(), package$.MODULE$.symbol2FieldExpression(symbol$3)})).where(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression(symbol$1).$less(package$.MODULE$.int2Literal(5))).$bar$bar(package$.MODULE$.UnresolvedFieldExpression(symbol$1).$greater(package$.MODULE$.int2Literal(17)))).select(new Expression[]{package$.MODULE$.ifThenElse(package$.MODULE$.UnresolvedFieldExpression(symbol$1).$less(package$.MODULE$.int2Literal(4)), package$.MODULE$.nullOf(Types.INT()), package$.MODULE$.symbol2FieldExpression(symbol$1)), package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$2)});
        table.executeInsert("csvSink").await();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{",Hello world,1970-01-01 00:00:00.002", ",Hello,1970-01-01 00:00:00.002", ",Hi,1970-01-01 00:00:00.001", "18,Comment#12,1970-01-01 00:00:00.006", "19,Comment#13,1970-01-01 00:00:00.006", "20,Comment#14,1970-01-01 00:00:00.006", "21,Comment#15,1970-01-01 00:00:00.006", "4,Hello world, how are you?,1970-01-01 00:00:00.003"}))).mkString("\n");
        TestBaseUtils.compareResultsByLinesInMemory((String)expected, (String)path);
    }

    @Test
    public void testAppendSinkOnAppendTable() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$20 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$20 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignAscendingTimestamps((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple3<Object, Object, String> x$2) {
                return BoxesRunTime.unboxToInt((Object)x$2._1());
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        TestingAppendTableSink sink = new TestingAppendTableSink(TimeZone.getDefault());
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("appendSink", (TableSink)sink.configure((String[])((Object[])new String[]{"t", "icnt", "nsum"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.SQL_TIMESTAMP(), Types.LONG(), Types.LONG()}))));
        Table table = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).millis())).on(package$.MODULE$.symbol2FieldExpression(symbol$7)).as(package$.MODULE$.symbol2FieldExpression(symbol$8))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$8)}).select(new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$8).end()).as(symbol$9, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).count()).as(symbol$10, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$5).sum()).as(symbol$11, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        table.executeInsert("appendSink").await();
        List result = (List)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01 00:00:00.005,4,8", "1970-01-01 00:00:00.010,5,18", "1970-01-01 00:00:00.015,5,24", "1970-01-01 00:00:00.020,5,29", "1970-01-01 00:00:00.025,2,12"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testAppendSinkWithNestedRow() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.smallTupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$21 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$21 $outer;
                    private final ExecutionConfig executionConfig$4;
                    private final TypeSerializer[] fieldSerializers$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$4 = executionConfig$4;
                        this.fieldSerializers$4 = fieldSerializers$4;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6)}));
        tEnv.registerTable("src", t);
        TestingAppendTableSink sink = new TestingAppendTableSink();
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("appendSink", (TableSink)sink.configure((String[])((Object[])new String[]{"t", "item"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.ROW((TypeInformation[])new TypeInformation[]{Types.LONG(), Types.STRING()})}))));
        tEnv.executeSql("INSERT INTO appendSink SELECT id, ROW(num, text) FROM src").await();
        List result = (List)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,Hi", "2,2,Hello", "3,2,Hello world"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testAppendSinkOnAppendTableForInnerJoin() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table ds1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.smallTupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$22 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$22 $outer;
                    private final ExecutionConfig executionConfig$5;
                    private final TypeSerializer[] fieldSerializers$5;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$5[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$5);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$5 = executionConfig$5;
                        this.fieldSerializers$5 = fieldSerializers$5;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}));
        Table ds2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData5(), (TypeInformation)new CaseClassTypeInfo<Tuple5<Object, Object, Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$23 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$23 $outer;
                    private final ExecutionConfig executionConfig$6;
                    private final TypeSerializer[] fieldSerializers$6;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$6[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$6);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$6 = executionConfig$6;
                        this.fieldSerializers$6 = fieldSerializers$6;
                    }
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple5<Object, Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((String)fields[3]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[4])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$12), package$.MODULE$.symbol2FieldExpression(symbol$13), package$.MODULE$.symbol2FieldExpression(symbol$14), package$.MODULE$.symbol2FieldExpression(symbol$15), package$.MODULE$.symbol2FieldExpression(symbol$16)}));
        TestingAppendTableSink sink = new TestingAppendTableSink();
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("appendSink", (TableSink)sink.configure((String[])((Object[])new String[]{"c", "g"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.STRING()}))));
        Table table = ds1.join(ds2).where(package$.MODULE$.UnresolvedFieldExpression(symbol$2).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression(symbol$13))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$15)});
        table.executeInsert("appendSink").await();
        List result = (List)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hi,Hallo", "Hello,Hallo Welt", "Hello world,Hallo Welt"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testRetractSinkOnUpdatingTable() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$24 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$24 $outer;
                    private final ExecutionConfig executionConfig$7;
                    private final TypeSerializer[] fieldSerializers$7;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$7[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$7);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$7 = executionConfig$7;
                        this.fieldSerializers$7 = fieldSerializers$7;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignAscendingTimestamps((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple3<Object, Object, String> x$3) {
                return BoxesRunTime.unboxToInt((Object)x$3._1());
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6)}));
        TestingRetractTableSink sink = new TestingRetractTableSink();
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("retractSink", (TableSink)sink.configure((String[])((Object[])new String[]{"len", "icnt", "nsum"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.DECIMAL()}))));
        Table table = t.select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$6).charLength()).as(symbol$17, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$17)}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$17), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).count()).as(symbol$10, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$5).sum()).as(symbol$11, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        table.executeInsert("retractSink").await();
        List retracted = (List)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,1,1.000000000000000000", "5,1,2.000000000000000000", "11,1,2.000000000000000000", "25,1,3.000000000000000000", "10,7,39.000000000000000000", "14,1,3.000000000000000000", "9,9,41.000000000000000000"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testRetractSinkOnAppendTable() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$25 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$25 $outer;
                    private final ExecutionConfig executionConfig$8;
                    private final TypeSerializer[] fieldSerializers$8;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$8[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$8);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$8 = executionConfig$8;
                        this.fieldSerializers$8 = fieldSerializers$8;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignAscendingTimestamps((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple3<Object, Object, String> x$4) {
                return BoxesRunTime.unboxToInt((Object)x$4._1());
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        TestingRetractTableSink sink = new TestingRetractTableSink(TimeZone.getDefault());
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("retractSink", (TableSink)sink.configure((String[])((Object[])new String[]{"t", "icnt", "nsum"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.SQL_TIMESTAMP(), Types.LONG(), Types.LONG()}))));
        Table table = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).millis())).on(package$.MODULE$.symbol2FieldExpression(symbol$7)).as(package$.MODULE$.symbol2FieldExpression(symbol$8))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$8)}).select(new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$8).end()).as(symbol$9, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).count()).as(symbol$10, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$5).sum()).as(symbol$11, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        table.executeInsert("retractSink").await();
        Assert.assertFalse((String)"Received retraction messages for append only table", (boolean)sink.getRawResults().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$5) {
                return x$5.startsWith("(false,");
            }
        }));
        List retracted = (List)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01 00:00:00.005,4,8", "1970-01-01 00:00:00.010,5,18", "1970-01-01 00:00:00.015,5,24", "1970-01-01 00:00:00.020,5,29", "1970-01-01 00:00:00.025,2,12"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkOnUpdatingTableWithFullKey() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$26 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$26 $outer;
                    private final ExecutionConfig executionConfig$9;
                    private final TypeSerializer[] fieldSerializers$9;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$9[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$9);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$9 = executionConfig$9;
                        this.fieldSerializers$9 = fieldSerializers$9;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignAscendingTimestamps((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple3<Object, Object, String> x$6) {
                return BoxesRunTime.unboxToInt((Object)x$6._1());
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6)}));
        TestingUpsertTableSink sink = new TestingUpsertTableSink(new int[]{0, 2}, TimeZone.getDefault()).configure((String[])((Object[])new String[]{"cnt", "lencnt", "cTrue"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), Types.DECIMAL(), Types.BOOLEAN()})));
        sink.expectedKeys_$eq((Option<String[]>)new Some((Object)new String[]{"cnt", "cTrue"}));
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("upsertSink", (TableSink)sink);
        Table table = t.select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$6).charLength()).as(symbol$17, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression(symbol$4).$greater(package$.MODULE$.int2Literal(0))).as(symbol$18, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$17), package$.MODULE$.symbol2FieldExpression(symbol$18)}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$17), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).count()).as(symbol$19, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression(symbol$18)}).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$19), package$.MODULE$.symbol2FieldExpression(symbol$18)}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$19), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$17).count()).as(symbol$20, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression(symbol$18)});
        table.executeInsert("upsertSink").await();
        Assert.assertTrue((String)"Results must include delete messages", (boolean)sink.getRawResults().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$7) {
                return x$7.startsWith("(false,");
            }
        }));
        List retracted = (List)sink.getUpsertResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,5.000000000000000000,true", "7,1.000000000000000000,true", "9,1.000000000000000000,true"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkOnAppendingTableWithFullKey1() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$27 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$27 $outer;
                    private final ExecutionConfig executionConfig$10;
                    private final TypeSerializer[] fieldSerializers$10;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$10[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$10);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$10 = executionConfig$10;
                        this.fieldSerializers$10 = fieldSerializers$10;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignAscendingTimestamps((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple3<Object, Object, String> x$8) {
                return BoxesRunTime.unboxToInt((Object)x$8._1());
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        TestingUpsertTableSink sink = new TestingUpsertTableSink(new int[]{0, 1, 2}, TimeZone.getDefault()).configure((String[])((Object[])new String[]{"num", "wend", "icnt"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), Types.SQL_TIMESTAMP(), Types.LONG()})));
        sink.expectedKeys_$eq((Option<String[]>)new Some((Object)new String[]{"wend", "num"}));
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("upsertSink", (TableSink)sink);
        Table table = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).millis())).on(package$.MODULE$.symbol2FieldExpression(symbol$7)).as(package$.MODULE$.symbol2FieldExpression(symbol$8))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$8), package$.MODULE$.symbol2FieldExpression(symbol$5)}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$8).end()).as(symbol$21, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).count()).as(symbol$10, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        table.executeInsert("upsertSink").await();
        Assert.assertFalse((String)"Received retraction messages for append only table", (boolean)sink.getRawResults().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$9) {
                return x$9.startsWith("(false,");
            }
        }));
        List retracted = (List)sink.getUpsertResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1970-01-01 00:00:00.005,1", "2,1970-01-01 00:00:00.005,2", "3,1970-01-01 00:00:00.005,1", "3,1970-01-01 00:00:00.010,2", "4,1970-01-01 00:00:00.010,3", "4,1970-01-01 00:00:00.015,1", "5,1970-01-01 00:00:00.015,4", "5,1970-01-01 00:00:00.020,1", "6,1970-01-01 00:00:00.020,4", "6,1970-01-01 00:00:00.025,2"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkOnAppendingTableWithFullKey2() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$28 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$28 $outer;
                    private final ExecutionConfig executionConfig$11;
                    private final TypeSerializer[] fieldSerializers$11;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$11[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$11);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$11 = executionConfig$11;
                        this.fieldSerializers$11 = fieldSerializers$11;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignAscendingTimestamps((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple3<Object, Object, String> x$10) {
                return BoxesRunTime.unboxToInt((Object)x$10._1());
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        TestingUpsertTableSink sink = new TestingUpsertTableSink(new int[]{0, 1, 2}, TimeZone.getDefault());
        sink.expectedKeys_$eq((Option<String[]>)new Some((Object)new String[]{"wend", "num"}));
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("upsertSink", (TableSink)sink.configure((String[])((Object[])new String[]{"wstart", "wend", "num", "icnt"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.SQL_TIMESTAMP(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.LONG()}))));
        Table table = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).millis())).on(package$.MODULE$.symbol2FieldExpression(symbol$7)).as(package$.MODULE$.symbol2FieldExpression(symbol$8))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$8), package$.MODULE$.symbol2FieldExpression(symbol$5)}).select(new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$8).start()).as(symbol$22, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$8).end()).as(symbol$23, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).count()).as(symbol$10, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        table.executeInsert("upsertSink").await();
        Assert.assertFalse((String)"Received retraction messages for append only table", (boolean)sink.getRawResults().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$11) {
                return x$11.startsWith("(false,");
            }
        }));
        List retracted = (List)sink.getUpsertResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01 00:00:00.000,1970-01-01 00:00:00.005,1,1", "1970-01-01 00:00:00.000,1970-01-01 00:00:00.005,2,2", "1970-01-01 00:00:00.000,1970-01-01 00:00:00.005,3,1", "1970-01-01 00:00:00.005,1970-01-01 00:00:00.010,3,2", "1970-01-01 00:00:00.005,1970-01-01 00:00:00.010,4,3", "1970-01-01 00:00:00.010,1970-01-01 00:00:00.015,4,1", "1970-01-01 00:00:00.010,1970-01-01 00:00:00.015,5,4", "1970-01-01 00:00:00.015,1970-01-01 00:00:00.020,5,1", "1970-01-01 00:00:00.015,1970-01-01 00:00:00.020,6,4", "1970-01-01 00:00:00.020,1970-01-01 00:00:00.025,6,2"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkOnAppendingTableWithoutFullKey1() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$29 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$29 $outer;
                    private final ExecutionConfig executionConfig$12;
                    private final TypeSerializer[] fieldSerializers$12;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$12[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$12);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$12 = executionConfig$12;
                        this.fieldSerializers$12 = fieldSerializers$12;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignAscendingTimestamps((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple3<Object, Object, String> x$12) {
                return BoxesRunTime.unboxToInt((Object)x$12._1());
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        TestingUpsertTableSink sink = new TestingUpsertTableSink(new int[]{0}, TimeZone.getDefault());
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("upsertSink", (TableSink)sink.configure((String[])((Object[])new String[]{"wend", "cnt"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.SQL_TIMESTAMP(), Types.LONG()}))));
        Table table = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).millis())).on(package$.MODULE$.symbol2FieldExpression(symbol$7)).as(package$.MODULE$.symbol2FieldExpression(symbol$8))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$8), package$.MODULE$.symbol2FieldExpression(symbol$5)}).select(new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$8).end()).as(symbol$23, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).count()).as(symbol$24, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        table.executeInsert("upsertSink").await();
        Assert.assertFalse((String)"Received retraction messages for append only table", (boolean)sink.getRawResults().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$13) {
                return x$13.startsWith("(false,");
            }
        }));
        List retracted = (List)sink.getRawResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(true,1970-01-01 00:00:00.005,1)", "(true,1970-01-01 00:00:00.005,2)", "(true,1970-01-01 00:00:00.005,1)", "(true,1970-01-01 00:00:00.010,2)", "(true,1970-01-01 00:00:00.010,3)", "(true,1970-01-01 00:00:00.015,1)", "(true,1970-01-01 00:00:00.015,4)", "(true,1970-01-01 00:00:00.020,1)", "(true,1970-01-01 00:00:00.020,4)", "(true,1970-01-01 00:00:00.025,2)"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkOnAppendingTableWithoutFullKey2() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$30 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$30 $outer;
                    private final ExecutionConfig executionConfig$13;
                    private final TypeSerializer[] fieldSerializers$13;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$13[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$13);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$13 = executionConfig$13;
                        this.fieldSerializers$13 = fieldSerializers$13;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignAscendingTimestamps((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple3<Object, Object, String> x$14) {
                return BoxesRunTime.unboxToInt((Object)x$14._1());
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        TestingUpsertTableSink sink = new TestingUpsertTableSink(new int[]{0}, TimeZone.getDefault());
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("upsertSink", (TableSink)sink.configure((String[])((Object[])new String[]{"num", "cnt"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), Types.LONG()}))));
        Table table = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).millis())).on(package$.MODULE$.symbol2FieldExpression(symbol$7)).as(package$.MODULE$.symbol2FieldExpression(symbol$8))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$8), package$.MODULE$.symbol2FieldExpression(symbol$5)}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).count()).as(symbol$24, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        table.executeInsert("upsertSink").await();
        Assert.assertFalse((String)"Received retraction messages for append only table", (boolean)sink.getRawResults().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$15) {
                return x$15.startsWith("(false,");
            }
        }));
        List retracted = (List)sink.getRawResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(true,1,1)", "(true,2,2)", "(true,3,1)", "(true,3,2)", "(true,4,3)", "(true,4,1)", "(true,5,4)", "(true,5,1)", "(true,6,4)", "(true,6,2)"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)retracted);
    }

    @Test
    public void testUpsertSinkWithFilter() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        env.setParallelism(4);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$31 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$31 $outer;
                    private final ExecutionConfig executionConfig$14;
                    private final TypeSerializer[] fieldSerializers$14;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$14[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$14);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$14 = executionConfig$14;
                        this.fieldSerializers$14 = fieldSerializers$14;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignAscendingTimestamps((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple3<Object, Object, String> x$16) {
                return BoxesRunTime.unboxToInt((Object)x$16._1());
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6)}));
        TestingUpsertTableSink sink = new TestingUpsertTableSink(new int[]{0});
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        ((TableEnvironmentInternal)tEnv).registerTableSinkInternal("upsertSink", (TableSink)sink.configure((String[])((Object[])new String[]{"num", "cnt"}), (TypeInformation<?>[])((TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), Types.LONG()}))));
        Table table = t.groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5)}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).count()).as(symbol$24, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).where(package$.MODULE$.UnresolvedFieldExpression(symbol$24).$less$eq(package$.MODULE$.int2Literal(3)));
        table.executeInsert("upsertSink").await();
        List expectedWithFilter = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1", "2,2", "3,3"}));
        Assert.assertEquals((Object)expectedWithFilter.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getUpsertResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test(expected=TableException.class)
    public void testToAppendStreamMultiRowtime() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$32 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$32 $outer;
                    private final ExecutionConfig executionConfig$15;
                    private final TypeSerializer[] fieldSerializers$15;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$15[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$15);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$15 = executionConfig$15;
                        this.fieldSerializers$15 = fieldSerializers$15;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignAscendingTimestamps((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple3<Object, Object, String> x$17) {
                return BoxesRunTime.unboxToInt((Object)x$17._1());
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        Table r = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).milli())).on(package$.MODULE$.symbol2FieldExpression(symbol$7)).as(package$.MODULE$.symbol2FieldExpression(symbol$8))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$8)}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$8).rowtime(), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$8).rowtime()).as(symbol$25, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(r).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test(expected=TableException.class)
    public void testToRetractStreamMultiRowtime() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$33 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$33 $outer;
                    private final ExecutionConfig executionConfig$16;
                    private final TypeSerializer[] fieldSerializers$16;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$16[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$16);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$16 = executionConfig$16;
                        this.fieldSerializers$16 = fieldSerializers$16;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignAscendingTimestamps((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple3<Object, Object, String> x$18) {
                return BoxesRunTime.unboxToInt((Object)x$18._1());
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        Table r = t.window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(5).milli())).on(package$.MODULE$.symbol2FieldExpression(symbol$7)).as(package$.MODULE$.symbol2FieldExpression(symbol$8))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$8)}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$8).rowtime(), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$8).rowtime()).as(symbol$25, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(r).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testDecimalAppendStreamTableSink() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        MemoryTableSourceSinkUtil$.MODULE$.clear();
        TableSchema schema = TableSchema.builder().field("c", DataTypes.VARCHAR((int)5)).field("b", DataTypes.DECIMAL((int)10, (int)0)).field("d", DataTypes.CHAR((int)5)).build();
        MemoryTableSourceSinkUtil$.MODULE$.createDataTypeAppendStreamTable((TableEnvironment)tEnv, schema, "testSink");
        Table table = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$34 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$34 $outer;
                    private final ExecutionConfig executionConfig$17;
                    private final TypeSerializer[] fieldSerializers$17;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$17[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$17);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$17 = executionConfig$17;
                        this.fieldSerializers$17 = fieldSerializers$17;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)})).where(package$.MODULE$.UnresolvedFieldExpression(symbol$1).$greater(package$.MODULE$.int2Literal(20))).select(new Expression[]{package$.MODULE$.string2Literal("12345"), (Expression)package$.MODULE$.LiteralIntExpression(55).cast(DataTypes.DECIMAL((int)10, (int)0)), (Expression)package$.MODULE$.LiteralStringExpression("12345").cast(DataTypes.CHAR((int)5))});
        table.executeInsert("testSink").await();
        java.util.List results = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(MemoryTableSourceSinkUtil$.MODULE$.tableDataStrings()).asJava();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"12345,55,12345"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)results, (String)expected);
    }
}

