/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.table;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.api.ApiExpression;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.factories.utils.TestCollectionTableFactory;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.types.Row;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.ExpectedException;

public class FunctionITCase
extends StreamingTestBase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testScalarFunction() throws Exception {
        List<Row> sourceData = Arrays.asList(Row.of((Object[])new Object[]{1, 1L, 1L}), Row.of((Object[])new Object[]{2, 2L, 1L}), Row.of((Object[])new Object[]{3, 3L, 1L}));
        List<Row> sinkData = Arrays.asList(Row.of((Object[])new Object[]{1, 2L, 1L}), Row.of((Object[])new Object[]{2, 4L, 1L}), Row.of((Object[])new Object[]{3, 6L, 1L}));
        TestCollectionTableFactory.reset();
        TestCollectionTableFactory.initData(sourceData);
        this.tEnv().executeSql("CREATE TABLE TestTable(a INT, b BIGINT, c BIGINT) WITH ('connector' = 'COLLECTION')");
        Table table = this.tEnv().from("TestTable").select(new Expression[]{Expressions.$((String)"a"), Expressions.call((UserDefinedFunction)new SimpleScalarFunction(), (Object[])new Object[]{Expressions.$((String)"a"), Expressions.$((String)"b")}), (Expression)((ApiExpression)Expressions.call((UserDefinedFunction)new SimpleScalarFunction(), (Object[])new Object[]{Expressions.$((String)"a"), Expressions.$((String)"b")}).plus((Object)1)).minus((Object)Expressions.call((UserDefinedFunction)new SimpleScalarFunction(), (Object[])new Object[]{Expressions.$((String)"a"), Expressions.$((String)"b")}))});
        table.executeInsert("TestTable").await();
        Assert.assertThat(TestCollectionTableFactory.getResult(), (Matcher)CoreMatchers.equalTo(sinkData));
    }

    @Test
    public void testJoinWithTableFunction() throws Exception {
        List<Row> sourceData = Arrays.asList(Row.of((Object[])new Object[]{"1,2,3"}), Row.of((Object[])new Object[]{"2,3,4"}), Row.of((Object[])new Object[]{"3,4,5"}), Row.of((Object[])new Object[]{null}));
        List<Row> sinkData = Arrays.asList(Row.of((Object[])new Object[]{"1,2,3", new String[]{"1", "2", "3"}}), Row.of((Object[])new Object[]{"2,3,4", new String[]{"2", "3", "4"}}), Row.of((Object[])new Object[]{"3,4,5", new String[]{"3", "4", "5"}}));
        TestCollectionTableFactory.reset();
        TestCollectionTableFactory.initData(sourceData);
        this.tEnv().executeSql("CREATE TABLE SourceTable(s STRING) WITH ('connector' = 'COLLECTION')");
        this.tEnv().executeSql("CREATE TABLE SinkTable(s STRING, sa ARRAY<STRING>) WITH ('connector' = 'COLLECTION')");
        this.tEnv().from("SourceTable").joinLateral((Expression)Expressions.call((UserDefinedFunction)new SimpleTableFunction(), (Object[])new Object[]{Expressions.$((String)"s")}).as("a", new String[]{"b"})).select(new Expression[]{Expressions.$((String)"a"), Expressions.$((String)"b")}).executeInsert("SinkTable").await();
        Assert.assertThat(TestCollectionTableFactory.getResult(), (Matcher)CoreMatchers.equalTo(sinkData));
    }

    @Test
    public void testLateralJoinWithScalarFunction() throws Exception {
        this.thrown.expect(ValidationException.class);
        this.thrown.expect(ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Currently, only table functions can be used in a correlate operation.")));
        TestCollectionTableFactory.reset();
        this.tEnv().executeSql("CREATE TABLE SourceTable(s STRING) WITH ('connector' = 'COLLECTION')");
        this.tEnv().executeSql("CREATE TABLE SinkTable(s STRING, sa ARRAY<STRING>) WITH ('connector' = 'COLLECTION')");
        this.tEnv().from("SourceTable").joinLateral((Expression)Expressions.call((UserDefinedFunction)new RowScalarFunction(), (Object[])new Object[]{Expressions.$((String)"s")}).as("a", new String[]{"b"})).select(new Expression[]{Expressions.$((String)"a"), Expressions.$((String)"b")}).executeInsert("SinkTable").await();
    }

    @FunctionHint(output=@DataTypeHint(value="ROW<s STRING, sa ARRAY<STRING>>"))
    public static class SimpleTableFunction
    extends TableFunction<Row> {
        public void eval(String s) {
            if (s == null) {
                this.collect(null);
            } else {
                this.collect(Row.of((Object[])new Object[]{s, s.split(",")}));
            }
        }
    }

    @FunctionHint(output=@DataTypeHint(value="ROW<s STRING, sa ARRAY<STRING>>"))
    public static class RowScalarFunction
    extends ScalarFunction {
        public Row eval(String s) {
            return Row.of((Object[])new Object[]{s, s.split(",")});
        }
    }

    public static class SimpleScalarFunction
    extends ScalarFunction {
        public Long eval(Integer i, Long j) {
            return (long)i.intValue() + j;
        }
    }
}

