/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.util.Collection;
import java.util.HashMap;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.PartitionableSourceITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001y4A!\u0001\u0002\u0001'\tI\u0002+\u0019:uSRLwN\\1cY\u0016\u001cv.\u001e:dK&#6)Y:f\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\rM$(/Z1n\u0015\t9\u0001\"A\u0004sk:$\u0018.\\3\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\u0012'R\u0014X-Y7j]\u001e$Vm\u001d;CCN,\u0007\u0002C\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002+M|WO]2f\r\u0016$8\r\u001b)beRLG/[8ogV\tQ\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sDA\u0004C_>dW-\u00198\t\u0011\u0011\u0002!\u0011!Q\u0001\nu\tac]8ve\u000e,g)\u001a;dQB\u000b'\u000f^5uS>t7\u000f\t\u0005\tM\u0001\u0011)\u0019!C\u00019\u0005\u0001Ro]3DCR\fGn\\4GS2$XM\u001d\u0005\tQ\u0001\u0011\t\u0011)A\u0005;\u0005\tRo]3DCR\fGn\\4GS2$XM\u001d\u0011\t\u000b)\u0002A\u0011A\u0016\u0002\rqJg.\u001b;?)\racf\f\t\u0003[\u0001i\u0011A\u0001\u0005\u00067%\u0002\r!\b\u0005\u0006M%\u0002\r!\b\u0005\u0006c\u0001!\tEM\u0001\u0007E\u00164wN]3\u0015\u0003M\u0002\"A\b\u001b\n\u0005Uz\"\u0001B+oSRD#\u0001M\u001c\u0011\u0005aZT\"A\u001d\u000b\u0005i\u0002\u0012!\u00026v]&$\u0018B\u0001\u001f:\u0005\u0019\u0011UMZ8sK\")a\b\u0001C\u0001e\u0005\u0011C/Z:u'&l\u0007\u000f\\3QCJ$\u0018\u000e^5p]\u001aKW\r\u001c3Qe\u0016$\u0017nY1uKFB#!\u0010!\u0011\u0005a\n\u0015B\u0001\":\u0005\u0011!Vm\u001d;\t\u000b\u0011\u0003A\u0011\u0001\u001a\u0002UQ,7\u000f\u001e)beRL\u0017\r\u001c)beRLG/[8o\r&,G\u000e\u001a)sK\u0012L7-\u0019;f!V\u001c\b\u000eR8x]\"\u00121\t\u0011\u0005\u0006\u000f\u0002!\tAM\u0001\u001ai\u0016\u001cH/\u00168d_:4XM\u001d;fI\u0016C\bO]3tg&|g\u000e\u000b\u0002G\u0001\"\"\u0001A\u0013)R!\tYe*D\u0001M\u0015\ti\u0015(\u0001\u0004sk:tWM]\u0005\u0003\u001f2\u0013qAU;o/&$\b.A\u0003wC2,XmI\u0001S!\t\u0019f+D\u0001U\u0015\t)\u0016(A\u0004sk:tWM]:\n\u0005]#&!\u0004)be\u0006lW\r^3sSj,GmB\u0003Z\u0005!\u0005!,A\rQCJ$\u0018\u000e^5p]\u0006\u0014G.Z*pkJ\u001cW-\u0013+DCN,\u0007CA\u0017\\\r\u0015\t!\u0001#\u0001]'\tYV\f\u0005\u0002\u001f=&\u0011ql\b\u0002\u0007\u0003:L(+\u001a4\t\u000b)ZF\u0011A1\u0015\u0003iCQaY.\u0005\u0002\u0011\f!\u0002]1sC6,G/\u001a:t)\u0005)\u0007c\u00014l[6\tqM\u0003\u0002iS\u0006!Q\u000f^5m\u0015\u0005Q\u0017\u0001\u00026bm\u0006L!\u0001\\4\u0003\u0015\r{G\u000e\\3di&|g\u000eE\u0002\u001f]BL!a\\\u0010\u0003\u000b\u0005\u0013(/Y=\u0011\u0005y\t\u0018B\u0001: \u0005\r\te.\u001f\u0015\u0005ER\\H\u0010\u0005\u0002vq:\u00111K^\u0005\u0003oR\u000bQ\u0002U1sC6,G/\u001a:ju\u0016$\u0017BA={\u0005)\u0001\u0016M]1nKR,'o\u001d\u0006\u0003oR\u000bAA\\1nK\u0006\nQ0A\u0018t_V\u00148-\u001a$fi\u000eD\u0007+\u0019:uSRLwN\\:>wBjH\u0006I;tK\u000e\u000bG/\u00197pO\u001aKG\u000e^3s{m\fT\u0010")
public class PartitionableSourceITCase
extends StreamingTestBase {
    private final boolean sourceFetchPartitions;
    private final boolean useCatalogFilter;

    @Parameterized.Parameters(name="sourceFetchPartitions={0}, useCatalogFilter={1}")
    public static Collection<Object[]> parameters() {
        return PartitionableSourceITCase$.MODULE$.parameters();
    }

    public boolean sourceFetchPartitions() {
        return this.sourceFetchPartitions;
    }

    public boolean useCatalogFilter() {
        return this.useCatalogFilter;
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.env().setParallelism(1);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "ZhangSan", "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "LiSi", "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "Tom", "B", BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "Vivi", "C", BoxesRunTime.boxToInteger((int)1)}))}));
        String myTableDataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddlTemp = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE MyTable (\n         |  id int,\n         |  name string,\n         |  part1 string,\n         |  part2 int,\n         |  virtualField as part2 + 1)\n         |  partitioned by (part1, part2)\n         |  with (\n         |    'connector' = 'values',\n         |    'data-id' = '", "',\n         |    'bounded' = 'true',\n         |    'partition-list' = '%s'\n         |)\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{myTableDataId})))).stripMargin();
        if (this.sourceFetchPartitions()) {
            String partitions = "part1:A,part2:1;part1:A,part2:2;part1:B,part2:3;part1:C,part2:1";
            this.tEnv().executeSql(String.format(ddlTemp, partitions));
        } else {
            TestValuesCatalog catalog = new TestValuesCatalog("test_catalog", "test_database", this.useCatalogFilter());
            this.tEnv().registerCatalog("test_catalog", (Catalog)catalog);
            this.tEnv().useCatalog("test_catalog");
            this.tEnv().executeSql(String.format(ddlTemp, ""));
            ObjectPath mytablePath = ObjectPath.fromString((String)"test_database.MyTable");
            Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"2")})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"B"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"3")})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"C"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")}))}));
            partitions.foreach((Function1)new Serializable(this, catalog, mytablePath){
                public static final long serialVersionUID = 0L;
                private final TestValuesCatalog catalog$1;
                private final ObjectPath mytablePath$1;

                public final void apply(Map<String, String> partition) {
                    CatalogPartitionSpec catalogPartitionSpec = new CatalogPartitionSpec(JavaConversions$.MODULE$.mapAsJavaMap(partition));
                    CatalogPartitionImpl catalogPartition = new CatalogPartitionImpl(new HashMap<K, V>(), "");
                    this.catalog$1.createPartition(this.mytablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
                }
                {
                    this.catalog$1 = catalog$1;
                    this.mytablePath$1 = mytablePath$1;
                }
            });
        }
    }

    @Test
    public void testSimplePartitionFieldPredicate1() {
        String query = "SELECT * FROM MyTable WHERE part1 = 'A'";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,ZhangSan,A,1,2", "2,LiSi,A,1,2", "3,Jack,A,2,3"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialPartitionFieldPredicatePushDown() {
        String query = "SELECT * FROM MyTable WHERE (id > 2 OR part1 = 'A') AND part2 > 1";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,Jack,A,2,3", "4,Tom,B,3,4"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testUnconvertedExpression() {
        String query = "select * from MyTable where trim(part1) = 'A' and part2 > 1";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,Jack,A,2,3"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    public PartitionableSourceITCase(boolean sourceFetchPartitions, boolean useCatalogFilter) {
        this.sourceFetchPartitions = sourceFetchPartitions;
        this.useCatalogFilter = useCatalogFilter;
    }
}

