/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.functions.AssignerWithPunctuatedWatermarks;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.stream.sql.IntervalJoinITCase$;
import org.apache.flink.table.planner.runtime.stream.sql.Row3WatermarkExtractor2;
import org.apache.flink.table.planner.runtime.stream.sql.Row4WatermarkExtractor;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0001\u0003\u0001M\u0011!#\u00138uKJ4\u0018\r\u001c&pS:LEkQ1tK*\u00111\u0001B\u0001\u0004gFd'BA\u0003\u0007\u0003\u0019\u0019HO]3b[*\u0011q\u0001C\u0001\beVtG/[7f\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0019\tQ!\u001e;jYNL!!\u0007\f\u00035M#(/Z1nS:<w+\u001b;i'R\fG/\u001a+fgR\u0014\u0015m]3\t\u0011m\u0001!\u0011!Q\u0001\nq\tA!\\8eKB\u0011Q$\r\b\u0003==r!a\b\u0018\u000f\u0005\u0001jcBA\u0011-\u001d\t\u00113F\u0004\u0002$U9\u0011A%\u000b\b\u0003K!j\u0011A\n\u0006\u0003OI\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0005=\u0001\u0012BA\u0007\u000f\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003/\u0019I!\u0001\r\f\u00025M#(/Z1nS:<w+\u001b;i'R\fG/\u001a+fgR\u0014\u0015m]3\n\u0005I\u001a$\u0001E*uCR,')Y2lK:$Wj\u001c3f\u0015\t\u0001d\u0003C\u00036\u0001\u0011\u0005a'\u0001\u0004=S:LGO\u0010\u000b\u0003oe\u0002\"\u0001\u000f\u0001\u000e\u0003\tAQa\u0007\u001bA\u0002qAQa\u000f\u0001\u0005\u0002q\n\u0001\u0004^3tiB\u0013xnY3tgRKW.Z%o]\u0016\u0014(j\\5o)\u0005i\u0004C\u0001 B\u001b\u0005y$\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t{$\u0001B+oSRD#A\u000f#\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d\u0003\u0012!\u00026v]&$\u0018BA%G\u0005\u0011!Vm\u001d;\t\u000b-\u0003A\u0011\u0001\u001f\u0002QQ,7\u000f\u001e)s_\u000e,7o\u001d+j[\u0016Tu.\u001b8XSRD\u0017j\u001d(pi\u0012K7\u000f^5oGR4%o\\7)\u0005)#\u0005\"\u0002(\u0001\t\u0003a\u0014a\u000b;fgR\u0004&o\\2fgN$\u0016.\\3J]:,'OS8j]^KG\u000f[(uQ\u0016\u00148i\u001c8eSRLwN\\:)\u00055#\u0005\"B)\u0001\t\u0003a\u0014\u0001\u0006;fgR\u0014vn\u001e+j[\u0016LeN\\3s\u0015>Lg\u000e\u000b\u0002Q\t\")A\u000b\u0001C\u0001y\u0005IC/Z:u%><H+[7f\u0013:tWM\u001d&pS:<\u0016\u000e\u001e5Jg:{G\u000fR5ti&t7\r\u001e$s_6D#a\u0015#\t\u000b]\u0003A\u0011\u0001\u001f\u0002SQ,7\u000f\u001e*poRKW.Z%o]\u0016\u0014(j\\5o/&$\bn\\;u\u000bF,\u0018\r\\\"p]\u0012LG/[8oQ\t1F\tC\u0003[\u0001\u0011\u0005A(A\u0013uKN$XK\u001c2pk:$W\rZ!hO\u00063G/\u001a:S_^$\u0018.\\3J]:,'OS8j]\"\u0012\u0011\f\u0012\u0005\u0006;\u0002!\t\u0001P\u0001&i\u0016\u001cHOU8x)&lW-\u00138oKJTu.\u001b8XSRDW)];j)&lW-\u0011;ueND#\u0001\u0018#\t\u000b\u0001\u0004A\u0011\u0001\u001f\u0002OQ,7\u000f\u001e*poRKW.Z%o]\u0016\u0014(j\\5o/&$\bn\u0014;iKJ\u001cuN\u001c3ji&|gn\u001d\u0015\u0003?\u0012CQa\u0019\u0001\u0005\u0002q\n!\u0006^3tiJ{w\u000fV5nK&sg.\u001a:K_&tw+\u001b;i\u001fRDWM\u001d+j[\u0016\u001cuN\u001c3ji&|g\u000e\u000b\u0002c\t\")a\r\u0001C\u0001y\u0005\u0011D/Z:u%><H+[7f\u0013:tWM\u001d&pS:<\u0016\u000e\u001e5XS:$wn^!hOJ,w-\u0019;f\u001f:4\u0015N]:u)&lW\r\u000b\u0002f\t\")\u0011\u000e\u0001C\u0001y\u0005\u0019D/Z:u%><H+[7f\u0013:tWM\u001d&pS:<\u0016\u000e\u001e5XS:$wn^!hOJ,w-\u0019;f\u001f:\u001cVmY8oIRKW.\u001a\u0015\u0003Q\u0012CQ\u0001\u001c\u0001\u0005\u0002q\n\u0011\u0004^3tiB\u0013xn\u0019+j[\u0016dUM\u001a;PkR,'OS8j]\"\u00121\u000e\u0012\u0005\u0006_\u0002!\t\u0001P\u0001\u0019i\u0016\u001cHOU8x)&lW\rT3gi>+H/\u001a:K_&t\u0007F\u00018E\u0011\u0015\u0011\b\u0001\"\u0001=\u00031\"Xm\u001d;S_^$\u0016.\\3MK\u001a$x*\u001e;fe*{\u0017N\u001c(fO\u0006$\u0018N^3J]R,'O^1m'&TX\r\u000b\u0002r\t\")Q\u000f\u0001C\u0001y\u0005QB/Z:u!J|7\rV5nKJKw\r\u001b;PkR,'OS8j]\"\u0012A\u000f\u0012\u0005\u0006q\u0002!\t\u0001P\u0001\u001ai\u0016\u001cHOU8x)&lWMU5hQR|U\u000f^3s\u0015>Lg\u000e\u000b\u0002x\t\")1\u0010\u0001C\u0001y\u0005iC/Z:u%><H+[7f%&<\u0007\u000e^(vi\u0016\u0014(j\\5o\u001d\u0016<\u0017\r^5wK&sG/\u001a:wC2\u001c\u0016N_3)\u0005i$\u0005\"\u0002@\u0001\t\u0003a\u0014!\u0007;fgR\u0004&o\\2US6,g)\u001e7m\u001fV$XM\u001d&pS:D#! #\t\r\u0005\r\u0001\u0001\"\u0001=\u0003a!Xm\u001d;S_^$\u0016.\\3Gk2dw*\u001e;fe*{\u0017N\u001c\u0015\u0004\u0003\u0003!\u0005BBA\u0005\u0001\u0011\u0005A(\u0001\u0017uKN$(k\\<US6,g)\u001e7m\u001fV$XM\u001d&pS:tUmZ1uSZ,\u0017J\u001c;feZ\fGnU5{K\"\u001a\u0011q\u0001#)\u000f\u0001\ty!a\u0007\u0002\u001eA!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016\u0019\u000baA];o]\u0016\u0014\u0018\u0002BA\r\u0003'\u0011qAU;o/&$\b.A\u0003wC2,Xm\t\u0002\u0002 A!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&\u0019\u000bqA];o]\u0016\u00148/\u0003\u0003\u0002*\u0005\r\"!\u0004)be\u0006lW\r^3sSj,G\r")
public class IntervalJoinITCase
extends StreamingWithStateTestBase {
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("proctime");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("key");
    private static Symbol symbol$6 = Symbol$.MODULE$.apply("id");
    private static Symbol symbol$7 = Symbol$.MODULE$.apply("rowtime");
    private static Symbol symbol$8 = Symbol$.MODULE$.apply("tm");

    @Test
    public void testProcessTimeInnerJoin() {
        this.env().setParallelism(1);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a, t2.c, t1.c\n        |FROM T1 as t1 join T2 as t2 ON\n        |  t1.a = t2.a AND\n        |  t1.proctime BETWEEN t2.proctime - INTERVAL '5' SECOND AND\n        |    t2.proctime + INTERVAL '5' SECOND\n        |")).stripMargin();
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Hi1"));
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Hi2"));
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)5L), (Object)"Hi3"));
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)7L), (Object)"Hi5"));
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)9L), (Object)"Hi6"));
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)8L), (Object)"Hi8"));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"HiHi"));
        data2.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"HeHe"));
        Table tmp1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data1, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$43 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$43 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime()}));
        this.tEnv().registerTable("TmpT1", tmp1);
        String subquery1 = "SELECT IF(a = 1, CAST(NULL AS INT), a) as a, b, c, proctime FROM TmpT1";
        Table t1 = this.tEnv().sqlQuery(subquery1);
        this.tEnv().registerTable("T1", t1);
        Table tmp2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data2, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$44 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$44 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime()}));
        this.tEnv().registerTable("TmpT2", tmp2);
        String subquery2 = "SELECT IF(a = 1, CAST(NULL AS INT), a) as a, b, c, proctime FROM TmpT2";
        Table t2 = this.tEnv().sqlQuery(subquery2);
        this.tEnv().registerTable("T2", t2);
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink);
        this.env().execute();
    }

    @Test
    public void testProcessTimeJoinWithIsNotDistinctFrom() {
        this.env().setParallelism(1);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a, t2.c, t1.c\n        |FROM T1 as t1 join T2 as t2 ON\n        |  t1.a is not distinct from t2.a AND\n        |  t1.proctime BETWEEN t2.proctime - INTERVAL '5' SECOND AND\n        |    t2.proctime + INTERVAL '5' SECOND\n        |")).stripMargin();
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Hi1"));
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Hi2"));
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)5L), (Object)"Hi3"));
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)7L), (Object)"Hi5"));
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)9L), (Object)"Hi6"));
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)8L), (Object)"Hi8"));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"HiHi"));
        data2.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"HeHe"));
        Table tmp1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data1, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$45 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$45 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime()}));
        this.tEnv().registerTable("TmpT1", tmp1);
        String subquery1 = "SELECT IF(a = 1, CAST(NULL AS INT), a) as a, b, c, proctime FROM TmpT1";
        Table t1 = this.tEnv().sqlQuery(subquery1);
        this.tEnv().registerTable("T1", t1);
        Table tmp2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data2, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$46 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$46 $outer;
                    private final ExecutionConfig executionConfig$4;
                    private final TypeSerializer[] fieldSerializers$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$4 = executionConfig$4;
                        this.fieldSerializers$4 = fieldSerializers$4;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime()}));
        this.tEnv().registerTable("TmpT2", tmp2);
        String subquery2 = "SELECT IF(a = 1, CAST(NULL AS INT), a) as a, b, c, proctime FROM TmpT2";
        Table t2 = this.tEnv().sqlQuery(subquery2);
        this.tEnv().registerTable("T2", t2);
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink);
        this.env().execute();
    }

    @Test
    public void testProcessTimeInnerJoinWithOtherConditions() {
        this.env().setParallelism(2);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a, t2.c, t1.c\n        |FROM T1 as t1 JOIN T2 as t2 ON\n        |  t1.a = t2.a AND\n        |  t1.proctime BETWEEN t2.proctime - interval '5' SECOND AND\n        |    t2.proctime + interval '5' second AND\n        |  t1.b = t2.b\n        |")).stripMargin();
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)new Tuple3((Object)"1", (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Hi1"));
        data1.$plus$eq((Object)new Tuple3((Object)"1", (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Hi2"));
        data1.$plus$eq((Object)new Tuple3((Object)"1", (Object)BoxesRunTime.boxToLong((long)5L), (Object)"Hi3"));
        data1.$plus$eq((Object)new Tuple3((Object)"2", (Object)BoxesRunTime.boxToLong((long)7L), (Object)"Hi5"));
        data1.$plus$eq((Object)new Tuple3((Object)"1", (Object)BoxesRunTime.boxToLong((long)9L), (Object)"Hi6"));
        data1.$plus$eq((Object)new Tuple3((Object)"1", (Object)BoxesRunTime.boxToLong((long)8L), (Object)"Hi8"));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)new Tuple3((Object)"1", (Object)BoxesRunTime.boxToLong((long)5L), (Object)"HiHi"));
        data2.$plus$eq((Object)new Tuple3((Object)"2", (Object)BoxesRunTime.boxToLong((long)2L), (Object)"HeHe"));
        data1.$plus$eq((Object)new Tuple3(null, (Object)BoxesRunTime.boxToLong((long)20L), (Object)"leftNull"));
        data2.$plus$eq((Object)new Tuple3(null, (Object)BoxesRunTime.boxToLong((long)20L), (Object)"rightNull"));
        Table t1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data1, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$47 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$47 $outer;
                    private final ExecutionConfig executionConfig$5;
                    private final TypeSerializer[] fieldSerializers$5;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$5[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$5);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$5 = executionConfig$5;
                        this.fieldSerializers$5 = fieldSerializers$5;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, String>>(this, fieldSerializers){

                    public Tuple3<String, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime()}));
        Table t2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data2, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$48 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$48 $outer;
                    private final ExecutionConfig executionConfig$6;
                    private final TypeSerializer[] fieldSerializers$6;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$6[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$6);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$6 = executionConfig$6;
                        this.fieldSerializers$6 = fieldSerializers$6;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, String>>(this, fieldSerializers){

                    public Tuple3<String, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime()}));
        this.tEnv().registerTable("T1", t1);
        this.tEnv().registerTable("T2", t2);
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Assert.assertFalse((boolean)sink.getAppendResults().contains((Object)"null"));
    }

    @Test
    public void testRowTimeInnerJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.key, t2.id, t1.id\n        |FROM T1 as t1 join T2 as t2 ON\n        |  t1.key = t2.key AND\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '5' SECOND AND\n        |    t2.rowtime + INTERVAL '6' SECOND\n        |")).stripMargin();
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT0.999", (Object)BoxesRunTime.boxToLong((long)999L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT1", (Object)BoxesRunTime.boxToLong((long)1000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT2", (Object)BoxesRunTime.boxToLong((long)2000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT3", (Object)BoxesRunTime.boxToLong((long)3000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"B", (Object)"LEFT4", (Object)BoxesRunTime.boxToLong((long)4000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT5", (Object)BoxesRunTime.boxToLong((long)5000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        data1.$plus$eq((Object)new Tuple3(null, (Object)"LEFT8", (Object)BoxesRunTime.boxToLong((long)8000L)));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)new Tuple3((Object)"A", (Object)"RIGHT6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"B", (Object)"RIGHT7", (Object)BoxesRunTime.boxToLong((long)7000L)));
        data2.$plus$eq((Object)new Tuple3(null, (Object)"RIGHT10", (Object)BoxesRunTime.boxToLong((long)10000L)));
        Table t1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data1, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$49 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$49 $outer;
                    private final ExecutionConfig executionConfig$7;
                    private final TypeSerializer[] fieldSerializers$7;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$7[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$7);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$7 = executionConfig$7;
                        this.fieldSerializers$7 = fieldSerializers$7;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        Table t2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data2, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$50 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$50 $outer;
                    private final ExecutionConfig executionConfig$8;
                    private final TypeSerializer[] fieldSerializers$8;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$8[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$8);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$8 = executionConfig$8;
                        this.fieldSerializers$8 = fieldSerializers$8;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        this.tEnv().registerTable("T1", t1);
        this.tEnv().registerTable("T2", t2);
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A,RIGHT6,LEFT1", "A,RIGHT6,LEFT2", "A,RIGHT6,LEFT3", "A,RIGHT6,LEFT5", "A,RIGHT6,LEFT6", "B,RIGHT7,LEFT4"}));
        Assert.assertEquals((Object)expected, (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowTimeInnerJoinWithIsNotDistinctFrom() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.key, t2.id, t1.id\n        |FROM T1 as t1 join T2 as t2 ON\n        |  t1.key is not distinct from t2.key AND\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '5' SECOND AND\n        |    t2.rowtime + INTERVAL '6' SECOND\n        |")).stripMargin();
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT0.999", (Object)BoxesRunTime.boxToLong((long)999L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT1", (Object)BoxesRunTime.boxToLong((long)1000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT2", (Object)BoxesRunTime.boxToLong((long)2000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT3", (Object)BoxesRunTime.boxToLong((long)3000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"B", (Object)"LEFT4", (Object)BoxesRunTime.boxToLong((long)4000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT5", (Object)BoxesRunTime.boxToLong((long)5000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        data1.$plus$eq((Object)new Tuple3(null, (Object)"LEFT8", (Object)BoxesRunTime.boxToLong((long)8000L)));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)new Tuple3((Object)"A", (Object)"RIGHT6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"B", (Object)"RIGHT7", (Object)BoxesRunTime.boxToLong((long)7000L)));
        data2.$plus$eq((Object)new Tuple3(null, (Object)"RIGHT10", (Object)BoxesRunTime.boxToLong((long)10000L)));
        Table t1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data1, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$51 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$51 $outer;
                    private final ExecutionConfig executionConfig$9;
                    private final TypeSerializer[] fieldSerializers$9;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$9[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$9);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$9 = executionConfig$9;
                        this.fieldSerializers$9 = fieldSerializers$9;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        Table t2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data2, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$52 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$52 $outer;
                    private final ExecutionConfig executionConfig$10;
                    private final TypeSerializer[] fieldSerializers$10;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$10[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$10);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$10 = executionConfig$10;
                        this.fieldSerializers$10 = fieldSerializers$10;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        this.tEnv().registerTable("T1", t1);
        this.tEnv().registerTable("T2", t2);
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A,RIGHT6,LEFT1", "A,RIGHT6,LEFT2", "A,RIGHT6,LEFT3", "A,RIGHT6,LEFT5", "A,RIGHT6,LEFT6", "B,RIGHT7,LEFT4", "null,RIGHT10,LEFT8"}));
        Assert.assertEquals((Object)expected, (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowTimeInnerJoinWithoutEqualCondition() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.key, t2.id, t1.id\n        |FROM T1 as t1 join T2 as t2 ON\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '5' SECOND AND\n        |    t2.rowtime + INTERVAL '6' SECOND\n        |")).stripMargin();
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT0.999", (Object)BoxesRunTime.boxToLong((long)999L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT1", (Object)BoxesRunTime.boxToLong((long)1000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT2", (Object)BoxesRunTime.boxToLong((long)2000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT3", (Object)BoxesRunTime.boxToLong((long)3000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"B", (Object)"LEFT4", (Object)BoxesRunTime.boxToLong((long)4000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT5", (Object)BoxesRunTime.boxToLong((long)5000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        data1.$plus$eq((Object)new Tuple3(null, (Object)"LEFT8", (Object)BoxesRunTime.boxToLong((long)8000L)));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)new Tuple3((Object)"A", (Object)"RIGHT6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"B", (Object)"RIGHT7", (Object)BoxesRunTime.boxToLong((long)7000L)));
        data2.$plus$eq((Object)new Tuple3(null, (Object)"RIGHT10", (Object)BoxesRunTime.boxToLong((long)10000L)));
        Table t1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data1, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$53 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$53 $outer;
                    private final ExecutionConfig executionConfig$11;
                    private final TypeSerializer[] fieldSerializers$11;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$11[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$11);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$11 = executionConfig$11;
                        this.fieldSerializers$11 = fieldSerializers$11;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        Table t2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data2, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$54 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$54 $outer;
                    private final ExecutionConfig executionConfig$12;
                    private final TypeSerializer[] fieldSerializers$12;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$12[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$12);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$12 = executionConfig$12;
                        this.fieldSerializers$12 = fieldSerializers$12;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        this.tEnv().registerTable("T1", t1);
        this.tEnv().registerTable("T2", t2);
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A,RIGHT6,LEFT1", "A,RIGHT6,LEFT2", "A,RIGHT6,LEFT3", "A,RIGHT6,LEFT4", "A,RIGHT6,LEFT5", "A,RIGHT6,LEFT6", "A,RIGHT6,LEFT8", "B,RIGHT7,LEFT2", "B,RIGHT7,LEFT3", "B,RIGHT7,LEFT4", "B,RIGHT7,LEFT5", "B,RIGHT7,LEFT6", "B,RIGHT7,LEFT8", "null,RIGHT10,LEFT5", "null,RIGHT10,LEFT6", "null,RIGHT10,LEFT8"}));
        Assert.assertEquals((Object)expected, (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testUnboundedAggAfterRowtimeInnerJoin() {
        String innerSql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.key as key, t2.id as id1, t1.id as id2\n        |FROM T1 as t1 join T2 as t2 ON\n        |  t1.key = t2.key AND\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '5' SECOND AND\n        |    t2.rowtime + INTERVAL '6' SECOND\n        |")).stripMargin();
        String sqlQuery = new StringBuilder().append((Object)"SELECT key, COUNT(DISTINCT id1), COUNT(DISTINCT id2) FROM (").append((Object)innerSql).append((Object)") GROUP BY key").toString();
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT0.999", (Object)BoxesRunTime.boxToLong((long)999L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT1", (Object)BoxesRunTime.boxToLong((long)1000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT2", (Object)BoxesRunTime.boxToLong((long)2000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT3", (Object)BoxesRunTime.boxToLong((long)3000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"B", (Object)"LEFT4", (Object)BoxesRunTime.boxToLong((long)4000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT5", (Object)BoxesRunTime.boxToLong((long)5000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"LEFT6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        data1.$plus$eq((Object)new Tuple3(null, (Object)"LEFT8", (Object)BoxesRunTime.boxToLong((long)8000L)));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)new Tuple3((Object)"A", (Object)"RIGHT6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"B", (Object)"RIGHT7", (Object)BoxesRunTime.boxToLong((long)7000L)));
        data2.$plus$eq((Object)new Tuple3(null, (Object)"RIGHT10", (Object)BoxesRunTime.boxToLong((long)10000L)));
        Table t1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data1, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$55 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$55 $outer;
                    private final ExecutionConfig executionConfig$13;
                    private final TypeSerializer[] fieldSerializers$13;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$13[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$13);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$13 = executionConfig$13;
                        this.fieldSerializers$13 = fieldSerializers$13;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        Table t2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data2, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$56 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$56 $outer;
                    private final ExecutionConfig executionConfig$14;
                    private final TypeSerializer[] fieldSerializers$14;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$14[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$14);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$14 = executionConfig$14;
                        this.fieldSerializers$14 = fieldSerializers$14;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        this.tEnv().registerTable("T1", t1);
        this.tEnv().registerTable("T2", t2);
        TestingRetractSink sink = new TestingRetractSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A,1,5", "B,1,1"}));
        Assert.assertEquals((Object)expected, (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowTimeInnerJoinWithEquiTimeAttrs() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.key, t2.id, t1.id\n        |FROM T1 AS t1 JOIN T2 AS t2 ON\n        |t1.key = t2.key AND\n        |t2.rowtime = t1.rowtime\n      ")).stripMargin();
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToLong((long)4000L), (Object)"A", (Object)BoxesRunTime.boxToLong((long)4000L)));
        data1.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToLong((long)5000L), (Object)"A", (Object)BoxesRunTime.boxToLong((long)5000L)));
        data1.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToLong((long)6000L), (Object)"A", (Object)BoxesRunTime.boxToLong((long)6000L)));
        data1.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToLong((long)6000L), (Object)"B", (Object)BoxesRunTime.boxToLong((long)6000L)));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)new Tuple3((Object)"A", (Object)"R-5", (Object)BoxesRunTime.boxToLong((long)5000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"B", (Object)"R-6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        Table t1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data1, (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$57 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$57 $outer;
                    private final ExecutionConfig executionConfig$15;
                    private final TypeSerializer[] fieldSerializers$15;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$15[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$15);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$15 = executionConfig$15;
                        this.fieldSerializers$15 = fieldSerializers$15;
                    }
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row4WatermarkExtractor())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$6), package$.MODULE$.symbol2FieldExpression(symbol$8), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$7)}));
        Table t2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data2, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$58 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$58 $outer;
                    private final ExecutionConfig executionConfig$16;
                    private final TypeSerializer[] fieldSerializers$16;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$16[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$16);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$16 = executionConfig$16;
                        this.fieldSerializers$16 = fieldSerializers$16;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), package$.MODULE$.symbol2FieldExpression(symbol$7)}));
        this.tEnv().registerTable("T1", t1);
        this.tEnv().registerTable("T2", t2);
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A,R-5,5", "B,R-6,6"}));
        Assert.assertEquals((Object)expected.toList().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowTimeInnerJoinWithOtherConditions() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a, t1.c, t2.c\n        |FROM T1 as t1 JOIN T2 as t2 ON\n        |  t1.a = t2.a AND\n        |  t1.rowtime > t2.rowtime - INTERVAL '5' SECOND AND\n        |    t1.rowtime < t2.rowtime - INTERVAL '1' SECOND AND\n        |  t1.b < t2.b AND\n        |  t1.b > 2\n        |")).stripMargin();
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)4L), (Object)"LEFT1", (Object)BoxesRunTime.boxToLong((long)1000L)));
        data1.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)8L), (Object)"LEFT1.1", (Object)BoxesRunTime.boxToLong((long)1001L)));
        data1.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"LEFT2", (Object)BoxesRunTime.boxToLong((long)2000L)));
        data1.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)7L), (Object)"LEFT3", (Object)BoxesRunTime.boxToLong((long)3000L)));
        data1.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)5L), (Object)"LEFT4", (Object)BoxesRunTime.boxToLong((long)4000L)));
        data1.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)4L), (Object)"LEFT4.9", (Object)BoxesRunTime.boxToLong((long)4999L)));
        data1.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)4L), (Object)"LEFT5", (Object)BoxesRunTime.boxToLong((long)5000L)));
        data1.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)10L), (Object)"LEFT6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"RIGHT1", (Object)BoxesRunTime.boxToLong((long)1000L)));
        data2.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)9L), (Object)"RIGHT6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        data2.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)14L), (Object)"RIGHT7", (Object)BoxesRunTime.boxToLong((long)7000L)));
        data2.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)4L), (Object)"RIGHT8", (Object)BoxesRunTime.boxToLong((long)8000L)));
        Table t1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data1, (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$59 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$59 $outer;
                    private final ExecutionConfig executionConfig$17;
                    private final TypeSerializer[] fieldSerializers$17;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$17[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$17);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$17 = executionConfig$17;
                        this.fieldSerializers$17 = fieldSerializers$17;
                    }
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row4WatermarkExtractor())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        Table t2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data2, (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$60 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$60 $outer;
                    private final ExecutionConfig executionConfig$18;
                    private final TypeSerializer[] fieldSerializers$18;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$18[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$18);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$18 = executionConfig$18;
                        this.fieldSerializers$18 = fieldSerializers$18;
                    }
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row4WatermarkExtractor())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        this.tEnv().registerTable("T1", t1);
        this.tEnv().registerTable("T2", t2);
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,LEFT3,RIGHT6", "1,LEFT1.1,RIGHT6", "2,LEFT4,RIGHT7", "1,LEFT4.9,RIGHT6"}));
        Assert.assertEquals((Object)expected.toList().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowTimeInnerJoinWithOtherTimeCondition() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a, t1.c, t2.c\n        |FROM T1 as t1 JOIN T2 as t2 ON\n        |  t1.a = t2.a AND\n        |  t1.rowtime > t2.rowtime - INTERVAL '4' SECOND AND\n        |    t1.rowtime < t2.rowtime AND\n        |  QUARTER(t1.rowtime) = t2.a\n        |")).stripMargin();
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)4L), (Object)"LEFT1", (Object)BoxesRunTime.boxToLong((long)1000L)));
        data1.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"LEFT2", (Object)BoxesRunTime.boxToLong((long)2000L)));
        data1.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)7L), (Object)"LEFT3", (Object)BoxesRunTime.boxToLong((long)3000L)));
        data1.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)5L), (Object)"LEFT4", (Object)BoxesRunTime.boxToLong((long)4000L)));
        data1.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)4L), (Object)"LEFT5", (Object)BoxesRunTime.boxToLong((long)5000L)));
        data1.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)10L), (Object)"LEFT6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"RIGHT1", (Object)BoxesRunTime.boxToLong((long)1000L)));
        data2.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)9L), (Object)"RIGHT6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        data2.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)8L), (Object)"RIGHT7", (Object)BoxesRunTime.boxToLong((long)7000L)));
        data2.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)4L), (Object)"RIGHT8", (Object)BoxesRunTime.boxToLong((long)8000L)));
        Table t1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data1, (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$61 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$61 $outer;
                    private final ExecutionConfig executionConfig$19;
                    private final TypeSerializer[] fieldSerializers$19;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$19[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$19);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$19 = executionConfig$19;
                        this.fieldSerializers$19 = fieldSerializers$19;
                    }
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row4WatermarkExtractor())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        Table t2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data2, (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$62 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$62 $outer;
                    private final ExecutionConfig executionConfig$20;
                    private final TypeSerializer[] fieldSerializers$20;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$20[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$20);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$20 = executionConfig$20;
                        this.fieldSerializers$20 = fieldSerializers$20;
                    }
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row4WatermarkExtractor())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        this.tEnv().registerTable("T1", t1);
        this.tEnv().registerTable("T2", t2);
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,LEFT3,RIGHT6", "1,LEFT5,RIGHT6", "1,LEFT5,RIGHT8", "1,LEFT6,RIGHT8"}));
        Assert.assertEquals((Object)expected.toList().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowTimeInnerJoinWithWindowAggregateOnFirstTime() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.key, TUMBLE_END(t1.rowtime, INTERVAL '4' SECOND), COUNT(t2.key)\n        |FROM T1 AS t1 join T2 AS t2 ON\n        |  t1.key = t2.key AND\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '5' SECOND AND\n        |    t2.rowtime + INTERVAL '5' SECOND\n        |GROUP BY TUMBLE(t1.rowtime, INTERVAL '4' SECOND), t1.key\n        |")).stripMargin();
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-1", (Object)BoxesRunTime.boxToLong((long)1000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-2", (Object)BoxesRunTime.boxToLong((long)2000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-3", (Object)BoxesRunTime.boxToLong((long)3000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"B", (Object)"L-4", (Object)BoxesRunTime.boxToLong((long)4000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"C", (Object)"L-5", (Object)BoxesRunTime.boxToLong((long)4000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-6", (Object)BoxesRunTime.boxToLong((long)10000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-7", (Object)BoxesRunTime.boxToLong((long)13000L)));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)new Tuple3((Object)"A", (Object)"R-1", (Object)BoxesRunTime.boxToLong((long)7000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"B", (Object)"R-4", (Object)BoxesRunTime.boxToLong((long)7000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"A", (Object)"R-3", (Object)BoxesRunTime.boxToLong((long)8000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"D", (Object)"R-2", (Object)BoxesRunTime.boxToLong((long)8000L)));
        Table t1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data1, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$63 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$63 $outer;
                    private final ExecutionConfig executionConfig$21;
                    private final TypeSerializer[] fieldSerializers$21;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$21[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$21);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$21 = executionConfig$21;
                        this.fieldSerializers$21 = fieldSerializers$21;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        Table t2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data2, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$64 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$64 $outer;
                    private final ExecutionConfig executionConfig$22;
                    private final TypeSerializer[] fieldSerializers$22;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$22[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$22);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$22 = executionConfig$22;
                        this.fieldSerializers$22 = fieldSerializers$22;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        this.tEnv().registerTable("T1", t1);
        this.tEnv().registerTable("T2", t2);
        TestingAppendSink sink = new TestingAppendSink();
        Table t_r = this.tEnv().sqlQuery(sqlQuery);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t_r).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A,1970-01-01T00:00:04,3", "A,1970-01-01T00:00:12,2", "A,1970-01-01T00:00:16,1", "B,1970-01-01T00:00:08,1"}));
        Assert.assertEquals((Object)expected.toList().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowTimeInnerJoinWithWindowAggregateOnSecondTime() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.key, TUMBLE_END(t2.rowtime, INTERVAL '4' SECOND), COUNT(t1.key)\n        |FROM T1 AS t1 join T2 AS t2 ON\n        | t1.key = t2.key AND\n        | t1.rowtime BETWEEN t2.rowtime - INTERVAL '5' SECOND AND\n        | t2.rowtime + INTERVAL '5' SECOND\n        | GROUP BY TUMBLE(t2.rowtime, INTERVAL '4' SECOND), t2.key\n      ")).stripMargin();
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-1", (Object)BoxesRunTime.boxToLong((long)1000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-2", (Object)BoxesRunTime.boxToLong((long)2000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-3", (Object)BoxesRunTime.boxToLong((long)3000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"B", (Object)"L-4", (Object)BoxesRunTime.boxToLong((long)4000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"C", (Object)"L-5", (Object)BoxesRunTime.boxToLong((long)4000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-6", (Object)BoxesRunTime.boxToLong((long)10000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-7", (Object)BoxesRunTime.boxToLong((long)13000L)));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)new Tuple3((Object)"A", (Object)"R-1", (Object)BoxesRunTime.boxToLong((long)7000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"B", (Object)"R-4", (Object)BoxesRunTime.boxToLong((long)7000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"A", (Object)"R-3", (Object)BoxesRunTime.boxToLong((long)8000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"D", (Object)"R-2", (Object)BoxesRunTime.boxToLong((long)8000L)));
        Table t1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data1, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$65 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$65 $outer;
                    private final ExecutionConfig executionConfig$23;
                    private final TypeSerializer[] fieldSerializers$23;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$23[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$23);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$23 = executionConfig$23;
                        this.fieldSerializers$23 = fieldSerializers$23;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        Table t2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data2, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$66 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$66 $outer;
                    private final ExecutionConfig executionConfig$24;
                    private final TypeSerializer[] fieldSerializers$24;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$24[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$24);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$24 = executionConfig$24;
                        this.fieldSerializers$24 = fieldSerializers$24;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        this.tEnv().registerTable("T1", t1);
        this.tEnv().registerTable("T2", t2);
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A,1970-01-01T00:00:08,3", "A,1970-01-01T00:00:12,3", "B,1970-01-01T00:00:08,1"}));
        Assert.assertEquals((Object)expected.toList().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testProcTimeLeftOuterJoin() {
        this.env().setParallelism(1);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a, t2.c, t1.c\n        |FROM T1 AS t1 LEFT OUTER JOIN T2 AS t2 ON\n        | t1.a = t2.a AND\n        | t1.proctime BETWEEN t2.proctime - INTERVAL '5' SECOND AND\n        | t2.proctime + INTERVAL '3' SECOND\n      ")).stripMargin();
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Hi1"));
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Hi2"));
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)5L), (Object)"Hi3"));
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)7L), (Object)"Hi5"));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"HiHi"));
        data2.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"HeHe"));
        Table t1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data1, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$67 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$67 $outer;
                    private final ExecutionConfig executionConfig$25;
                    private final TypeSerializer[] fieldSerializers$25;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$25[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$25);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$25 = executionConfig$25;
                        this.fieldSerializers$25 = fieldSerializers$25;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime()}));
        Table t2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data2, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$68 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$68 $outer;
                    private final ExecutionConfig executionConfig$26;
                    private final TypeSerializer[] fieldSerializers$26;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$26[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$26);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$26 = executionConfig$26;
                        this.fieldSerializers$26 = fieldSerializers$26;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime()}));
        this.tEnv().registerTable("T1", t1);
        this.tEnv().registerTable("T2", t2);
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink);
        this.env().execute();
    }

    @Test
    public void testRowTimeLeftOuterJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.key, t2.id, t1.id\n        |FROM T1 AS t1 LEFT OUTER JOIN  T2 AS t2 ON\n        | t1.key = t2.key AND\n        | t1.rowtime BETWEEN t2.rowtime - INTERVAL '5' SECOND AND\n        | t2.rowtime + INTERVAL '6' SECOND AND\n        | t1.id <> 'L-5'\n      ")).stripMargin();
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-1", (Object)BoxesRunTime.boxToLong((long)1000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-2", (Object)BoxesRunTime.boxToLong((long)2000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"B", (Object)"L-4", (Object)BoxesRunTime.boxToLong((long)4000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"B", (Object)"L-5", (Object)BoxesRunTime.boxToLong((long)5000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"C", (Object)"L-7", (Object)BoxesRunTime.boxToLong((long)7000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-10", (Object)BoxesRunTime.boxToLong((long)10000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-12", (Object)BoxesRunTime.boxToLong((long)12000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-20", (Object)BoxesRunTime.boxToLong((long)20000L)));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)new Tuple3((Object)"A", (Object)"R-6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"B", (Object)"R-7", (Object)BoxesRunTime.boxToLong((long)7000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"D", (Object)"R-8", (Object)BoxesRunTime.boxToLong((long)8000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"A", (Object)"R-11", (Object)BoxesRunTime.boxToLong((long)11000L)));
        Table t1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data1, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$69 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$69 $outer;
                    private final ExecutionConfig executionConfig$27;
                    private final TypeSerializer[] fieldSerializers$27;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$27[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$27);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$27 = executionConfig$27;
                        this.fieldSerializers$27 = fieldSerializers$27;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        Table t2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data2, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$70 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$70 $outer;
                    private final ExecutionConfig executionConfig$28;
                    private final TypeSerializer[] fieldSerializers$28;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$28[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$28);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$28 = executionConfig$28;
                        this.fieldSerializers$28 = fieldSerializers$28;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        this.tEnv().registerTable("T1", t1);
        this.tEnv().registerTable("T2", t2);
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A,R-6,L-1", "A,R-6,L-2", "A,R-6,L-6", "A,R-6,L-10", "A,R-6,L-12", "B,R-7,L-4", "A,R-11,L-6", "A,R-11,L-10", "A,R-11,L-12", "B,null,L-5", "C,null,L-7", "A,null,L-20"}));
        Assert.assertEquals((Object)expected.toList().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowTimeLeftOuterJoinNegativeIntervalSize() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.key, t2.id, t1.id\n        |FROM T1 AS t1 LEFT OUTER JOIN T2 AS t2 ON\n        | t1.key = t2.key AND\n        |  t1.rowtime BETWEEN t2.rowtime + INTERVAL '3' SECOND AND\n        |  t2.rowtime + INTERVAL '1' SECOND\n      ")).stripMargin();
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-1", (Object)BoxesRunTime.boxToLong((long)1000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"B", (Object)"L-4", (Object)BoxesRunTime.boxToLong((long)4000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"C", (Object)"L-7", (Object)BoxesRunTime.boxToLong((long)7000L)));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)new Tuple3((Object)"A", (Object)"R-6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"B", (Object)"R-7", (Object)BoxesRunTime.boxToLong((long)7000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"D", (Object)"R-8", (Object)BoxesRunTime.boxToLong((long)8000L)));
        Table t1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data1, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$71 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$71 $outer;
                    private final ExecutionConfig executionConfig$29;
                    private final TypeSerializer[] fieldSerializers$29;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$29[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$29);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$29 = executionConfig$29;
                        this.fieldSerializers$29 = fieldSerializers$29;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        Table t2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data2, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$72 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$72 $outer;
                    private final ExecutionConfig executionConfig$30;
                    private final TypeSerializer[] fieldSerializers$30;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$30[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$30);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$30 = executionConfig$30;
                        this.fieldSerializers$30 = fieldSerializers$30;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        this.tEnv().registerTable("T1", t1);
        this.tEnv().registerTable("T2", t2);
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"null,null,L-1", "null,null,L-4", "null,null,L-7"}));
        Assert.assertEquals((Object)expected.toList().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testProcTimeRightOuterJoin() {
        this.env().setParallelism(1);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a, t2.c, t1.c\n        |FROM T1 as t1 RIGHT  OUTER JOIN T2 as t2 ON\n        | t1.a = t2.a AND\n        | t1.proctime BETWEEN t2.proctime -  INTERVAL '5' SECOND AND\n        | t2.proctime + INTERVAL '3' SECOND\n      ")).stripMargin();
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Hi1"));
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Hi2"));
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)5L), (Object)"Hi3"));
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)7L), (Object)"Hi5"));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"HiHi"));
        data2.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"HeHe"));
        Table t1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data1, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$73 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$73 $outer;
                    private final ExecutionConfig executionConfig$31;
                    private final TypeSerializer[] fieldSerializers$31;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$31[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$31);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$31 = executionConfig$31;
                        this.fieldSerializers$31 = fieldSerializers$31;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime()}));
        Table t2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data2, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$74 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$74 $outer;
                    private final ExecutionConfig executionConfig$32;
                    private final TypeSerializer[] fieldSerializers$32;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$32[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$32);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$32 = executionConfig$32;
                        this.fieldSerializers$32 = fieldSerializers$32;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime()}));
        this.tEnv().registerTable("T1", t1);
        this.tEnv().registerTable("T2", t2);
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink);
        this.env().execute();
    }

    @Test
    public void testRowTimeRightOuterJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.key, t2.id, t1.id\n        |FROM T1 AS t1 RIGHT OUTER JOIN T2 AS t2 ON\n        | t1.key = t2.key AND\n        | t1.rowtime BETWEEN t2.rowtime - INTERVAL '5' SECOND AND\n        | t2.rowtime + INTERVAL '6' SECOND AND\n        | t2.id <> 'R-5'\n      ")).stripMargin();
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-1", (Object)BoxesRunTime.boxToLong((long)1000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-2", (Object)BoxesRunTime.boxToLong((long)2000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"B", (Object)"L-4", (Object)BoxesRunTime.boxToLong((long)4000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"C", (Object)"L-7", (Object)BoxesRunTime.boxToLong((long)7000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-10", (Object)BoxesRunTime.boxToLong((long)10000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-12", (Object)BoxesRunTime.boxToLong((long)12000L)));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)new Tuple3((Object)"A", (Object)"R-5", (Object)BoxesRunTime.boxToLong((long)5000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"A", (Object)"R-6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"B", (Object)"R-7", (Object)BoxesRunTime.boxToLong((long)7000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"D", (Object)"R-8", (Object)BoxesRunTime.boxToLong((long)8000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"A", (Object)"R-20", (Object)BoxesRunTime.boxToLong((long)20000L)));
        Table t1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data1, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$75 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$75 $outer;
                    private final ExecutionConfig executionConfig$33;
                    private final TypeSerializer[] fieldSerializers$33;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$33[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$33);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$33 = executionConfig$33;
                        this.fieldSerializers$33 = fieldSerializers$33;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        Table t2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data2, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$76 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$76 $outer;
                    private final ExecutionConfig executionConfig$34;
                    private final TypeSerializer[] fieldSerializers$34;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$34[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$34);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$34 = executionConfig$34;
                        this.fieldSerializers$34 = fieldSerializers$34;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        this.tEnv().registerTable("T1", t1);
        this.tEnv().registerTable("T2", t2);
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A,R-5,null", "A,R-6,L-1", "A,R-6,L-2", "A,R-6,L-6", "A,R-6,L-10", "A,R-6,L-12", "A,R-20,null", "B,R-7,L-4", "D,R-8,null"}));
        Assert.assertEquals((Object)expected.toList().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowTimeRightOuterJoinNegativeIntervalSize() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.key, t2.id, t1.id\n        |FROM T1 AS t1 RIGHT OUTER JOIN T2 AS t2 ON\n        |t1.key = t2.key AND\n        |t1.rowtime BETWEEN t2.rowtime + INTERVAL '5' SECOND AND\n        |t2.rowtime + INTERVAL '1' SECOND\n      ")).stripMargin();
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-1", (Object)BoxesRunTime.boxToLong((long)1000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"B", (Object)"L-4", (Object)BoxesRunTime.boxToLong((long)4000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"C", (Object)"L-7", (Object)BoxesRunTime.boxToLong((long)7000L)));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)new Tuple3((Object)"A", (Object)"R-6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"B", (Object)"R-7", (Object)BoxesRunTime.boxToLong((long)7000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"D", (Object)"R-8", (Object)BoxesRunTime.boxToLong((long)8000L)));
        Table t1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data1, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$77 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$77 $outer;
                    private final ExecutionConfig executionConfig$35;
                    private final TypeSerializer[] fieldSerializers$35;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$35[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$35);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$35 = executionConfig$35;
                        this.fieldSerializers$35 = fieldSerializers$35;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        Table t2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data2, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$78 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$78 $outer;
                    private final ExecutionConfig executionConfig$36;
                    private final TypeSerializer[] fieldSerializers$36;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$36[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$36);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$36 = executionConfig$36;
                        this.fieldSerializers$36 = fieldSerializers$36;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        this.tEnv().registerTable("T1", t1);
        this.tEnv().registerTable("T2", t2);
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A,R-6,null", "B,R-7,null", "D,R-8,null"}));
        Assert.assertEquals((Object)expected.toList().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testProcTimeFullOuterJoin() {
        this.env().setParallelism(1);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a, t2.c, t1.c\n        |FROM T1 as t1 FULL OUTER JOIN T2 as t2 ON\n        |t1.a = t2.a AND\n        |t1.proctime BETWEEN t2.proctime -  INTERVAL '5' SECOND AND\n        |t2.proctime\n      ")).stripMargin();
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Hi1"));
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Hi2"));
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)5L), (Object)"Hi3"));
        data1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)7L), (Object)"Hi5"));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"HiHi"));
        data2.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"HeHe"));
        Table t1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data1, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$79 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$79 $outer;
                    private final ExecutionConfig executionConfig$37;
                    private final TypeSerializer[] fieldSerializers$37;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$37[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$37);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$37 = executionConfig$37;
                        this.fieldSerializers$37 = fieldSerializers$37;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime()}));
        Table t2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data2, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$80 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$80 $outer;
                    private final ExecutionConfig executionConfig$38;
                    private final TypeSerializer[] fieldSerializers$38;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$38[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$38);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$38 = executionConfig$38;
                        this.fieldSerializers$38 = fieldSerializers$38;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime()}));
        this.tEnv().registerTable("T1", t1);
        this.tEnv().registerTable("T2", t2);
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink);
        this.env().execute();
    }

    @Test
    public void testRowTimeFullOuterJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.key, t2.id, t1.id\n        |FROM T1 AS t1 FULL OUTER JOIN T2 AS t2 ON\n        |t1.key = t2.key AND\n        |t1.rowtime BETWEEN t2.rowtime - INTERVAL '5' SECOND AND\n        |t2.rowtime + INTERVAL '6' SECOND AND\n        |NOT (t1.id = 'L-5' OR t2.id = 'R-5')\n      ")).stripMargin();
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-1", (Object)BoxesRunTime.boxToLong((long)1000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-2", (Object)BoxesRunTime.boxToLong((long)2000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"B", (Object)"L-4", (Object)BoxesRunTime.boxToLong((long)4000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"B", (Object)"L-5", (Object)BoxesRunTime.boxToLong((long)5000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"C", (Object)"L-7", (Object)BoxesRunTime.boxToLong((long)7000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-10", (Object)BoxesRunTime.boxToLong((long)10000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-12", (Object)BoxesRunTime.boxToLong((long)12000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-20", (Object)BoxesRunTime.boxToLong((long)20000L)));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)new Tuple3((Object)"A", (Object)"R-5", (Object)BoxesRunTime.boxToLong((long)5000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"A", (Object)"R-6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"B", (Object)"R-7", (Object)BoxesRunTime.boxToLong((long)7000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"D", (Object)"R-8", (Object)BoxesRunTime.boxToLong((long)8000L)));
        Table t1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data1, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$81 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$81 $outer;
                    private final ExecutionConfig executionConfig$39;
                    private final TypeSerializer[] fieldSerializers$39;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$39[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$39);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$39 = executionConfig$39;
                        this.fieldSerializers$39 = fieldSerializers$39;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        Table t2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data2, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$82 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$82 $outer;
                    private final ExecutionConfig executionConfig$40;
                    private final TypeSerializer[] fieldSerializers$40;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$40[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$40);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$40 = executionConfig$40;
                        this.fieldSerializers$40 = fieldSerializers$40;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        this.tEnv().registerTable("T1", t1);
        this.tEnv().registerTable("T2", t2);
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A,R-6,L-1", "A,R-6,L-2", "A,R-6,L-6", "A,R-6,L-10", "A,R-6,L-12", "B,R-7,L-4", "A,R-5,null", "D,R-8,null", "null,null,L-5", "null,null,L-7", "null,null,L-20"}));
        Assert.assertEquals((Object)expected.toList().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowTimeFullOuterJoinNegativeIntervalSize() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.key, t2.id, t1.id\n        |FROM T1 AS t1 FULL OUTER JOIN T2 AS t2 ON\n        |t1.key = t2.key AND\n        |t1.rowtime BETWEEN t2.rowtime + INTERVAL '5' SECOND AND\n        |t2.rowtime + INTERVAL '4' SECOND\n      ")).stripMargin();
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)new Tuple3((Object)"A", (Object)"L-1", (Object)BoxesRunTime.boxToLong((long)1000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"B", (Object)"L-4", (Object)BoxesRunTime.boxToLong((long)4000L)));
        data1.$plus$eq((Object)new Tuple3((Object)"C", (Object)"L-7", (Object)BoxesRunTime.boxToLong((long)7000L)));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)new Tuple3((Object)"A", (Object)"R-6", (Object)BoxesRunTime.boxToLong((long)6000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"B", (Object)"R-7", (Object)BoxesRunTime.boxToLong((long)7000L)));
        data2.$plus$eq((Object)new Tuple3((Object)"D", (Object)"R-8", (Object)BoxesRunTime.boxToLong((long)8000L)));
        Table t1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data1, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$83 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$83 $outer;
                    private final ExecutionConfig executionConfig$41;
                    private final TypeSerializer[] fieldSerializers$41;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$41[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$41);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$41 = executionConfig$41;
                        this.fieldSerializers$41 = fieldSerializers$41;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        Table t2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data2, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$84 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$84 $outer;
                    private final ExecutionConfig executionConfig$42;
                    private final TypeSerializer[] fieldSerializers$42;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$42[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$42);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$42 = executionConfig$42;
                        this.fieldSerializers$42 = fieldSerializers$42;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, Object>>(this, fieldSerializers){

                    public Tuple3<String, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new Row3WatermarkExtractor2())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$7).rowtime()}));
        this.tEnv().registerTable("T1", t1);
        this.tEnv().registerTable("T2", t2);
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"null,null,L-1", "null,null,L-4", "null,null,L-7", "A,R-6,null", "B,R-7,null", "D,R-8,null"}));
        Assert.assertEquals((Object)expected.toList().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    public IntervalJoinITCase(StreamingWithStateTestBase.StateBackendMode mode) {
        super(mode);
    }
}

