/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.api.scala.typeutils.Types$;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestSinkUtil$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendRowDataSink;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.runtime.utils.TestingAppendTableSink;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.MapDataSerializerTest;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.utils.LegacyRowResource;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0001'\tQ1)\u00197d\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0007gR\u0014X-Y7\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\u0007\u0003\u0015)H/\u001b7t\u0013\tIbCA\tTiJ,\u0017-\\5oOR+7\u000f\u001e\"bg\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000b\u0001\u0002A\u0011A\u0011\u0002\u001dU\u001cXm\u001d'fO\u0006\u001c\u0017PU8xgV\t!\u0005\u0005\u0002$K5\tAE\u0003\u0002\u0018\u0015%\u0011a\u0005\n\u0002\u0012\u0019\u0016<\u0017mY=S_^\u0014Vm]8ve\u000e,\u0007FA\u0010)!\tIC&D\u0001+\u0015\tY\u0003#A\u0003kk:LG/\u0003\u0002.U\t!!+\u001e7f\u0011\u0015y\u0003\u0001\"\u00011\u0003\u0011\"Xm\u001d;DCN$h*^7fe&\u001cGk\u001c\"p_2,\u0017M\\%o!J|'.Z2uS>tG#A\u0019\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\tUs\u0017\u000e\u001e\u0015\u0003]a\u0002\"!K\u001d\n\u0005iR#\u0001\u0002+fgRDQ\u0001\u0010\u0001\u0005\u0002A\n1\u0005^3ti\u000e\u000b7\u000f\u001e(v[\u0016\u0014\u0018n\u0019+p\u0005>|G.Z1o\u0013:\u001cuN\u001c3ji&|g\u000e\u000b\u0002<q!)q\b\u0001C\u0001a\u0005AB/Z:u\u000f\u0016tWM]5d%><\u0018I\u001c3S_^$\u0015\r^1)\u0005yB\u0004\"\u0002\"\u0001\t\u0003\u0001\u0014!\u0005;fgR\u0014vn^!oIJ{w\u000fR1uC\"\u0012\u0011\t\u000f\u0005\u0006\u000b\u0002!\t\u0001M\u0001\u0015i\u0016\u001cHoR3oKJL7MU8x\u0003:$'k\\<)\u0005\u0011C\u0004\"\u0002%\u0001\t\u0003\u0001\u0014!\u0004;fgR\u0014vn^!oIJ{w\u000f\u000b\u0002Hq!)1\n\u0001C\u0001a\u0005!B/Z:u!JLW.\u001b;jm\u0016l\u0015\r\u001d+za\u0016D#A\u0013\u001d\t\u000b9\u0003A\u0011\u0001\u0019\u0002/Q,7\u000f\u001e(p]B\u0013\u0018.\\5uSZ,W*\u00199UsB,\u0007FA'9\u0011\u0015\t\u0006\u0001\"\u00011\u0003u!Xm\u001d;TK2,7\r^*uCJ4%o\\7OKN$X\r\u001a+bE2,\u0007F\u0001)9\u0011\u0015!\u0006\u0001\"\u00011\u0003\u0019!Xm\u001d;J]\"\u00121\u000b\u000f\u0005\u0006/\u0002!\t\u0001M\u0001\ni\u0016\u001cHOT8u\u0013:D#A\u0016\u001d\t\u000bi\u0003A\u0011\u0001\u0019\u0002-Q,7\u000f\u001e'p]\u001e\u0004&o\u001c6fGRLwN\u001c'jgRD#!\u0017\u001d\t\u000bu\u0003A\u0011\u0001\u0019\u0002AQ,7\u000f^*pkJ\u001cWmV5uQ\u000e+8\u000f^8n\u0013:$XM\u001d8bY\u0012\u000bG/\u0019\u0015\u00039bBQ\u0001\u0019\u0001\u0005\u0002A\n\u0011\u0003^3tiNKW\u000e\u001d7f!J|'.Z2uQ\ty\u0006\bC\u0003d\u0001\u0011\u0005\u0001'A\tuKN$h*Z:uK\u0012\u0004&o\u001c6fGRD#A\u0019\u001d\t\u000b\u0019\u0004A\u0011\u0001\u0019\u0002MQ,7\u000f\u001e#fG&l\u0017\r\\!se\u0006Lx+\u001b;i\t&4g-\u001a:f]R\u0004&/Z2jg&|g\u000e\u000b\u0002fq!)\u0011\u000e\u0001C\u0001a\u0005!C/Z:u\t\u0016\u001c\u0017.\\1m\u001b\u0006\u0004x+\u001b;i\t&4g-\u001a:f]R\u0004&/Z2jg&|g\u000e\u000b\u0002iq!)A\u000e\u0001C\u0001a\u0005!B/Z:u\u0007V\u0014(/\u001a8u/\u0006$XM]7be.D#a\u001b\u001d\t\u000b=\u0004A\u0011\u0001\u0019\u0002UQ,7\u000f^\"veJ,g\u000e^,bi\u0016\u0014X.\u0019:l\r>\u0014hj\u001c8S_^$\u0018.\\3BiR\u0014\u0018NY;uK\"\u0012a\u000e\u000f\u0005\u0006e\u0002!\t\u0001M\u0001'i\u0016\u001cHo\u0011:fCR,G+Z7q_J\f'/\u001f+bE2,gI]8n\t\u0016\u001c8M]5qi>\u0014\bFA99\u0011\u0015)\b\u0001\"\u00011\u0003)!Xm\u001d;TK\u0006\u00148\r\u001b\u0015\u0003ib\u0002")
public class CalcITCase
extends StreamingTestBase {
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("_1");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("_2");

    @Rule
    public LegacyRowResource usesLegacyRows() {
        return LegacyRowResource.INSTANCE;
    }

    @Test
    public void testCastNumericToBooleanInProjection() {
        String sqlQuery = "SELECT CAST(1 AS BOOLEAN), CAST(0 AS BOOLEAN), CAST(1.1 AS BOOLEAN), CAST(0.00 AS BOOLEAN)";
        InternalTypeInfo outputType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new BooleanType(), new BooleanType(), new BooleanType(), new BooleanType()});
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(RowData.class));
        TestingAppendRowDataSink sink = new TestingAppendRowDataSink((InternalTypeInfo<RowData>)outputType);
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"+I(true,false,true,false)"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCastNumericToBooleanInCondition() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT * FROM MyTableRow WHERE b = CAST(1 AS BOOLEAN)\n         | UNION ALL\n         | SELECT * FROM MyTableRow WHERE b = CAST(0 AS BOOLEAN)\n         | UNION ALL\n         | SELECT * FROM MyTableRow WHERE b = CAST(1.1 AS BOOLEAN)\n         | UNION ALL\n         | SELECT * FROM MyTableRow WHERE b = CAST(0.0 AS BOOLEAN)\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin();
        GenericRowData rowData1 = new GenericRowData(2);
        rowData1.setField(0, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData1.setField(1, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        GenericRowData rowData2 = new GenericRowData(2);
        rowData2.setField(0, (Object)BoxesRunTime.boxToInteger((int)2));
        rowData2.setField(1, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        List data = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GenericRowData[]{rowData1, rowData2}));
        InternalTypeInfo dataType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new BooleanType()});
        DataStream ds = this.env().fromCollection((Seq)data, (TypeInformation)dataType);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2)}));
        this.tEnv().registerTable("MyTableRow", t);
        InternalTypeInfo outputType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new BooleanType()});
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(RowData.class));
        TestingAppendRowDataSink sink = new TestingAppendRowDataSink((InternalTypeInfo<RowData>)outputType);
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"+I(1,true)", "+I(2,false)", "+I(1,true)", "+I(2,false)"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testGenericRowAndRowData() {
        String sqlQuery = "SELECT * FROM MyTableRow";
        GenericRowData rowData = new GenericRowData(3);
        rowData.setField(0, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData.setField(1, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData.setField(2, (Object)BoxesRunTime.boxToLong((long)1L));
        List data = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GenericRowData[]{rowData}));
        InternalTypeInfo tpe = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new IntType(), new BigIntType()});
        DataStream ds = this.env().fromCollection((Seq)data, (TypeInformation)tpe);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3)}));
        this.tEnv().registerTable("MyTableRow", t);
        InternalTypeInfo outputType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new IntType(), new BigIntType()});
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(RowData.class));
        TestingAppendRowDataSink sink = new TestingAppendRowDataSink((InternalTypeInfo<RowData>)outputType);
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"+I(1,1,1)"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowAndRowData() {
        String sqlQuery = "SELECT * FROM MyTableRow WHERE c < 3";
        List data = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{"Hello", "Worlds", BoxesRunTime.boxToInteger((int)1)}), Row.of((Object[])new Object[]{"Hello", "Hiden", BoxesRunTime.boxToInteger((int)5)}), Row.of((Object[])new Object[]{"Hello again", "Worlds", BoxesRunTime.boxToInteger((int)2)})}));
        RowTypeInfo tpe = new RowTypeInfo(new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.STRING(), Types$.MODULE$.INT()});
        DataStream ds = this.env().fromCollection((Seq)data, (TypeInformation)tpe);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3)}));
        this.tEnv().registerTable("MyTableRow", t);
        InternalTypeInfo outputType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new VarCharType(Integer.MAX_VALUE), new VarCharType(Integer.MAX_VALUE), new IntType()});
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(RowData.class));
        TestingAppendRowDataSink sink = new TestingAppendRowDataSink((InternalTypeInfo<RowData>)outputType);
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"+I(Hello,Worlds,1)", "+I(Hello again,Worlds,2)"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testGenericRowAndRow() {
        String sqlQuery = "SELECT * FROM MyTableRow";
        GenericRowData rowData = new GenericRowData(3);
        rowData.setField(0, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData.setField(1, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData.setField(2, (Object)BoxesRunTime.boxToLong((long)1L));
        List data = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GenericRowData[]{rowData}));
        InternalTypeInfo tpe = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new IntType(), new BigIntType()});
        DataStream ds = this.env().fromCollection((Seq)data, (TypeInformation)tpe);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3)}));
        this.tEnv().registerTable("MyTableRow", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,1"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowAndRow() {
        String sqlQuery = "SELECT * FROM MyTableRow WHERE c < 3";
        List data = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{"Hello", "Worlds", BoxesRunTime.boxToInteger((int)1)}), Row.of((Object[])new Object[]{"Hello", "Hiden", BoxesRunTime.boxToInteger((int)5)}), Row.of((Object[])new Object[]{"Hello again", "Worlds", BoxesRunTime.boxToInteger((int)2)})}));
        RowTypeInfo tpe = new RowTypeInfo(new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.STRING(), Types$.MODULE$.INT()});
        DataStream ds = this.env().fromCollection((Seq)data, (TypeInformation)tpe);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3)}));
        this.tEnv().registerTable("MyTableRow", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream((TypeInformation)tpe);
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hello,Worlds,1", "Hello again,Worlds,2"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPrimitiveMapType() {
        String sqlQuery = "SELECT MAP[b, 30, 10, a] FROM MyTableRow";
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.smallTupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$9 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3)}));
        this.tEnv().registerTable("MyTableRow", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{1=30, 10=1}", "{2=30, 10=2}", "{2=30, 10=3}"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNonPrimitiveMapType() {
        String sqlQuery = "SELECT MAP[a, c] FROM MyTableRow";
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.smallTupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$10 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3)}));
        this.tEnv().registerTable("MyTableRow", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{1=Hi}", "{2=Hello}", "{3=Hello world}"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSelectStarFromNestedTable() {
        String sqlQuery = "SELECT * FROM MyTable";
        Table table = this.tEnv().fromDataStream(this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)"0"), new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)"1"), new Tuple2((Object)new Tuple2.mcII.sp(2, 2), (Object)"2")})), (TypeInformation)new CaseClassTypeInfo<Tuple2<Tuple2<Object, Object>, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Tuple2<Object, Object>, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$11 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$5;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$5[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$5 = fieldSerializers$5;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<Tuple2<Object, Object>, String>> unused = new ScalaCaseClassSerializer<Tuple2<Tuple2<Object, Object>, String>>(this, fieldSerializers){

                    public Tuple2<Tuple2<Object, Object>, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)((Tuple2)fields[0]), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$5)}));
        this.tEnv().registerTable("MyTable", table);
        Table result = this.tEnv().sqlQuery(sqlQuery);
        TestingAppendTableSink sink = TestSinkUtil$.MODULE$.configureSink(result, new TestingAppendTableSink());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSinkInternal("MySink", (TableSink)sink);
        table.executeInsert("MySink").await();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,0,0", "1,1,1", "2,2,2"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testIn() {
        String sqlQuery = "SELECT * FROM MyTable WHERE b in (1,3,4,5,6)";
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$14 $outer;
                    private final ExecutionConfig executionConfig$6;
                    private final TypeSerializer[] fieldSerializers$6;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$6[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$6);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$6 = executionConfig$6;
                        this.fieldSerializers$6 = fieldSerializers$6;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3)}));
        this.tEnv().registerTable("MyTable", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,Hi", "4,3,Hello world, how are you?", "5,3,I am fine.", "6,3,Luke Skywalker", "7,4,Comment#1", "8,4,Comment#2", "9,4,Comment#3", "10,4,Comment#4", "11,5,Comment#5", "12,5,Comment#6", "13,5,Comment#7", "14,5,Comment#8", "15,5,Comment#9", "16,6,Comment#10", "17,6,Comment#11", "18,6,Comment#12", "19,6,Comment#13", "20,6,Comment#14", "21,6,Comment#15"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNotIn() {
        String sqlQuery = "SELECT * FROM MyTable WHERE b not in (1,3,4,5,6)";
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$15 $outer;
                    private final ExecutionConfig executionConfig$7;
                    private final TypeSerializer[] fieldSerializers$7;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$7[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$7);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$7 = executionConfig$7;
                        this.fieldSerializers$7 = fieldSerializers$7;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3)}));
        this.tEnv().registerTable("MyTable", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,2,Hello", "3,2,Hello world"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testLongProjectionList() {
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.smallTupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$16 $outer;
                    private final ExecutionConfig executionConfig$8;
                    private final TypeSerializer[] fieldSerializers$8;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$8[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$8);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$8 = executionConfig$8;
                        this.fieldSerializers$8 = fieldSerializers$8;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3)}));
        this.tEnv().createTemporaryView("MyTable", t);
        String selectList = ((Stream)((Stream)package$.MODULE$.Stream().range((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)200), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int i) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CASE WHEN a IS NOT NULL AND a > ", " THEN 0 WHEN a < 0 THEN 0 ELSE ", " END"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)i)}));
            }
        }, Stream$.MODULE$.canBuildFrom())).mkString(",");
        String sqlQuery = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select ", " from MyTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{selectList}));
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        String expected = ((Stream)((Stream)package$.MODULE$.Stream().range((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)200), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int x$1) {
                return ((Object)BoxesRunTime.boxToInteger((int)x$1)).toString();
            }
        }, Stream$.MODULE$.canBuildFrom())).mkString(",");
        Assert.assertEquals((long)sink.getAppendResults().size(), (long)TestData$.MODULE$.smallTupleData3().size());
        sink.getAppendResults().foreach((Function1)new Serializable(this, expected){
            public static final long serialVersionUID = 0L;
            private final String expected$1;

            public final void apply(String result) {
                Assert.assertEquals((Object)this.expected$1, (Object)result);
            }
            {
                this.expected$1 = expected$1;
            }
        });
    }

    @Test
    public void testSourceWithCustomInternalData() {
        GenericRowData rowData1 = new GenericRowData(2);
        rowData1.setField(0, (Object)BoxesRunTime.boxToLong((long)1L));
        rowData1.setField(1, (Object)this.createMapData$1(1L, 2L));
        GenericRowData rowData2 = new GenericRowData(2);
        rowData2.setField(0, (Object)BoxesRunTime.boxToLong((long)2L));
        rowData2.setField(1, (Object)this.createMapData$1(4L, 5L));
        List values = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GenericRowData[]{rowData1, rowData2}));
        String myTableDataId = TestValuesTableFactory.registerRowData((Seq<RowData>)values);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE CustomTable (\n         |  a bigint,\n         |  b map<bigint, bigint>\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '", "',\n         |  'register-internal-data' = 'true',\n         |  'bounded' = 'true'\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{myTableDataId})))).stripMargin();
        this.env().getConfig().disableObjectReuse();
        this.tEnv().executeSql(ddl);
        TableResult result = this.tEnv().executeSql("select a, b from CustomTable");
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,{1=2}", "2,{4=5}"}));
        Buffer actual = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(CollectionUtil.iteratorToList((Iterator)result.collect())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Row r) {
                return r.toString();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)actual.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSimpleProject() {
        String myTableDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.smallData3());
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE SimpleTable (\n         |  a int,\n         |  b bigint,\n         |  c string\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '", "',\n         |  'bounded' = 'true'\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{myTableDataId})))).stripMargin();
        this.tEnv().executeSql(ddl);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery("select a, c from SimpleTable")).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,Hi", "2,Hello", "3,Hello world"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNestedProject() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"HI", BoxesRunTime.boxToInteger((int)11)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)111), BoxesRunTime.boxToBoolean((boolean)true)}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hi", BoxesRunTime.boxToInteger((int)1111)})), "tom"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"HELLO", BoxesRunTime.boxToInteger((int)22)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)222), BoxesRunTime.boxToBoolean((boolean)false)}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hello", BoxesRunTime.boxToInteger((int)2222)})), "mary"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"HELLO WORLD", BoxesRunTime.boxToInteger((int)33)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)333), BoxesRunTime.boxToBoolean((boolean)true)}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hello world", BoxesRunTime.boxToInteger((int)3333)})), "benji"}))}));
        String myTableDataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE NestedTable (\n         |  id int,\n         |  deepNested row<nested1 row<name string, `value` int>,\n         |                 nested2 row<num int, flag boolean>>,\n         |  nested row<name string, `value` int>,\n         |  name string\n         |) WITH (\n         |  'connector' = 'values',\n         |  'nested-projection-supported' = 'false',\n         |  'data-id' = '", "',\n         |  'bounded' = 'true'\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{myTableDataId})))).stripMargin();
        this.tEnv().executeSql(ddl);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |select id,\n        |    deepNested.nested1.name AS nestedName,\n        |    nested.`value` AS nestedValue,\n        |    deepNested.nested2.flag AS nestedFlag,\n        |    deepNested.nested2.num AS nestedNum\n        |from NestedTable\n        |")).stripMargin();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,HI,1111,true,111", "2,HELLO,2222,false,222", "3,HELLO WORLD,3333,true,333"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testDecimalArrayWithDifferentPrecision() {
        String sqlQuery = "SELECT ARRAY[0.12, 0.5, 0.99]";
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[0.12, 0.50, 0.99]"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testDecimalMapWithDifferentPrecision() {
        String sqlQuery = "SELECT Map['a', 0.12, 'b', 0.5]";
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{a=0.12, b=0.50}"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCurrentWatermark() {
        Seq rows = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Instant.ofEpochSecond(644326662L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), Instant.ofEpochSecond(1622466300L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), Instant.ofEpochSecond(1622466300L)}))}));
        String tableId = TestValuesTableFactory.registerData((Seq<Row>)rows);
        this.tEnv().getConfig().getConfiguration().setString("table.local-time-zone", "Europe/Berlin");
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                       |CREATE TABLE T (\n                       |  id INT,\n                       |  ts TIMESTAMP_LTZ(3),\n                       |  WATERMARK FOR ts AS ts\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '", "',\n                       |  'bounded' = 'true'\n                       |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableId})))).stripMargin());
        List result1 = JavaConversions$.MODULE$.asScalaIterator((Iterator)this.tEnv().from("T").select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.$("id"), org.apache.flink.table.api.package$.MODULE$.currentWatermark(org.apache.flink.table.api.package$.MODULE$.$("ts"))}).execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.seqAsJavaList((Seq)result1), (String)new StringOps(Predef$.MODULE$.augmentString("1,null\n        |2,1990-06-02T11:37:42Z\n        |3,2021-05-31T13:05:00Z\n        |")).stripMargin());
        List result2 = JavaConversions$.MODULE$.asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT id, CURRENT_WATERMARK(ts) FROM T").execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.seqAsJavaList((Seq)result2), (String)new StringOps(Predef$.MODULE$.augmentString("1,null\n        |2,1990-06-02T11:37:42Z\n        |3,2021-05-31T13:05:00Z\n        |")).stripMargin());
        List result3 = JavaConversions$.MODULE$.asScalaIterator((Iterator)this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id FROM T WHERE CURRENT_WATERMARK(ts) IS NULL OR ts > CURRENT_WATERMARK(ts)\n        |")).stripMargin()).execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.seqAsJavaList((Seq)result3), (String)new StringOps(Predef$.MODULE$.augmentString("1\n        |2\n        |")).stripMargin());
        List result4 = JavaConversions$.MODULE$.asScalaIterator((Iterator)this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  TUMBLE_END(ts, INTERVAL '1' SECOND),\n        |  CURRENT_WATERMARK(ts)\n        |FROM T\n        |GROUP BY\n        |  TUMBLE(ts, INTERVAL '1' SECOND),\n        |  CURRENT_WATERMARK(ts)\n        |")).stripMargin()).execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.seqAsJavaList((Seq)result4), (String)new StringOps(Predef$.MODULE$.augmentString("1990-06-02T13:37:43,null\n        |2021-05-31T15:05:01,1990-06-02T11:37:42Z\n        |2021-05-31T15:05:01,2021-05-31T13:05:00Z\n        |")).stripMargin());
    }

    @Test
    public void testCurrentWatermarkForNonRowtimeAttribute() {
        String tableId = TestValuesTableFactory.registerData((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                       |CREATE TABLE T (\n                       |  ts TIMESTAMP_LTZ(3)\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '", "',\n                       |  'bounded' = 'true'\n                       |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableId})))).stripMargin());
        try {
            this.tEnv().sqlQuery("SELECT CURRENT_WATERMARK(ts) FROM T");
            Assert.fail((String)"CURRENT_WATERMARK for a non-rowtime attribute should have failed.");
        }
        catch (Exception exception) {
            Assert.assertEquals((Object)"SQL validation failed. Invalid function call:\nCURRENT_WATERMARK(TIMESTAMP_LTZ(3))", (Object)exception.getMessage());
        }
    }

    @Test
    public void testCreateTemporaryTableFromDescriptor() {
        Seq rows = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)42)}))}));
        String tableId = TestValuesTableFactory.registerData((Seq<Row>)rows);
        this.tEnv().createTemporaryTable("T", TableDescriptor.forConnector((String)"values").schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.INT()).build()).option("data-id", tableId).option("bounded", "true").build());
        List result = JavaConversions$.MODULE$.asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT * FROM T").execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.seqAsJavaList((Seq)result), (String)"42");
    }

    @Test
    public void testSearch() {
        DataStream stream = this.env().fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HC809", "H389N     "}), (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        this.tEnv().createTemporaryView("SimpleTable", stream, Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).build());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT upper(f0) from SimpleTable where upper(f0) in (\n        |'CTNBSmokeSensor',\n        |'H388N',\n        |'H389N     ',\n        |'GHL-IRD',\n        |'JY-BF-20YN',\n        |'HC809',\n        |'DH-9908N-AEP',\n        |'DH-9908N'\n        |)\n        |")).stripMargin();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HC809", "H389N     "}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    private final MapData createMapData$1(long k, long v) {
        HashMap<Long, Long> mapData = new HashMap<Long, Long>();
        mapData.put(BoxesRunTime.boxToLong((long)k), BoxesRunTime.boxToLong((long)v));
        return new MapDataSerializerTest.CustomMapData(mapData);
    }
}

