/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.jsonplan;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.TestData;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.JsonPlanTestBase;
import org.apache.flink.types.Row;
import org.junit.Before;
import org.junit.Test;

public class WindowJoinJsonITCase
extends JsonPlanTestBase {
    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.createTestValuesSourceTable("MyTable", (List<Row>)JavaScalaConversionUtil.toJava(TestData.windowDataWithTimestamp()), new String[]{"ts STRING", "`int` INT", "`double` DOUBLE", "`float` FLOAT", "`bigdec` DECIMAL(10, 2)", "`string` STRING", "`name` STRING", "`rowtime` AS TO_TIMESTAMP(`ts`)", "WATERMARK for `rowtime` AS `rowtime` - INTERVAL '1' SECOND"}, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("enable-watermark-push-down", "true");
                this.put("failing-source", "true");
            }
        });
        this.createTestValuesSourceTable("MyTable2", (List<Row>)JavaScalaConversionUtil.toJava(TestData.windowData2WithTimestamp()), new String[]{"ts STRING", "`int` INT", "`double` DOUBLE", "`float` FLOAT", "`bigdec` DECIMAL(10, 2)", "`string` STRING", "`name` STRING", "`rowtime` AS TO_TIMESTAMP(`ts`)", "WATERMARK for `rowtime` AS `rowtime` - INTERVAL '1' SECOND"}, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("enable-watermark-push-down", "true");
                this.put("failing-source", "true");
            }
        });
    }

    @Test
    public void testEventTimeTumbleWindow() throws Exception {
        this.createTestValuesSinkTable("MySink", "name STRING", "window_start TIMESTAMP(3)", "window_end TIMESTAMP(3)", "uv1 BIGINT", "uv2 BIGINT");
        String jsonPlan = this.tableEnv.getJsonPlan("insert into MySink select\n  L.name,\n  L.window_start,\n  L.window_end,\n  uv1,\n  uv2\nFROM(\n  SELECT\n    name,\n    window_start,\n    window_end,\n    COUNT(DISTINCT `string`) as uv1\n  FROM TABLE(\n     TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n  GROUP BY name, window_start, window_end\n  ) L\nJOIN (\n  SELECT\n    name,\n    window_start,\n    window_end,\n    COUNT(DISTINCT `string`) as uv2\n  FROM TABLE(\n     TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n  GROUP BY name, window_start, window_end\n  ) R\nON L.window_start = R.window_start AND L.window_end = R.window_end AND L.name = R.name");
        this.tableEnv.executeJsonPlan(jsonPlan).await();
        List<String> result = TestValuesTableFactory.getResults("MySink");
        this.assertResult(Arrays.asList("+I[b, 2020-10-10T00:00:05, 2020-10-10T00:00:10, 2, 2]", "+I[b, 2020-10-10T00:00:15, 2020-10-10T00:00:20, 1, 1]", "+I[b, 2020-10-10T00:00:30, 2020-10-10T00:00:35, 1, 1]"), result);
    }
}

