/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream;

import java.io.File;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.filesystem.FileSystemConnectorOptions;
import org.apache.flink.table.planner.runtime.stream.FiniteTestSource;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestSinkUtil$;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.CollectionUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ea!B\u0001\u0003\u0003\u0003\t\"!\u0007$t'R\u0014X-Y7j]\u001e\u001c\u0016N\\6J)\u000e\u000b7/\u001a\"bg\u0016T!a\u0001\u0003\u0002\rM$(/Z1n\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005)Q\u000f^5mg&\u0011q\u0003\u0006\u0002\u0012'R\u0014X-Y7j]\u001e$Vm\u001d;CCN,\u0007\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u0015q\u0002\u0001\"\u0001 \u00039!\u0018.\\3pkR\u0004VM\u001d+fgR,\u0012\u0001\t\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nQA];mKNT!!\n\b\u0002\u000b),h.\u001b;\n\u0005\u001d\u0012#a\u0002+j[\u0016|W\u000f\u001e\u0015\u0003;%\u0002\"AK\u0016\u000e\u0003\u0011J!\u0001\f\u0013\u0003\tI+H.\u001a\u0005\n]\u0001\u0001\r\u00111A\u0005\u0012=\n!B]3tk2$\b+\u0019;i+\u0005\u0001\u0004CA\u00198\u001d\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001(\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y\u001a\u0004\"C\u001e\u0001\u0001\u0004\u0005\r\u0011\"\u0005=\u00039\u0011Xm];miB\u000bG\u000f[0%KF$\"!\u0010!\u0011\u0005Ir\u0014BA 4\u0005\u0011)f.\u001b;\t\u000f\u0005S\u0014\u0011!a\u0001a\u0005\u0019\u0001\u0010J\u0019\t\r\r\u0003\u0001\u0015)\u00031\u0003-\u0011Xm];miB\u000bG\u000f\u001b\u0011\t\u000f\u0015\u0003!\u0019!C\u0005\r\u0006!A-\u0019;b+\u00059\u0005c\u0001%L\u001b6\t\u0011J\u0003\u0002Kg\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00051K%aA*fcB\u0011a*U\u0007\u0002\u001f*\u0011\u0001KC\u0001\u0006if\u0004Xm]\u0005\u0003%>\u00131AU8x\u0011\u0019!\u0006\u0001)A\u0005\u000f\u0006)A-\u0019;bA!)a\u000b\u0001C!/\u00061!-\u001a4pe\u0016$\u0012!\u0010\u0015\u0003+f\u0003\"A\u000b.\n\u0005m##A\u0002\"fM>\u0014X\rC\u0003^\u0001\u0011\u0005a,\u0001\u000bbI\u0012LG/[8oC2\u0004&o\u001c9feRLWm\u001d\u000b\u0002?B\u0019!\u0007\u0019\u0019\n\u0005\u0005\u001c$!B!se\u0006L\b\"B2\u0001\t\u00039\u0016a\u0003;fgRtuN\u001c)beRD#AY3\u0011\u0005)2\u0017BA4%\u0005\u0011!Vm\u001d;\t\u000b%\u0004A\u0011A,\u0002\u0011Q,7\u000f\u001e)beRD#\u0001[3\t\u000b1\u0004A\u0011B7\u0002\tQ,7\u000f\u001e\u000b\u0004{9\u001c\b\"B8l\u0001\u0004\u0001\u0018!\u00039beRLG/[8o!\t\u0011\u0014/\u0003\u0002sg\t9!i\\8mK\u0006t\u0007b\u0002;l!\u0003\u0005\r\u0001M\u0001\u0007a>d\u0017nY=\t\u000bY\u0004A\u0011A,\u0002'Q,7\u000f^'fi\u0006\u001cHo\u001c:f!>d\u0017nY=)\u0005U,\u0007\"B=\u0001\t\u0003Q\u0018!B2iK\u000e\\GcA\u001f|{\")A\u0010\u001fa\u0001a\u0005A1/\u001d7Rk\u0016\u0014\u0018\u0010C\u0003\u007fq\u0002\u0007q)\u0001\bfqB,7\r^3e%\u0016\u001cX\u000f\u001c;\t\u0013\u0005\u0005\u0001!%A\u0005\n\u0005\r\u0011A\u0004;fgR$C-\u001a4bk2$HEM\u000b\u0003\u0003\u000bQ3\u0001MA\u0004W\t\tI\u0001\u0005\u0003\u0002\f\u0005UQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\u0013Ut7\r[3dW\u0016$'bAA\ng\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0011Q\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public abstract class FsStreamingSinkITCaseBase
extends StreamingTestBase {
    private String resultPath;
    private final Seq<Row> data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{1, "a", "b", "2020-05-03", "7"}), Row.of((Object[])new Object[]{2, "p", "q", "2020-05-03", "8"}), Row.of((Object[])new Object[]{3, "x", "y", "2020-05-03", "9"}), Row.of((Object[])new Object[]{4, "x", "y", "2020-05-03", "10"}), Row.of((Object[])new Object[]{5, "x", "y", "2020-05-03", "11"})}));

    @Rule
    public Timeout timeoutPerTest() {
        return Timeout.seconds((long)240L);
    }

    public String resultPath() {
        return this.resultPath;
    }

    public void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    private Seq<Row> data() {
        return this.data;
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.resultPath_$eq(this.tempFolder().newFolder().toURI().toString());
        this.env().setParallelism(1);
        this.env().enableCheckpointing(100L);
        org.apache.flink.streaming.api.scala.DataStream stream = new org.apache.flink.streaming.api.scala.DataStream((DataStream)this.env().getJavaEnv().addSource((SourceFunction)new FiniteTestSource((Iterable<Row>)this.data()), (TypeInformation)new RowTypeInfo(new TypeInformation[]{Types.INT, Types.STRING, Types.STRING, Types.STRING, Types.STRING})));
        this.tEnv().createTemporaryView("my_table", stream, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Expressions.$((String)"a"), Expressions.$((String)"b"), Expressions.$((String)"c"), Expressions.$((String)"d"), Expressions.$((String)"e")}));
    }

    public String[] additionalProperties() {
        return (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
    }

    @Test
    public void testNonPart() {
        this.test(false, this.test$default$2());
    }

    @Test
    public void testPart() {
        this.test(true, this.test$default$2());
        File basePath = new File(new URI(this.resultPath()).getPath(), "d=2020-05-03");
        Assert.assertEquals((long)5L, (long)basePath.list().length);
        Assert.assertTrue((boolean)new File(new File(basePath, "e=7"), "_MY_SUCCESS").exists());
        Assert.assertTrue((boolean)new File(new File(basePath, "e=8"), "_MY_SUCCESS").exists());
        Assert.assertTrue((boolean)new File(new File(basePath, "e=9"), "_MY_SUCCESS").exists());
        Assert.assertTrue((boolean)new File(new File(basePath, "e=10"), "_MY_SUCCESS").exists());
        Assert.assertTrue((boolean)new File(new File(basePath, "e=11"), "_MY_SUCCESS").exists());
    }

    private void test(boolean partition, String policy) {
        char dollar = '$';
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                 |create table sink_table (\n                 |  a int,\n                 |  b string,\n                 |  c string,\n                 |  d string,\n                 |  e string\n                 |)\n                 |", "\n                 |with (\n                 |  'connector' = 'filesystem',\n                 |  'path' = '", "',\n                 |  '", "' =\n                 |      '", "d ", "e:00:00',\n                 |  '", "' = '1h',\n                 |  '", "' = '", "',\n                 |  '", "' = '_MY_SUCCESS',\n                 |  ", "\n                 |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition ? "partitioned by (d, e)" : "", this.resultPath(), FileSystemConnectorOptions.PARTITION_TIME_EXTRACTOR_TIMESTAMP_PATTERN.key(), BoxesRunTime.boxToCharacter((char)dollar), BoxesRunTime.boxToCharacter((char)dollar), FileSystemConnectorOptions.SINK_PARTITION_COMMIT_DELAY.key(), FileSystemConnectorOptions.SINK_PARTITION_COMMIT_POLICY_KIND.key(), policy, FileSystemConnectorOptions.SINK_PARTITION_COMMIT_SUCCESS_FILE_NAME.key(), Predef$.MODULE$.refArrayOps((Object[])this.additionalProperties()).mkString(",\n")})))).stripMargin();
        this.tEnv().executeSql(ddl);
        this.tEnv().sqlQuery("select * from my_table").executeInsert("sink_table").await();
        this.check("select * from sink_table", this.data());
    }

    private String test$default$2() {
        return "success-file";
    }

    @Test
    public void testMetastorePolicy() {
        this.thrown().expectMessage("Can not configure a 'metastore' partition commit policy for a file system table. You can only configure 'metastore' partition commit policy for a hive table.");
        this.test(true, "metastore");
    }

    public void check(String sqlQuery, Seq<Row> expectedResult) {
        CloseableIterator iter = this.tEnv().sqlQuery(sqlQuery).execute().collect();
        List result = CollectionUtil.iteratorToList((Iterator)iter);
        iter.close();
        Assert.assertEquals((Object)((SeqLike)expectedResult.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Row x$1) {
                return TestSinkUtil$.MODULE$.rowToString(x$1, TestSinkUtil$.MODULE$.rowToString$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$), (Object)((SeqLike)JavaConversions$.MODULE$.asScalaBuffer(result).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Row x$2) {
                return TestSinkUtil$.MODULE$.rowToString(x$2, TestSinkUtil$.MODULE$.rowToString$default$2());
            }
        }, Buffer$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$));
    }
}

