/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.table;

import java.util.List;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.CollectionBatchExecTable$;
import org.apache.flink.table.planner.runtime.utils.SortTestUtils$;
import org.apache.flink.table.utils.LegacyRowResource;
import org.apache.flink.test.util.TestBaseUtils;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import scala.Function1;
import scala.Product;
import scala.Serializable;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00054A!\u0001\u0002\u0001%\tQ1k\u001c:u\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011!\u0002;bE2,'BA\u0003\u0007\u0003\u0015\u0011\u0017\r^2i\u0015\t9\u0001\"A\u0004sk:$\u0018.\\3\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0007-Q!\u0001D\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00059y\u0011AB1qC\u000eDWMC\u0001\u0011\u0003\ry'oZ\u0002\u0001'\t\u00011\u0003\u0005\u0002\u0015/5\tQC\u0003\u0002\u0017\r\u0005)Q\u000f^5mg&\u0011\u0001$\u0006\u0002\u000e\u0005\u0006$8\r\u001b+fgR\u0014\u0015m]3\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u0005\u0011\u0001\"B\u0010\u0001\t\u0003\u0001\u0013AD;tKNdUmZ1dsJ{wo]\u000b\u0002CA\u0011!\u0005J\u0007\u0002G)\u0011aCC\u0005\u0003K\r\u0012\u0011\u0003T3hC\u000eL(k\\<SKN|WO]2fQ\tqr\u0005\u0005\u0002)W5\t\u0011F\u0003\u0002+\u001f\u0005)!.\u001e8ji&\u0011A&\u000b\u0002\u0005%VdW\rC\u0003/\u0001\u0011\u0005q&A\u0004d_6\u0004\u0018M]3\u0015\u0007A2d\b\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$G\u0001\u0003V]&$\b\"B\u001c.\u0001\u0004A\u0014!\u0001;\u0011\u0005ebT\"\u0001\u001e\u000b\u0005mR\u0011aA1qS&\u0011QH\u000f\u0002\u0006)\u0006\u0014G.\u001a\u0005\u0006\u007f5\u0002\r\u0001Q\u0001\tKb\u0004Xm\u0019;fIB\u0011\u0011\t\u0012\b\u0003c\tK!a\u0011\u001a\u0002\rA\u0013X\rZ3g\u0013\t)eI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0007JBQ\u0001\u0013\u0001\u0005\u0002%\u000bq\u0002^3ti>\u0013H-\u001a:Cs\u0012+7o\u0019\u000b\u0002a!\u0012qi\u0013\t\u0003Q1K!!T\u0015\u0003\tQ+7\u000f\u001e\u0005\u0006\u001f\u0002!\t!S\u0001\u000fi\u0016\u001cHo\u0014:eKJ\u0014\u00150Q:dQ\tq5\nC\u0003S\u0001\u0011\u0005\u0011*\u0001\u0017uKN$xJ\u001d3fe\nKX*\u001e7uSBdWMR5fY\u0012\u001cH)\u001b4gKJ,g\u000e\u001e#je\u0016\u001cG/[8og\"\u0012\u0011k\u0013\u0005\u0006+\u0002!\t!S\u0001\u0012i\u0016\u001cHo\u0014:eKJ\u0014\u0015p\u00144gg\u0016$\bF\u0001+LQ\t!\u0006\f\u0005\u0002)3&\u0011!,\u000b\u0002\u0007\u0013\u001etwN]3\t\u000bq\u0003A\u0011A%\u00023Q,7\u000f^(sI\u0016\u0014()_(gMN,G/\u00118e\r\u0016$8\r\u001b\u0015\u00037.CQa\u0018\u0001\u0005\u0002%\u000b\u0001\u0003^3ti>\u0013H-\u001a:Cs\u001a+Go\u00195)\u0005y[\u0005")
public class SortITCase
extends BatchTestBase {
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("_1");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("_2");

    @Rule
    public LegacyRowResource usesLegacyRows() {
        return LegacyRowResource.INSTANCE;
    }

    public void compare(Table t, String expected) {
        TestBaseUtils.compareOrderedResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.executeQuery(t)).asJava()), (String)expected);
    }

    @Test
    public void testOrderByDesc() {
        Table ds = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.get3TupleDataSet$default$2());
        Table t = ds.orderBy(new Expression[]{(Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).desc()});
        this.compare(t, SortTestUtils$.MODULE$.sortExpectedly(SortTestUtils$.MODULE$.tupleDataSetStrings(), (Ordering<Product>)this.tupleOrdering$1()));
    }

    @Test
    public void testOrderByAsc() {
        Table ds = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.get3TupleDataSet$default$2());
        Table t = ds.orderBy(new Expression[]{(Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).asc()});
        this.compare(t, SortTestUtils$.MODULE$.sortExpectedly(SortTestUtils$.MODULE$.tupleDataSetStrings(), (Ordering<Product>)this.tupleOrdering$2()));
    }

    @Test
    public void testOrderByMultipleFieldsDifferentDirections() {
        Table ds = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.get3TupleDataSet$default$2());
        Table t = ds.orderBy(new Expression[]{(Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$2).asc(), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).desc()});
        this.compare(t, SortTestUtils$.MODULE$.sortExpectedly(SortTestUtils$.MODULE$.tupleDataSetStrings(), (Ordering<Product>)this.tupleOrdering$3()));
    }

    @Ignore
    @Test
    public void testOrderByOffset() {
        Table ds = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.get3TupleDataSet$default$2());
        Table t = ds.orderBy(new Expression[]{(Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).asc()}).offset(3);
        this.compare(t, SortTestUtils$.MODULE$.sortExpectedly(SortTestUtils$.MODULE$.tupleDataSetStrings(), 3, 21, (Ordering<Product>)this.tupleOrdering$4()));
    }

    @Test
    public void testOrderByOffsetAndFetch() {
        Table ds = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.get3TupleDataSet$default$2());
        Table t = ds.orderBy(new Expression[]{(Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).desc()}).offset(3).fetch(5);
        this.compare(t, SortTestUtils$.MODULE$.sortExpectedly(SortTestUtils$.MODULE$.tupleDataSetStrings(), 3, 8, (Ordering<Product>)this.tupleOrdering$5()));
    }

    @Test
    public void testOrderByFetch() {
        Table ds = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.get3TupleDataSet$default$2());
        Table t = ds.orderBy(new Expression[]{(Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).asc()}).offset(0).fetch(5);
        this.compare(t, SortTestUtils$.MODULE$.sortExpectedly(SortTestUtils$.MODULE$.tupleDataSetStrings(), 0, 5, (Ordering<Product>)this.tupleOrdering$6()));
    }

    private final Ordering tupleOrdering$1() {
        return package$.MODULE$.Ordering().by((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(T x) {
                return -BoxesRunTime.unboxToInt((Object)x.productElement(0));
            }
        }, (Ordering)Ordering.Int$.MODULE$);
    }

    private final Ordering tupleOrdering$2() {
        return package$.MODULE$.Ordering().by((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(T x) {
                return BoxesRunTime.unboxToInt((Object)x.productElement(0));
            }
        }, (Ordering)Ordering.Int$.MODULE$);
    }

    private final Ordering tupleOrdering$3() {
        return package$.MODULE$.Ordering().by((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(T x) {
                return new Tuple2.mcJI.sp(BoxesRunTime.unboxToLong((Object)x.productElement(1)), -BoxesRunTime.unboxToInt((Object)x.productElement(0)));
            }
        }, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
    }

    private final Ordering tupleOrdering$4() {
        return package$.MODULE$.Ordering().by((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(T x) {
                return BoxesRunTime.unboxToInt((Object)x.productElement(0));
            }
        }, (Ordering)Ordering.Int$.MODULE$);
    }

    private final Ordering tupleOrdering$5() {
        return package$.MODULE$.Ordering().by((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(T x) {
                return -BoxesRunTime.unboxToInt((Object)x.productElement(0));
            }
        }, (Ordering)Ordering.Int$.MODULE$);
    }

    private final Ordering tupleOrdering$6() {
        return package$.MODULE$.Ordering().by((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(T x) {
                return BoxesRunTime.unboxToInt((Object)x.productElement(0));
            }
        }, (Ordering)Ordering.Int$.MODULE$);
    }
}

