/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.join;

import java.util.Collection;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.batch.sql.join.LookupJoinITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.InMemoryLookupableTableSource$;
import org.apache.flink.types.Row;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\u0001\u0003\u0001U\u0011\u0001\u0003T8pWV\u0004(j\\5o\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011\u0001\u00026pS:T!!\u0002\u0004\u0002\u0007M\fHN\u0003\u0002\b\u0011\u0005)!-\u0019;dQ*\u0011\u0011BC\u0001\beVtG/[7f\u0015\tYA\"A\u0004qY\u0006tg.\u001a:\u000b\u00055q\u0011!\u0002;bE2,'BA\b\u0011\u0003\u00151G.\u001b8l\u0015\t\t\"#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00033!\tQ!\u001e;jYNL!a\u0007\r\u0003\u001b\t\u000bGo\u00195UKN$()Y:f\u0011!i\u0002A!A!\u0002\u0013q\u0012!\u00057fO\u0006\u001c\u0017\u0010V1cY\u0016\u001cv.\u001e:dKB\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t9!i\\8mK\u0006t\u0007\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u0017%\u001c\u0018i]=oG6{G-\u001a\u0005\u0006O\u0001!\t\u0001K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007%ZC\u0006\u0005\u0002+\u00015\t!\u0001C\u0003\u001eM\u0001\u0007a\u0004C\u0003&M\u0001\u0007a\u0004C\u0004/\u0001\t\u0007I\u0011A\u0018\u0002\t\u0011\fG/Y\u000b\u0002aA\u0019\u0011G\u000e\u001d\u000e\u0003IR!a\r\u001b\u0002\u0013%lW.\u001e;bE2,'BA\u001b!\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003oI\u0012A\u0001T5tiB\u0011\u0011\bP\u0007\u0002u)\u00111HD\u0001\u0006if\u0004Xm]\u0005\u0003{i\u00121AU8x\u0011\u0019y\u0004\u0001)A\u0005a\u0005)A-\u0019;bA!9\u0011\t\u0001b\u0001\n\u0003y\u0013\u0001\u00043bi\u0006<\u0016\u000e\u001e5Ok2d\u0007BB\"\u0001A\u0003%\u0001'A\u0007eCR\fw+\u001b;i\u001dVdG\u000e\t\u0005\b\u000b\u0002\u0011\r\u0011\"\u00010\u0003!)8/\u001a:ECR\f\u0007BB$\u0001A\u0003%\u0001'A\u0005vg\u0016\u0014H)\u0019;bA!9\u0011\n\u0001b\u0001\n\u0003y\u0013\u0001E;tKJ$\u0015\r^1XSRDg*\u001e7m\u0011\u0019Y\u0005\u0001)A\u0005a\u0005\tRo]3s\t\u0006$\u0018mV5uQ:+H\u000e\u001c\u0011\t\u000b5\u0003A\u0011\t(\u0002\r\t,gm\u001c:f)\u0005y\u0005CA\u0010Q\u0013\t\t\u0006E\u0001\u0003V]&$\bF\u0001'T!\t!v+D\u0001V\u0015\t1&#A\u0003kk:LG/\u0003\u0002Y+\n1!)\u001a4pe\u0016DQA\u0017\u0001\u0005B9\u000bQ!\u00194uKJD#!\u0017/\u0011\u0005Qk\u0016B\u00010V\u0005\u0015\te\r^3s\u0011\u0015\u0001\u0007\u0001\"\u0003b\u0003E\u0019'/Z1uK2{wn[;q)\u0006\u0014G.\u001a\u000b\u0004\u001f\n\\\u0007\"B2`\u0001\u0004!\u0017!\u0003;bE2,g*Y7f!\t)\u0007N\u0004\u0002 M&\u0011q\rI\u0001\u0007!J,G-\u001a4\n\u0005%T'AB*ue&twM\u0003\u0002hA!)af\u0018a\u0001YB\u0019Q.\u001e\u001d\u000f\u00059\u001chBA8s\u001b\u0005\u0001(BA9\u0015\u0003\u0019a$o\\8u}%\t\u0011%\u0003\u0002uA\u00059\u0001/Y2lC\u001e,\u0017BA\u001cw\u0015\t!\b\u0005C\u0003y\u0001\u0011%\u00110A\u0012de\u0016\fG/\u001a'p_.,\b\u000fV1cY\u0016<\u0016\u000e\u001e5D_6\u0004X\u000f^3e\u0007>dW/\u001c8\u0015\u0007=S8\u0010C\u0003do\u0002\u0007A\rC\u0003/o\u0002\u0007A\u000eC\u0003~\u0001\u0011%a0A\bde\u0016\fG/Z*dC:$\u0016M\u00197f)\u0011yu0!\u0001\t\u000b\rd\b\u0019\u00013\t\u000b9b\b\u0019\u00017\t\r\u0005\u0015\u0001\u0001\"\u0001O\u0003-\"Xm\u001d;MK\u001a$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRDGj\\2bYB\u0013X\rZ5dCR,\u0007\u0006BA\u0002\u0003\u0013\u00012\u0001VA\u0006\u0013\r\ti!\u0016\u0002\u0005)\u0016\u001cH\u000f\u0003\u0004\u0002\u0012\u0001!\tAT\u0001\u0016i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197fQ\u0011\ty!!\u0003\t\r\u0005]\u0001\u0001\"\u0001O\u0003\u0005\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5QkNDGi\\<oQ\u0011\t)\"!\u0003\t\r\u0005u\u0001\u0001\"\u0001O\u0003\u001d\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5O_:,\u0015/^1m\r&dG/\u001a:)\t\u0005m\u0011\u0011\u0002\u0005\u0007\u0003G\u0001A\u0011\u0001(\u0002EQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK>sW*\u001e7uS\u001aKW\r\u001c3tQ\u0011\t\t#!\u0003\t\r\u0005%\u0002\u0001\"\u0001O\u0003%\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016|e.T;mi&4\u0015.\u001a7eg^KG\u000f[+eM\"\"\u0011qEA\u0005\u0011\u0019\ty\u0003\u0001C\u0001\u001d\u0006)C/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,wJ\\'vYRL7*Z=GS\u0016dGm\u001d\u0015\u0005\u0003[\tI\u0001\u0003\u0004\u00026\u0001!\tAT\u0001\u001ai\u0016\u001cH\u000fT3gi*{\u0017N\u001c+f[B|'/\u00197UC\ndW\r\u000b\u0003\u00024\u0005%\u0001BBA\u001e\u0001\u0011\u0005a*A\u0019uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3P]6+H\u000e^5LKf4\u0015.\u001a7eg^KG\u000f\u001b(vY2$\u0015\r^1)\t\u0005e\u0012\u0011\u0002\u0005\u0007\u0003\u0003\u0002A\u0011\u0001(\u0002kQ,7\u000f\u001e'fMRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z(o\u001bVdG/[&fs\u001aKW\r\u001c3t/&$\bNT;mY\u0012\u000bG/\u0019\u0015\u0005\u0003\u007f\tI\u0001\u0003\u0004\u0002H\u0001!\tAT\u0001'i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f\u001f:tU\u000f\u001c7D_:\u001cH/\u00198u\u0017\u0016L\b\u0006BA#\u0003\u0013Aa!!\u0014\u0001\t\u0003q\u0015\u0001\u000f;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z(o\u001bVdG/[&fs\u001aKW\r\u001c3t/&$\bNT;mY\u000e{gn\u001d;b]R\\U-\u001f\u0015\u0005\u0003\u0017\nI\u0001\u0003\u0004\u0002T\u0001!\tAT\u0001(i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\bnQ8naV$X\rZ\"pYVlg\u000e\u000b\u0003\u0002R\u0005%\u0001BBA-\u0001\u0011\u0005a*\u0001\u001auKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRD7i\\7qkR,GmQ8mk6t\u0017I\u001c3QkNDGi\\<oQ\u0011\t9&!\u0003)\u000f\u0001\ty&a\u001b\u0002nA!\u0011\u0011MA4\u001b\t\t\u0019GC\u0002\u0002fU\u000baA];o]\u0016\u0014\u0018\u0002BA5\u0003G\u0012qAU;o/&$\b.A\u0003wC2,Xm\t\u0002\u0002pA!\u0011\u0011OA<\u001b\t\t\u0019HC\u0002\u0002vU\u000bqA];o]\u0016\u00148/\u0003\u0003\u0002z\u0005M$!\u0004)be\u0006lW\r^3sSj,GmB\u0004\u0002~\tA\t!a \u0002!1{wn[;q\u0015>Lg.\u0013+DCN,\u0007c\u0001\u0016\u0002\u0002\u001a1\u0011A\u0001E\u0001\u0003\u0007\u001bB!!!\u0002\u0006B\u0019q$a\"\n\u0007\u0005%\u0005E\u0001\u0004B]f\u0014VM\u001a\u0005\bO\u0005\u0005E\u0011AAG)\t\ty\b\u0003\u0005\u0002\u0012\u0006\u0005E\u0011AAJ\u0003)\u0001\u0018M]1nKR,'o\u001d\u000b\u0003\u0003+\u0003b!a&\u0002\"\u0006\u0015VBAAM\u0015\u0011\tY*!(\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003?\u000bAA[1wC&!\u00111UAM\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0006?\u0005\u001d\u00161V\u0005\u0004\u0003S\u0003#!B!se\u0006L\b\u0003BAW\u0003gk!!a,\u000b\t\u0005E\u0016QT\u0001\u0005Y\u0006tw-\u0003\u0003\u00026\u0006=&AB(cU\u0016\u001cG\u000f\u000b\u0005\u0002\u0010\u0006e\u0016qYAe!\u0011\tY,!1\u000f\t\u0005E\u0014QX\u0005\u0005\u0003\u007f\u000b\u0019(A\u0007QCJ\fW.\u001a;fe&TX\rZ\u0005\u0005\u0003\u0007\f)M\u0001\u0006QCJ\fW.\u001a;feNTA!a0\u0002t\u0005!a.Y7fC\t\tY-\u0001\u0015MK\u001e\f7-\u001f+bE2,7k\\;sG\u0016l4\u0010M?-A%\u001c\u0018i]=oG6{G-\u001a\u0011>Am\fT\u0010")
public class LookupJoinITCase
extends BatchTestBase {
    private final boolean legacyTableSource;
    private final boolean isAsyncMode;
    private final List<Row> data;
    private final List<Row> dataWithNull;
    private final List<Row> userData;
    private final List<Row> userDataWithNull;

    @Parameterized.Parameters(name="LegacyTableSource={0}, isAsyncMode = {1}")
    public static Collection<Object[]> parameters() {
        return LookupJoinITCase$.MODULE$.parameters();
    }

    public List<Row> data() {
        return this.data;
    }

    public List<Row> dataWithNull() {
        return this.dataWithNull;
    }

    public List<Row> userData() {
        return this.userData;
    }

    public List<Row> userDataWithNull() {
        return this.userDataWithNull;
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.createScanTable("T", this.data());
        this.createScanTable("nullableT", this.dataWithNull());
        this.createLookupTable("userTable", this.userData());
        this.createLookupTable("userTableWithNull", this.userDataWithNull());
        this.createLookupTableWithComputedColumn("userTableWithComputedColumn", this.userData());
        this.env().getConfig().disableObjectReuse();
    }

    @Override
    @After
    public void after() {
        if (this.legacyTableSource) {
            Assert.assertEquals((long)0L, (long)InMemoryLookupableTableSource$.MODULE$.RESOURCE_COUNTER().get());
        } else {
            Assert.assertEquals((long)0L, (long)TestValuesTableFactory.RESOURCE_COUNTER.get());
        }
    }

    private void createLookupTable(String tableName, List<Row> data) {
        if (this.legacyTableSource) {
            TableSchema userSchema = TableSchema.builder().field("age", Types.INT()).field("id", Types.LONG()).field("name", Types.STRING()).build();
            InMemoryLookupableTableSource$.MODULE$.createTemporaryTable(this.tEnv(), this.isAsyncMode, data, userSchema, tableName, true);
        } else {
            String dataId = TestValuesTableFactory.registerData(data);
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |CREATE TABLE ", " (\n           |  `age` INT,\n           |  `id` BIGINT,\n           |  `name` STRING\n           |) WITH (\n           |  'connector' = 'values',\n           |  'data-id' = '", "',\n           |  'async' = '", "',\n           |  'bounded' = 'true'\n           |)\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, dataId, BoxesRunTime.boxToBoolean((boolean)this.isAsyncMode)})))).stripMargin());
        }
    }

    private void createLookupTableWithComputedColumn(String tableName, List<Row> data) {
        if (!this.legacyTableSource) {
            String dataId = TestValuesTableFactory.registerData(data);
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |CREATE TABLE ", " (\n           |  `age` INT,\n           |  `id` BIGINT,\n           |  `name` STRING,\n           |  `nominal_age` as age + 1\n           |) WITH (\n           |  'connector' = 'values',\n           |  'data-id' = '", "',\n           |  'async' = '", "',\n           |  'bounded' = 'true'\n           |)\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, dataId, BoxesRunTime.boxToBoolean((boolean)this.isAsyncMode)})))).stripMargin());
        }
    }

    private void createScanTable(String tableName, List<Row> data) {
        String dataId = TestValuesTableFactory.registerData(data);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE ", " (\n         |  `id` BIGINT,\n         |  `len` BIGINT,\n         |  `content` STRING,\n         |  `proctime` AS PROCTIME()\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '", "',\n         |  'bounded' = 'true'\n         |)\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, dataId})))).stripMargin());
    }

    @Test
    public void testLeftJoinTemporalTableWithLocalPredicate() {
        String sql = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT T.id, T.len, T.content, D.name, D.age FROM T LEFT JOIN userTable "})).s((Seq)Nil$.MODULE$)).append((Object)"for system_time as of T.proctime AS D ON T.id = D.id ").append((Object)"AND T.len > 1 AND D.age > 20 AND D.name = 'Fabian' ").append((Object)"WHERE T.id > 1").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian", BoxesRunTime.boxToInteger((int)33)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), BoxesRunTime.boxToInteger((int)11), "Hello world", null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)12), "Hello world!", null, null}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTable() {
        String sql = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT T.id, T.len, T.content, D.name FROM T JOIN userTable "})).s((Seq)Nil$.MODULE$)).append((Object)"for system_time as of T.proctime AS D ON T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian", "Julian"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableWithPushDown() {
        String sql = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT T.id, T.len, T.content, D.name FROM T JOIN userTable "})).s((Seq)Nil$.MODULE$)).append((Object)"for system_time as of T.proctime AS D ON T.id = D.id AND D.age > 20").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableWithNonEqualFilter() {
        String sql = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT T.id, T.len, T.content, D.name, D.age FROM T JOIN userTable "})).s((Seq)Nil$.MODULE$)).append((Object)"for system_time as of T.proctime AS D ON T.id = D.id WHERE T.len <= D.age").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark", BoxesRunTime.boxToInteger((int)22)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian", BoxesRunTime.boxToInteger((int)33)}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableOnMultiFields() {
        String sql = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT T.id, T.len, D.name FROM T JOIN userTable "})).s((Seq)Nil$.MODULE$)).append((Object)"for system_time as of T.proctime AS D ON T.id = D.id AND T.content = D.name").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableOnMultiFieldsWithUdf() {
        String sql = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT T.id, T.len, D.name FROM T JOIN userTable "})).s((Seq)Nil$.MODULE$)).append((Object)"for system_time as of T.proctime AS D ON mod(T.id, 4) = D.id AND T.content = D.name").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFields() {
        String sql = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT T.id, T.len, D.name FROM T JOIN userTable "})).s((Seq)Nil$.MODULE$)).append((Object)"for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testLeftJoinTemporalTable() {
        String sql = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT T.id, T.len, D.name, D.age FROM T LEFT JOIN userTable "})).s((Seq)Nil$.MODULE$)).append((Object)"for system_time as of T.proctime AS D ON T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian", BoxesRunTime.boxToInteger((int)11)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Jark", BoxesRunTime.boxToInteger((int)22)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", BoxesRunTime.boxToInteger((int)33)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), BoxesRunTime.boxToInteger((int)11), null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)12), null, null}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFieldsWithNullData() {
        String sql = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT T.id, T.len, D.name FROM nullableT T JOIN userTableWithNull "})).s((Seq)Nil$.MODULE$)).append((Object)"for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testLeftJoinTemporalTableOnMultiKeyFieldsWithNullData() {
        String sql = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT D.id, T.len, D.name FROM nullableT T LEFT JOIN userTableWithNull "})).s((Seq)Nil$.MODULE$)).append((Object)"for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)15), null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)11), null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)12), null}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableOnNullConstantKey() {
        String sql = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT T.id, T.len, T.content FROM T JOIN userTable "})).s((Seq)Nil$.MODULE$)).append((Object)"for system_time as of T.proctime AS D ON D.id = null").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFieldsWithNullConstantKey() {
        String sql = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT T.id, T.len, D.name FROM T JOIN userTable "})).s((Seq)Nil$.MODULE$)).append((Object)"for system_time as of T.proctime AS D ON T.content = D.name AND null = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableWithComputedColumn() {
        Assume.assumeFalse((boolean)this.legacyTableSource);
        String sql = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT T.id, T.len, T.content, D.name, D.age, D.nominal_age "})).s((Seq)Nil$.MODULE$)).append((Object)"FROM T JOIN userTableWithComputedColumn ").append((Object)"for system_time as of T.proctime AS D ON T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian", "Julian", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)12)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark", BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToInteger((int)23)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian", BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToInteger((int)34)}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableWithComputedColumnAndPushDown() {
        Assume.assumeFalse((boolean)this.legacyTableSource);
        String sql = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT T.id, T.len, T.content, D.name, D.age, D.nominal_age "})).s((Seq)Nil$.MODULE$)).append((Object)"FROM T JOIN userTableWithComputedColumn ").append((Object)"for system_time as of T.proctime AS D ON T.id = D.id and D.nominal_age > 12").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark", BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToInteger((int)23)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian", BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToInteger((int)34)}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    public LookupJoinITCase(boolean legacyTableSource, boolean isAsyncMode) {
        this.legacyTableSource = legacyTableSource;
        this.isAsyncMode = isAsyncMode;
        this.data = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToLong((long)12L), "Julian"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)15L), "Hello"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToLong((long)15L), "Fabian"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)8L), BoxesRunTime.boxToLong((long)11L), "Hello world"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToLong((long)12L), "Hello world!"}))}));
        this.dataWithNull = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)15L), "Hello"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToLong((long)15L), "Fabian"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)11L), "Hello world"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToLong((long)12L), "Hello world!"}))}));
        this.userData = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "Julian"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToLong((long)2L), "Jark"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToLong((long)3L), "Fabian"}))}));
        this.userDataWithNull = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "Julian"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22), null, "Hello"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToLong((long)3L), "Fabian"})), this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)44), null, "Hello world"}))}));
    }
}

