/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.runtime.batch.sql.MultipleInputITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.types.Row;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001B\u0001\u0003\u0001M\u00111#T;mi&\u0004H.Z%oaV$\u0018\nV\"bg\u0016T!a\u0001\u0003\u0002\u0007M\fHN\u0003\u0002\u0006\r\u0005)!-\u0019;dQ*\u0011q\u0001C\u0001\beVtG/[7f\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0019\tQ!\u001e;jYNL!!\u0007\f\u0003\u001b\t\u000bGo\u00195UKN$()Y:f\u0011!Y\u0002A!A!\u0002\u0013a\u0012aC:ik\u001a4G.Z'pI\u0016\u0004\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\r\r|W.\\8o\u0015\t\tC\"A\u0002ba&L!a\t\u0010\u0003!\t\u000bGo\u00195TQV4g\r\\3N_\u0012,\u0007\"B\u0013\u0001\t\u00031\u0013A\u0002\u001fj]&$h\b\u0006\u0002(SA\u0011\u0001\u0006A\u0007\u0002\u0005!)1\u0004\na\u00019!)1\u0006\u0001C!Y\u00051!-\u001a4pe\u0016$\u0012!\f\t\u0003]Ej\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\u0005+:LG\u000f\u000b\u0002+iA\u0011Q\u0007O\u0007\u0002m)\u0011q\u0007E\u0001\u0006UVt\u0017\u000e^\u0005\u0003sY\u0012aAQ3g_J,\u0007\"B\u001e\u0001\t\u0003a\u0013A\u0006;fgR\u0014\u0015m]5d\u001bVdG/\u001b9mK&s\u0007/\u001e;)\u0005ij\u0004CA\u001b?\u0013\tydG\u0001\u0003UKN$\b\"B!\u0001\t\u0003a\u0013A\u0006;fgRl\u0015M\\=Nk2$\u0018\u000e\u001d7f\u0013:\u0004X\u000f^:)\u0005\u0001k\u0004\"\u0002#\u0001\t\u0003a\u0013A\u0006;fgRTu.\u001b8XSRD\u0017iZ4BgB\u0013xNY3)\u0005\rk\u0004\"B$\u0001\t\u0003a\u0013\u0001\u0007;fgRtu\u000e\u0015:j_JLG/_\"p]N$(/Y5oi\"\u0012a)\u0010\u0005\u0006\u0015\u0002!\t\u0001L\u0001\u0012i\u0016\u001cHOU3mCR,G-\u00138qkR\u001c\bFA%>\u0011\u0015i\u0005\u0001\"\u0001-\u0003a!Xm\u001d;SK2\fG/\u001a3J]B,Ho],ji\"\fum\u001a\u0015\u0003\u0019vBQ\u0001\u0015\u0001\u0005\u00021\na\u0005^3ti\u0012+\u0017\r\u001a7pG.\u001c\u0015-^:fI\nKX\t_2iC:<W-\u00138B]\u000e,7\u000f^8sQ\tyU\bC\u0003T\u0001\u0011\u0005A&\u0001\fuKN$X*\u0019=TkB\u0004xN\u001d;fI&s\u0007/\u001e;tQ\t\u0011V\bC\u0003W\u0001\u0011\u0005q+\u0001\rdQ\u0016\u001c7.T;mi&\u0004H.Z%oaV$(+Z:vYR$\"!\f-\t\u000b\r)\u0006\u0019A-\u0011\u0005ikfB\u0001\u0018\\\u0013\tav&\u0001\u0004Qe\u0016$WMZ\u0005\u0003=~\u0013aa\u0015;sS:<'B\u0001/0Q\u0011\u0001\u0011m\u001a5\u0011\u0005\t,W\"A2\u000b\u0005\u00114\u0014A\u0002:v]:,'/\u0003\u0002gG\n9!+\u001e8XSRD\u0017!\u0002<bYV,7%A5\u0011\u0005)lW\"A6\u000b\u000514\u0014a\u0002:v]:,'o]\u0005\u0003].\u0014Q\u0002U1sC6,G/\u001a:ju\u0016$w!\u00029\u0003\u0011\u0003\t\u0018aE'vYRL\u0007\u000f\\3J]B,H/\u0013+DCN,\u0007C\u0001\u0015s\r\u0015\t!\u0001#\u0001t'\t\u0011H\u000f\u0005\u0002/k&\u0011ao\f\u0002\u0007\u0003:L(+\u001a4\t\u000b\u0015\u0012H\u0011\u0001=\u0015\u0003EDQA\u001f:\u0005\u0002m\f!\u0002]1sC6,G/\u001a:t+\u0005a\bc\u0001\u0018~9%\u0011ap\f\u0002\u0006\u0003J\u0014\u0018-\u001f\u0015\bs\u0006\u0005\u0011\u0011EA\u0012!\u0011\t\u0019!a\u0007\u000f\t\u0005\u0015\u0011q\u0003\b\u0005\u0003\u000f\t)B\u0004\u0003\u0002\n\u0005Ma\u0002BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=!#\u0001\u0004=e>|GOP\u0005\u0002#%\u0011q\u0007E\u0005\u0003YZJ1!!\u0007l\u00035\u0001\u0016M]1nKR,'/\u001b>fI&!\u0011QDA\u0010\u0005)\u0001\u0016M]1nKR,'o\u001d\u0006\u0004\u00033Y\u0017\u0001\u00028b[\u0016\f#!!\n\u0002!MDWO\u001a4mK6{G-\u001a\u001e!wBj\bbBA\u0015e\u0012\u0005\u00111F\u0001\u0013O\u0016tWM]1uKJ\u000bg\u000eZ8n\t\u0006$\u0018\r\u0006\u0002\u0002.A1\u0011qFA\u001d\u0003\u007fqA!!\r\u000269!\u00111BA\u001a\u0013\u0005\u0001\u0014bAA\u001c_\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001e\u0003{\u00111aU3r\u0015\r\t9d\f\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011Q\t\u0007\u0002\u000bQL\b/Z:\n\t\u0005%\u00131\t\u0002\u0004%><\bBCA'e\"\u0015\r\u0011\"\u0001\u0002P\u00059!o\\<UsB,WCAA)!\u0011\t\u0019&!\u0018\u000e\u0005\u0005U#\u0002BA,\u00033\n\u0011\u0002^=qKV$\u0018\u000e\\:\u000b\u0007\u0005m\u0003%\u0001\u0003kCZ\f\u0017\u0002BA0\u0003+\u00121BU8x)f\u0004X-\u00138g_\"Q\u00111\r:\t\u0002\u0003\u0006K!!\u0015\u0002\u0011I|w\u000fV=qK\u0002B!\"a\u001as\u0011\u000b\u0007I\u0011AA5\u0003%qW\u000f\u001c7bE2,7/\u0006\u0002\u0002lA!a&`A7!\rq\u0013qN\u0005\u0004\u0003cz#a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0003k\u0012\b\u0012!Q!\n\u0005-\u0014A\u00038vY2\f'\r\\3tA!Q\u0011\u0011\u0010:\t\u0006\u0004%\t!a\u001f\u0002\u000b\u0011\fG/\u0019-\u0016\u0005\u00055\u0002BCA@e\"\u0005\t\u0015)\u0003\u0002.\u00051A-\u0019;b1\u0002B!\"a!s\u0011\u000b\u0007I\u0011AA>\u0003\u0015!\u0017\r^1Z\u0011)\t9I\u001dE\u0001B\u0003&\u0011QF\u0001\u0007I\u0006$\u0018-\u0017\u0011\t\u0015\u0005-%\u000f#b\u0001\n\u0003\tY(A\u0003eCR\f'\f\u0003\u0006\u0002\u0010JD\t\u0011)Q\u0005\u0003[\ta\u0001Z1uCj\u0003\u0003BCAJe\"\u0015\r\u0011\"\u0001\u0002|\u0005)A-\u0019;b)\"Q\u0011q\u0013:\t\u0002\u0003\u0006K!!\f\u0002\r\u0011\fG/\u0019+!\u0001")
public class MultipleInputITCase
extends BatchTestBase {
    private final BatchShuffleMode shuffleMode;

    public static Seq<Row> dataT() {
        return MultipleInputITCase$.MODULE$.dataT();
    }

    public static Seq<Row> dataZ() {
        return MultipleInputITCase$.MODULE$.dataZ();
    }

    public static Seq<Row> dataY() {
        return MultipleInputITCase$.MODULE$.dataY();
    }

    public static Seq<Row> dataX() {
        return MultipleInputITCase$.MODULE$.dataX();
    }

    public static boolean[] nullables() {
        return MultipleInputITCase$.MODULE$.nullables();
    }

    public static RowTypeInfo rowType() {
        return MultipleInputITCase$.MODULE$.rowType();
    }

    public static Seq<Row> generateRandomData() {
        return MultipleInputITCase$.MODULE$.generateRandomData();
    }

    @Parameterized.Parameters(name="shuffleMode: {0}")
    public static BatchShuffleMode[] parameters() {
        return MultipleInputITCase$.MODULE$.parameters();
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.registerCollection("x", MultipleInputITCase$.MODULE$.dataX(), MultipleInputITCase$.MODULE$.rowType(), "a, b, c, nx", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("y", MultipleInputITCase$.MODULE$.dataY(), MultipleInputITCase$.MODULE$.rowType(), "d, e, f, ny", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("z", MultipleInputITCase$.MODULE$.dataZ(), MultipleInputITCase$.MODULE$.rowType(), "g, h, i, nz", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("t", MultipleInputITCase$.MODULE$.dataT(), MultipleInputITCase$.MODULE$.rowType(), "a, b, c, nt", MultipleInputITCase$.MODULE$.nullables());
        this.tEnv().getConfig().getConfiguration().set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)this.shuffleMode);
    }

    @Test
    public void testBasicMultipleInput() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  (SELECT a FROM x INNER JOIN y ON x.a = y.d) T1\n        |  INNER JOIN\n        |  (SELECT d FROM y INNER JOIN t ON y.d = t.a) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin());
    }

    @Test
    public void testManyMultipleInputs() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (\n        |    SELECT a, ny, nz FROM x\n        |      LEFT JOIN y ON x.a = y.ny\n        |      LEFT JOIN z ON x.a = z.nz),\n        |  T2 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN t ON T1.a = t.a\n        |      INNER JOIN y ON T1.a = y.d),\n        |  T3 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN y ON T1.a = y.d\n        |      INNER JOIN t ON T1.a = t.a),\n        |  T4 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T2 GROUP BY b),\n        |  T5 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T3 GROUP BY b)\n        |SELECT * FROM\n        |  (SELECT t.b, sd, sy, sz FROM T4 LEFT JOIN t ON T4.b = t.b)\n        |  UNION ALL\n        |  (SELECT y.e, sd, sy, sz FROM T5 LEFT JOIN y ON T5.b = y.e)\n        |")).stripMargin());
    }

    @Test
    public void testJoinWithAggAsProbe() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T AS (SELECT a, d FROM x INNER JOIN y ON x.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a, COUNT(*) AS cnt FROM T GROUP BY a) T1\n        |  LEFT JOIN\n        |  (SELECT d, SUM(a) AS sm FROM T GROUP BY d) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin());
    }

    @Test
    public void testNoPriorityConstraint() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM x\n        |  INNER JOIN y ON x.a = y.d\n        |  INNER JOIN t ON x.a = t.a\n        |")).stripMargin());
    }

    @Test
    public void testRelatedInputs() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT x.a AS a, y.d AS b FROM y LEFT JOIN x ON y.d = x.a),\n        |  T2 AS (\n        |    SELECT a, b FROM\n        |      (SELECT a, b FROM T1)\n        |      UNION ALL\n        |      (SELECT x.a AS a, x.b AS b FROM x))\n        |SELECT * FROM T2 LEFT JOIN t ON T2.a = t.a\n        |")).stripMargin());
    }

    @Test
    public void testRelatedInputsWithAgg() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT x.a AS a, y.d AS b FROM y LEFT JOIN x ON y.d = x.a),\n        |  T2 AS (\n        |    SELECT a, b FROM\n        |      (SELECT a, b FROM T1)\n        |      UNION ALL\n        |      (SELECT COUNT(x.a) AS a, x.b AS b FROM x GROUP BY x.b))\n        |SELECT * FROM T2 LEFT JOIN t ON T2.a = t.a\n        |")).stripMargin());
    }

    @Test
    public void testDeadlockCausedByExchangeInAncestor() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T1 AS (\n        |  SELECT x1.*, x2.a AS k, (x1.b + x2.b) AS v\n        |  FROM x x1 LEFT JOIN x x2 ON x1.a = x2.a WHERE x2.a > 0)\n        |SELECT x.a, x.b, T1.* FROM x LEFT JOIN T1 ON x.a = T1.k WHERE x.a > 0 AND T1.v = 0\n        |")).stripMargin());
    }

    @Test
    public void testMaxSupportedInputs() {
        RowTypeInfo rowType = new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "test"}))}));
        boolean[] nullables = new boolean[]{true, true};
        this.registerCollection("left_table", data, rowType, "a, b", nullables);
        this.registerCollection("right_table", data, rowType, "c, d", nullables);
        int numJoins = 62;
        StringBuilder sql = new StringBuilder("SELECT t0.a, t0.b");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numJoins).foreach((Function1)new Serializable(this, sql){
            public static final long serialVersionUID = 0L;
            private final StringBuilder sql$1;

            public final StringBuilder apply(int i) {
                return this.sql$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", t", ".c, t", ".d"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)i)})));
            }
            {
                this.sql$1 = sql$1;
            }
        });
        sql.append(" from left_table as t0");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numJoins).foreach((Function1)new Serializable(this, sql){
            public static final long serialVersionUID = 0L;
            private final StringBuilder sql$1;

            public final StringBuilder apply(int i) {
                return this.sql$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" left join right_table as t", " on t0.a = t", ".c and t", ".c = 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)i)})));
            }
            {
                this.sql$1 = sql$1;
            }
        });
        this.checkMultipleInputResult(sql.toString());
    }

    public void checkMultipleInputResult(String sql) {
        this.tEnv().getConfig().getConfiguration().setBoolean(OptimizerConfigOptions.TABLE_OPTIMIZER_MULTIPLE_INPUT_ENABLED, false);
        Seq<Row> expected = this.executeQuery(sql);
        this.tEnv().getConfig().getConfiguration().setBoolean(OptimizerConfigOptions.TABLE_OPTIMIZER_MULTIPLE_INPUT_ENABLED, true);
        this.checkResult(sql, expected, this.checkResult$default$3());
    }

    public MultipleInputITCase(BatchShuffleMode shuffleMode) {
        this.shuffleMode = shuffleMode;
    }
}

