/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.utils.TestLegacyLimitableTableSource$;
import org.junit.Before;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M3A!\u0001\u0002\u0001'\t\tB*Z4bGfd\u0015.\\5u\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0006E\u0006$8\r\u001b\u0006\u0003\u000f!\tqA];oi&lWM\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"!\u0004\"bi\u000eDG+Z:u\u0005\u0006\u001cX\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!)\u0001\u0005\u0001C!C\u00051!-\u001a4pe\u0016$\u0012A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0005+:LG\u000f\u000b\u0002 SA\u0011!&L\u0007\u0002W)\u0011A\u0006E\u0001\u0006UVt\u0017\u000e^\u0005\u0003]-\u0012aAQ3g_J,\u0007\"\u0002\u0019\u0001\t\u0003\t\u0013A\u0005;fgR|eMZ:fi\u0006sGMR3uG\"D#a\f\u001a\u0011\u0005)\u001a\u0014B\u0001\u001b,\u0005\u0011!Vm\u001d;\t\u000bY\u0002A\u0011A\u0011\u0002%Q,7\u000f^(gMN,G/\u00118e\u0019&l\u0017\u000e\u001e\u0015\u0003kIBQ!\u000f\u0001\u0005\u0002\u0005\n\u0011\u0002^3ti\u001a+Go\u00195)\u0005a\u0012\u0004\"\u0002\u001f\u0001\t\u0003\t\u0013a\u0006;fgR4U\r^2i/&$\b\u000eT5nSR$\u0016M\u00197fQ\tY$\u0007C\u0003@\u0001\u0011\u0005\u0011%\u0001\buKN$h)\u001a;dQ\u001aK'o\u001d;)\u0005y\u0012\u0004\"\u0002\"\u0001\t\u0003\t\u0013\u0001\b;fgR4U\r^2i\r&\u00148\u000f^,ji\"d\u0015.\\5u)\u0006\u0014G.\u001a\u0015\u0003\u0003JBQ!\u0012\u0001\u0005\u0002\u0005\n\u0011\u0002^3ti2KW.\u001b;)\u0005\u0011\u0013\u0004\"\u0002%\u0001\t\u0003\t\u0013\u0001\u0007;fgRd\u0015.\\5ua]KG\u000f\u001b'j[&$H+\u00192mK\"\u0012qI\r\u0005\u0006\u0017\u0002!\t!I\u0001\u0018i\u0016\u001cH\u000fT5nSR<\u0016\u000e\u001e5MS6LG\u000fV1cY\u0016D#A\u0013\u001a\t\u000b9\u0003A\u0011A\u0011\u0002%Q,7\u000f\u001e'fgN$\u0006.\u00198PM\u001a\u001cX\r\u001e\u0015\u0003\u001bJBQ!\u0015\u0001\u0005\u0002\u0005\n\u0011\u0005^3ti2+7o\u001d+iC:|eMZ:fi^KG\u000f\u001b'j[&$8k\\;sG\u0016D#\u0001\u0015\u001a")
public class LegacyLimitITCase
extends BatchTestBase {
    @Override
    @Before
    public void before() {
        super.before();
        this.registerCollection("Table3", TestData$.MODULE$.data3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfData3());
        TestLegacyLimitableTableSource$.MODULE$.createTemporaryTable(this.tEnv(), TestData$.MODULE$.data3(), new TableSchema((String[])((Object[])new String[]{"a", "b", "c"}), TestData$.MODULE$.type3().getFieldTypes()), "LimitTable");
    }

    @Test
    public void testOffsetAndFetch() {
        this.checkSize("SELECT * FROM Table3 OFFSET 2 ROWS FETCH NEXT 5 ROWS ONLY", 5);
    }

    @Test
    public void testOffsetAndLimit() {
        this.checkSize("SELECT * FROM Table3 LIMIT 10 OFFSET 2", 10);
    }

    @Test
    public void testFetch() {
        this.checkSize("SELECT * FROM Table3 FETCH NEXT 10 ROWS ONLY", 10);
    }

    @Test
    public void testFetchWithLimitTable() {
        this.checkSize("SELECT * FROM LimitTable FETCH NEXT 10 ROWS ONLY", 10);
    }

    @Test
    public void testFetchFirst() {
        this.checkSize("SELECT * FROM Table3 FETCH FIRST 10 ROWS ONLY", 10);
    }

    @Test
    public void testFetchFirstWithLimitTable() {
        this.checkSize("SELECT * FROM LimitTable FETCH FIRST 10 ROWS ONLY", 10);
    }

    @Test
    public void testLimit() {
        this.checkSize("SELECT * FROM Table3 LIMIT 5", 5);
    }

    @Test
    public void testLimit0WithLimitTable() {
        this.checkSize("SELECT * FROM LimitTable LIMIT 0", 0);
    }

    @Test
    public void testLimitWithLimitTable() {
        this.checkSize("SELECT * FROM LimitTable LIMIT 5", 5);
    }

    @Test
    public void testLessThanOffset() {
        this.checkSize("SELECT * FROM Table3 OFFSET 2 ROWS FETCH NEXT 50 ROWS ONLY", 19);
    }

    @Test
    public void testLessThanOffsetWithLimitSource() {
        this.checkSize("SELECT * FROM LimitTable OFFSET 2 ROWS FETCH NEXT 50 ROWS ONLY", 19);
    }
}

