/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime;

import java.io.File;
import java.util.List;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.runtime.FileSystemITCaseBase;
import org.apache.flink.table.planner.runtime.FileSystemITCaseBase$;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import scala.Array$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class FileSystemITCaseBase$class {
    @Rule
    public static TemporaryFolder fileTempFolder(FileSystemITCaseBase $this) {
        return $this.fileTmpFolder();
    }

    public static String[] formatProperties(FileSystemITCaseBase $this) {
        return (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
    }

    public static String getScheme(FileSystemITCaseBase $this) {
        return "file";
    }

    public static void check(FileSystemITCaseBase $this, String sqlQuery, List expectedResult) {
        $this.check(sqlQuery, (Seq<Row>)((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(expectedResult.iterator()).asScala()).toSeq());
    }

    public static void open(FileSystemITCaseBase $this) {
        $this.resultPath_$eq($this.fileTmpFolder().newFolder().toURI().getPath());
        BatchTableEnvUtil$.MODULE$.registerCollection($this.tableEnv(), "originalT", FileSystemITCaseBase$.MODULE$.data_with_partitions(), FileSystemITCaseBase$.MODULE$.dataType(), "x, y, a, b");
        $this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create table partitionedTable (\n         |  x string,\n         |  y int,\n         |  a int,\n         |  b bigint,\n         |  c as b + 1\n         |) partitioned by (a, b) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '", "://", "',\n         |  ", "\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.getScheme(), $this.resultPath(), Predef$.MODULE$.refArrayOps((Object[])$this.formatProperties()).mkString(",\n")})))).stripMargin());
        $this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create table nonPartitionedTable (\n         |  x string,\n         |  y int,\n         |  a int,\n         |  b bigint\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '", "://", "',\n         |  ", "\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.getScheme(), $this.resultPath(), Predef$.MODULE$.refArrayOps((Object[])$this.formatProperties()).mkString(",\n")})))).stripMargin());
        $this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create table hasDecimalFieldWithPrecisionTenAndZeroTable (\n         |  x decimal(10, 0), y int\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '", "://", "',\n         |  ", "\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.getScheme(), $this.resultPath(), Predef$.MODULE$.refArrayOps((Object[])$this.formatProperties()).mkString(",\n")})))).stripMargin());
        $this.tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create table hasDecimalFieldWithPrecisionThreeAndTwoTable (\n         |  x decimal(3, 2), y int\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '", "://", "',\n         |  ", "\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.getScheme(), $this.resultPath(), Predef$.MODULE$.refArrayOps((Object[])$this.formatProperties()).mkString(",\n")})))).stripMargin());
    }

    @Test
    public static void testSelectDecimalWithPrecisionTenAndZeroFromFileSystem(FileSystemITCaseBase $this) {
        $this.tableEnv().executeSql("insert into hasDecimalFieldWithPrecisionTenAndZeroTable(x, y) values(cast(2113554011 as decimal(10, 0)), 1), (cast(2113554022 as decimal(10,0)), 2)").await();
        $this.check("select x, y from hasDecimalFieldWithPrecisionTenAndZeroTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2113554011), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2113554022), BoxesRunTime.boxToInteger((int)2)}))}))));
    }

    @Test
    public static void testSelectDecimalWithPrecisionThreeAndTwoFromFileSystem(FileSystemITCaseBase $this) {
        $this.tableEnv().executeSql("insert into hasDecimalFieldWithPrecisionThreeAndTwoTable(x,y) values(cast(1.32 as decimal(3, 2)), 1), (cast(2.64 as decimal(3, 2)), 2)").await();
        $this.check("select x, y from hasDecimalFieldWithPrecisionThreeAndTwoTable", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.32), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)2.64), BoxesRunTime.boxToInteger((int)2)}))}))));
    }

    @Test
    public static void testAllStaticPartitions1(FileSystemITCaseBase $this) {
        $this.tableEnv().executeSql("insert into partitionedTable partition(a='1', b='1') select x, y from originalT where a=1 and b=1").await();
        $this.check("select x, y from partitionedTable where a=1 and b=1", FileSystemITCaseBase$.MODULE$.data_partition_1_1());
        $this.check("select x, y from partitionedTable", FileSystemITCaseBase$.MODULE$.data_partition_1_1());
    }

    @Test
    public static void testAllStaticPartitions2(FileSystemITCaseBase $this) {
        $this.tableEnv().executeSql("insert into partitionedTable partition(a='2', b='1') select x, y from originalT where a=2 and b=1").await();
        $this.check("select x, y from partitionedTable where a=2 and b=1", FileSystemITCaseBase$.MODULE$.data_partition_2_1());
        $this.check("select x, y from partitionedTable", FileSystemITCaseBase$.MODULE$.data_partition_2_1());
    }

    @Test
    public static void testPartialDynamicPartition(FileSystemITCaseBase $this) {
        $this.tableEnv().executeSql("insert into partitionedTable partition(a=3) select x, y, b from originalT where a=3").await();
        $this.check("select x, y from partitionedTable where a=2 and b=1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        $this.check("select x, y from partitionedTable where a=3 and b=1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x17", BoxesRunTime.boxToInteger((int)17)}))}))));
        $this.check("select x, y from partitionedTable where a=3 and b=2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x18", BoxesRunTime.boxToInteger((int)18)}))}))));
        $this.check("select x, y from partitionedTable where a=3 and b=3", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x19", BoxesRunTime.boxToInteger((int)19)}))}))));
        $this.check("select x, y from partitionedTable where a=3", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x17", BoxesRunTime.boxToInteger((int)17)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x18", BoxesRunTime.boxToInteger((int)18)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x19", BoxesRunTime.boxToInteger((int)19)}))}))));
    }

    @Test
    public static void testDynamicPartition(FileSystemITCaseBase $this) {
        $this.tableEnv().executeSql("insert into partitionedTable select x, y, a, b from originalT").await();
        $this.check("select x, y from partitionedTable where a=1 and b=1", FileSystemITCaseBase$.MODULE$.data_partition_1_1());
        $this.check("select x, y from partitionedTable where a=2 and b=1", FileSystemITCaseBase$.MODULE$.data_partition_2_1());
        $this.check("select x, y, a, b, c from partitionedTable where a=1 and c=2", FileSystemITCaseBase$.MODULE$.data_partition_1_2());
        $this.check("select x, y from partitionedTable", FileSystemITCaseBase$.MODULE$.data());
    }

    @Test
    public static void testPartitionWithHiddenFile(FileSystemITCaseBase $this) {
        $this.tableEnv().executeSql("insert into partitionedTable partition(a='1', b='1') select x, y from originalT where a=1 and b=1").await();
        Assert.assertTrue((boolean)new File(new Path(new StringBuilder().append((Object)"file:").append((Object)$this.resultPath()).append((Object)"/a=1/.b=2").toString()).toUri()).mkdir());
        $this.check("select x, y from partitionedTable", FileSystemITCaseBase$.MODULE$.data_partition_1_1());
    }

    @Test
    public static void testNonPartition(FileSystemITCaseBase $this) {
        $this.tableEnv().executeSql("insert into nonPartitionedTable select x, y, a, b from originalT where a=1 and b=1").await();
        $this.check("select x, y from nonPartitionedTable where a=1 and b=1", FileSystemITCaseBase$.MODULE$.data_partition_1_1());
    }

    @Test
    public static void testLimitPushDown(FileSystemITCaseBase $this) {
        $this.tableEnv().getConfig().getConfiguration().setInteger(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, 1);
        $this.tableEnv().executeSql("insert into nonPartitionedTable select x, y, a, b from originalT").await();
        $this.check("select x, y from nonPartitionedTable limit 3", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x1", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x2", BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x3", BoxesRunTime.boxToInteger((int)3)}))}))));
    }

    @Test
    public static void testFilterPushDown(FileSystemITCaseBase $this) {
        $this.tableEnv().executeSql("insert into nonPartitionedTable select x, y, a, b from originalT").await();
        $this.check("select x, y from nonPartitionedTable where a=10086", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    @Test
    public static void testProjectPushDown(FileSystemITCaseBase $this) {
        $this.tableEnv().executeSql("insert into partitionedTable select x, y, a, b from originalT").await();
        $this.check("select y, b, x from partitionedTable where a=3", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)17), BoxesRunTime.boxToInteger((int)1), "x17"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)18), BoxesRunTime.boxToInteger((int)2), "x18"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToInteger((int)3), "x19"}))}))));
    }

    @Test
    public static void testInsertAppend(FileSystemITCaseBase $this) {
        $this.tableEnv().sqlUpdate("insert into partitionedTable select x, y, a, b from originalT");
        $this.tableEnv().execute("test1");
        $this.tableEnv().sqlUpdate("insert into partitionedTable select x, y, a, b from originalT");
        $this.tableEnv().execute("test2");
        $this.check("select y, b, x from partitionedTable where a=3", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)17), BoxesRunTime.boxToInteger((int)1), "x17"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)18), BoxesRunTime.boxToInteger((int)2), "x18"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToInteger((int)3), "x19"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)17), BoxesRunTime.boxToInteger((int)1), "x17"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)18), BoxesRunTime.boxToInteger((int)2), "x18"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToInteger((int)3), "x19"}))}))));
    }

    @Test
    public static void testInsertOverwrite(FileSystemITCaseBase $this) {
        $this.tableEnv().sqlUpdate("insert overwrite partitionedTable select x, y, a, b from originalT");
        $this.tableEnv().execute("test1");
        $this.tableEnv().sqlUpdate("insert overwrite partitionedTable select x, y, a, b from originalT");
        $this.tableEnv().execute("test2");
        $this.check("select y, b, x from partitionedTable where a=3", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)17), BoxesRunTime.boxToInteger((int)1), "x17"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)18), BoxesRunTime.boxToInteger((int)2), "x18"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToInteger((int)3), "x19"}))}))));
    }

    public static void $init$(FileSystemITCaseBase $this) {
        $this.org$apache$flink$table$planner$runtime$FileSystemITCaseBase$_setter_$fileTmpFolder_$eq(new TemporaryFolder());
    }
}

