/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.functions.AggregateFunction;

public class JavaUserDefinedAggFunctions {

    public static class LargerThanCount
    extends AggregateFunction<Long, Tuple1<Long>> {
        public void accumulate(Tuple1<Long> acc, Long a, Long b) {
            if (a > b) {
                Tuple1<Long> tuple1 = acc;
                tuple1.f0 = (Long)tuple1.f0 + 1L;
            }
        }

        public void retract(Tuple1<Long> acc, Long a, Long b) {
            if (a > b) {
                Tuple1<Long> tuple1 = acc;
                tuple1.f0 = (Long)tuple1.f0 - 1L;
            }
        }

        public Long getValue(Tuple1<Long> accumulator) {
            return (Long)accumulator.f0;
        }

        public Tuple1<Long> createAccumulator() {
            return Tuple1.of((Object)0L);
        }
    }

    public static class CountDistinctWithRetractAndReset
    extends CountDistinct {
        public void retract(CountDistinctAccum accumulator, long id) {
            try {
                Integer cnt = (Integer)accumulator.map.get((Object)String.valueOf(id));
                if (cnt != null) {
                    if ((cnt = Integer.valueOf(cnt - 1)) <= 0) {
                        accumulator.map.remove((Object)String.valueOf(id));
                        --accumulator.count;
                    } else {
                        accumulator.map.put((Object)String.valueOf(id), (Object)cnt);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void resetAccumulator(CountDistinctAccum acc) {
            acc.map.clear();
            acc.count = 0L;
        }
    }

    public static class CountDistinctWithMergeAndReset
    extends CountDistinctWithMerge {
        public void resetAccumulator(CountDistinctAccum acc) {
            acc.map.clear();
            acc.count = 0L;
        }
    }

    public static class CountDistinctWithMerge
    extends CountDistinct {
        private static final long serialVersionUID = -9028804545597563968L;

        public void merge(CountDistinctAccum acc, Iterable<CountDistinctAccum> it) {
            for (CountDistinctAccum mergeAcc : it) {
                try {
                    Iterable keys = mergeAcc.map.keys();
                    if (keys == null) continue;
                    for (String key : keys) {
                        Integer cnt = (Integer)mergeAcc.map.get((Object)key);
                        if (acc.map.contains((Object)key)) {
                            acc.map.put((Object)key, (Object)((Integer)acc.map.get((Object)key) + cnt));
                            continue;
                        }
                        acc.map.put((Object)key, (Object)cnt);
                        ++acc.count;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class CountDistinct
    extends AggregateFunction<Long, CountDistinctAccum> {
        private static final long serialVersionUID = -8369074832279506466L;

        public CountDistinctAccum createAccumulator() {
            CountDistinctAccum accum = new CountDistinctAccum();
            accum.map = new MapView(org.apache.flink.table.api.Types.STRING(), org.apache.flink.table.api.Types.INT());
            accum.count = 0L;
            return accum;
        }

        public void accumulate(CountDistinctAccum accumulator, String id) {
            try {
                Integer cnt = (Integer)accumulator.map.get((Object)id);
                if (cnt != null) {
                    cnt = cnt + 1;
                    accumulator.map.put((Object)id, (Object)cnt);
                } else {
                    accumulator.map.put((Object)id, (Object)1);
                    ++accumulator.count;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void accumulate(CountDistinctAccum accumulator, long id) {
            try {
                Integer cnt = (Integer)accumulator.map.get((Object)String.valueOf(id));
                if (cnt != null) {
                    cnt = cnt + 1;
                    accumulator.map.put((Object)String.valueOf(id), (Object)cnt);
                } else {
                    accumulator.map.put((Object)String.valueOf(id), (Object)1);
                    ++accumulator.count;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Long getValue(CountDistinctAccum accumulator) {
            return accumulator.count;
        }
    }

    public static class CountDistinctAccum {
        public MapView<String, Integer> map;
        public long count;
    }

    public static class ConcatDistinctAggFunction
    extends AggregateFunction<String, ConcatAcc> {
        private static final long serialVersionUID = -2678065132752935739L;
        private static final String DELIMITER = "|";

        public void accumulate(ConcatAcc acc, String value) throws Exception {
            if (value != null && !acc.map.contains((Object)value)) {
                acc.map.put((Object)value, (Object)true);
                acc.list.add((Object)value);
            }
        }

        public void merge(ConcatAcc acc, Iterable<ConcatAcc> its) throws Exception {
            for (ConcatAcc otherAcc : its) {
                Iterable accList = otherAcc.list.get();
                if (accList == null) continue;
                for (String value : accList) {
                    if (acc.map.contains((Object)value)) continue;
                    acc.map.put((Object)value, (Object)true);
                    acc.list.add((Object)value);
                }
            }
        }

        public ConcatAcc createAccumulator() {
            return new ConcatAcc();
        }

        public String getValue(ConcatAcc acc) {
            try {
                Iterable accList = acc.list.get();
                if (accList == null || !accList.iterator().hasNext()) {
                    return null;
                }
                StringBuilder builder = new StringBuilder();
                boolean isFirst = true;
                for (String value : accList) {
                    if (!isFirst) {
                        builder.append(DELIMITER);
                    }
                    builder.append(value);
                    isFirst = false;
                }
                return builder.toString();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public static class ConcatAcc {
        public MapView<String, Boolean> map = new MapView(Types.STRING, Types.BOOLEAN);
        public ListView<String> list = new ListView(Types.STRING);
    }

    public static class WeightedAvgWithRetract
    extends WeightedAvg {
        public void retract(WeightedAvgAccum accumulator, long iValue, int iWeight) {
            accumulator.sum -= iValue * (long)iWeight;
            accumulator.count -= iWeight;
        }

        public void retract(WeightedAvgAccum accumulator, int iValue, int iWeight) {
            accumulator.sum -= (long)(iValue * iWeight);
            accumulator.count -= iWeight;
        }
    }

    public static class WeightedAvgWithMergeAndReset
    extends WeightedAvgWithMerge {
        private static final long serialVersionUID = -2721882038448388054L;

        public void resetAccumulator(WeightedAvgAccum acc) {
            acc.count = 0;
            acc.sum = 0L;
        }
    }

    public static class WeightedAvgWithMerge
    extends WeightedAvg {
        public void merge(WeightedAvgAccum acc, Iterable<WeightedAvgAccum> it) {
            for (WeightedAvgAccum a : it) {
                acc.count += a.count;
                acc.sum += a.sum;
            }
        }

        public String toString() {
            return "myWeightedAvg";
        }
    }

    public static class WeightedAvg
    extends AggregateFunction<Long, WeightedAvgAccum> {
        public WeightedAvgAccum createAccumulator() {
            return new WeightedAvgAccum();
        }

        public Long getValue(WeightedAvgAccum accumulator) {
            if (accumulator.count == 0) {
                return null;
            }
            return accumulator.sum / (long)accumulator.count;
        }

        public void accumulate(WeightedAvgAccum accumulator, Long iValue, Integer iWeight, Integer x, String string) {
            accumulator.sum += (iValue + (long)Integer.parseInt(string)) * (long)iWeight.intValue();
            accumulator.count += iWeight.intValue();
        }

        public void accumulate(WeightedAvgAccum accumulator, Long iValue, Long iWeight) {
            accumulator.sum += iValue * iWeight;
            accumulator.count = (int)((long)accumulator.count + iWeight);
        }

        public void accumulate(WeightedAvgAccum accumulator, Integer iValue, Integer iWeight) {
            accumulator.sum += (long)(iValue * iWeight);
            accumulator.count += iWeight.intValue();
        }
    }

    public static class WeightedAvgAccum {
        public long sum = 0L;
        public int count = 0;
    }

    public static class VarSum2AggFunction
    extends AggregateFunction<Long, Long> {
        public Long createAccumulator() {
            return 0L;
        }

        public void accumulate(Long acc, Integer ... args) {
            for (Integer x : args) {
                if (x == null) continue;
                acc = acc + x.longValue();
            }
        }

        public Long getValue(Long accumulator) {
            return accumulator;
        }

        public TypeInformation<Long> getResultType() {
            return Types.LONG;
        }
    }

    public static class VarSum1AggFunction
    extends AggregateFunction<Long, VarSumAcc> {
        public VarSumAcc createAccumulator() {
            return new VarSumAcc();
        }

        public void accumulate(VarSumAcc acc, Integer ... args) {
            for (Integer x : args) {
                if (x == null) continue;
                acc.sum += x.longValue();
            }
        }

        public Long getValue(VarSumAcc accumulator) {
            return accumulator.sum;
        }

        public TypeInformation<Long> getResultType() {
            return Types.LONG;
        }
    }

    public static class VarSumAggFunction
    extends AggregateFunction<Long, VarSumAcc> {
        public VarSumAcc createAccumulator() {
            return new VarSumAcc();
        }

        public void accumulate(VarSumAcc acc, Integer ... args) {
            for (Integer x : args) {
                if (x == null) continue;
                acc.sum += x.longValue();
            }
        }

        public Long getValue(VarSumAcc accumulator) {
            return accumulator.sum;
        }
    }

    public static class VarSumAcc {
        public long sum;
    }
}

