/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.join;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.nodes.exec.spec.IntervalJoinSpec;
import org.apache.flink.table.planner.plan.stream.sql.join.IntervalJoinTest$;
import org.apache.flink.table.planner.plan.utils.IntervalJoinUtil$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\u0001\u0003\u0001U\u0011\u0001#\u00138uKJ4\u0018\r\u001c&pS:$Vm\u001d;\u000b\u0005\r!\u0011\u0001\u00026pS:T!!\u0002\u0004\u0002\u0007M\fHN\u0003\u0002\b\u0011\u000511\u000f\u001e:fC6T!!\u0003\u0006\u0002\tAd\u0017M\u001c\u0006\u0003\u00171\tq\u0001\u001d7b]:,'O\u0003\u0002\u000e\u001d\u0005)A/\u00192mK*\u0011q\u0002E\u0001\u0006M2Lgn\u001b\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001b\u001b\u0005A\"BA\r\u000b\u0003\u0015)H/\u001b7t\u0013\tY\u0002DA\u0007UC\ndW\rV3ti\n\u000b7/\u001a\u0005\u0006;\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003\tAqA\t\u0001C\u0002\u0013%1%\u0001\u0003vi&dW#\u0001\u0013\u0011\u0005])\u0013B\u0001\u0014\u0019\u0005M\u0019FO]3b[R\u000b'\r\\3UKN$X\u000b^5m\u0011\u0019A\u0003\u0001)A\u0005I\u0005)Q\u000f^5mA!)!\u0006\u0001C\u0001W\u0005\u0019C/Z:u\u0013:$XM]1wY*{\u0017N\\*j]\u001edW\rV5nK\u000e{g\u000eZ5uS>tG#\u0001\u0017\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0003\tUs\u0017\u000e\u001e\u0015\u0003SM\u0002\"\u0001N\u001c\u000e\u0003UR!A\u000e\n\u0002\u000b),h.\u001b;\n\u0005a*$\u0001\u0002+fgRDQA\u000f\u0001\u0005\u0002-\na\u0004^3ti&sG/\u001a:bm\u0006dG)\u001b4g)&lW-\u00138eS\u000e\fGo\u001c:)\u0005e\u001a\u0004\"B\u001f\u0001\t\u0003Y\u0013!\t;fgRLe\u000e^3sm\u0006d'j\\5o\u001f:$\u0015N\u001a4S_^$\u0016.\\3UsB,\u0007F\u0001\u001f4\u0011\u0015\u0001\u0005\u0001\"\u0001,\u0003q!Xm\u001d;J]R,'/\u0019<bY:{Go\u00118g\u0007>tG-\u001b;j_:D#aP\u001a\t\u000b\r\u0003A\u0011A\u0016\u0002=Q,7\u000f\u001e(p%><H/[7f\u0003R$(/\u001b2vi\u0016LeNU3tk2$\b\u0006\u0002\"4\u000b\u001a\u000b\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002\u000fB\u0011\u0001jS\u0007\u0002\u0013*\u0011!\nD\u0001\u0004CBL\u0017B\u0001'J\u00059!\u0016M\u00197f\u000bb\u001cW\r\u001d;j_:DQA\u0014\u0001\u0005\u0002-\n\u0001\u0007^3ti^Kg\u000eZ8x\u001fV$XM\u001d&pS:<\u0016\u000e\u001e5QsRDwN\u001c$v]\u000e$\u0018n\u001c8J]\u000e{g\u000eZ5uS>t\u0007\u0006B'4\u000b\u001aCQ!\u0015\u0001\u0005\u0002-\nq\u0005^3tiB\u0013xnY3tg&tw\rV5nK&sg.\u001a:K_&tw+\u001b;i\u001f:\u001cE.Y;tK\"\u0012\u0001k\r\u0005\u0006)\u0002!\taK\u0001+i\u0016\u001cH\u000f\u0015:pG\u0016\u001c8/\u001b8h)&lW-\u00138oKJTu.\u001b8XSRDw\u000b[3sK\u000ec\u0017-^:fQ\t\u00196\u0007C\u0003X\u0001\u0011\u00051&\u0001\u0019uKN$\bK]8dKN\u001c\u0018N\\4US6,\u0017J\u001c8fe*{\u0017N\\,ji\"|W\u000f^#rk\u0006d7i\u001c8eSRLwN\u001c\u0015\u0003-NBQA\u0017\u0001\u0005\u0002-\n\u0001\u0005^3tiJ{w\u000fV5nK&sg.\u001a:K_&tw+\u001b;i\u001f:\u001cE.Y;tK\"\u0012\u0011l\r\u0005\u0006;\u0002!\taK\u0001&i\u0016\u001cH/\u00138uKJ4\u0018\r\u001c&pS:|e\u000eV5nKN$\u0018-\u001c9Mij\u0014vn\u001e;j[\u0016D#\u0001X\u001a\t\u000b\u0001\u0004A\u0011A\u0016\u0002SQ,7\u000f\u001e*poRKW.Z%o]\u0016\u0014(j\\5o/&$\bn\\;u\u000bF,\u0018\r\\\"p]\u0012LG/[8oQ\ty6\u0007C\u0003d\u0001\u0011\u00051&A\u0012uKN$(k\\<US6,\u0017J\u001c8fe*{\u0017N\\,ji\"<\u0006.\u001a:f\u00072\fWo]3)\u0005\t\u001c\u0004\"\u00024\u0001\t\u0003Y\u0013\u0001\u0007;fgRTu.\u001b8XSRDW)];j!J|7\rV5nK\"\u0012Qm\r\u0005\u0006S\u0002!\taK\u0001\u0018i\u0016\u001cHOS8j]^KG\u000f[#rk&\u0014vn\u001e+j[\u0016D#\u0001[\u001a\t\u000b1\u0004A\u0011A\u0016\u0002/Q,7\u000f\u001e&pS:<\u0016\u000e\u001e5Ok2dG*\u001b;fe\u0006d\u0007FA64\u0011\u0015y\u0007\u0001\"\u0001,\u0003=\"Xm\u001d;S_^$\u0016.\\3J]:,'OS8j]\u0006sGmV5oI><\u0018iZ4sK\u001e\fG/[8o\u001f:4\u0015N]:uQ\tq7\u0007C\u0003s\u0001\u0011\u00051&\u0001\u0019uKN$(k\\<US6,\u0017J\u001c8fe*{\u0017N\\!oI^Kg\u000eZ8x\u0003\u001e<'/Z4bi&|gn\u00148TK\u000e|g\u000e\u001a\u0015\u0003cNBQ!\u001e\u0001\u0005\u0002-\n\u0011\u0004^3tiB\u0013xn\u0019+j[\u0016dUM\u001a;PkR,'OS8j]\"\u0012Ao\r\u0005\u0006q\u0002!\taK\u0001\u0019i\u0016\u001cHOU8x)&lW\rT3gi>+H/\u001a:K_&t\u0007FA<4\u0011\u0015Y\b\u0001\"\u0001,\u0003i!Xm\u001d;Qe>\u001cG+[7f%&<\u0007\u000e^(vi\u0016\u0014(j\\5oQ\tQ8\u0007C\u0003\u007f\u0001\u0011\u00051&A\ruKN$(k\\<US6,'+[4ii>+H/\u001a:K_&t\u0007FA?4\u0011\u0019\t\u0019\u0001\u0001C\u0001W\u0005IB/Z:u!J|7\rV5nK\u001a+H\u000e\\(vi\u0016\u0014(j\\5oQ\r\t\ta\r\u0005\u0007\u0003\u0013\u0001A\u0011A\u0016\u00021Q,7\u000f\u001e*poRKW.\u001a$vY2|U\u000f^3s\u0015>Lg\u000eK\u0002\u0002\bMBa!a\u0004\u0001\t\u0003Y\u0013\u0001\u0005;fgR|U\u000f^3s\u0015>Lgn\u00149uQ\r\tia\r\u0005\u0007\u0003+\u0001A\u0011A\u0016\u0002)Q,7\u000f\u001e&pS:$\u0016.\\3C_VtG-\u0019:zQ\r\t\u0019b\r\u0005\u0007\u00037\u0001A\u0011A\u0016\u0002=Q,7\u000f\u001e&pS:\u0014V-\\1j]\u000e{g\u000eZ5uS>t7i\u001c8wKJ$\bfAA\rg!1\u0011\u0011\u0005\u0001\u0005\u0002-\n\u0011\u0004^3ti\u001a\u000bG\u000e\u001c2bG.$vNU3hk2\f'OS8j]\"\u001a\u0011qD\u001a\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*\u0005\u0011b/\u001a:jMf$\u0016.\\3C_VtG-\u0019:z)%a\u00131FA\u001f\u0003\u000f\nY\u0005\u0003\u0005\u0002.\u0005\u0015\u0002\u0019AA\u0018\u0003A!\u0018.\\3D_:$\u0017\u000e^5p]N\u000bH\u000e\u0005\u0003\u00022\u0005]bbA\u0017\u00024%\u0019\u0011Q\u0007\u0018\u0002\rA\u0013X\rZ3g\u0013\u0011\tI$a\u000f\u0003\rM#(/\u001b8h\u0015\r\t)D\f\u0005\t\u0003\u007f\t)\u00031\u0001\u0002B\u0005YQ\r\u001f9MK\u001a$8+\u001b>f!\ri\u00131I\u0005\u0004\u0003\u000br#\u0001\u0002'p]\u001eD\u0001\"!\u0013\u0002&\u0001\u0007\u0011\u0011I\u0001\rKb\u0004(+[4iiNK'0\u001a\u0005\t\u0003\u001b\n)\u00031\u0001\u00020\u0005YQ\r\u001f9US6,G+\u001f9f\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'\nAD^3sS\u001aL(+Z7bS:\u001cuN\u001c3ji&|gnQ8om\u0016\u0014H\u000fF\u0003-\u0003+\nI\u0006\u0003\u0005\u0002X\u0005=\u0003\u0019AA\u0018\u0003!\u0019\u0018\u000f\\)vKJL\b\u0002CA.\u0003\u001f\u0002\r!a\f\u0002%\u0015D\b/Z2u\u0007>tG-\u001b;j_:\u001cFO\u001d")
public class IntervalJoinTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("rowtime");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("proctime");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("b");

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testInteravlJoinSingleTimeCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a FROM MyTable t1 JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND t1.proctime > t2.proctime - INTERVAL '5' SECOND\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testInteravalDiffTimeIndicator() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a FROM MyTable t1 JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.proctime > t2.proctime - INTERVAL '5' SECOND AND\n        |  t1.proctime < t2.rowtime + INTERVAL '5' SECOND\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testIntervalJoinOnDiffRowTimeType() {
        this.expectedException().expectMessage("Interval join with rowtime attribute requires same rowtime types, but the types are TIMESTAMP(3) *ROWTIME* and TIMESTAMP_LTZ(3) *ROWTIME*");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a FROM MyTable2 t1 JOIN MyTable3 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.rowtime > t2.rowtime - INTERVAL '5' SECOND AND\n        |  t1.rowtime < t2.rowtime + INTERVAL '5' SECOND\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testInteravalNotCnfCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a FROM MyTable t1 JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  (t1.proctime > t2.proctime - INTERVAL '5' SECOND OR\n        |   t1.proctime < t2.rowtime + INTERVAL '5' SECOND)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test(expected=TableException.class)
    public void testNoRowtimeAttributeInResult() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable t1, MyTable2 t2 WHERE\n        |  t1.a = t2.a AND\n        |  t1.proctime BETWEEN t2.proctime - INTERVAL '5' SECOND AND t2.proctime\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test(expected=TableException.class)
    public void testWindowOuterJoinWithPythonFunctionInCondition() {
        this.util().addFunction("pyFunc", new JavaUserDefinedScalarFunctions.PythonScalarFunction("pyFunc"));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b FROM MyTable t1 LEFT OUTER JOIN MyTable2 t2 ON\n        |    t1.a = t2.a AND pyFunc(t1.a, t2.a) = t1.a + t2.a AND\n        |    t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testProcessingTimeInnerJoinWithOnClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b FROM MyTable t1 JOIN MyTable2 t2 ON\n        |    t1.a = t2.a AND\n        |    t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testProcessingTimeInnerJoinWithWhereClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b FROM MyTable t1, MyTable2 t2 WHERE\n        |    t1.a = t2.a AND\n        |    t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testProcessingTimeInnerJoinWithoutEqualCondition() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b FROM MyTable t1 JOIN MyTable2 t2 ON\n        |    t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRowTimeInnerJoinWithOnClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b FROM MyTable t1 JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '10' SECOND AND t2.rowtime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testIntervalJoinOnTimestampLtzRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a FROM MyTable3 t1 JOIN MyTable4 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.rowtime > t2.rowtime - INTERVAL '5' SECOND AND\n        |  t1.rowtime < t2.rowtime + INTERVAL '5' SECOND\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRowTimeInnerJoinWithoutEqualCondition() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b FROM MyTable t1 JOIN MyTable2 t2 ON\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '10' SECOND AND t2.rowtime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRowTimeInnerJoinWithWhereClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b FROM MyTable t1, MyTable2 t2 WHERE\n        |  t1.a = t2.a AND\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '10' MINUTE AND t2.rowtime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testJoinWithEquiProcTime() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b FROM MyTable t1, MyTable2 t2 WHERE\n        |  t1.a = t2.a AND t1.proctime = t2.proctime\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testJoinWithEquiRowTime() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b FROM MyTable t1, MyTable2 t2 WHERE\n        |  t1.a = t2.a AND t1.rowtime = t2.rowtime\n        ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testJoinWithNullLiteral() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T1 AS (SELECT a, b, c, proctime, CAST(null AS BIGINT) AS nullField FROM MyTable),\n        |     T2 AS (SELECT a, b, c, proctime, CAST(12 AS BIGINT) AS nullField FROM MyTable2)\n        |\n        |SELECT t2.a, t2.c, t1.c\n        |FROM T1 AS t1\n        |JOIN T2 AS t2 ON t1.a = t2.a AND t1.nullField = t2.nullField AND\n        |  t1.proctime BETWEEN t2.proctime - INTERVAL '5' SECOND AND\n        |  t2.proctime + INTERVAL '5' SECOND\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRowTimeInnerJoinAndWindowAggregationOnFirst() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.b, SUM(t2.a) AS aSum, COUNT(t2.b) AS bCnt\n        |FROM MyTable t1, MyTable2 t2\n        |WHERE t1.a = t2.a AND\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '10' MINUTE AND t2.rowtime + INTERVAL '1' HOUR\n        |GROUP BY TUMBLE(t1.rowtime, INTERVAL '6' HOUR), t1.b\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRowTimeInnerJoinAndWindowAggregationOnSecond() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.b, SUM(t1.a) AS aSum, COUNT(t1.b) AS bCnt\n        |FROM MyTable t1, MyTable2 t2\n        |WHERE t1.a = t2.a AND\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '10' MINUTE AND t2.rowtime + INTERVAL '1' HOUR\n        |GROUP BY TUMBLE(t2.rowtime, INTERVAL '6' HOUR), t2.b\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testProcTimeLeftOuterJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 LEFT OUTER JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRowTimeLeftOuterJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 LEFT OUTER JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '10' SECOND AND t2.rowtime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testProcTimeRightOuterJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 RIGHT OUTER JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRowTimeRightOuterJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 RIGHT OUTER JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '10' SECOND AND t2.rowtime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testProcTimeFullOuterJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 Full OUTER JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRowTimeFullOuterJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 FULL OUTER JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '10' SECOND AND t2.rowtime + INTERVAL '1' HOUR\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testOuterJoinOpt() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 FULL OUTER JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.rowtime BETWEEN t2.rowtime - INTERVAL '10' SECOND AND t2.rowtime + INTERVAL '1' HOUR\n        |  WHERE t1.b LIKE t2.b\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testJoinTimeBoundary() {
        this.verifyTimeBoundary("t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR", -3600000L, 3600000L, "proctime");
        this.verifyTimeBoundary("t1.proctime > t2.proctime - INTERVAL '1' SECOND AND t1.proctime < t2.proctime + INTERVAL '1' SECOND", -999L, 999L, "proctime");
        this.verifyTimeBoundary("t1.rowtime >= t2.rowtime - INTERVAL '1' SECOND AND t1.rowtime <= t2.rowtime + INTERVAL '1' SECOND", -1000L, 1000L, "rowtime");
        this.verifyTimeBoundary("t1.rowtime >= t2.rowtime AND t1.rowtime <= t2.rowtime + INTERVAL '1' SECOND", 0L, 1000L, "rowtime");
        this.verifyTimeBoundary("t1.rowtime >= t2.rowtime + INTERVAL '1' SECOND AND t1.rowtime <= t2.rowtime + INTERVAL '10' SECOND", 1000L, 10000L, "rowtime");
        this.verifyTimeBoundary("t2.rowtime - INTERVAL '1' SECOND <= t1.rowtime AND t2.rowtime + INTERVAL '10' SECOND >= t1.rowtime", -1000L, 10000L, "rowtime");
        this.verifyTimeBoundary("t1.rowtime - INTERVAL '2' SECOND >= t2.rowtime + INTERVAL '1' SECOND - INTERVAL '10' SECOND AND t1.rowtime <= t2.rowtime + INTERVAL '10' SECOND", -7000L, 10000L, "rowtime");
        this.verifyTimeBoundary("t1.rowtime >= t2.rowtime - INTERVAL '10' SECOND AND t1.rowtime <= t2.rowtime - INTERVAL '5' SECOND", -10000L, -5000L, "rowtime");
    }

    @Test
    public void testJoinRemainConditionConvert() {
        this.util().addDataStream("MyTable3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$2).rowtime(), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime()}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$9 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addDataStream("MyTable4", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$2).rowtime(), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime()}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$10 $outer;
                    private final ExecutionConfig executionConfig$4;
                    private final TypeSerializer[] fieldSerializers$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$4 = executionConfig$4;
                        this.fieldSerializers$4 = fieldSerializers$4;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.c FROM MyTable3 AS t1 JOIN MyTable4 AS t2 ON\n        |    t1.a = t2.a AND\n        |    t1.rowtime >= t2.rowtime - INTERVAL '10' SECOND AND\n        |    t1.rowtime <= t2.rowtime - INTERVAL '5' SECOND AND\n        |    t1.c > t2.c\n      ")).stripMargin();
        this.verifyRemainConditionConvert(query, ">($2, $6)");
        String query1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.c FROM MyTable3 as t1 JOIN MyTable4 AS t2 ON\n        |    t1.a = t2.a AND\n        |    t1.rowtime >= t2.rowtime - INTERVAL '10' SECOND AND\n        |    t1.rowtime <= t2.rowtime - INTERVAL '5' SECOND\n      ")).stripMargin();
        this.verifyRemainConditionConvert(query1, "");
        this.util().addDataStream("MyTable5", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime()}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$11 $outer;
                    private final ExecutionConfig executionConfig$5;
                    private final TypeSerializer[] fieldSerializers$5;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$5[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$5);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$5 = executionConfig$5;
                        this.fieldSerializers$5 = fieldSerializers$5;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addDataStream("MyTable6", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime()}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$12 $outer;
                    private final ExecutionConfig executionConfig$6;
                    private final TypeSerializer[] fieldSerializers$6;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$6[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$6);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$6 = executionConfig$6;
                        this.fieldSerializers$6 = fieldSerializers$6;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        String query2 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.c FROM MyTable5 AS t1 JOIN MyTable6 AS t2 ON\n        |    t1.a = t2.a AND\n        |    t1.proctime >= t2.proctime - INTERVAL '10' SECOND AND\n        |    t1.proctime <= t2.proctime - INTERVAL '5' SECOND AND\n        |    t1.c > t2.c\n      ")).stripMargin();
        this.verifyRemainConditionConvert(query2, ">($2, $6)");
    }

    @Test
    public void testFallbackToRegularJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a FROM MyTable t1 WHERE t1.a IN (\n        | SELECT t2.a FROM MyTable2 t2\n        |   WHERE t1.b = t2.b AND t1.rowtime between t2.rowtime and t2.rowtime + INTERVAL '5' MINUTE\n        |   GROUP BY t2.a\n        |)\n    ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    private void verifyTimeBoundary(String timeConditionSql, long expLeftSize, long expRightSize, String expTimeType) {
        String query = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT t1.a, t2.b FROM MyTable AS t1 JOIN MyTable2 AS t2 ON\n         |    t1.a = t2.a AND\n         |    ", "\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timeConditionSql})))).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(query);
        RelNode relNode = TableTestUtil$.MODULE$.toRelNode(table);
        LogicalJoin joinNode = (LogicalJoin)relNode.getInput(0);
        RexNode rexNode = joinNode.getCondition();
        Tuple2 tuple2 = IntervalJoinUtil$.MODULE$.extractWindowBoundsFromPredicate(rexNode, joinNode.getLeft().getRowType().getFieldCount(), joinNode.getRowType(), joinNode.getCluster().getRexBuilder(), this.util().tableEnv().getConfig());
        if (tuple2 != null) {
            Option windowBounds = (Option)tuple2._1();
            Option option = windowBounds;
            Option windowBounds2 = option;
            String timeTypeStr = ((IntervalJoinSpec.WindowBounds)windowBounds2.get()).isEventTime() ? "rowtime" : "proctime";
            Assert.assertEquals((long)expLeftSize, (long)((IntervalJoinSpec.WindowBounds)windowBounds2.get()).getLeftLowerBound());
            Assert.assertEquals((long)expRightSize, (long)((IntervalJoinSpec.WindowBounds)windowBounds2.get()).getLeftUpperBound());
            Assert.assertEquals((Object)expTimeType, (Object)timeTypeStr);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private void verifyRemainConditionConvert(String sqlQuery, String expectConditionStr) {
        Table table = this.util().tableEnv().sqlQuery(sqlQuery);
        RelNode relNode = TableTestUtil$.MODULE$.toRelNode(table);
        LogicalJoin joinNode = (LogicalJoin)relNode.getInput(0);
        JoinInfo joinInfo = joinNode.analyzeCondition();
        RexNode rexNode = joinInfo.getRemaining(joinNode.getCluster().getRexBuilder());
        Tuple2 tuple2 = IntervalJoinUtil$.MODULE$.extractWindowBoundsFromPredicate(rexNode, joinNode.getLeft().getRowType().getFieldCount(), joinNode.getRowType(), joinNode.getCluster().getRexBuilder(), this.util().tableEnv().getConfig());
        if (tuple2 != null) {
            Option remainCondition;
            Option option;
            Option remainCondition2 = option = (remainCondition = (Option)tuple2._2());
            String actual = remainCondition2.getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            }).toString();
            Assert.assertEquals((Object)expectConditionStr, (Object)actual);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public IntervalJoinTest() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$2).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$7 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addDataStream("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$2).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$8 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |CREATE TABLE MyTable3 (\n       |  a int,\n       |  b bigint,\n       |  c string,\n       |  rowtime as TO_TIMESTAMP_LTZ(b, 3),\n       |  watermark for rowtime as rowtime\n       |) WITH (\n       |  'connector' = 'values',\n       |  'bounded' = 'false'\n       |)\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |CREATE TABLE MyTable4 (\n       |  a int,\n       |  b bigint,\n       |  c string,\n       |  rowtime as TO_TIMESTAMP_LTZ(b, 3),\n       |  watermark for rowtime as rowtime\n       |) WITH (\n       |  'connector' = 'values',\n       |  'bounded' = 'false'\n       |)\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
    }
}

