/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.PartitionableSinkTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001}3A!\u0001\u0002\u0001'\t)\u0002+\u0019:uSRLwN\\1cY\u0016\u001c\u0016N\\6UKN$(BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\taa\u001d;sK\u0006l'BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0011\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%I!I\u0001\u0005kRLG.F\u0001#!\t)2%\u0003\u0002%-\t\u00192\u000b\u001e:fC6$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\"1a\u0005\u0001Q\u0001\n\t\nQ!\u001e;jY\u0002BQ\u0001\u000b\u0001\u0005\n%\n1b\u0019:fCR,G+\u00192mKR\u0019!\u0006M\u001d\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0006c\u001d\u0002\rAM\u0001\u0005]\u0006lW\r\u0005\u00024m9\u00111\u0006N\u0005\u0003k1\na\u0001\u0015:fI\u00164\u0017BA\u001c9\u0005\u0019\u0019FO]5oO*\u0011Q\u0007\f\u0005\u0006u\u001d\u0002\raO\u0001\ng\",hM\u001a7f\u0005f\u0004\"a\u000b\u001f\n\u0005ub#a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u007f\u0001!\t\u0001Q\u0001\u000bi\u0016\u001cHo\u0015;bi&\u001cG#\u0001\u0016)\u0005y\u0012\u0005CA\"G\u001b\u0005!%BA#\u0011\u0003\u0015QWO\\5u\u0013\t9EI\u0001\u0003UKN$\b\"B%\u0001\t\u0003\u0001\u0015a\u0003;fgR$\u0015P\\1nS\u000eD#\u0001\u0013\"\t\u000b1\u0003A\u0011\u0001!\u0002)Q,7\u000f\u001e#z]\u0006l\u0017nY*ik\u001a4G.\u001a\"zQ\tY%\tC\u0003P\u0001\u0011\u0005\u0001)A\u0006uKN$\b+\u0019:uS\u0006d\u0007F\u0001(C\u0011\u0015\u0011\u0006\u0001\"\u0001A\u0003=!Xm\u001d;Xe>twm\u0015;bi&\u001c\u0007\u0006B)C)V\u000b\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002-B\u0011qKW\u0007\u00021*\u0011\u0011LC\u0001\u0004CBL\u0017BA.Y\u0005M1\u0016\r\\5eCRLwN\\#yG\u0016\u0004H/[8o\u0011\u0015i\u0006\u0001\"\u0001A\u0003=!Xm\u001d;Xe>twMR5fY\u0012\u001c\b\u0006\u0002/C)V\u0003")
public class PartitionableSinkTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");

    private StreamTableTestUtil util() {
        return this.util;
    }

    private void createTable(String name, boolean shuffleBy) {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create table ", " (\n         |  a bigint,\n         |  b bigint,\n         |  c bigint\n         |) partitioned by (b, c) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '/non',\n         |  ", "\n         |  'format' = 'testcsv'\n         |)\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, shuffleBy ? "'sink.shuffle-by-partition.enable'='true'," : ""})))).stripMargin());
    }

    @Test
    public void testStatic() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (b=1, c=1) SELECT a FROM MyTable");
    }

    @Test
    public void testDynamic() {
        this.util().verifyExecPlanInsert("INSERT INTO sink SELECT a, b, c FROM MyTable");
    }

    @Test
    public void testDynamicShuffleBy() {
        this.createTable("sinkShuffleBy", true);
        this.util().verifyExecPlanInsert("INSERT INTO sinkShuffleBy SELECT a, b, c FROM MyTable");
    }

    @Test
    public void testPartial() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (b=1) SELECT a, c FROM MyTable");
    }

    @Test(expected=ValidationException.class)
    public void testWrongStatic() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (a=1) SELECT b, c FROM MyTable");
    }

    @Test(expected=ValidationException.class)
    public void testWrongFields() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (b=1) SELECT a, b, c FROM MyTable");
    }

    public PartitionableSinkTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.createTable("sink", false);
    }
}

