/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.time.Duration;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.stream.sql.Func1;
import org.apache.flink.table.planner.plan.stream.sql.ModifiedMonotonicityTest$;
import org.apache.flink.table.planner.plan.trait.RelModifiedMonotonicity;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001M\u0011\u0001$T8eS\u001aLW\rZ'p]>$xN\\5dSRLH+Z:u\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\rM$(/Z1n\u0015\t9\u0001\"\u0001\u0003qY\u0006t'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003C\u0001\u0006kRLGn]\u0005\u00033Y\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005\u0002\u0005\nA!\u001e;jYV\t!\u0005\u0005\u0002\u0016G%\u0011AE\u0006\u0002\u0014'R\u0014X-Y7UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007M\u0001\u0001\u000b\u0011\u0002\u0012\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000b!\u0002A\u0011A\u0015\u00025Q,7\u000f^'bq^KG\u000f\u001b*fiJ\f7\r^(qi&l\u0017N_3\u0015\u0003)\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012A!\u00168ji\"\u0012q%\r\t\u0003eUj\u0011a\r\u0006\u0003iA\tQA[;oSRL!AN\u001a\u0003\tQ+7\u000f\u001e\u0005\u0006q\u0001!\t!K\u0001\u001bi\u0016\u001cH/T5o/&$\bNU3ue\u0006\u001cGo\u00149uS6L'0\u001a\u0015\u0003oEBQa\u000f\u0001\u0005\u0002%\nQ\u0003^3ti6KgnQ1o\u001d>$x\n\u001d;j[&TX\r\u000b\u0002;c!)a\b\u0001C\u0001S\u0005IC/Z:u\u001b\u0006Dx+\u001b;i%\u0016$(/Y2u\u001fB$\u0018.\\5{K^KG\u000f\u001b'pG\u0006dw\t\\8cC2D#!P\u0019\t\u000b\u0005\u0003A\u0011A\u0015\u0002SQ,7\u000f^'j]^KG\u000f\u001b*fiJ\f7\r^(qi&l\u0017N_3XSRDGj\\2bY\u001ecwNY1mQ\t\u0001\u0015\u0007C\u0003E\u0001\u0011\u0005\u0011&\u0001\u0013uKN$X*\u001b8DC:tu\u000e^(qi&l\u0017N_3XSRDGj\\2bY\u001ecwNY1mQ\t\u0019\u0015\u0007C\u0003H\u0001\u0011\u0005\u0011&\u0001\u0014uKN$H+^7cY\u00164UO\\!oIJ+w-\u001e7be\u0006;wMR;o\u0013:<%o\\;q\u0005fD#AR\u0019\t\u000b)\u0003A\u0011A\u0015\u0002\u0019Q,7\u000f^!oi&Tu.\u001b8)\u0005%\u000b\u0004\"B'\u0001\t\u0003I\u0013\u0001\u0007;fgR\u001cV-\\5K_&tw+\u001b;i\u001d>tW)];bY\"\u0012A*\r\u0005\u0006!\u0002!\t!K\u0001\ri\u0016\u001cHoU3nS*{\u0017N\u001c\u0015\u0003\u001fFBQa\u0015\u0001\u0005\u0002%\n\u0001\u0004^3ti&sg.\u001a:K_&twJ\\!hOJ+7/\u001e7uQ\t\u0011\u0016\u0007C\u0003W\u0001\u0011\u0005\u0011&A\u0007uKN$\u0018J\u001c8fe*{\u0017N\u001c\u0015\u0003+FBQ!\u0017\u0001\u0005\u0002%\nA\u0002^3tiVs\u0017n\u001c8BY2D#\u0001W\u0019\t\u000bq\u0003A\u0011A\u0015\u0002\u0011Q,7\u000f^(wKJD#aW\u0019\t\u000b}\u0003A\u0011A\u0015\u00021Q,7\u000f^'vYRLw\n]3sC:$7OR8s\u0007\u0006d7\r\u000b\u0002_c!)!\r\u0001C\u0001S\u0005aA/Z:u)>\u0004h\nR3tG\"\u0012\u0011-\r\u0005\u0006K\u0002!\t!K\u0001\fi\u0016\u001cH\u000fV8q\u001d\u0006\u001b8\r\u000b\u0002ec!)\u0001\u000e\u0001C\u0001S\u0005!B/Z:u)>\u0004h*\u00114uKJ<%o\\;q\u0005fD#aZ\u0019\t\u000b-\u0004A\u0011A\u0015\u0002+Q,7\u000f\u001e+pa:\u000be\r^3s\u000fJ|W\u000f\u001d\"ze!\u0012!.\r\u0005\u0006]\u0002!\ta\\\u0001\u0013m\u0016\u0014\u0018NZ=N_:|Go\u001c8jG&$\u0018\u0010F\u0002+abDQaA7A\u0002E\u0004\"A];\u000f\u0005-\u001a\u0018B\u0001;-\u0003\u0019\u0001&/\u001a3fM&\u0011ao\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Qd\u0003\"B=n\u0001\u0004Q\u0018AB3ya\u0016\u001cG\u000f\u0005\u0002|}6\tAP\u0003\u0002~\r\u0005)AO]1ji&\u0011q\u0010 \u0002\u0018%\u0016dWj\u001c3jM&,G-T8o_R|g.[2jif\u0004")
public class ModifiedMonotonicityTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a1");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("a2");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("a3");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("b1");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("b2");
    private static Symbol symbol$6 = Symbol$.MODULE$.apply("b3");
    private static Symbol symbol$7 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$8 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$9 = Symbol$.MODULE$.apply("c");
    private static Symbol symbol$10 = Symbol$.MODULE$.apply("proctime");
    private static Symbol symbol$11 = Symbol$.MODULE$.apply("rowtime");
    private static Symbol symbol$12 = Symbol$.MODULE$.apply("b4");
    private static Symbol symbol$13 = Symbol$.MODULE$.apply("b5");

    public StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testMaxWithRetractOptimize() {
        String query = "SELECT a1, MAX(a3) FROM (SELECT a1, a2, MAX(a3) AS a3 FROM A GROUP BY a1, a2) t GROUP BY a1";
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMinWithRetractOptimize() {
        String query = "SELECT a1, MIN(a3) FROM (SELECT a1, a2, MIN(a3) AS a3 FROM A GROUP BY a1, a2) t GROUP BY a1";
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMinCanNotOptimize() {
        String query = "SELECT a1, MIN(a3) FROM (SELECT a1, a2, MAX(a3) AS a3 FROM A GROUP BY a1, a2) t GROUP BY a1";
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMaxWithRetractOptimizeWithLocalGlobal() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, true);
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofMillis(100L));
        String query = "SELECT a1, max(a3) from (SELECT a1, a2, max(a3) as a3 FROM A GROUP BY a1, a2) group by a1";
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMinWithRetractOptimizeWithLocalGlobal() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, true);
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofMillis(100L));
        String query = "SELECT min(a3) from (SELECT a1, a2, min(a3) as a3 FROM A GROUP BY a1, a2)";
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMinCanNotOptimizeWithLocalGlobal() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, true);
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofMillis(100L));
        String query = "SELECT a1, MIN(a3) FROM (SELECT a1, a2, MAX(a3) AS a3 FROM A GROUP BY a1, a2) t GROUP BY a1";
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testTumbleFunAndRegularAggFunInGroupBy() {
        String sql = "SELECT b, d, weightedAvg(c, a) FROM  (SELECT a, b, c, count(*) d,  TUMBLE_START(rowtime, INTERVAL '15' MINUTE) as ping_start  FROM MyTable   GROUP BY a, b, c, TUMBLE(rowtime, INTERVAL '15' MINUTE)) AS t1 GROUP BY b, d, ping_start";
        this.verifyMonotonicity(sql, new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT, SqlMonotonicity.NOT_MONOTONIC})));
    }

    @Test
    public void testAntiJoin() {
        String sql = "SELECT * FROM AA WHERE NOT EXISTS (SELECT b1 from BB WHERE a1 = b1)";
        this.verifyMonotonicity(sql, null);
    }

    @Test
    public void testSemiJoinWithNonEqual() {
        String query1 = "SELECT MAX(a2) AS a2, a1 FROM AA group by a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM BB group by b1";
        String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM (", ") WHERE a1 in (SELECT b1 from (", ") WHERE a2 < b2)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1, query2}));
        this.verifyMonotonicity(sql, null);
    }

    @Test
    public void testSemiJoin() {
        String query1 = "SELECT MAX(a2) AS a2, a1 FROM AA group by a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM BB group by b1";
        String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, a2 FROM (", ") WHERE a1 in (SELECT b1 from (", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1, query2}));
        this.verifyMonotonicity(sql, new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.INCREASING})));
    }

    @Test
    public void testInnerJoinOnAggResult() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM AA group by a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM BB group by b1";
        String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, a2, b1, b2 FROM (", ") JOIN (", ") ON a2 = b2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1, query2}));
        this.verifyMonotonicity(sql, null);
    }

    @Test
    public void testInnerJoin() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM AA group by a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM BB group by b1";
        String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, a2, b1, b2 FROM (", ") JOIN (", ") ON a1 = b1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1, query2}));
        this.verifyMonotonicity(sql, new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.CONSTANT, SqlMonotonicity.NOT_MONOTONIC})));
    }

    @Test
    public void testUnionAll() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM AA group by a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM BB group by b1";
        String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, a2 FROM (", ") union all (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1, query2}));
        this.verifyMonotonicity(sql, new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.NOT_MONOTONIC})));
    }

    @Test
    public void testOver() {
        String sql = "SELECT a,   SUM(c) OVER (    PARTITION BY a ORDER BY proctime ROWS BETWEEN 4 PRECEDING AND CURRENT ROW),   MIN(c) OVER (    PARTITION BY a ORDER BY proctime ROWS BETWEEN 4 PRECEDING AND CURRENT ROW) FROM MyTable";
        this.verifyMonotonicity(sql, new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT})));
    }

    @Test
    public void testMultiOperandsForCalc() {
        this.util().addFunction("func1", new Func1());
        String sql = "SELECT func1(func1(a1, a3)) from (SELECT last_value(a1) as a1, last_value(a3) as a3 FROM AA group by a2) ";
        this.verifyMonotonicity(sql, new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.NOT_MONOTONIC})));
    }

    @Test
    public void testTopNDesc() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT b, c, a,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY b DESC, c ASC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num <= 10\n      ")).stripMargin();
        this.verifyMonotonicity(sql, new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.INCREASING, SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT})));
    }

    @Test
    public void testTopNAsc() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT a, b, c,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY b ASC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num <= 10\n      ")).stripMargin();
        this.verifyMonotonicity(sql, new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.DECREASING, SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.CONSTANT})));
    }

    @Test
    public void testTopNAfterGroupBy() {
        String subquery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, COUNT(*) as count_c\n        |FROM MyTable\n        |GROUP BY a, b\n      ")).stripMargin();
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT *\n         |FROM (\n         |  SELECT a, b, count_c,\n         |      ROW_NUMBER() OVER (PARTITION BY b ORDER BY count_c DESC) as rank_num\n         |  FROM (", "))\n         |WHERE rank_num <= 10\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{subquery})))).stripMargin();
        this.verifyMonotonicity(sql, new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.CONSTANT, SqlMonotonicity.INCREASING, SqlMonotonicity.CONSTANT})));
    }

    @Test
    public void testTopNAfterGroupBy2() {
        String subquery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, COUNT(*) as count_c\n        |FROM MyTable\n        |GROUP BY a, b\n      ")).stripMargin();
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT *\n         |FROM (\n         |  SELECT a, b, count_c,\n         |      ROW_NUMBER() OVER (PARTITION BY count_c ORDER BY a DESC) as rank_num\n         |  FROM (", "))\n         |WHERE rank_num <= 10\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{subquery})))).stripMargin();
        this.verifyMonotonicity(sql, null);
    }

    public void verifyMonotonicity(String sql, RelModifiedMonotonicity expect) {
        Table table = this.util().tableEnv().sqlQuery(sql);
        RelNode relNode = TableTestUtil$.MODULE$.toRelNode(table);
        RelNode optimized = this.util().getPlanner().optimize(relNode);
        RelModifiedMonotonicity actualMono = FlinkRelMetadataQuery.reuseOrCreate((RelMetadataQuery)optimized.getCluster().getMetadataQuery()).getRelModifiedMonotonicity(optimized);
        Assert.assertEquals((Object)expect, (Object)actualMono);
    }

    public ModifiedMonotonicityTest() {
        this.util().addDataStream("A", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$6 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addDataStream("B", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6)}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$7 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$7), package$.MODULE$.symbol2FieldExpression(symbol$8), package$.MODULE$.symbol2FieldExpression(symbol$9), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$10).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$11).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$8 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addTemporarySystemFunction("weightedAvg", JavaUserDefinedAggFunctions.WeightedAvgWithMerge.class);
        this.util().addTableSource("AA", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$9 $outer;
                    private final ExecutionConfig executionConfig$4;
                    private final TypeSerializer[] fieldSerializers$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$4 = executionConfig$4;
                        this.fieldSerializers$4 = fieldSerializers$4;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addTableSource("BB", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), package$.MODULE$.symbol2FieldExpression(symbol$12), package$.MODULE$.symbol2FieldExpression(symbol$13)}), new CaseClassTypeInfo<Tuple5<Object, Object, Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$10 $outer;
                    private final ExecutionConfig executionConfig$5;
                    private final TypeSerializer[] fieldSerializers$5;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$5[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$5);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$5 = executionConfig$5;
                        this.fieldSerializers$5 = fieldSerializers$5;
                    }
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple5<Object, Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((String)fields[3]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[4])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
    }
}

