/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001=3A!\u0001\u0002\u0001'\t!b)\u001b7uKJ\f'\r\\3T_V\u00148-\u001a+fgRT!a\u0001\u0003\u0002\u0007M\fHN\u0003\u0002\u0006\r\u000511\u000f\u001e:fC6T!a\u0002\u0005\u0002\tAd\u0017M\u001c\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\t\u0003\u0015)H/\u001b7t\u0013\tIbCA\u0007UC\ndW\rV3ti\n\u000b7/\u001a\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAq\u0001\t\u0001C\u0002\u0013%\u0011%\u0001\u0003vi&dW#\u0001\u0012\u0011\u0005U\u0019\u0013B\u0001\u0013\u0017\u0005M\u0019FO]3b[R\u000b'\r\\3UKN$X\u000b^5m\u0011\u00191\u0003\u0001)A\u0005E\u0005)Q\u000f^5mA!)\u0001\u0006\u0001C\u0001S\u0005)1/\u001a;vaR\t!\u0006\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0003V]&$\bFA\u00142!\t\u0011T'D\u00014\u0015\t!\u0004#A\u0003kk:LG/\u0003\u00027g\t1!)\u001a4pe\u0016DQ\u0001\u000f\u0001\u0005\u0002%\n\u0001\u0005^3ti\u001a+H\u000e\u001c$jYR,'/T1uG\"<\u0016\u000e\u001e5XCR,'/\\1sW\"\u0012qG\u000f\t\u0003emJ!\u0001P\u001a\u0003\tQ+7\u000f\u001e\u0005\u0006}\u0001!\t!K\u0001$i\u0016\u001cH\u000fU1si&\fGNR5mi\u0016\u0014X*\u0019;dQ^KG\u000f[,bi\u0016\u0014X.\u0019:lQ\ti$\bC\u0003B\u0001\u0011\u0005\u0011&\u0001\u0010uKN$hj\u001c$jYR,'/T1uG\"<\u0016\u000e\u001e5XCR,'/\\1sW\"\u0012\u0001I\u000f\u0005\u0006\t\u0002!\t!K\u0001)i\u0016\u001cHOR;mYB+8\u000f\u001b3po:<\u0016\u000e\u001e5pkR<\u0016\r^3s[\u0006\u00148.Q:tS\u001etWM\u001d\u0015\u0003\u0007jBQa\u0012\u0001\u0005\u0002%\n1\u0006^3tiB\u000b'\u000f^5bYB+8\u000f\u001b3po:<\u0016\u000e\u001e5pkR<\u0016\r^3s[\u0006\u00148.Q:tS\u001etWM\u001d\u0015\u0003\rjBQA\u0013\u0001\u0005\u0002%\n\u0011\u0006^3ti\u000e{W\u000e];uK\u0012\u001cu\u000e\\;n]B+8\u000f\u001b3po:\f5M]8tg^\u000bG/\u001a:nCJ\\\u0007FA%;\u0011\u0015i\u0005\u0001\"\u0001*\u0003e!Xm\u001d;GS2$XM\u001d)vg\"$wn\u001e8XSRDW\u000b\u001a4)\u00051S\u0004")
public class FilterableSourceTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n        | CREATE TABLE MyTable(\n        |   a INT,\n        |   b BIGINT,\n        |   c TIMESTAMP(3),\n        |   d STRING,\n        |   WATERMARK FOR c AS c\n        | ) WITH (\n        |   'connector' = 'values',\n        |   'enable-watermark-push-down' = 'true',\n        |   'filterable-fields' = 'a;d',\n        |   'bounded' = 'false',\n        |   'disable-lookup' = 'true'\n        | )\n        |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
    }

    @Test
    public void testFullFilterMatchWithWatermark() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE LOWER(d) = 'hello'");
    }

    @Test
    public void testPartialFilterMatchWithWatermark() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE LOWER(d) = 'h' AND d IS NOT NULL");
    }

    @Test
    public void testNoFilterMatchWithWatermark() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE b > 5");
    }

    @Test
    public void testFullPushdownWithoutWatermarkAssigner() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE NoWatermark (\n        |  name STRING,\n        |  event_time TIMESTAMP(3)\n        |) WITH (\n        |  'connector' = 'values',\n        |  'filterable-fields' = 'name',\n        |  'bounded' = 'false',\n        |  'disable-lookup' = 'true'\n        |)\n        |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT * FROM NoWatermark WHERE LOWER(name) = 'foo' AND UPPER(name) = 'FOO'");
    }

    @Test
    public void testPartialPushdownWithoutWatermarkAssigner() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE NoWatermark (\n        |  name STRING,\n        |  event_time TIMESTAMP(3)\n        |) WITH (\n        |  'connector' = 'values',\n        |  'filterable-fields' = 'name',\n        |  'bounded' = 'false',\n        |  'disable-lookup' = 'true'\n        |)\n        |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT * FROM NoWatermark WHERE LOWER(name) = 'foo' AND name IS NOT NULL");
    }

    @Test
    public void testComputedColumnPushdownAcrossWatermark() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE WithWatermark (\n        |  event_time TIMESTAMP(3),\n        |  name STRING,\n        |  lowercase_name AS LOWER(name),\n        |  WATERMARK FOR event_time AS event_time\n        |) WITH (\n        |  'connector' = 'values',\n        |  'bounded' = 'false',\n        |  'enable-watermark-push-down' = 'true',\n        |  'filterable-fields' = 'name',\n        |  'disable-lookup' = 'true'\n        |)\n        |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT * FROM WithWatermark WHERE lowercase_name = 'foo'");
    }

    @Test
    public void testFilterPushdownWithUdf() {
        JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled = false;
        JavaUserDefinedScalarFunctions.JavaFunc5.openCalled = false;
        this.util().tableEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.JavaFunc5());
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE Table UdfTable (\n         |   a INT,\n         |   b BIGINT,\n         |   c timestamp(3),\n         |   d as func(c, a),\n         |   f STRING,\n         |   WATERMARK FOR c as func(func(d, a), a)\n         | ) with (\n         |   'connector' = 'values',\n         |   'bounded' = 'false',\n         |   'filterable-fields' = 'f',\n         |   'enable-watermark-push-down' = 'true',\n         |   'disable-lookup' = 'true'\n         | )\n         |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT * FROM UdfTable WHERE UPPER(f) = 'welcome'");
    }
}

