/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.time.Duration;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.DeduplicateTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001'\tyA)\u001a3va2L7-\u0019;f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/!\tQ!\u001e;jYNL!!\u0007\f\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0005!\u0001\u0001\u0007\t\u0019!C\u0001C\u0005!Q\u000f^5m+\u0005\u0011\u0003CA\u000b$\u0013\t!cCA\nTiJ,\u0017-\u001c+bE2,G+Z:u+RLG\u000eC\u0005'\u0001\u0001\u0007\t\u0019!C\u0001O\u0005AQ\u000f^5m?\u0012*\u0017\u000f\u0006\u0002)]A\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t!QK\\5u\u0011\u001dyS%!AA\u0002\t\n1\u0001\u001f\u00132\u0011\u0019\t\u0004\u0001)Q\u0005E\u0005)Q\u000f^5mA!)1\u0007\u0001C\u0001i\u0005)1/\u001a;VaR\t\u0001\u0006\u000b\u00023mA\u0011qGO\u0007\u0002q)\u0011\u0011\bE\u0001\u0006UVt\u0017\u000e^\u0005\u0003wa\u0012aAQ3g_J,\u0007\"B\u001f\u0001\t\u0003!\u0014a\n;fgRLeN^1mS\u0012\u0014vn\u001e(v[\n,'oQ8oI&$\u0018n\u001c8P]B\u0013xn\u0019;j[\u0016D#\u0001P \u0011\u0005]\u0002\u0015BA!9\u0005\u0011!Vm\u001d;\t\u000b\r\u0003A\u0011\u0001\u001b\u0002MQ,7\u000f^%om\u0006d\u0017\u000e\u001a*po:+XNY3s\u0007>tG-\u001b;j_:|eNU8xi&lW\r\u000b\u0002C\u007f!)a\t\u0001C\u0001i\u0005qB/Z:u\u0019\u0006\u001cHOU8x/&$\bnV5oI><xJ\u001c*poRLW.\u001a\u0015\u0003\u000b~BQ!\u0013\u0001\u0005\u0002Q\n1\u0004^3tiNKW\u000e\u001d7f\r&\u00148\u000f\u001e*po>s'k\\<uS6,\u0007F\u0001%@\u0011\u0015a\u0005\u0001\"\u00015\u0003\r\"Xm\u001d;NS:L')\u0019;dQ&sg-\u001a:GSJ\u001cHOU8x\u001f:\u0014vn\u001e;j[\u0016D#aS \t\u000b=\u0003A\u0011\u0001\u001b\u00025Q,7\u000f^*j[BdW\rT1tiJ{wo\u00148S_^$\u0018.\\3)\u00059{\u0004\"\u0002*\u0001\t\u0003!\u0014A\t;fgRl\u0015N\\5CCR\u001c\u0007.\u00138gKJd\u0015m\u001d;S_^|eNU8xi&lW\r\u000b\u0002R\u007f!)Q\u000b\u0001C\u0001i\u0005YB/Z:u'&l\u0007\u000f\\3MCN$(k\\<P]B\u0013xn\u0019;j[\u0016D#\u0001V \t\u000ba\u0003A\u0011\u0001\u001b\u0002EQ,7\u000f^*j[BdW\rT1tiJ{wo\u00148Ck&dG/\u001b8Qe>\u001cG/[7fQ\t9v\bC\u0003\\\u0001\u0011\u0005A'\u0001\u000fuKN$8+[7qY\u00164\u0015N]:u%><xJ\u001c)s_\u000e$\u0018.\\3)\u0005i{\u0004\"\u00020\u0001\t\u0003!\u0014a\t;fgR\u001c\u0016.\u001c9mK\u001aK'o\u001d;S_^|eNQ;jYRLg\u000e\u0015:pGRLW.\u001a\u0015\u0003;~\u0002")
public class DeduplicateTest
extends TableTestBase {
    private StreamTableTestUtil util;
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("proctime");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("rowtime");

    public StreamTableTestUtil util() {
        return this.util;
    }

    public void util_$eq(StreamTableTestUtil x$1) {
        this.util = x$1;
    }

    @Before
    public void setUp() {
        this.util_$eq(this.streamTestUtil(this.streamTestUtil$default$1()));
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$5).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
    }

    @Test
    public void testInvalidRowNumberConditionOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT a, ROW_NUMBER() OVER (PARTITION BY b ORDER BY proctime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 2\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testInvalidRowNumberConditionOnRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT a, ROW_NUMBER() OVER (PARTITION BY b ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 3\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testLastRowWithWindowOnRowtime() {
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofMillis(500L));
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T (\n        | `a` INT,\n        | `b` STRING,\n        | `ts` TIMESTAMP(3),\n        | WATERMARK FOR `ts` AS `ts`\n        |) WITH (\n        | 'connector' = 'COLLECTION',\n        | 'is-bounded' = 'false'\n        |)\n      ")).stripMargin());
        String deduplicateSQl = new StringOps(Predef$.MODULE$.augmentString("\n        |(\n        |SELECT a, b, ts\n        |FROM (\n        |  SELECT *,\n        |    ROW_NUMBER() OVER (PARTITION BY a ORDER BY ts DESC) as rowNum\n        |  FROM T\n        |)\n        |WHERE rowNum = 1\n        |)\n      ")).stripMargin();
        String windowSql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |select b, sum(a), TUMBLE_START(ts, INTERVAL '0.004' SECOND)\n         |FROM ", "\n         |GROUP BY b, TUMBLE(ts, INTERVAL '0.004' SECOND)\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deduplicateSQl})))).stripMargin();
        this.util().verifyExplain(windowSql);
    }

    @Test
    public void testSimpleFirstRowOnRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c\n        |FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime ASC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num <= 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMiniBatchInferFirstRowOnRowtime() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, true);
        this.util().tableEnv().getConfig().getConfiguration().setLong(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, 3L);
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE T (\n         |    a INT,\n         |    b VARCHAR,\n         |    rowtime TIMESTAMP(3),\n         |    proctime as PROCTIME(),\n         |    WATERMARK FOR rowtime AS rowtime\n         |) WITH (\n         | 'connector' = 'COLLECTION',\n         | 'is-bounded' = 'false'\n         |)\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(b) FROM (\n        |  SELECT a, b\n        |  FROM (\n        |    SELECT *,\n        |        ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime ASC) as rank_num\n        |    FROM T)\n        |  WHERE rank_num <= 1\n        |)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSimpleLastRowOnRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c\n        |FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMiniBatchInferLastRowOnRowtime() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, true);
        this.util().tableEnv().getConfig().getConfiguration().setLong(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, 3L);
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE T (\n         |    a INT,\n         |    b VARCHAR,\n         |    rowtime TIMESTAMP(3),\n         |    proctime as PROCTIME(),\n         |    WATERMARK FOR rowtime AS rowtime\n         |) WITH (\n         | 'connector' = 'COLLECTION',\n         | 'is-bounded' = 'false'\n         |)\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(b) FROM (\n        |  SELECT a, b\n        |  FROM (\n        |    SELECT *,\n        |        ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |    FROM T)\n        |  WHERE rank_num = 1\n        |)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSimpleLastRowOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY proctime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSimpleLastRowOnBuiltinProctime() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *,\n        |    ROW_NUMBER() OVER (ORDER BY PROCTIME() DESC) as rowNum\n        |  FROM MyTable\n        |)\n        |WHERE rowNum = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSimpleFirstRowOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c\n        |FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY proctime ASC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSimpleFirstRowOnBuiltinProctime() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *,\n        |    ROW_NUMBER() OVER (PARTITION BY a ORDER BY PROCTIME() ASC) as rowNum\n        |  FROM MyTable\n        |)\n        |WHERE rowNum = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }
}

