/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.rules.logical.WindowGroupReorderRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001'\tQr+\u001b8e_^<%o\\;q%\u0016|'\u000fZ3s%VdW\rV3ti*\u00111\u0001B\u0001\bY><\u0017nY1m\u0015\t)a!A\u0003sk2,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/!\tQ!\u001e;jYNL!!\u0007\f\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0004!\u0001\t\u0007I\u0011B\u0011\u0002\tU$\u0018\u000e\\\u000b\u0002EA\u0011QcI\u0005\u0003IY\u0011!CQ1uG\"$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\"1a\u0005\u0001Q\u0001\n\t\nQ!\u001e;jY\u0002BQ\u0001\u000b\u0001\u0005\u0002%\nQa]3ukB$\u0012A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0005+:LG\u000f\u000b\u0002(cA\u0011!'N\u0007\u0002g)\u0011A\u0007E\u0001\u0006UVt\u0017\u000e^\u0005\u0003mM\u0012aAQ3g_J,\u0007\"\u0002\u001d\u0001\t\u0003I\u0013\u0001\f;fgR\u001c\u0016-\\3QCJ$\u0018\u000e^5p].+\u0017p],ji\"\u001c\u0016-\\3Pe\u0012,'oS3zgB\u0013XMZ5yQ\t9$\b\u0005\u00023w%\u0011Ah\r\u0002\u0005)\u0016\u001cH\u000fC\u0003?\u0001\u0011\u0005\u0011&A\u0014uKN$8+Y7f!\u0006\u0014H/\u001b;j_:\\U-_:XSRDG)\u001b4g\u001fJ$WM]&fsN\f\u0004FA\u001f;\u0011\u0015\t\u0005\u0001\"\u0001*\u0003\u001d\"Xm\u001d;TC6,\u0007+\u0019:uSRLwN\\&fsN<\u0016\u000e\u001e5ES\u001a4wJ\u001d3fe.+\u0017p\u001d\u001a)\u0005\u0001S\u0004\"\u0002#\u0001\t\u0003I\u0013\u0001\u000e;fgR\u001c\u0016-\\3QCJ$\u0018\u000e^5p].+\u0017p],ji\"\u001c\u0016-\\3Pe\u0012,'oS3zg\u0012KgM\u001a#je\u0016\u001cG/[8oc!\u00121I\u000f\u0005\u0006\u000f\u0002!\t!K\u00015i\u0016\u001cHoU1nKB\u000b'\u000f^5uS>t7*Z=t/&$\bnU1nK>\u0013H-\u001a:LKf\u001cH)\u001b4g\t&\u0014Xm\u0019;j_:\u0014\u0004F\u0001$;\u0011\u0015Q\u0005\u0001\"\u0001*\u0003Q\"Xm\u001d;TC6,\u0007+\u0019:uSRLwN\\&fsN<\u0016\u000e\u001e5TC6,wJ\u001d3fe.+\u0017p],ji\",U\u000e\u001d;z\u001fJ$WM\u001d\u0015\u0003\u0013jBQ!\u0014\u0001\u0005\u0002%\na\u0005^3ti\u0012KgM\u001a)beRLG/[8o\u0017\u0016L8oV5uQN\u000bW.Z(sI\u0016\u00148*Z=tQ\ta%\bC\u0003Q\u0001\u0011\u0005\u0011&A\u0014uKN$H)\u001b4g!\u0006\u0014H/\u001b;j_:\\U-_:XSRDG)\u001b4g\u001fJ$WM]&fsN\f\u0004FA(;\u0011\u0015\u0019\u0006\u0001\"\u0001*\u0003\u001d\"Xm\u001d;ES\u001a4\u0007+\u0019:uSRLwN\\&fsN<\u0016\u000e\u001e5ES\u001a4wJ\u001d3fe.+\u0017p\u001d\u001a)\u0005IS\u0004\"\u0002,\u0001\t\u0003I\u0013\u0001\b;fgRlU\u000f\u001c;j\u001fZ,'oV5oI><(+\u00198hKRK\b/\u001a\u0015\u0003+j\u0002")
public class WindowGroupReorderRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        this.util().buildBatchProgram(FlinkBatchProgram$.MODULE$.LOGICAL());
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeysPrefix() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a,\n        |    RANK() OVER (PARTITION BY b ORDER BY c, a DESC),\n        |    RANK() OVER (PARTITION BY b ORDER BY c, b)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithDiffOrderKeys1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY c),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY b),\n        |    AVG(a) OVER (PARTITION BY b ORDER BY a),\n        |    RANK() OVER (PARTITION BY b ORDER BY c),\n        |    MIN(a) OVER (PARTITION BY b ORDER BY b)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithDiffOrderKeys2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY c),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY a),\n        |    AVG(a) OVER (PARTITION BY b ORDER BY a, c),\n        |    RANK() OVER (PARTITION BY b ORDER BY a, b),\n        |    MIN(a) OVER (PARTITION BY b ORDER BY b)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeysDiffDirection1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a ASC),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY a ASC),\n        |    AVG(a) OVER (PARTITION BY b ORDER BY a DESC),\n        |    RANK() OVER (PARTITION BY b ORDER BY a ASC),\n        |    MIN(a) OVER (PARTITION BY b ORDER BY a DESC)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeysDiffDirection2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    RANK() OVER (PARTITION BY b ORDER BY a DESC),\n        |    RANK() OVER (PARTITION BY b ORDER BY a ASC)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeysWithEmptyOrder() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a),\n        |    MIN(a) OVER (PARTITION BY b),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY a)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testDiffPartitionKeysWithSameOrderKeys() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY a),\n        |    AVG(a) OVER (PARTITION BY c ORDER BY a),\n        |    RANK() OVER (PARTITION BY b ORDER BY a),\n        |    MIN(a) OVER (PARTITION BY c ORDER BY a)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testDiffPartitionKeysWithDiffOrderKeys1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY c),\n        |    AVG(a) OVER (PARTITION BY c ORDER BY a),\n        |    RANK() OVER (PARTITION BY b ORDER BY a),\n        |    MIN(a) OVER (PARTITION BY c ORDER BY a)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testDiffPartitionKeysWithDiffOrderKeys2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY c),\n        |    MAX(a) OVER (PARTITION BY c ORDER BY a),\n        |    MIN(a) OVER (ORDER BY c, a),\n        |    RANK() OVER (PARTITION BY b ORDER BY c),\n        |    AVG(a) OVER (ORDER BY b)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiOverWindowRangeType() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY a RANGE BETWEEN -1 PRECEDING AND 10 FOLLOWING),\n        |    SUM(a) OVER (PARTITION BY c ORDER BY a),\n        |    RANK() OVER (PARTITION BY c ORDER BY a, c),\n        |    SUM(a) OVER (PARTITION BY c ORDER BY a RANGE BETWEEN 1 PRECEDING AND 10 FOLLOWING),\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY c ROWS BETWEEN 1 PRECEDING AND 10 FOLLOWING)\n        | FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }
}

