/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.logical.SimplifyFilterConditionRule$;
import org.apache.flink.table.planner.plan.rules.logical.SimplifyFilterConditionRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001'\ty2+[7qY&4\u0017PR5mi\u0016\u00148i\u001c8eSRLwN\u001c*vY\u0016$Vm\u001d;\u000b\u0005\r!\u0011a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003\u000b\u0019\tQA];mKNT!a\u0002\u0005\u0002\tAd\u0017M\u001c\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\t\u0003\u0015)H/\u001b7t\u0013\tIbCA\u0007UC\ndW\rV3ti\n\u000b7/\u001a\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAq\u0001\t\u0001C\u0002\u0013%\u0011%\u0001\u0003vi&dW#\u0001\u0012\u0011\u0005U\u0019\u0013B\u0001\u0013\u0017\u0005I\u0011\u0015\r^2i)\u0006\u0014G.\u001a+fgR,F/\u001b7\t\r\u0019\u0002\u0001\u0015!\u0003#\u0003\u0015)H/\u001b7!\u0011\u0015A\u0003\u0001\"\u0001*\u0003\u0015\u0019X\r^;q)\u0005Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#\u0001B+oSRD#aJ\u0019\u0011\u0005I*T\"A\u001a\u000b\u0005Q\u0002\u0012!\u00026v]&$\u0018B\u0001\u001c4\u0005\u0019\u0011UMZ8sK\")\u0001\b\u0001C\u0001S\u0005\u0019B/Z:u'&l\u0007\u000f\\3D_:$\u0017\u000e^5p]\"\u0012qG\u000f\t\u0003emJ!\u0001P\u001a\u0003\tQ+7\u000f\u001e\u0005\u0006}\u0001!\t!K\u0001\"i\u0016\u001cHoU5na2,7i\u001c8eSRLwN\\,ji\"\u001c\u0015m\u001d;U_R\u0013X/\u001a\u0015\u0003{iBQ!\u0011\u0001\u0005\u0002%\n!\u0005^3tiNKW\u000e\u001d7f\u0007>tG-\u001b;j_:<\u0016\u000e\u001e5DCN$Hk\u001c$bYN,\u0007F\u0001!;\u0011\u0015!\u0005\u0001\"\u0001*\u0003\u0001\"Xm\u001d;TS6\u0004H.\u001b4z\u0007>tG-\u001b;j_:LenU;c#V,'/_\u0019)\u0005\rS\u0004\"B$\u0001\t\u0003I\u0013\u0001\t;fgR\u001c\u0016.\u001c9mS\u001aL8i\u001c8eSRLwN\\%o'V\u0014\u0017+^3ssJB#A\u0012\u001e\t\u000b)\u0003A\u0011A\u0015\u0002AQ,7\u000f^*j[Bd\u0017NZ=D_:$\u0017\u000e^5p]&s7+\u001e2Rk\u0016\u0014\u0018p\r\u0015\u0003\u0013jBQ!\u0014\u0001\u0005\u0002%\nQ\u0003^3ti\u000e{W\u000e\u001d7fq\u000e{g\u000eZ5uS>t\u0017\u0007\u000b\u0002Mu!)\u0001\u000b\u0001C\u0001S\u0005)B/Z:u\u0007>l\u0007\u000f\\3y\u0007>tG-\u001b;j_:\u0014\u0004FA(;\u0011\u0015\u0019\u0006\u0001\"\u0001*\u0003U!Xm\u001d;D_6\u0004H.\u001a=D_:$\u0017\u000e^5p]NB#A\u0015\u001e")
public class SimplifyFilterConditionRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("d");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("e");
    private static Symbol symbol$6 = Symbol$.MODULE$.apply("f");
    private static Symbol symbol$7 = Symbol$.MODULE$.apply("i");
    private static Symbol symbol$8 = Symbol$.MODULE$.apply("j");
    private static Symbol symbol$9 = Symbol$.MODULE$.apply("k");

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        programs.addLast("FilterSimplifyExpressions", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{SimplifyFilterConditionRule$.MODULE$.EXTENDED()})).build());
        this.util().replaceBatchProgram((FlinkChainedProgram<BatchOptimizeContext>)programs);
        this.util().addTableSource("x", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$4 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addTableSource("y", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6)}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$5 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addTableSource("z", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$7), package$.MODULE$.symbol2FieldExpression(symbol$8), package$.MODULE$.symbol2FieldExpression(symbol$9)}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$6 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
    }

    @Test
    public void testSimpleCondition() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE (a = 1 AND b = 2) OR (NOT(a <> 1) AND c = 3) AND true");
    }

    @Test
    public void testSimpleConditionWithCastToTrue() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE CAST(200 AS BOOLEAN)");
    }

    @Test
    public void testSimpleConditionWithCastToFalse() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE CAST(0 AS BOOLEAN)");
    }

    @Test
    public void testSimplifyConditionInSubQuery1() {
        String sqlQuery = "SELECT * FROM x WHERE EXISTS (SELECT * FROM y WHERE (d = 1 AND e = 2) OR (NOT (d <> 1) AND e = 3)) AND true";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSimplifyConditionInSubQuery2() {
        String sqlQuery = "SELECT * FROM x WHERE (a = 1 AND b = 2) OR (NOT (a <> 1) AND b = 3) AND true AND EXISTS (SELECT * FROM y WHERE d > 10)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSimplifyConditionInSubQuery3() {
        String sqlQuery = "SELECT * FROM x WHERE EXISTS (SELECT * FROM y WHERE d IN (SELECT i FROM z WHERE (i = 1 AND j = 2) OR (NOT (i <> 1) AND j = 3) AND true) AND e > 10)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testComplexCondition1() {
        String sqlQuery = "SELECT * FROM x WHERE (a = 1 AND b = 2) OR (NOT(a <> 1) AND c = 3) AND true AND EXISTS (SELECT * FROM y WHERE x.a = y.d AND 2=2 AND (SELECT count(*) FROM z WHERE i = 5 AND j = 6) > 0)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testComplexCondition2() {
        String sqlQuery = "SELECT * FROM x WHERE (a = 1 AND b = 2) OR (NOT(a <> 1) AND c = 3) AND true AND EXISTS (SELECT * FROM y WHERE x.a = y.d AND (SELECT count(*) FROM z WHERE (i = 5 AND j = 6) OR (NOT (i <> 5) AND j = 7) AND true) > 0)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testComplexCondition3() {
        String sqlQuery = "SELECT * FROM x WHERE (a = 1 AND b = 2) OR (NOT(a <> 1) AND c = 3) AND true AND EXISTS (SELECT * FROM y WHERE x.a = y.d AND 2=2 AND (SELECT count(*) FROM z WHERE (i = 5 AND j = 6) OR (NOT (i <> 5) AND j = 7) AND true) > 0)";
        this.util().verifyRelPlan(sqlQuery);
    }
}

