/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.sql.Date;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.FlinkBatchRuleSets$;
import org.apache.flink.table.planner.plan.rules.logical.RewriteCoalesceRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple3;
import scala.Tuple8;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001'\t9\"+Z<sSR,7i\\1mKN\u001cWMU;mKR+7\u000f\u001e\u0006\u0003\u0007\u0011\tq\u0001\\8hS\u000e\fGN\u0003\u0002\u0006\r\u0005)!/\u001e7fg*\u0011q\u0001C\u0001\u0005a2\fgN\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0005\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0013\u0001B;uS2,\u0012A\t\t\u0003+\rJ!\u0001\n\f\u0003%\t\u000bGo\u00195UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007M\u0001\u0001\u000b\u0011\u0002\u0012\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000b!\u0002A\u0011A\u0015\u0002\u000bM,G/\u001e9\u0015\u0003)\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012A!\u00168ji\"\u0012q%\r\t\u0003eUj\u0011a\r\u0006\u0003iA\tQA[;oSRL!AN\u001a\u0003\r\t+gm\u001c:f\u0011\u0015A\u0004\u0001\"\u0001*\u0003=!Xm\u001d;DC2\u001c\u0017\u000e^32aEB\u0004FA\u001c;!\t\u00114(\u0003\u0002=g\t!A+Z:u\u0011\u0015q\u0004\u0001\"\u0001*\u0003i!Xm\u001d;D_\u0006dWm]2f\u0007>t7\u000f^1oiJ+G-^2fQ\ti$\bC\u0003B\u0001\u0011\u0005\u0011&\u0001\tuKN$8)\u00197dSR,\u0007H\u000e\u001b`c!\"\u0001IO\"E\u0003!)\u0007\u0010]3di\u0016$7%A#\u0011\u0005\u0019KU\"A$\u000b\u0005!C\u0011aB2pI\u0016<WM\\\u0005\u0003\u0015\u001e\u0013\u0001cQ8eK\u001e+g.\u0012=dKB$\u0018n\u001c8\t\u000b1\u0003A\u0011A\u0015\u0002!Q,7\u000f^\"bY\u000eLG/\u001a\u001d7i}\u001b\u0004\u0006B&;\u0007\u0012CQa\u0014\u0001\u0005\u0002%\nQ\u0004^3ti:\u000bG/\u001e:bY*{\u0017N\\,ji\"\u0004&/\u001a3jG\u0006$Xm\u001d\u0015\u0003\u001djBQA\u0015\u0001\u0005\u0002%\n\u0001\u0004^3ti:\u000bG/\u001e:bY*{\u0017N\u001c'fMR|U\u000f^3sQ\t\t&\bC\u0003V\u0001\u0011\u0005\u0011&A\ruKN$h*\u0019;ve\u0006d'j\\5o%&<\u0007\u000e^(vi\u0016\u0014\bF\u0001+;\u0001")
public class RewriteCoalesceRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("empno");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("ename");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("job");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("mgr");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("hiredate");
    private static Symbol symbol$6 = Symbol$.MODULE$.apply("sal");
    private static Symbol symbol$7 = Symbol$.MODULE$.apply("comm");
    private static Symbol symbol$8 = Symbol$.MODULE$.apply("deptno");
    private static Symbol symbol$9 = Symbol$.MODULE$.apply("dname");
    private static Symbol symbol$10 = Symbol$.MODULE$.apply("loc");

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        programs.addLast("default_rewrite", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(FlinkBatchRuleSets$.MODULE$.DEFAULT_REWRITE_RULES()).build());
        this.util().replaceBatchProgram((FlinkChainedProgram<BatchOptimizeContext>)programs);
        this.util().addTableSource("scott_emp", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), package$.MODULE$.symbol2FieldExpression(symbol$7), package$.MODULE$.symbol2FieldExpression(symbol$8)}), new CaseClassTypeInfo<Tuple8<Object, String, String, Object, Date, Object, Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple8<Object, String, String, Object, Date, Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$3 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple8<Object, String, String, Object, Date, Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple8<Object, String, String, Object, Date, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple8<Object, String, String, Object, Date, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple8((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])), (Object)((Date)fields[4]), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[5])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[6])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[7])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addTableSource("scott_dept", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$8), package$.MODULE$.symbol2FieldExpression(symbol$9), package$.MODULE$.symbol2FieldExpression(symbol$10)}), new CaseClassTypeInfo<Tuple3<Object, String, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$4 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, String>>(this, fieldSerializers){

                    public Tuple3<Object, String, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
    }

    @Test
    public void testCalcite1018() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |select * from (select * from scott_emp) e left join (\n        |    select * from scott_dept d) using (deptno)\n        |    order by empno limit 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCoalesceConstantReduce() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |select * from lateral (select * from scott_emp) as e\n        |    join (table scott_dept) using (deptno)\n        |    where e.deptno = 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test(expected=CodeGenException.class)
    public void testCalcite864_1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |select *\n        |    from scott_emp as e\n        |    join scott_dept as d using (deptno)\n        |    where sal = (\n        |      select max(sal)\n        |      from scott_emp as e2\n        |      join scott_dept as d2 using (deptno)\n        |      where d2.deptno = d.deptno)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test(expected=CodeGenException.class)
    public void testCalcite864_3() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |select *\n        |    from scott_emp as e\n        |    join scott_dept as d using (deptno)\n        |    where d.dname = (\n        |      select max(dname)\n        |      from scott_dept as d2\n        |      where d2.deptno = d.deptno)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNaturalJoinWithPredicates() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |select * from scott_dept natural join scott_emp where empno = 1\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNaturalJoinLeftOuter() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM scott_dept\n        |    natural left join scott_emp\n        |    order by scott_dept.deptno, scott_emp.deptno\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNaturalJoinRightOuter() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM scott_dept\n        |    natural right join scott_emp\n        |    order by scott_dept.deptno, scott_emp.deptno\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }
}

