/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalLegacyTableSourceScan$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalSort$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.logical.PushLimitIntoLegacyTableSourceScanRule$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001'\tQ\u0003+^:i\u0019&l\u0017\u000e^%oi>dUmZ1dsR\u000b'\r\\3T_V\u00148-Z*dC:\u0014V\u000f\\3UKN$(BA\u0002\u0005\u0003\u001dawnZ5dC2T!!\u0002\u0004\u0002\u000bI,H.Z:\u000b\u0005\u001dA\u0011\u0001\u00029mC:T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9\u0002\"A\u0003vi&d7/\u0003\u0002\u001a-\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000f\u0001\u0002!\u0019!C\tC\u0005!Q\u000f^5m+\u0005\u0011\u0003CA\u000b$\u0013\t!cC\u0001\nCCR\u001c\u0007\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0014\u0001A\u0003%!%A\u0003vi&d\u0007\u0005C\u0003)\u0001\u0011\u0005\u0011&A\u0003tKR,\b\u000fF\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0011)f.\u001b;)\u0005\u001d\n\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0011\u0003\u0015QWO\\5u\u0013\t14G\u0001\u0004CK\u001a|'/\u001a\u0005\u0006q\u0001!\t!K\u0001\u001ci\u0016\u001cH\u000fT5nSR<\u0016\u000e\u001e5OK\u001e\fG/\u001b<f\u001f\u001a47/\u001a;)\t]RTH\u0010\t\u0003emJ!\u0001P\u001a\u0003\tQ+7\u000f^\u0001\tKb\u0004Xm\u0019;fI\u000e\nq\b\u0005\u0002A\u00076\t\u0011I\u0003\u0002C\u0015\u0005\u0019\u0011\r]5\n\u0005\u0011\u000b%AE*rYB\u000b'o]3s\u000bb\u001cW\r\u001d;j_:DQA\u0012\u0001\u0005\u0002%\na\u0004^3ti:+w-\u0019;jm\u0016d\u0015.\\5u/&$\bn\\;u\u001f\u001a47/\u001a;)\t\u0015STH\u0010\u0005\u0006\u0013\u0002!\t!K\u0001\u000fi\u0016\u001cH/T=tc2d\u0015.\\5uQ\u0011A%(\u0010 \t\u000b1\u0003A\u0011A\u0015\u0002CQ,7\u000f^\"b]B+8\u000f\u001b3po:d\u0015.\\5u/&$\bn\\;u\u001f\u001a47/\u001a;)\u0005-S\u0004\"B(\u0001\t\u0003I\u0013A\b;fgR\u001c\u0015M\u001c)vg\"$wn\u001e8MS6LGoV5uQ>3gm]3uQ\tq%\bC\u0003S\u0001\u0011\u0005\u0011&\u0001\u0010uKN$8)\u00198QkNDGm\\<o\r\u0016$8\r[,ji\"|eMZ:fi\"\u0012\u0011K\u000f\u0005\u0006+\u0002!\t!K\u0001\"i\u0016\u001cHoQ1o!V\u001c\b\u000eZ8x]\u001a+Go\u00195XSRDw.\u001e;PM\u001a\u001cX\r\u001e\u0015\u0003)jBQ\u0001\u0017\u0001\u0005\u0002%\na\u0004^3ti\u000e\u000bgN\\8u!V\u001c\b\u000eR8x]^KG\u000f[8vi2KW.\u001b;)\u0005]S\u0004\"B.\u0001\t\u0003I\u0013A\b;fgR\u001c\u0015M\u001c8piB+8\u000f\u001b#po:<\u0016\u000e\u001e5pkR4U\r^2iQ\tQ&\bC\u0003_\u0001\u0011\u0005\u0011&A\u000fuKN$8)\u00198o_R\u0004Vo\u001d5E_^tw+\u001b;i\u001fJ$WM\u001d\"zQ\ti&\b")
public class PushLimitIntoLegacyTableSourceScanRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    public BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        this.util().buildBatchProgram(FlinkBatchProgram$.MODULE$.DEFAULT_REWRITE());
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig((TableConfig)this.util().tableEnv().getConfig());
        ((FlinkChainedProgram)calciteConfig.getBatchProgram().get()).addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_COLLECTION()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{PushLimitIntoLegacyTableSourceScanRule$.MODULE$.INSTANCE(), CoreRules.SORT_PROJECT_TRANSPOSE, FlinkLogicalSort$.MODULE$.BATCH_CONVERTER(), FlinkLogicalLegacyTableSourceScan$.MODULE$.CONVERTER()})).build());
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE LimitTable (\n         |  a int,\n         |  b bigint,\n         |  c string\n         |) WITH (\n         |  'connector.type' = 'TestLimitableTableSource',\n         |  'is-bounded' = 'true'\n         |)\n       "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().tableEnv().executeSql(ddl);
    }

    @Test(expected=SqlParserException.class)
    public void testLimitWithNegativeOffset() {
        this.util().verifyRelPlan("SELECT a, c FROM LimitTable LIMIT 10 OFFSET -1");
    }

    @Test(expected=SqlParserException.class)
    public void testNegativeLimitWithoutOffset() {
        this.util().verifyRelPlan("SELECT a, c FROM LimitTable LIMIT -1");
    }

    @Test(expected=SqlParserException.class)
    public void testMysqlLimit() {
        this.util().verifyRelPlan("SELECT a, c FROM LimitTable LIMIT 1, 10");
    }

    @Test
    public void testCanPushdownLimitWithoutOffset() {
        this.util().verifyRelPlan("SELECT a, c FROM LimitTable LIMIT 5");
    }

    @Test
    public void testCanPushdownLimitWithOffset() {
        this.util().verifyRelPlan("SELECT a, c FROM LimitTable LIMIT 10 OFFSET 1");
    }

    @Test
    public void testCanPushdownFetchWithOffset() {
        this.util().verifyRelPlan("SELECT a, c FROM LimitTable OFFSET 10 ROWS FETCH NEXT 10 ROWS ONLY");
    }

    @Test
    public void testCanPushdownFetchWithoutOffset() {
        this.util().verifyRelPlan("SELECT a, c FROM LimitTable FETCH FIRST 10 ROWS ONLY");
    }

    @Test
    public void testCannotPushDownWithoutLimit() {
        this.util().verifyRelPlan("SELECT a, c FROM LimitTable OFFSET 10");
    }

    @Test
    public void testCannotPushDownWithoutFetch() {
        this.util().verifyRelPlan("SELECT a, c FROM LimitTable OFFSET 10 ROWS");
    }

    @Test
    public void testCannotPushDownWithOrderBy() {
        String sqlQuery = "SELECT a, c FROM LimitTable ORDER BY c LIMIT 10";
        this.util().verifyRelPlan(sqlQuery);
    }
}

