/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.rules.logical.DecomposeGroupingSetsRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001'\tiB)Z2p[B|7/Z$s_V\u0004\u0018N\\4TKR\u001c(+\u001e7f)\u0016\u001cHO\u0003\u0002\u0004\t\u00059An\\4jG\u0006d'BA\u0003\u0007\u0003\u0015\u0011X\u000f\\3t\u0015\t9\u0001\"\u0001\u0003qY\u0006t'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003C\u0001\u0006kRLGn]\u0005\u00033Y\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005\n\u0005\nA!\u001e;jYV\t!\u0005\u0005\u0002\u0016G%\u0011AE\u0006\u0002\u0013\u0005\u0006$8\r\u001b+bE2,G+Z:u+RLG\u000e\u0003\u0004'\u0001\u0001\u0006IAI\u0001\u0006kRLG\u000e\t\u0005\u0006Q\u0001!\t!K\u0001\u0011i\u0016\u001cHo\u0012:pkBLgnZ*fiN$\u0012A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0005+:LG\u000f\u000b\u0002(cA\u0011!'N\u0007\u0002g)\u0011A\u0007E\u0001\u0006UVt\u0017\u000e^\u0005\u0003mM\u0012A\u0001V3ti\")\u0001\b\u0001C\u0001S\u0005AA/Z:u\u0007V\u0014W\r\u000b\u00028c!)1\b\u0001C\u0001S\u0005QA/Z:u%>dG.\u001e9)\u0005i\n\u0004\"\u0002 \u0001\t\u0003I\u0013a\b;fgR<%o\\;qS:<7+\u001a;t/&$\bn\u00148f\u000fJ|W\u000f]5oO\"\u0012Q(\r\u0005\u0006\u0003\u0002!\t!K\u0001%i\u0016\u001cHo\u0012:pkBLgnZ*fiN<\u0016\u000e\u001e5EkBd\u0017nY1uK\u001aKW\r\u001c3tc!\u0012\u0001)\r\u0005\u0006\t\u0002!\t!K\u0001%i\u0016\u001cHo\u0012:pkBLgnZ*fiN<\u0016\u000e\u001e5EkBd\u0017nY1uK\u001aKW\r\u001c3te!\u00121)\r\u0005\u0006\u000f\u0002!\t!K\u0001\u0010i\u0016\u001cHoQ!M\u0007&#V)\r\u001d3i!\u0012a)\r\u0005\u0006\u0015\u0002!\t!K\u0001\u001ai\u0016\u001cH\u000fV8p\u001b\u0006t\u0017p\u0012:pkBLgn\u001a$jK2$7\u000f\u000b\u0003Jc1k\u0015\u0001C3ya\u0016\u001cG/\u001a3$\u00039\u0003\"aT,\u000f\u0005A+fBA)U\u001b\u0005\u0011&BA*\u0013\u0003\u0019a$o\\8u}%\tQ&\u0003\u0002WY\u00059\u0001/Y2lC\u001e,\u0017B\u0001-Z\u0005A\u0011VO\u001c;j[\u0016,\u0005pY3qi&|gN\u0003\u0002WY\u0001")
public class DecomposeGroupingSetsRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testGroupingSets() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c, avg(a) AS a, GROUP_ID() AS g FROM MyTable\n        |GROUP BY GROUPING SETS (b, c)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCube() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) AS gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY CUBE (b, c)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRollup() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) AS gic,\n        |    GROUPING_ID(b, c) as gid\n        |FROM MyTable\n        |     GROUP BY ROLLUP (b, c)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testGroupingSetsWithOneGrouping() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b,\n        |    AVG(a) AS a,\n        |    GROUP_ID() as g,\n        |    GROUPING(b) as gb,\n        |    GROUPING_ID(b) as gib\n        |FROM MyTable\n        |    GROUP BY GROUPING SETS (b)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testGroupingSetsWithDuplicateFields1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT count(b) as b, count(c) as c FROM MyTable GROUP BY GROUPING SETS (b, c)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testGroupingSetsWithDuplicateFields2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT count(a) as a, count(b) as b, count(c) as c FROM MyTable\n        |GROUP BY GROUPING SETS ((a, b), (a, c))\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCALCITE1824() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, GROUP_ID() AS g, COUNT(*) as c FROM MyTable GROUP BY GROUPING SETS (a, (), ())\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test(expected=RuntimeException.class)
    public void testTooManyGroupingFields() {
        String[] fieldNames = (String[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 64).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int i) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        TypeInformation[] fieldTypes = (TypeInformation[])Array$.MODULE$.fill(fieldNames.length, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TypeInformation<Integer> apply() {
                return Types.INT();
            }
        }, ClassTag$.MODULE$.apply(TypeInformation.class));
        this.util().addTableSource("MyTable64", fieldTypes, fieldNames);
        String fields = Predef$.MODULE$.refArrayOps((Object[])fieldNames).mkString(",");
        String sqlQuery = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT ", " FROM MyTable64 GROUP BY GROUPING SETS (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fields, fields}));
        this.util().verifyRelPlan(sqlQuery);
    }

    public DecomposeGroupingSetsRuleTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().buildBatchProgram(FlinkBatchProgram$.MODULE$.PHYSICAL());
    }
}

