/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.logical.ConvertToNotInOrInRule$;
import org.apache.flink.table.planner.plan.rules.logical.ConvertToNotInOrInRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u0001M\u0011!dQ8om\u0016\u0014H\u000fV8O_RLen\u0014:J]J+H.\u001a+fgRT!a\u0001\u0003\u0002\u000f1|w-[2bY*\u0011QAB\u0001\u0006eVdWm\u001d\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\tYA\"A\u0003uC\ndWM\u0003\u0002\u000e\u001d\u0005)a\r\\5oW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0005]A\u0011!B;uS2\u001c\u0018BA\r\u0017\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0003\u0011)H/\u001b7\u0016\u0003\t\u0002\"!F\u0012\n\u0005\u00112\"A\u0005\"bi\u000eDG+\u00192mKR+7\u000f^+uS2DaA\n\u0001!\u0002\u0013\u0011\u0013!B;uS2\u0004\u0003\"\u0002\u0015\u0001\t\u0003I\u0013!B:fiV\u0004H#\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0003OE\u0002\"AM\u001b\u000e\u0003MR!\u0001\u000e\t\u0002\u000b),h.\u001b;\n\u0005Y\u001a$A\u0002\"fM>\u0014X\rC\u00039\u0001\u0011\u0005\u0011&A\u0013uKN$8i\u001c8wKJ$Hk\\%o?2+7o\u001d+iC:$\u0006N]3tQ>dGmX%oi\"\u0012qG\u000f\t\u0003emJ!\u0001P\u001a\u0003\tQ+7\u000f\u001e\u0005\u0006}\u0001!\t!K\u0001&i\u0016\u001cHoQ8om\u0016\u0014H\u000fV8J]~+\u0015/^1mgR{G\u000b\u001b:fg\"|G\u000eZ0J]RD#!\u0010\u001e\t\u000b\u0005\u0003A\u0011A\u0015\u0002QQ,7\u000f^\"p]Z,'\u000f\u001e+p\u0013:|vI]3bi\u0016\u0014H\u000b[1o)\"\u0014Xm\u001d5pY\u0012|\u0016J\u001c;)\u0005\u0001S\u0004\"\u0002#\u0001\t\u0003I\u0013\u0001\u000b;fgR\u001cuN\u001c<feR$v.\u00138`\u0019\u0016\u001c8\u000f\u00165b]RC'/Z:i_2$w\fR8vE2,\u0007FA\";\u0011\u00159\u0005\u0001\"\u0001*\u0003-\"Xm\u001d;D_:4XM\u001d;U_&swl\u0012:fCR,'\u000f\u00165b]RC'/Z:i_2$w\fR8vE2,\u0007F\u0001$;\u0011\u0015Q\u0005\u0001\"\u0001*\u0003]!Xm\u001d;D_:4XM\u001d;U_&swlV5uQ>\u0013\u0018\u0007\u000b\u0002Ju!)Q\n\u0001C\u0001S\u00059B/Z:u\u0007>tg/\u001a:u)>LenX,ji\"|%O\r\u0015\u0003\u0019jBQ\u0001\u0015\u0001\u0005\u0002%\n\u0001\u0004^3ti\u000e{gN^3siR{\u0017J\\0XSRD\u0017I\u001c32Q\ty%\bC\u0003T\u0001\u0011\u0005\u0011&\u0001\ruKN$8i\u001c8wKJ$Hk\\%o?^KG\u000f[!oIJB#A\u0015\u001e\t\u000bY\u0003A\u0011A\u0015\u0002QQ,7\u000f^\"p]Z,'\u000f\u001e+p\u001d>$\u0018J\\0MKN\u001cH\u000b[1o)\"\u0014Xm\u001d5pY\u0012|\u0016J\u001c;)\u0005US\u0004\"B-\u0001\t\u0003I\u0013\u0001\u000b;fgR\u001cuN\u001c<feR$vNT8u\u0013:|V)];bYN$v\u000e\u00165sKNDw\u000e\u001c3`\u0013:$\bF\u0001-;\u0011\u0015a\u0006\u0001\"\u0001*\u0003-\"Xm\u001d;D_:4XM\u001d;U_:{G/\u00138`\u000fJ,\u0017\r^3s)\"\fg\u000e\u00165sKNDw\u000e\u001c3`\u0013:$\bFA.;\u0011\u0015y\u0006\u0001\"\u0001*\u0003-\"Xm\u001d;D_:4XM\u001d;U_:{G/\u00138`\u0019\u0016\u001c8\u000f\u00165b]RC'/Z:i_2$w\fR8vE2,\u0007F\u00010;\u0011\u0015\u0011\u0007\u0001\"\u0001*\u00039\"Xm\u001d;D_:4XM\u001d;U_:{G/\u00138`\u000fJ,\u0017\r^3s)\"\fg\u000e\u00165sKNDw\u000e\u001c3`\t>,(\r\\3)\u0005\u0005T\u0004\"B3\u0001\t\u0003I\u0013A\u0007;fgR\u001cuN\u001c<feR$vNT8u\u0013:|v+\u001b;i\u001fJ\f\u0004F\u00013;\u0011\u0015A\u0007\u0001\"\u0001*\u0003i!Xm\u001d;D_:4XM\u001d;U_:{G/\u00138`/&$\bn\u0014:3Q\t9'\bC\u0003l\u0001\u0011\u0005\u0011&\u0001\u000euKN$8i\u001c8wKJ$Hk\u001c(pi&swlV5uQ>\u00138\u0007\u000b\u0002ku!)a\u000e\u0001C\u0001S\u0005YB/Z:u\u0007>tg/\u001a:u)>tu\u000e^%o?^KG\u000f[!oIFB#!\u001c\u001e\t\u000bE\u0004A\u0011A\u0015\u00027Q,7\u000f^\"p]Z,'\u000f\u001e+p\u001d>$\u0018J\\0XSRD\u0017I\u001c33Q\t\u0001(\bC\u0003u\u0001\u0011\u0005\u0011&\u0001\ruKN$8i\u001c8wKJ$Hk\\%o\u0003:$gj\u001c;J]FB#a\u001d\u001e\t\u000b]\u0004A\u0011A\u0015\u00021Q,7\u000f^\"p]Z,'\u000f\u001e+p\u0013:\fe\u000e\u001a(pi&s'\u0007\u000b\u0002wu!)!\u0010\u0001C\u0001S\u0005AB/Z:u\u0007>tg/\u001a:u)>Le.\u00118e\u001d>$\u0018J\\\u001a)\u0005eT\u0004\"B?\u0001\t\u0003I\u0013!\u0007;fgR\u001cuN\u001c<feR$vnU3be\u000eD7\u000b\u001e:j]\u001eD#\u0001 \u001e\t\r\u0005\u0005\u0001\u0001\"\u0001*\u0003\u0005\"Xm\u001d;D_:4XM\u001d;U_N+\u0017M]2i'R\u0014\u0018N\\4XSRDg*\u001e7mQ\ty(\b\u0003\u0004\u0002\b\u0001!\t!K\u0001!i\u0016\u001cHoQ8om\u0016\u0014H\u000fV8TK\u0006\u00148\r[,ji\"l\u0015\u000e_3e)f\u0004X\rK\u0002\u0002\u0006i\u0002")
public class ConvertToNotInOrInRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("d");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("e");

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        programs.addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{ConvertToNotInOrInRule$.MODULE$.INSTANCE()})).build());
        this.util().replaceBatchProgram((FlinkChainedProgram<BatchOptimizeContext>)programs);
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5)}), new CaseClassTypeInfo<Tuple5<Object, Object, Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, Object, Object, String>>(this, fieldSerializers){

                    public Tuple5<Object, Object, Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[2])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[3])), (Object)((String)fields[4]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
    }

    @Test
    public void testConvertToIn_LessThanThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3");
    }

    @Test
    public void testConvertToIn_EqualsToThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3 OR a = 4");
    }

    @Test
    public void testConvertToIn_GreaterThanThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3 OR a = 4 OR a = 5");
    }

    @Test
    public void testConvertToIn_LessThanThreshold_Double() {
        String where = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 20).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int i) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString(" OR ");
        this.util().verifyRelPlan(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM MyTable WHERE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{where})));
    }

    @Test
    public void testConvertToIn_GreaterThanThreshold_Double() {
        String where = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 21).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int i) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString(" OR ");
        this.util().verifyRelPlan(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM MyTable WHERE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{where})));
    }

    @Test
    public void testConvertToIn_WithOr1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3 OR a = 4 OR b = 1");
    }

    @Test
    public void testConvertToIn_WithOr2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR b = 1 OR a = 3 OR a = 4");
    }

    @Test
    public void testConvertToIn_WithAnd1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE (a = 1 OR a = 2 OR a = 3 OR a = 4) AND b = 1");
    }

    @Test
    public void testConvertToIn_WithAnd2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3 OR a = 4 AND b = 1");
    }

    @Test
    public void testConvertToNotIn_LessThanThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 AND a <> 2 AND a <> 3");
    }

    @Test
    public void testConvertToNotIn_EqualsToThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 AND a <> 2 AND a <> 3 AND a <> 4");
    }

    @Test
    public void testConvertToNotIn_GreaterThanThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 AND a <> 2 AND a <> 3 AND a <> 4 AND a = 5");
    }

    @Test
    public void testConvertToNotIn_LessThanThreshold_Double() {
        String where = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 20).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int i) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d <> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString(" AND ");
        this.util().verifyRelPlan(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM MyTable WHERE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{where})));
    }

    @Test
    public void testConvertToNotIn_GreaterThanThreshold_Double() {
        String where = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 21).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int i) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d <> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString(" AND ");
        this.util().verifyRelPlan(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM MyTable WHERE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{where})));
    }

    @Test
    public void testConvertToNotIn_WithOr1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE (a <> 1 AND a <> 2 AND a <> 3 AND a <> 4) OR b = 1");
    }

    @Test
    public void testConvertToNotIn_WithOr2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 AND a <> 2 AND a <> 3 AND a <> 4 OR b = 1");
    }

    @Test
    public void testConvertToNotIn_WithOr3() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 OR a <> 2 OR a <> 3 OR a <> 4 OR b = 1");
    }

    @Test
    public void testConvertToNotIn_WithAnd1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 AND a <> 2 AND a <> 3 AND a <> 4 AND b = 1");
    }

    @Test
    public void testConvertToNotIn_WithAnd2() {
        String sqlQuery = "SELECT * FROM MyTable WHERE a <> 1 AND a <> 2  AND b = 1 AND a <> 3 AND a <> 4";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testConvertToInAndNotIn1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3 OR a = 4 OR b = 1 OR (a <> 1 AND a <> 2 AND a <> 3 AND a <> 4)");
    }

    @Test
    public void testConvertToInAndNotIn2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE b = 1 OR a = 1 OR a = 2 OR a = 3 OR a = 4  AND (a <> 1 AND a <> 2 AND a <> 3 AND a <> 4)");
    }

    @Test
    public void testConvertToInAndNotIn3() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE b = 1 OR b = 2 OR (a <> 1 AND a <> 2 AND a <> 3 AND a <> 4 AND c = 1) OR b = 3 OR b = 4 OR c = 1");
    }

    @Test
    public void testConvertToSearchString() {
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * from MyTable where e in (\n        |'CTNBSmokeSensor',\n        |'H388N',\n        |'H389N     ',\n        |'GHL-IRD',\n        |'JY-BF-20YN',\n        |'HC809',\n        |'DH-9908N-AEP',\n        |'DH-9908N'\n        |)\n        |")).stripMargin());
    }

    @Test
    public void testConvertToSearchStringWithNull() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE e = 'a' or e = 'b' or e = 'c' or e = 'd' or e = 'e' or e = 'f' or e = NULL or e = 'HELLO WORLD!'");
    }

    @Test
    public void testConvertToSearchWithMixedType() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a is null or a = 1 OR a = 2 OR a = 3.0 OR a = 4.0 OR a = 5 OR a = 7 OR a = CAST(8 AS BIGINT)");
    }
}

