/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;

public class TemporalSortJsonPlanTest
extends TableTestBase {
    private StreamTableTestUtil util;

    @Before
    public void setup() {
        this.util = this.streamTestUtil(TableConfig.getDefault());
        TableEnvironment tEnv = this.util.getTableEnv();
        String srcTableDdl = "CREATE TABLE MyTable (\n a INT,\n b BIGINT,\n c VARCHAR,\n `rowtime` AS TO_TIMESTAMP(c),\n proctime as PROCTIME(),\n WATERMARK for `rowtime` AS `rowtime` - INTERVAL '1' SECOND\n) WITH (\n 'connector' = 'values')\n";
        tEnv.executeSql(srcTableDdl);
        String sinkTableDdl = "CREATE TABLE MySink (\n a INT\n) WITH (\n 'connector' = 'values')\n";
        tEnv.executeSql(sinkTableDdl);
    }

    @Test
    public void testSortProcessingTime() {
        this.util.verifyJsonPlan("insert into MySink SELECT a FROM MyTable order by proctime, c");
    }

    @Test
    public void testSortRowTime() {
        this.util.verifyJsonPlan("insert into MySink SELECT a FROM MyTable order by rowtime, c");
    }
}

