/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;

public class SortLimitJsonPlanTest
extends TableTestBase {
    private StreamTableTestUtil util;
    private TableEnvironment tEnv;

    @Before
    public void setup() {
        this.util = this.streamTestUtil(TableConfig.getDefault());
        this.tEnv = this.util.getTableEnv();
        String srcTableDdl = "CREATE TABLE MyTable (\n  a bigint,\n  b int not null,\n  c varchar,\n  d timestamp(3)\n) with (\n  'connector' = 'values',\n  'bounded' = 'false')";
        this.tEnv.executeSql(srcTableDdl);
    }

    @Test
    public void testSortLimit() {
        String sinkTableDdl = "CREATE TABLE MySink (\n  a bigint,\n  b bigint\n) with (\n  'connector' = 'values',\n  'sink-insert-only' = 'false',\n  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
        String sql = "insert into MySink SELECT a, a from MyTable order by b limit 10";
        this.util.verifyJsonPlan(sql);
    }
}

