/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkContextImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpec;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RelDataTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RelDataTypeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.plan.nodes.exec.spec.TemporalTableSourceSpec;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.junit.Assert;
import org.junit.Test;

public class TemporalTableSourceSpecSerdeTest {
    private static final FlinkTypeFactory FACTORY = FlinkTypeFactory.INSTANCE();

    @Test
    public void testTemporalTableSourceSpecSerde() throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        SerdeContext serdeCtx = new SerdeContext((FlinkContext)new FlinkContextImpl(false, TableConfig.getDefault(), null, CatalogManagerMocks.createEmptyCatalogManager(), null), classLoader, FlinkTypeFactory.INSTANCE(), (SqlOperatorTable)FlinkSqlOperatorTable.instance());
        ObjectMapper mapper = JsonSerdeUtil.createObjectMapper((SerdeContext)serdeCtx);
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new RexNodeJsonSerializer());
        module.addSerializer((JsonSerializer)new RelDataTypeJsonSerializer());
        module.addDeserializer(RexNode.class, (JsonDeserializer)new RexNodeJsonDeserializer());
        module.addDeserializer(RelDataType.class, (JsonDeserializer)new RelDataTypeJsonDeserializer());
        mapper.registerModule((Module)module);
        StringWriter writer = new StringWriter(100);
        List<TemporalTableSourceSpec> specs = TemporalTableSourceSpecSerdeTest.testData();
        for (TemporalTableSourceSpec spec : specs) {
            try (JsonGenerator gen = mapper.getFactory().createGenerator((Writer)writer);){
                gen.writeObject((Object)spec);
            }
            String json = writer.toString();
            TemporalTableSourceSpec actual = (TemporalTableSourceSpec)mapper.readValue(json, TemporalTableSourceSpec.class);
            Assert.assertEquals((Object)spec.getTableSourceSpec(), (Object)actual.getTableSourceSpec());
            Assert.assertEquals((Object)spec.getOutputType(), (Object)actual.getOutputType());
        }
    }

    public static List<TemporalTableSourceSpec> testData() {
        HashMap<String, String> properties1 = new HashMap<String, String>();
        properties1.put("connector", "filesystem");
        properties1.put("format", "testcsv");
        properties1.put("path", "/tmp");
        properties1.put("schema.0.name", "a");
        properties1.put("schema.0.data-type", "BIGINT");
        CatalogTable catalogTable1 = CatalogTable.fromProperties(properties1);
        ResolvedSchema resolvedSchema1 = new ResolvedSchema(Collections.singletonList(Column.physical((String)"a", (DataType)DataTypes.BIGINT())), Collections.emptyList(), null);
        ResolvedCatalogTable resolvedCatalogTable = new ResolvedCatalogTable(catalogTable1, resolvedSchema1);
        RelDataType relDataType1 = FACTORY.createSqlType(SqlTypeName.BIGINT);
        TestValuesTableFactory.MockedLookupTableSource lookupTableSource = new TestValuesTableFactory.MockedLookupTableSource();
        TableSourceTable tableSourceTable1 = new TableSourceTable(null, ObjectIdentifier.of((String)"default_catalog", (String)"default_db", (String)"MyTable"), relDataType1, FlinkStatistic.UNKNOWN(), (DynamicTableSource)lookupTableSource, true, resolvedCatalogTable, new String[0], new SourceAbilitySpec[0]);
        TemporalTableSourceSpec temporalTableSourceSpec1 = new TemporalTableSourceSpec((RelOptTable)tableSourceTable1, new TableConfig());
        return Arrays.asList(temporalTableSourceSpec1);
    }
}

