/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkContextImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.expressions.PlannerWindowReference;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.logical.SessionGroupWindow;
import org.apache.flink.table.planner.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.planner.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.planner.plan.nodes.exec.serde.DurationJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.DurationJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalWindowJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalWindowJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LogicalWindowSerdeTest {
    @Parameterized.Parameter
    public LogicalWindow window;

    @Parameterized.Parameters(name="{0}")
    public static List<LogicalWindow> testData() {
        return Arrays.asList(new TumblingGroupWindow(new PlannerWindowReference("timeWindow", (LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), new FieldReferenceExpression("rowTime", (DataType)new AtomicDataType((LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), 1, 2), new ValueLiteralExpression((Object)Duration.ofMinutes(10L))), new TumblingGroupWindow(new PlannerWindowReference("countWindow", (LogicalType)new BigIntType()), new FieldReferenceExpression("rowTime", (DataType)new AtomicDataType((LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), 1, 2), new ValueLiteralExpression((Object)10L)), new SlidingGroupWindow(new PlannerWindowReference("timeWindow", (LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), new FieldReferenceExpression("rowTime", (DataType)new AtomicDataType((LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), 1, 2), new ValueLiteralExpression((Object)Duration.ofSeconds(10L)), new ValueLiteralExpression((Object)Duration.ofSeconds(5L))), new SlidingGroupWindow(new PlannerWindowReference("countWindow", (LogicalType)new BigIntType()), new FieldReferenceExpression("rowTime", (DataType)new AtomicDataType((LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), 1, 2), new ValueLiteralExpression((Object)10L), new ValueLiteralExpression((Object)5L)), new SessionGroupWindow(new PlannerWindowReference("timeWindow", (LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), new FieldReferenceExpression("rowTime", (DataType)new AtomicDataType((LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), 1, 2), new ValueLiteralExpression((Object)Duration.ofDays(10L))));
    }

    @Test
    public void testLogicalWindowSerde() throws JsonProcessingException {
        SerdeContext serdeCtx = new SerdeContext((FlinkContext)new FlinkContextImpl(false, TableConfig.getDefault(), null, null, null), Thread.currentThread().getContextClassLoader(), FlinkTypeFactory.INSTANCE(), (SqlOperatorTable)FlinkSqlOperatorTable.instance());
        ObjectMapper mapper = JsonSerdeUtil.createObjectMapper((SerdeContext)serdeCtx);
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new DurationJsonSerializer());
        module.addDeserializer(Duration.class, (JsonDeserializer)new DurationJsonDeserializer());
        module.addSerializer((JsonSerializer)new RexNodeJsonSerializer());
        module.addDeserializer(RexNode.class, (JsonDeserializer)new RexNodeJsonDeserializer());
        module.addSerializer((JsonSerializer)new LogicalTypeJsonSerializer());
        module.addDeserializer(LogicalType.class, (JsonDeserializer)new LogicalTypeJsonDeserializer());
        module.addSerializer((JsonSerializer)new LogicalWindowJsonSerializer());
        module.addDeserializer(LogicalWindow.class, (JsonDeserializer)new LogicalWindowJsonDeserializer());
        mapper.registerModule((Module)module);
        Assert.assertEquals((Object)mapper.readValue(mapper.writeValueAsString((Object)this.window), LogicalWindow.class), (Object)this.window);
    }
}

