/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class InputPropertySerdeTest {
    @Parameterized.Parameter
    public InputProperty inputProperty;

    @Test
    public void testExecEdgeSerde() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        StringWriter writer = new StringWriter(100);
        try (JsonGenerator gen = mapper.getFactory().createGenerator((Writer)writer);){
            gen.writeObject((Object)this.inputProperty);
        }
        String json = writer.toString();
        InputProperty actual = (InputProperty)mapper.readValue(json, InputProperty.class);
        Assert.assertEquals((Object)this.inputProperty, (Object)actual);
    }

    @Parameterized.Parameters(name="{0}")
    public static List<InputProperty> testData() {
        return Arrays.asList(InputProperty.DEFAULT, InputProperty.builder().requiredDistribution((InputProperty.RequiredDistribution)InputProperty.hashDistribution((int[])new int[]{0, 1})).damBehavior(InputProperty.DamBehavior.BLOCKING).priority(0).build(), InputProperty.builder().requiredDistribution(InputProperty.BROADCAST_DISTRIBUTION).damBehavior(InputProperty.DamBehavior.END_INPUT).priority(0).build(), InputProperty.builder().requiredDistribution(InputProperty.SINGLETON_DISTRIBUTION).damBehavior(InputProperty.DamBehavior.END_INPUT).priority(1).build(), InputProperty.builder().requiredDistribution(InputProperty.ANY_DISTRIBUTION).damBehavior(InputProperty.DamBehavior.PIPELINED).priority(2).build(), InputProperty.builder().requiredDistribution(InputProperty.UNKNOWN_DISTRIBUTION).damBehavior(InputProperty.DamBehavior.PIPELINED).priority(0).build());
    }
}

