/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec;

import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.transformations.LegacySourceTransformation;
import org.apache.flink.streaming.api.transformations.WithBoundedness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.planner.connectors.TransformationScanProvider;
import org.apache.flink.table.planner.utils.JavaBatchTableTestUtil;
import org.apache.flink.table.planner.utils.JavaStreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.junit.Assert;
import org.junit.Test;

public class TransformationsTest
extends TableTestBase {
    @Test
    public void testLegacyBatchSource() {
        JavaBatchTableTestUtil util = this.javaBatchTestUtil();
        StreamTableEnvironment env = util.tableEnv();
        Table table = env.from(TableDescriptor.forConnector((String)"values").option("bounded", "true").schema(TransformationsTest.dummySchema()).build());
        LegacySourceTransformation<?> sourceTransform = TransformationsTest.toLegacySourceTransformation(env, table);
        TransformationsTest.assertBoundedness(Boundedness.BOUNDED, sourceTransform);
        Assert.assertFalse((boolean)sourceTransform.getOperator().emitsProgressiveWatermarks());
    }

    @Test
    public void testLegacyStreamSource() {
        JavaStreamTableTestUtil util = this.javaStreamTestUtil();
        StreamTableEnvironment env = util.tableEnv();
        Table table = env.from(TableDescriptor.forConnector((String)"values").option("bounded", "false").schema(TransformationsTest.dummySchema()).build());
        LegacySourceTransformation<?> sourceTransform = TransformationsTest.toLegacySourceTransformation(env, table);
        TransformationsTest.assertBoundedness(Boundedness.CONTINUOUS_UNBOUNDED, sourceTransform);
        Assert.assertTrue((boolean)sourceTransform.getOperator().emitsProgressiveWatermarks());
    }

    @Test
    public void testStreamTransformationScanProvider() {
        JavaStreamTableTestUtil util = this.javaStreamTestUtil();
        StreamTableEnvironment env = util.tableEnv();
        Table table = env.from(TableDescriptor.forConnector((String)"values").option("bounded", "false").schema(TransformationsTest.dummySchema()).build());
        Transformation transformation = env.toChangelogStream(table).map((MapFunction & Serializable)r -> new GenericRowData(0)).getTransformation();
        Assert.assertFalse((boolean)TransformationScanProvider.of((Transformation)transformation).isBounded());
    }

    @Test
    public void testBatchTransformationScanProvider() {
        JavaBatchTableTestUtil util = this.javaBatchTestUtil();
        StreamTableEnvironment env = util.tableEnv();
        Table table = env.from(TableDescriptor.forConnector((String)"values").option("bounded", "true").schema(TransformationsTest.dummySchema()).build());
        Transformation transformation = env.toChangelogStream(table).map((MapFunction & Serializable)r -> new GenericRowData(0)).getTransformation();
        Assert.assertTrue((boolean)TransformationScanProvider.of((Transformation)transformation).isBounded());
    }

    @Test
    public void testLegacyBatchValues() {
        JavaBatchTableTestUtil util = this.javaBatchTestUtil();
        StreamTableEnvironment env = util.tableEnv();
        Table table = env.fromValues(new Object[]{1, 2, 3});
        LegacySourceTransformation<?> sourceTransform = TransformationsTest.toLegacySourceTransformation(env, table);
        TransformationsTest.assertBoundedness(Boundedness.BOUNDED, sourceTransform);
    }

    private static LegacySourceTransformation<?> toLegacySourceTransformation(StreamTableEnvironment env, Table table) {
        Transformation transform = env.toChangelogStream(table).getTransformation();
        while (transform.getInputs().size() == 1) {
            transform = (Transformation)transform.getInputs().get(0);
        }
        Assert.assertTrue((boolean)(transform instanceof LegacySourceTransformation));
        return (LegacySourceTransformation)transform;
    }

    private static void assertBoundedness(Boundedness boundedness, Transformation<?> transform) {
        Assert.assertTrue((boolean)(transform instanceof WithBoundedness));
        Assert.assertEquals((Object)boundedness, (Object)((WithBoundedness)transform).getBoundedness());
    }

    private static Schema dummySchema() {
        return Schema.newBuilder().column("i", (AbstractDataType)DataTypes.INT()).build();
    }
}

