/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkRexBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.plan.metadata.AggCallSelectivityEstimator;
import org.apache.flink.table.planner.plan.metadata.AggCallSelectivityEstimatorTest$;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.metadata.MockMetaTable;
import org.apache.flink.table.planner.plan.metadata.SelectivityEstimator;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef$;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\rd\u0001B\u0001\u0003\u0001E\u0011q$Q4h\u0007\u0006dGnU3mK\u000e$\u0018N^5us\u0016\u001bH/[7bi>\u0014H+Z:u\u0015\t\u0019A!\u0001\u0005nKR\fG-\u0019;b\u0015\t)a!\u0001\u0003qY\u0006t'BA\u0004\t\u0003\u001d\u0001H.\u00198oKJT!!\u0003\u0006\u0002\u000bQ\f'\r\\3\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001aDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000fy\u0001!\u0019!C\u0005?\u0005i\u0011\r\u001c7GS\u0016dGMT1nKN,\u0012\u0001\t\t\u0004C\u00112S\"\u0001\u0012\u000b\u0005\r\"\u0012AC2pY2,7\r^5p]&\u0011QE\t\u0002\u0004'\u0016\f\bCA\u0014-\u001b\u0005A#BA\u0015+\u0003\u0011a\u0017M\\4\u000b\u0003-\nAA[1wC&\u0011Q\u0006\u000b\u0002\u0007'R\u0014\u0018N\\4\t\r=\u0002\u0001\u0015!\u0003!\u00039\tG\u000e\u001c$jK2$g*Y7fg\u0002Bq!\r\u0001C\u0002\u0013%!'A\u0007bY24\u0015.\u001a7e)f\u0004Xm]\u000b\u0002gA\u0019\u0011\u0005\n\u001b\u0011\u0005UbT\"\u0001\u001c\u000b\u0005]B\u0014\u0001\u0002;za\u0016T!!\u000f\u001e\u0002\u0007M\fHN\u0003\u0002<\u0019\u000591-\u00197dSR,\u0017BA\u001f7\u0005-\u0019\u0016\u000f\u001c+za\u0016t\u0015-\\3\t\r}\u0002\u0001\u0015!\u00034\u00039\tG\u000e\u001c$jK2$G+\u001f9fg\u0002B!\"\u0011\u0001\u0011\u0002\u0003\r\t\u0015!\u0003C\u0003\rAH%\r\t\u0006'\r+U)R\u0005\u0003\tR\u0011a\u0001V;qY\u0016\u001c\u0004CA\nG\u0013\t9ECA\u0002J]RDq!\u0013\u0001C\u0002\u0013\u0005!*\u0001\u0005oC6,w,\u001b3y+\u0005)\u0005B\u0002'\u0001A\u0003%Q)A\u0005oC6,w,\u001b3yA!9a\n\u0001b\u0001\n\u0003Q\u0015AC1n_VtGoX5eq\"1\u0001\u000b\u0001Q\u0001\n\u0015\u000b1\"Y7pk:$x,\u001b3yA!9!\u000b\u0001b\u0001\n\u0003Q\u0015!\u00039sS\u000e,w,\u001b3y\u0011\u0019!\u0006\u0001)A\u0005\u000b\u0006Q\u0001O]5dK~KG\r\u001f\u0011\t\u000fY\u0003!\u0019!C\u0001/\u0006YA/\u001f9f\r\u0006\u001cGo\u001c:z+\u0005A\u0006CA-\\\u001b\u0005Q&BA\u001e\u0007\u0013\ta&L\u0001\tGY&t7\u000eV=qK\u001a\u000b7\r^8ss\"1a\f\u0001Q\u0001\na\u000bA\u0002^=qK\u001a\u000b7\r^8ss\u0002Bq\u0001\u0019\u0001A\u0002\u0013\u0005\u0011-\u0001\u0006sKb\u0014U/\u001b7eKJ,\u0012A\u0019\t\u00033\u000eL!\u0001\u001a.\u0003\u001f\u0019c\u0017N\\6SKb\u0014U/\u001b7eKJDqA\u001a\u0001A\u0002\u0013\u0005q-\u0001\bsKb\u0014U/\u001b7eKJ|F%Z9\u0015\u0005!\\\u0007CA\nj\u0013\tQGC\u0001\u0003V]&$\bbB!f\u0003\u0003\u0005\rA\u0019\u0005\u0007[\u0002\u0001\u000b\u0015\u00022\u0002\u0017I,\u0007PQ;jY\u0012,'\u000f\t\u0005\b_\u0002\u0011\r\u0011\"\u0001q\u0003-\u0011X\r\u001c#bi\u0006$\u0016\u0010]3\u0016\u0003E\u0004\"A\u001d<\u000e\u0003MT!a\u000e;\u000b\u0005UT\u0014a\u0001:fY&\u0011qo\u001d\u0002\f%\u0016dG)\u0019;b)f\u0004X\r\u0003\u0004z\u0001\u0001\u0006I!]\u0001\re\u0016dG)\u0019;b)f\u0004X\r\t\u0005\bw\u0002\u0011\r\u0011\"\u0001}\u0003\ti\u0017/F\u0001~!\tab0\u0003\u0002\u0000\u0005\t)b\t\\5oWJ+G.T3uC\u0012\fG/Y)vKJL\bbBA\u0002\u0001\u0001\u0006I!`\u0001\u0004[F\u0004\u0003bCA\u0004\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0013\tAa]2b]V\u0011\u00111\u0002\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u0003;\u0002\t\r|'/Z\u0005\u0005\u0003+\tyAA\u0005UC\ndWmU2b]\"Y\u0011\u0011\u0004\u0001A\u0002\u0003\u0007I\u0011AA\u000e\u0003!\u00198-\u00198`I\u0015\fHc\u00015\u0002\u001e!I\u0011)a\u0006\u0002\u0002\u0003\u0007\u00111\u0002\u0005\t\u0003C\u0001\u0001\u0015)\u0003\u0002\f\u0005)1oY1oA!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0012!B:fiV\u0004H#\u00015)\t\u0005\r\u00121\u0006\t\u0005\u0003[\t\u0019$\u0004\u0002\u00020)\u0019\u0011\u0011\u0007\b\u0002\u000b),h.\u001b;\n\t\u0005U\u0012q\u0006\u0002\u0007\u0005\u00164wN]3\t\u000f\u0005e\u0002\u0001\"\u0003\u0002<\u0005AQn\\2l'\u000e\fg\u000e\u0006\u0003\u0002\f\u0005u\u0002BCA \u0003o\u0001\n\u00111\u0001\u0002B\u0005I1\u000f^1uSN$\u0018n\u0019\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0019\u0011q\t\u0003\u0002\u000bM$\u0018\r^:\n\t\u0005-\u0013Q\t\u0002\u000f\r2Lgn[*uCRL7\u000f^5d\u0011\u001d\ty\u0005\u0001C\u0005\u0003#\nqb\u0019:fCR,\u0017iZ4sK\u001e\fG/\u001a\u000b\u0007\u0003'\nI&a\u0019\u0011\t\u00055\u0011QK\u0005\u0005\u0003/\nyAA\u0005BO\u001e\u0014XmZ1uK\"A\u00111LA'\u0001\u0004\ti&\u0001\u0005he>,\boU3u!\u0011\u0019\u0012qL#\n\u0007\u0005\u0005DCA\u0003BeJ\f\u0017\u0010\u0003\u0005\u0002f\u00055\u0003\u0019AA4\u0003A\u0019\u0018\u000f\\!hO\u001a+hnV5uQ\u0006\u0013x\r\u0005\u0004\u0002j\u0005e\u0014Q\u0010\b\u0005\u0003W\n)H\u0004\u0003\u0002n\u0005MTBAA8\u0015\r\t\t\bE\u0001\u0007yI|w\u000e\u001e \n\u0003UI1!a\u001e\u0015\u0003\u001d\u0001\u0018mY6bO\u0016L1!JA>\u0015\r\t9\b\u0006\t\u0007'\u0005}\u00141Q#\n\u0007\u0005\u0005EC\u0001\u0004UkBdWM\r\t\u0005\u0003\u000b\u000b9)D\u00019\u0013\r\tI\t\u000f\u0002\u000f'Fd\u0017iZ4Gk:\u001cG/[8o\u0011\u001d\ty\u0005\u0001C\u0005\u0003\u001b#\u0002\"a\u0015\u0002\u0010\u0006E\u00151\u0013\u0005\t\u0003\u000f\tY\t1\u0001\u0002\f!A\u00111LAF\u0001\u0004\ti\u0006\u0003\u0005\u0002f\u0005-\u0005\u0019AA4\u0011\u001d\t9\n\u0001C\u0005\u00033\u000bAc\u0019:fCR,g*^7fe&\u001cG*\u001b;fe\u0006dG\u0003BAN\u0003O\u0003B!!(\u0002$6\u0011\u0011q\u0014\u0006\u0004\u0003CS\u0014a\u0001:fq&!\u0011QUAP\u0005)\u0011V\r\u001f'ji\u0016\u0014\u0018\r\u001c\u0005\t\u0003S\u000b)\n1\u0001\u0002,\u0006\u0019a.^7\u0011\u0007M\ti+C\u0002\u00020R\u0011A\u0001T8oO\"9\u00111\u0017\u0001\u0005\n\u0005U\u0016AD2sK\u0006$X-\u00138qkR\u0014VM\u001a\u000b\u0005\u0003o\u000bi\f\u0005\u0003\u0002\u001e\u0006e\u0016\u0002BA^\u0003?\u00131BU3y\u0013:\u0004X\u000f\u001e*fM\"9\u0011qXAY\u0001\u0004)\u0015!B5oI\u0016D\bbBAb\u0001\u0011%\u0011QY\u0001\u001eGJ,\u0017\r^3J]B,HOU3g/&$\bNT;mY\u0006\u0014\u0017\u000e\\5usR1\u0011qWAd\u0003\u0013Dq!a0\u0002B\u0002\u0007Q\t\u0003\u0005\u0002L\u0006\u0005\u0007\u0019AAg\u0003)I7OT;mY\u0006\u0014G.\u001a\t\u0004'\u0005=\u0017bAAi)\t9!i\\8mK\u0006t\u0007bBAk\u0001\u0011%\u0011q[\u0001\u000bGJ,\u0017\r^3DC2dGCBAm\u0003?\fI\u000f\u0005\u0003\u0002\u001e\u0006m\u0017\u0002BAo\u0003?\u0013qAU3y\u001d>$W\r\u0003\u0005\u0002b\u0006M\u0007\u0019AAr\u0003!y\u0007/\u001a:bi>\u0014\b\u0003BAC\u0003KL1!a:9\u0005-\u0019\u0016\u000f\\(qKJ\fGo\u001c:\t\u0011\u0005-\u00181\u001ba\u0001\u0003[\fQ!\u001a=qeN\u0004RaEAx\u00033L1!!=\u0015\u0005)a$/\u001a9fCR,GM\u0010\u0005\b\u0003k\u0004A\u0011BA|\u0003E\u0019'/Z1uK\u000e{G.^7o'R\fGo\u001d\u000b\u000f\u0003s\u0014)Aa\f\u00034\t}\"1\nB8!\u0011\tYP!\u0001\u000e\u0005\u0005u(\u0002BA$\u0003\u007fT!!\u0002\u0005\n\t\t\r\u0011Q \u0002\f\u0007>dW/\u001c8Ti\u0006$8\u000f\u0003\u0006\u0003\b\u0005M\b\u0013!a\u0001\u0005\u0013\t1A\u001c3w!\u0015\u0019\"1\u0002B\b\u0013\r\u0011i\u0001\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\tE!\u0011\u0006\b\u0005\u0005'\u00119C\u0004\u0003\u0003\u0016\t\u0015b\u0002\u0002B\f\u0005GqAA!\u0007\u0003\"9!!1\u0004B\u0010\u001d\u0011\tiG!\b\n\u0003=I!!\u0004\b\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"C\u0002\u0002x\u0019IAAa\u000b\u0003.\t)!\nT8oO*\u0019\u0011q\u000f\u0004\t\u0015\tE\u00121\u001fI\u0001\u0002\u0004\u0011I!A\u0005ok2d7i\\;oi\"Q!QGAz!\u0003\u0005\rAa\u000e\u0002\r\u00054x\rT3o!\u0015\u0019\"1\u0002B\u001d!\u0011\u0011\tBa\u000f\n\t\tu\"Q\u0006\u0002\b\u0015\u0012{WO\u00197f\u0011)\u0011\t%a=\u0011\u0002\u0003\u0007!1I\u0001\u0007[\u0006DH*\u001a8\u0011\u000bM\u0011YA!\u0012\u0011\u0007\u001d\u00129%C\u0002\u0003J!\u0012q!\u00138uK\u001e,'\u000f\u0003\u0006\u0003N\u0005M\b\u0013!a\u0001\u0005\u001f\n1!\\5o!\u0015\u0019\"1\u0002B)a\u0011\u0011\u0019F!\u0018\u0011\u000b\u001d\u0012)F!\u0017\n\u0007\t]\u0003F\u0001\u0006D_6\u0004\u0018M]1cY\u0016\u0004BAa\u0017\u0003^1\u0001A\u0001\u0004B0\u0005\u0017\n\t\u0011!A\u0003\u0002\t\u0005$aA0%cE!!1\rB5!\r\u0019\"QM\u0005\u0004\u0005O\"\"a\u0002(pi\"Lgn\u001a\t\u0004'\t-\u0014b\u0001B7)\t\u0019\u0011I\\=\t\u0015\tE\u00141\u001fI\u0001\u0002\u0004\u0011\u0019(A\u0002nCb\u0004Ra\u0005B\u0006\u0005k\u0002DAa\u001e\u0003|A)qE!\u0016\u0003zA!!1\fB>\t1\u0011iHa\u001c\u0002\u0002\u0003\u0005)\u0011\u0001B1\u0005\ryFE\r\u0005\b\u0005\u0003\u0003A\u0011\u0002BB\u0003Q\u0019'/Z1uK\u001ac\u0017N\\6Ti\u0006$\u0018n\u001d;jGR1\u0011\u0011\tBC\u0005\u0013C!Ba\"\u0003\u0000A\u0005\t\u0019\u0001B\u0005\u0003!\u0011xn^\"pk:$\bB\u0003BF\u0005\u007f\u0002\n\u00111\u0001\u0003\u000e\u0006A1m\u001c7Ti\u0006$8\u000fE\u0003\u0014\u0005\u0017\u0011y\t\u0005\u0005\u0003\u0012\n]%QTA}\u001d\r\u0019\"1S\u0005\u0004\u0005+#\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0003\u001a\nm%aA'ba*\u0019!Q\u0013\u000b\u0011\t\tE%qT\u0005\u0004[\tm\u0005b\u0002BR\u0001\u0011\u0005\u0011qE\u0001\u0012i\u0016\u001cHoU;n/&$\b.R9vC2\u001c\b\u0006\u0002BQ\u0005O\u0003B!!\f\u0003*&!!1VA\u0018\u0005\u0011!Vm\u001d;\t\u000f\t=\u0006\u0001\"\u0001\u0002(\u0005\u0019B/Z:u'Vlw+\u001b;i\u0019\u0016\u001c8\u000f\u00165b]\"\"!Q\u0016BT\u0011\u001d\u0011)\f\u0001C\u0001\u0003O\tQ\u0004^3tiN+XnV5uQ2+7o\u001d+iC:|%/R9vC2\u001cHk\u001c\u0015\u0005\u0005g\u00139\u000bC\u0004\u0003<\u0002!\t!a\n\u0002-Q,7\u000f^*v[^KG\u000f[$sK\u0006$XM\u001d+iC:DCA!/\u0003(\"9!\u0011\u0019\u0001\u0005\u0002\u0005\u001d\u0012A\b;fgR\u001cV/\\,ji\"<%/Z1uKJ$\u0006.\u00198Pe\u0016\u000bX/\u00197tQ\u0011\u0011yLa*\t\u000f\t\u001d\u0007\u0001\"\u0001\u0002(\u0005QA/Z:u\u001b\u0006DX*\u001b8)\t\t\u0015'q\u0015\u0005\b\u0005\u001b\u0004A\u0011AA\u0014\u0003\u001d!Xm\u001d;Bm\u001eDCAa3\u0003(\"9!1\u001b\u0001\u0005\u0002\u0005\u001d\u0012!\u0003;fgR\u001cu.\u001e8uQ\u0011\u0011\tNa*\t\u000f\te\u0007\u0001\"\u0001\u0002(\u00059A/Z:u\u0003:$\u0007\u0006\u0002Bl\u0005OCqAa8\u0001\t\u0003\t9#\u0001\u0004uKN$xJ\u001d\u0015\u0005\u0005;\u00149\u000bC\u0005\u0003f\u0002\t\n\u0011\"\u0003\u0003h\u0006\u0011Rn\\2l'\u000e\fg\u000e\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011IO\u000b\u0003\u0002B\t-8F\u0001Bw!\u0011\u0011yO!?\u000e\u0005\tE(\u0002\u0002Bz\u0005k\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t]H#\u0001\u0006b]:|G/\u0019;j_:LAAa?\u0003r\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t}\b!%A\u0005\n\r\u0005\u0011aG2sK\u0006$XmQ8mk6t7\u000b^1ug\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004\u0004)\"!\u0011\u0002Bv\u0011%\u00199\u0001AI\u0001\n\u0013\u0019\t!A\u000ede\u0016\fG/Z\"pYVlgn\u0015;biN$C-\u001a4bk2$HE\r\u0005\n\u0007\u0017\u0001\u0011\u0013!C\u0005\u0007\u001b\t1d\u0019:fCR,7i\u001c7v[:\u001cF/\u0019;tI\u0011,g-Y;mi\u0012\u001aTCAB\bU\u0011\u00119Da;\t\u0013\rM\u0001!%A\u0005\n\rU\u0011aG2sK\u0006$XmQ8mk6t7\u000b^1ug\u0012\"WMZ1vYR$C'\u0006\u0002\u0004\u0018)\"!1\tBv\u0011%\u0019Y\u0002AI\u0001\n\u0013\u0019i\"A\u000ede\u0016\fG/Z\"pYVlgn\u0015;biN$C-\u001a4bk2$H%N\u000b\u0003\u0007?QCa!\t\u0003lB)1Ca\u0003\u0004$A\"1QEB\u0015!\u00159#QKB\u0014!\u0011\u0011Yf!\u000b\u0005\u0019\t}3\u0011DA\u0001\u0002\u0003\u0015\tA!\u0019\t\u0013\r5\u0002!%A\u0005\n\r=\u0012aG2sK\u0006$XmQ8mk6t7\u000b^1ug\u0012\"WMZ1vYR$c'\u0006\u0002\u00042)\"11\u0007Bv!\u0015\u0019\"1BB\u001ba\u0011\u00199da\u000f\u0011\u000b\u001d\u0012)f!\u000f\u0011\t\tm31\b\u0003\r\u0005{\u001aY#!A\u0001\u0002\u000b\u0005!\u0011\r\u0005\n\u0007\u007f\u0001\u0011\u0013!C\u0005\u0007\u0003\tad\u0019:fCR,g\t\\5oWN#\u0018\r^5ti&\u001cG\u0005Z3gCVdG\u000fJ\u0019\t\u0013\r\r\u0003!%A\u0005\n\r\u0015\u0013AH2sK\u0006$XM\u00127j].\u001cF/\u0019;jgRL7\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u00199E\u000b\u0003\u0003\u000e\n-xaBB&\u0005!\u00051QJ\u0001 \u0003\u001e<7)\u00197m'\u0016dWm\u0019;jm&$\u00180R:uS6\fGo\u001c:UKN$\bc\u0001\u000f\u0004P\u00191\u0011A\u0001E\u0001\u0007#\u001a2aa\u0014\u0013\u0011\u001dI2q\nC\u0001\u0007+\"\"a!\u0014\t\u0011\re3q\nC\u0001\u0003O\t\u0011BY3g_J,\u0017\t\u001c7)\t\r]3Q\f\t\u0005\u0003[\u0019y&\u0003\u0003\u0004b\u0005=\"a\u0003\"fM>\u0014Xm\u00117bgN\u0004")
public class AggCallSelectivityEstimatorTest {
    private final Seq<String> allFieldNames = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "amount", "price"}));
    private final Seq<SqlTypeName> allFieldTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SqlTypeName[]{SqlTypeName.VARCHAR, SqlTypeName.INTEGER, SqlTypeName.DOUBLE}));
    private final /* synthetic */ Tuple3 x$1;
    private final int name_idx;
    private final int amount_idx;
    private final int price_idx;
    private final FlinkTypeFactory typeFactory;
    private FlinkRexBuilder rexBuilder;
    private final RelDataType relDataType;
    private final FlinkRelMetadataQuery mq;
    private TableScan scan;

    @BeforeClass
    public static void beforeAll() {
        AggCallSelectivityEstimatorTest$.MODULE$.beforeAll();
    }

    private Seq<String> allFieldNames() {
        return this.allFieldNames;
    }

    private Seq<SqlTypeName> allFieldTypes() {
        return this.allFieldTypes;
    }

    public int name_idx() {
        return this.name_idx;
    }

    public int amount_idx() {
        return this.amount_idx;
    }

    public int price_idx() {
        return this.price_idx;
    }

    public FlinkTypeFactory typeFactory() {
        return this.typeFactory;
    }

    public FlinkRexBuilder rexBuilder() {
        return this.rexBuilder;
    }

    public void rexBuilder_$eq(FlinkRexBuilder x$1) {
        this.rexBuilder = x$1;
    }

    public RelDataType relDataType() {
        return this.relDataType;
    }

    public FlinkRelMetadataQuery mq() {
        return this.mq;
    }

    public TableScan scan() {
        return this.scan;
    }

    public void scan_$eq(TableScan x$1) {
        this.scan = x$1;
    }

    @Before
    public void setup() {
        this.scan_$eq(this.mockScan(this.mockScan$default$1()));
    }

    private TableScan mockScan(FlinkStatistic statistic) {
        TableConfig tableConfig = new TableConfig();
        CatalogManager catalogManager = CatalogManagerMocks.createEmptyCatalogManager();
        SchemaPlus rootSchema = CalciteSchema.createRootSchema((boolean)true, (boolean)false).plus();
        MockMetaTable table = new MockMetaTable(this.relDataType(), statistic);
        rootSchema.add("test", (Table)table);
        PlannerContext plannerContext = new PlannerContext(false, tableConfig, new FunctionCatalog(tableConfig, catalogManager, new ModuleManager()), catalogManager, CalciteSchema.from((SchemaPlus)rootSchema), Arrays.asList((Object[])new RelTraitDef[]{ConventionTraitDef.INSTANCE, FlinkRelDistributionTraitDef$.MODULE$.INSTANCE(), RelCollationTraitDef.INSTANCE}));
        FlinkRelBuilder relBuilder = plannerContext.createRelBuilder("default_catalog", "default_database");
        relBuilder.clear();
        return (TableScan)relBuilder.scan(Arrays.asList((Object[])new String[]{"test"})).build();
    }

    private FlinkStatistic mockScan$default$1() {
        return FlinkStatistic$.MODULE$.UNKNOWN();
    }

    private Aggregate createAggregate(int[] groupSet, Seq<Tuple2<SqlAggFunction, Object>> sqlAggFunWithArg) {
        return this.createAggregate(this.scan(), groupSet, sqlAggFunWithArg);
    }

    private Aggregate createAggregate(TableScan scan, int[] groupSet, Seq<Tuple2<SqlAggFunction, Object>> sqlAggFunWithArg) {
        Seq aggCalls = (Seq)sqlAggFunWithArg.map((Function1)new Serializable(this, scan, groupSet){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AggCallSelectivityEstimatorTest $outer;
            private final TableScan scan$1;
            private final int[] groupSet$1;

            public final AggregateCall apply(Tuple2<SqlAggFunction, Object> x0$1) {
                Tuple2<SqlAggFunction, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    SqlAggFunction sqlAggFun = (SqlAggFunction)tuple2._1();
                    int arg = tuple2._2$mcI$sp();
                    SqlAggFunction sqlAggFunction = sqlAggFun;
                    SqlAggFunction sqlAggFunction2 = SqlStdOperatorTable.COUNT;
                    SqlAggFunction sqlAggFunction3 = sqlAggFunction;
                    RelDataType relDataType = !(sqlAggFunction2 != null ? !sqlAggFunction2.equals(sqlAggFunction3) : sqlAggFunction3 != null) ? this.$outer.typeFactory().createSqlType(SqlTypeName.BIGINT) : ((RelDataTypeField)this.scan$1.getRowType().getFieldList().get(arg)).getType();
                    RelDataType aggCallType = relDataType;
                    AggregateCall aggregateCall = AggregateCall.create((SqlAggFunction)sqlAggFun, (boolean)false, (boolean)false, (List)ImmutableList.of((Object)arg), (int)-1, (int)this.groupSet$1.length, (RelNode)this.scan$1, (RelDataType)aggCallType, (String)((String)this.scan$1.getRowType().getFieldNames().get(arg)));
                    return aggregateCall;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.scan$1 = scan$1;
                this.groupSet$1 = groupSet$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return LogicalAggregate.create((RelNode)scan, (ImmutableBitSet)ImmutableBitSet.of((int[])groupSet), null, (List)ImmutableList.copyOf((Object[])((Object[])aggCalls.toArray(ClassTag$.MODULE$.apply(AggregateCall.class)))));
    }

    private RexLiteral createNumericLiteral(long num) {
        return this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(num));
    }

    private RexInputRef createInputRef(int index) {
        return this.createInputRefWithNullability(index, false);
    }

    private RexInputRef createInputRefWithNullability(int index, boolean isNullable) {
        RelDataType relDataType = this.typeFactory().createSqlType((SqlTypeName)this.allFieldTypes().apply(index));
        RelDataType relDataTypeWithNullability = this.typeFactory().createTypeWithNullability(relDataType, isNullable);
        return this.rexBuilder().makeInputRef(relDataTypeWithNullability, index);
    }

    private RexNode createCall(SqlOperator operator, Seq<RexNode> exprs) {
        Preconditions.checkArgument((boolean)exprs.nonEmpty());
        return this.rexBuilder().makeCall(operator, (RexNode[])exprs.toArray(ClassTag$.MODULE$.apply(RexNode.class)));
    }

    private ColumnStats createColumnStats(Option<Long> ndv, Option<Long> nullCount, Option<Double> avgLen, Option<Integer> maxLen, Option<Comparable<?>> min, Option<Comparable<?>> max) {
        return ColumnStats.Builder.builder().setNdv((Long)ndv.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Long apply() {
                return null;
            }
        })).setNullCount((Long)nullCount.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Long apply() {
                return null;
            }
        })).setAvgLen((Double)avgLen.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Double apply() {
                return null;
            }
        })).setMaxLen((Integer)maxLen.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Integer apply() {
                return null;
            }
        })).setMax((Comparable)max.orNull(Predef$.MODULE$.$conforms())).setMin((Comparable)min.orNull(Predef$.MODULE$.$conforms())).build();
    }

    private Option<Long> createColumnStats$default$1() {
        return None$.MODULE$;
    }

    private Option<Long> createColumnStats$default$2() {
        return None$.MODULE$;
    }

    private Option<Double> createColumnStats$default$3() {
        return None$.MODULE$;
    }

    private Option<Integer> createColumnStats$default$4() {
        return None$.MODULE$;
    }

    private Option<Comparable<?>> createColumnStats$default$5() {
        return None$.MODULE$;
    }

    private Option<Comparable<?>> createColumnStats$default$6() {
        return None$.MODULE$;
    }

    private FlinkStatistic createFlinkStatistic(Option<Long> rowCount, Option<scala.collection.immutable.Map<String, ColumnStats>> colStats) {
        Predef$.MODULE$.require(rowCount.isDefined(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "rowCount must be non null now";
            }
        });
        TableStats tableStats = colStats.isDefined() ? new TableStats(Predef$.MODULE$.Long2long((Long)rowCount.get()), JavaConversions$.MODULE$.mapAsJavaMap((Map)colStats.get())) : new TableStats(Predef$.MODULE$.Long2long((Long)rowCount.get()), null);
        return FlinkStatistic$.MODULE$.builder().tableStats(tableStats).build();
    }

    private Option<Long> createFlinkStatistic$default$1() {
        return None$.MODULE$;
    }

    private Option<scala.collection.immutable.Map<String, ColumnStats>> createFlinkStatistic$default$2() {
        return None$.MODULE$;
    }

    @Test
    public void testSumWithEquals() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assert.assertEquals((Object)se.defaultEqualsSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.025)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(5L)}));
        Assert.assertEquals((Object)estimator1.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assert.assertEquals((Object)se.defaultEqualsSelectivity(), (Object)estimator3.evaluate(predicate1));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg4 = this.createAggregate(this.mockScan(statistic3), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator4 = new AggCallSelectivityEstimator((RelNode)agg4, this.mq());
        Assert.assertEquals((Object)se.defaultEqualsSelectivity(), (Object)estimator4.evaluate(predicate1));
    }

    @Test
    public void testSumWithLessThan() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(5L)}));
        Assert.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate3));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.25)), (Object)estimator2.evaluate(predicate1));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
    }

    @Test
    public void testSumWithLessThanOrEqualsTo() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(5L)}));
        Assert.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate3));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.25)), (Object)estimator2.evaluate(predicate1));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
    }

    @Test
    public void testSumWithGreaterThan() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assert.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(5L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate3));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.75)), (Object)estimator2.evaluate(predicate1));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
    }

    @Test
    public void testSumWithGreaterThanOrEquals() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assert.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(5L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate3));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.75)), (Object)estimator2.evaluate(predicate1));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
    }

    @Test
    public void testMaxMin() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.MAX, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.MIN, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(15L)}));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(10L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate2));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(20L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(30.0))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.MAX, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.MIN, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(15L)}));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(50L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), (Object)estimator2.evaluate(predicate3));
        Assert.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate5));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator2.evaluate(predicate1));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3103448275862069)), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.MIN, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.MAX, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate2));
    }

    @Test
    public void testAvg() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(15L)}));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(10L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate2));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(20L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(30.0))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(15L)}));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(50L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), (Object)estimator2.evaluate(predicate3));
        Assert.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate5));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator2.evaluate(predicate1));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3103448275862069)), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
        Assert.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate2));
    }

    @Test
    public void testCount() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(6L)}));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(5L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.9526830054771714)), (Object)estimator1.evaluate(predicate1));
        Assert.assertEquals((Object)estimator1.defaultAggCallSelectivity(), (Object)estimator1.evaluate(predicate2));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(20L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(30.0))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(6L)}));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(10L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.16666666666666666)), (Object)estimator2.evaluate(predicate3));
        Assert.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(10L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate5));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)estimator2.evaluate(predicate1));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)estimator3.evaluate(predicate1));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator3.evaluate(predicate2));
    }

    @Test
    public void testAnd() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(20L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(30.0))))}))));
        Aggregate agg = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator = new AggCallSelectivityEstimator((RelNode)agg, this.mq());
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(10L)}))}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.23706896551724138)), (Object)estimator.evaluate(predicate));
    }

    @Test
    public void testOr() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(20L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(30.0))))}))));
        Aggregate agg = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator = new AggCallSelectivityEstimator((RelNode)agg, this.mq());
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(10L)}))}));
        double s1 = 0.25;
        double s2 = 0.9482758620689655;
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(s1 + s2 - s1 * s2))), (Object)estimator.evaluate(predicate));
    }

    public AggCallSelectivityEstimatorTest() {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2));
        if (tuple3 != null) {
            Tuple3 tuple32;
            int name_idx = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int amount_idx = BoxesRunTime.unboxToInt((Object)tuple3._2());
            int price_idx = BoxesRunTime.unboxToInt((Object)tuple3._3());
            this.x$1 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)name_idx), (Object)BoxesRunTime.boxToInteger((int)amount_idx), (Object)BoxesRunTime.boxToInteger((int)price_idx));
            this.name_idx = BoxesRunTime.unboxToInt((Object)this.x$1._1());
            this.amount_idx = BoxesRunTime.unboxToInt((Object)this.x$1._2());
            this.price_idx = BoxesRunTime.unboxToInt((Object)this.x$1._3());
            this.typeFactory = new FlinkTypeFactory((RelDataTypeSystem)new FlinkTypeSystem());
            this.rexBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
            this.relDataType = this.typeFactory().createStructType(JavaConversions$.MODULE$.seqAsJavaList((Seq)this.allFieldTypes().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AggCallSelectivityEstimatorTest $outer;

                public final RelDataType apply(SqlTypeName typeName) {
                    return this.$outer.typeFactory().createSqlType(typeName);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Seq$.MODULE$.canBuildFrom())), JavaConversions$.MODULE$.seqAsJavaList(this.allFieldNames()));
            this.mq = FlinkRelMetadataQuery.instance();
            return;
        }
        throw new MatchError((Object)tuple3);
    }
}

