/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.cost;

import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptCostImpl;
import org.apache.flink.table.planner.plan.cost.FlinkCost;
import org.apache.flink.table.planner.plan.cost.FlinkCost$;
import org.junit.Assert;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0001\u0002\u0001#\tia\t\\5oW\u000e{7\u000f\u001e+fgRT!a\u0001\u0003\u0002\t\r|7\u000f\u001e\u0006\u0003\u000b\u0019\tA\u0001\u001d7b]*\u0011q\u0001C\u0001\ba2\fgN\\3s\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0003\u001f\u0001\u0011\u0005q$\u0001\buKN$\u0018j]%oM&t\u0017\u000e^3\u0015\u0003\u0001\u0002\"aE\u0011\n\u0005\t\"\"\u0001B+oSRD#!\b\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001dr\u0011!\u00026v]&$\u0018BA\u0015'\u0005\u0011!Vm\u001d;\t\u000b-\u0002A\u0011A\u0010\u0002\u0015Q,7\u000f^#rk\u0006d7\u000f\u000b\u0002+I!)a\u0006\u0001C\u0001?\u0005\u0019B/Z:u\u0013N,\u0015oV5uQ\u0016\u00038/\u001b7p]\"\u0012Q\u0006\n\u0005\u0006c\u0001!\taH\u0001\ti\u0016\u001cH/S:MK\"\u0012\u0001\u0007\n\u0005\u0006i\u0001!\taH\u0001\u0016i\u0016\u001cH/S:MK~;\u0016\u000e\u001e5ES\u001a47i\\:uQ\u0011\u0019DEN\u001c\u0002\u0011\u0015D\b/Z2uK\u0012\u001c\u0013\u0001\u000f\t\u0003s\u0005s!AO \u000f\u0005mrT\"\u0001\u001f\u000b\u0005u\u0002\u0012A\u0002\u001fs_>$h(C\u0001\u0016\u0013\t\u0001E#A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001b%AE\"mCN\u001c8)Y:u\u000bb\u001cW\r\u001d;j_:T!\u0001\u0011\u000b\t\u000b\u0015\u0003A\u0011A\u0010\u0002\u0011Q,7\u000f^%t\u0019RD#\u0001\u0012\u0013\t\u000b!\u0003A\u0011A\u0010\u0002+Q,7\u000f^%t\u0019R|v+\u001b;i\t&4gmQ8ti\"\"q\t\n\u001c8\u0011\u0015Y\u0005\u0001\"\u0001 \u0003!!Xm\u001d;QYV\u001c\bF\u0001&%\u0011\u0015q\u0005\u0001\"\u0001 \u0003U!Xm\u001d;QYV\u001cxlV5uQ\u0012KgMZ\"pgRDC!\u0014\u00137o!)\u0011\u000b\u0001C\u0001?\u0005IA/Z:u\u001b&tWo\u001d\u0015\u0003!\u0012BQ\u0001\u0016\u0001\u0005\u0002}\ta\u0003^3ti6Kg.^:`/&$\b\u000eR5gM\u000e{7\u000f\u001e\u0015\u0005'\u00122t\u0007C\u0003X\u0001\u0011\u0005q$\u0001\buKN$X*\u001e7uSBd\u0017PQ=)\u0005Y#\u0003\"\u0002.\u0001\t\u0003y\u0012\u0001\u0004;fgR$\u0015N^5eK\nK\bFA-%\u0001")
public class FlinkCostTest {
    @Test
    public void testIsInfinite() {
        Assert.assertFalse((boolean)FlinkCost$.MODULE$.Zero().isInfinite());
        Assert.assertFalse((boolean)FlinkCost$.MODULE$.Tiny().isInfinite());
        Assert.assertFalse((boolean)FlinkCost$.MODULE$.Huge().isInfinite());
        Assert.assertTrue((boolean)FlinkCost$.MODULE$.Infinity().isInfinite());
        Assert.assertTrue((boolean)new FlinkCost(100.0, 1000.0, Double.POSITIVE_INFINITY, 0.0, 0.0).isInfinite());
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((boolean)FlinkCost$.MODULE$.Tiny().equals((RelOptCost)FlinkCost$.MODULE$.Tiny()));
        Assert.assertFalse((boolean)FlinkCost$.MODULE$.Tiny().equals(RelOptCostImpl.FACTORY.makeTinyCost()));
        RelOptCost cost1 = FlinkCost$.MODULE$.FACTORY().makeCost(100.0, 1000.0, 0.0, 500.0, 0.0);
        RelOptCost cost2 = FlinkCost$.MODULE$.FACTORY().makeCost(100.0, 1000.0, 0.0, 500.0, 0.0);
        Assert.assertTrue((boolean)cost1.equals(cost2));
        RelOptCost cost3 = FlinkCost$.MODULE$.FACTORY().makeCost(100.0, 1000.0, Double.POSITIVE_INFINITY, 0.0, 0.0);
        RelOptCost cost4 = FlinkCost$.MODULE$.FACTORY().makeCost(100.0, 1000.0, Double.POSITIVE_INFINITY, 0.0, 0.0);
        Assert.assertTrue((boolean)cost3.equals(cost4));
        FlinkCost cost5 = new FlinkCost(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        Assert.assertTrue((boolean)FlinkCost$.MODULE$.Infinity().equals((RelOptCost)cost5));
        RelOptCost cost6 = FlinkCost$.MODULE$.FACTORY().makeCost(100.0, 1000.0, 0.0, 500.0, 1.0E-6);
        Assert.assertFalse((boolean)cost1.equals(cost6));
    }

    @Test
    public void testIsEqWithEpsilon() {
        Assert.assertTrue((boolean)FlinkCost$.MODULE$.Tiny().isEqWithEpsilon((RelOptCost)FlinkCost$.MODULE$.Tiny()));
        Assert.assertFalse((boolean)FlinkCost$.MODULE$.Tiny().isEqWithEpsilon(RelOptCostImpl.FACTORY.makeTinyCost()));
        RelOptCost cost1 = FlinkCost$.MODULE$.FACTORY().makeCost(100.123456, 1000.12345, 1.0E-6, 500.123, 1.0E-7);
        RelOptCost cost2 = FlinkCost$.MODULE$.FACTORY().makeCost(100.123457, 1000.12346, 1.0E-7, 500.123, 1.0E-6);
        Assert.assertTrue((boolean)cost1.isEqWithEpsilon(cost2));
        RelOptCost cost3 = FlinkCost$.MODULE$.FACTORY().makeCost(100.123456, 1000.12347, 1.0E-6, 500.123, 1.0E-7);
        Assert.assertFalse((boolean)cost1.isEqWithEpsilon(cost3));
    }

    @Test
    public void testIsLe() {
        Assert.assertTrue((boolean)FlinkCost$.MODULE$.Tiny().isLe((RelOptCost)FlinkCost$.MODULE$.Tiny()));
        RelOptCost cost1 = FlinkCost$.MODULE$.FACTORY().makeCost(100.0, 1000.0, 0.0, 500.0, 0.0);
        RelOptCost cost2 = FlinkCost$.MODULE$.FACTORY().makeCost(100.0, 1000.0, 0.0, 500.0, 0.0);
        Assert.assertTrue((boolean)cost1.isLe(cost2));
        Assert.assertTrue((boolean)cost2.isLe(cost1));
        RelOptCost cost3 = FlinkCost$.MODULE$.FACTORY().makeCost(100.0, 1200.0, 0.0, 500.0, 0.0);
        Assert.assertTrue((boolean)cost1.isLe(cost3));
        Assert.assertFalse((boolean)cost3.isLe(cost1));
        RelOptCost cost4 = FlinkCost$.MODULE$.FACTORY().makeCost(100.0, 1000.0, 50.0, 300.0, 200.0);
        Assert.assertFalse((boolean)cost1.isLe(cost4));
        Assert.assertTrue((boolean)cost4.isLe(cost1));
    }

    @Test(expected=ClassCastException.class)
    public void testIsLe_WithDiffCost() {
        FlinkCost$.MODULE$.Tiny().isLe(RelOptCostImpl.FACTORY.makeTinyCost());
    }

    @Test
    public void testIsLt() {
        Assert.assertFalse((boolean)FlinkCost$.MODULE$.Tiny().isLt((RelOptCost)FlinkCost$.MODULE$.Tiny()));
        RelOptCost cost1 = FlinkCost$.MODULE$.FACTORY().makeCost(100.0, 1000.0, 0.0, 500.0, 0.0);
        RelOptCost cost2 = FlinkCost$.MODULE$.FACTORY().makeCost(100.0, 1000.0, 0.0, 500.0, 0.0);
        Assert.assertFalse((boolean)cost1.isLt(cost2));
        Assert.assertFalse((boolean)cost2.isLt(cost1));
        RelOptCost cost3 = FlinkCost$.MODULE$.FACTORY().makeCost(100.0, 1200.0, 0.0, 500.0, 0.0);
        Assert.assertTrue((boolean)cost1.isLt(cost3));
        Assert.assertFalse((boolean)cost3.isLt(cost1));
        RelOptCost cost4 = FlinkCost$.MODULE$.FACTORY().makeCost(100.0, 1000.0, 50.0, 300.0, 200.0);
        Assert.assertFalse((boolean)cost1.isLt(cost4));
        Assert.assertTrue((boolean)cost4.isLt(cost1));
    }

    @Test(expected=ClassCastException.class)
    public void testIsLt_WithDiffCost() {
        FlinkCost$.MODULE$.Tiny().isLt(RelOptCostImpl.FACTORY.makeTinyCost());
    }

    @Test
    public void testPlus() {
        RelOptCost cost1 = FlinkCost$.MODULE$.FACTORY().makeCost(100.0, 1000.0, 0.0, 500.0, 0.0);
        Assert.assertTrue((boolean)FlinkCost$.MODULE$.Infinity().equals(cost1.plus((RelOptCost)FlinkCost$.MODULE$.Infinity())));
        Assert.assertTrue((boolean)FlinkCost$.MODULE$.Infinity().equals(FlinkCost$.MODULE$.Infinity().plus(cost1)));
        RelOptCost cost2 = FlinkCost$.MODULE$.FACTORY().makeCost(500.0, 3000.0, 27.0, 100.1234567, 0.0);
        RelOptCost expectedCost1 = FlinkCost$.MODULE$.FACTORY().makeCost(600.0, 4000.0, 27.0, 600.1234567, 0.0);
        Assert.assertTrue((boolean)expectedCost1.equals(cost1.plus(cost2)));
        RelOptCost cost3 = FlinkCost$.MODULE$.FACTORY().makeCost(500.0, 3000.0, 27.0, 100.1234567, Double.POSITIVE_INFINITY);
        RelOptCost expectedCost2 = FlinkCost$.MODULE$.FACTORY().makeCost(600.0, 4000.0, 27.0, 600.1234567, Double.POSITIVE_INFINITY);
        Assert.assertTrue((boolean)expectedCost2.equals(cost1.plus(cost3)));
    }

    @Test(expected=ClassCastException.class)
    public void testPlus_WithDiffCost() {
        FlinkCost$.MODULE$.Tiny().plus(RelOptCostImpl.FACTORY.makeTinyCost());
    }

    @Test
    public void testMinus() {
        RelOptCost cost1 = FlinkCost$.MODULE$.FACTORY().makeCost(100.0, 1000.0, 0.0, 500.0, 0.0);
        Assert.assertTrue((boolean)FlinkCost$.MODULE$.Infinity().equals(FlinkCost$.MODULE$.Infinity().minus(cost1)));
        RelOptCost expectedCost1 = FlinkCost$.MODULE$.FACTORY().makeCost(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Assert.assertTrue((boolean)expectedCost1.equals(cost1.minus((RelOptCost)FlinkCost$.MODULE$.Infinity())));
        RelOptCost cost2 = FlinkCost$.MODULE$.FACTORY().makeCost(500.0, 3000.0, 27.0, 100.1234567, 0.0);
        RelOptCost expectedCost2 = FlinkCost$.MODULE$.FACTORY().makeCost(-400.0, -2000.0, -27.0, 399.8765433, 0.0);
        Assert.assertTrue((boolean)expectedCost2.equals(cost1.minus(cost2)));
        RelOptCost expectedCost3 = FlinkCost$.MODULE$.FACTORY().makeCost(400.0, 2000.0, 27.0, -399.8765433, 0.0);
        Assert.assertTrue((boolean)expectedCost3.equals(cost2.minus(cost1)));
    }

    @Test(expected=ClassCastException.class)
    public void testMinus_WithDiffCost() {
        FlinkCost$.MODULE$.Tiny().minus(RelOptCostImpl.FACTORY.makeTinyCost());
    }

    @Test
    public void testMultiplyBy() {
        Assert.assertTrue((boolean)FlinkCost$.MODULE$.Infinity().equals(FlinkCost$.MODULE$.Infinity().multiplyBy(10.0)));
        RelOptCost cost1 = FlinkCost$.MODULE$.FACTORY().makeCost(100.0, 1000.0, 0.0, 500.0, 0.0);
        RelOptCost expectedCost1 = FlinkCost$.MODULE$.FACTORY().makeCost(1000.0, 10000.0, 0.0, 5000.0, 0.0);
        Assert.assertTrue((boolean)expectedCost1.equals(cost1.multiplyBy(10.0)));
        RelOptCost cost2 = FlinkCost$.MODULE$.FACTORY().makeCost(100.0, 1000.0, 0.0, 500.0, Double.POSITIVE_INFINITY);
        RelOptCost expectedCost2 = FlinkCost$.MODULE$.FACTORY().makeCost(1000.0, 10000.0, 0.0, 5000.0, Double.POSITIVE_INFINITY);
        Assert.assertTrue((boolean)expectedCost2.equals(cost2.multiplyBy(10.0)));
    }

    @Test
    public void testDivideBy() {
        Assert.assertEquals((double)1.0, (double)FlinkCost$.MODULE$.Infinity().divideBy((RelOptCost)FlinkCost$.MODULE$.Infinity()), (double)1.0E-5);
        Assert.assertEquals((double)1.0, (double)FlinkCost$.MODULE$.Tiny().divideBy((RelOptCost)FlinkCost$.MODULE$.Infinity()), (double)1.0E-5);
        Assert.assertEquals((double)1.0, (double)FlinkCost$.MODULE$.Tiny().divideBy((RelOptCost)FlinkCost$.MODULE$.Zero()), (double)1.0E-5);
        RelOptCost cost1 = FlinkCost$.MODULE$.FACTORY().makeCost(100.0, 1000.0, 200.0, 500.0, 600.0);
        RelOptCost cost2 = FlinkCost$.MODULE$.FACTORY().makeCost(50.0, 100.0, 40.0, 25.0, 200.0);
        Assert.assertEquals((double)Math.pow(6000.0, 0.2), (double)cost1.divideBy(cost2), (double)1.0E-5);
        Assert.assertEquals((double)Math.pow(1.6666666666666666E-4, 0.2), (double)cost2.divideBy(cost1), (double)1.0E-5);
    }
}

