/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.common;

import java.util.HashMap;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.CatalogViewImpl;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.common.ViewsExpandingTest$;
import org.apache.flink.table.planner.utils.TableFunc0;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.table.planner.utils.TableTestUtilBase;
import org.apache.flink.table.types.DataType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\u0001\u0003\u0001E\u0011!CV5foN,\u0005\u0010]1oI&tw\rV3ti*\u00111\u0001B\u0001\u0007G>lWn\u001c8\u000b\u0005\u00151\u0011\u0001\u00029mC:T!a\u0002\u0005\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\t)b!A\u0003vi&d7/\u0003\u0002\u0018)\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016D\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u000ei\u0006\u0014G.\u001a+fgR,F/\u001b7\u0011\tmq\"\u0003I\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\tIa)\u001e8di&|g.\r\t\u0003'\u0005J!A\t\u000b\u0003\u001bQ\u000b'\r\\3UKN$X\u000b^5m\u0011\u0015!\u0003\u0001\"\u0001&\u0003\u0019a\u0014N\\5u}Q\u0011a\u0005\u000b\t\u0003O\u0001i\u0011A\u0001\u0005\u00063\r\u0002\rA\u0007\u0005\u0006U\u0001!\taK\u0001\u001fi\u0016\u001cH/T5yK\u0012\u001c\u0016\u000f\u001c+bE2,g+[3x\u000bb\u0004\u0018M\u001c3j]\u001e$\u0012\u0001\f\t\u000375J!A\f\u000f\u0003\tUs\u0017\u000e\u001e\u0015\u0003SA\u0002\"!\r\u001b\u000e\u0003IR!a\r\b\u0002\u000b),h.\u001b;\n\u0005U\u0012$\u0001\u0002+fgRDQa\u000e\u0001\u0005\u0002-\nQ\u0003^3tiR\u000b'\r\\3Ba&,\u0005\u0010]1oI&tw\r\u000b\u00027a!)!\b\u0001C\u0001W\u0005\u0001B/Z:u'FdW\t\u001f9b]\u0012Lgn\u001a\u0015\u0003sABQ!\u0010\u0001\u0005\u0002-\nA\u0005^3tiZKWm^#ya\u0006tG-\u001b8h/&$\b.T5t[\u0006$8\r\u001b*poRK\b/\u001a\u0015\u0003yABQ\u0001\u0011\u0001\u0005\u0002-\n\u0011\u0006^3tiZKWm^#ya\u0006tG-\u001b8h/&$\b\u000eT1uKJ\fG\u000eV1cY\u00164UO\\2uS>t\u0007FA 1\u0011\u0015\u0019\u0005\u0001\"\u0001,\u0003\u0011\"Xm\u001d;WS\u0016<X\t\u001f9b]\u0012LgnZ,ji\"\u0014U/\u001b7uS:4UO\\2uS>t\u0007F\u0001\"1\u0011\u00151\u0005\u0001\"\u0001,\u0003a!Xm\u001d;WS\u0016<X\t\u001f9b]\u0012LgnZ,ji\",FI\u0012\u0015\u0003\u000bBBQ!\u0013\u0001\u0005\u0002-\na\u0004^3ti\u0016C\b/\u00198e#V,'/_,ji\"\u001c\u0016p\u001d;f[\u0006c\u0017.Y:)\u0005!\u0003\u0004\"\u0002'\u0001\t\u0013i\u0015!D2sK\u0006$XmU9m-&,w\u000f\u0006\u0002O)B\u0011qJU\u0007\u0002!*\u0011\u0011\u000bC\u0001\bG\u0006$\u0018\r\\8h\u0013\t\u0019\u0006KA\u0006DCR\fGn\\4WS\u0016<\b\"B+L\u0001\u00041\u0016aC8sS\u001eLg\u000eV1cY\u0016\u0004\"a\u0016.\u000f\u0005mA\u0016BA-\u001d\u0003\u0019\u0001&/\u001a3fM&\u00111\f\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005ec\u0002\u0006\u0002\u0001_I\u0016\u0004\"a\u00182\u000e\u0003\u0001T!!\u0019\u001a\u0002\rI,hN\\3s\u0013\t\u0019\u0007MA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0003\u0019\u0004\"a\u001a6\u000e\u0003!T!!\u001b\u001a\u0002\u000fI,hN\\3sg&\u00111\u000e\u001b\u0002\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\b\u000b5\u0014\u0001\u0012\u00018\u0002%YKWm^:FqB\fg\u000eZ5oOR+7\u000f\u001e\t\u0003O=4Q!\u0001\u0002\t\u0002A\u001c\"a\\9\u0011\u0005m\u0011\u0018BA:\u001d\u0005\u0019\te.\u001f*fM\")Ae\u001cC\u0001kR\ta\u000eC\u0003x_\u0012\u0005\u00010\u0001\u0006qCJ\fW.\u001a;feN$\u0012!\u001f\t\u00047id\u0018BA>\u001d\u0005\u0015\t%O]1z!\u0011YbDE?\u0011\u0005Mq\u0018BA@\u0015\u0005E!\u0016M\u00197f)\u0016\u001cH/\u0016;jY\n\u000b7/\u001a\u0015\u0004m\u0006\r\u0001\u0003BA\u0003\u0003;qA!a\u0002\u0002\u001a9!\u0011\u0011BA\f\u001d\u0011\tY!!\u0006\u000f\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005\u0011\u0003\u0019a$o\\8u}%\tq\"\u0003\u00024\u001d%\u0011\u0011NM\u0005\u0004\u00037A\u0017!\u0004)be\u0006lW\r^3sSj,G-\u0003\u0003\u0002 \u0005\u0005\"A\u0003)be\u0006lW\r^3sg*\u0019\u00111\u00045\u0007\r\u0005\u0015r\u000eAA\u0014\u0005]\u0001&/[7ji&4XmU2bY\u0006\u0014h)\u001e8di&|gn\u0005\u0003\u0002$\u0005%\u0002\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=\u0002\"A\u0005gk:\u001cG/[8og&!\u00111GA\u0017\u00059\u00196-\u00197be\u001a+hn\u0019;j_:Dq\u0001JA\u0012\t\u0003\t9\u0004\u0006\u0002\u0002:A!\u00111HA\u0012\u001b\u0005y\u0007\u0002CA \u0003G!\t!!\u0011\u0002\t\u00154\u0018\r\u001c\u000b\t\u0003\u0007\nI%a\u0015\u0002XA\u00191$!\u0012\n\u0007\u0005\u001dCD\u0001\u0003M_:<\u0007\u0002CA&\u0003{\u0001\r!!\u0014\u0002\u0003%\u00042aGA(\u0013\r\t\t\u0006\b\u0002\u0004\u0013:$\b\u0002CA+\u0003{\u0001\r!a\u0011\u0002\u00031Dq!!\u0017\u0002>\u0001\u0007a+A\u0001t\u0001")
public class ViewsExpandingTest
extends TableTestBase {
    private final Function1<TableTestBase, TableTestUtil> tableTestUtil;
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");

    @Parameterized.Parameters
    public static Function1<TableTestBase, TableTestUtilBase>[] parameters() {
        return ViewsExpandingTest$.MODULE$.parameters();
    }

    @Test
    public void testMixedSqlTableViewExpanding() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableUtil.addDataStream("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$5 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        Catalog catalog = (Catalog)tableEnv.getCatalog(tableEnv.getCurrentCatalog()).get();
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view1"), (CatalogBaseTable)this.createSqlView("t1"), false);
        tableEnv.createTemporaryView("view2", tableEnv.from("view1"));
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view3"), (CatalogBaseTable)this.createSqlView("view2"), false);
        tableEnv.createTemporaryView("view4", tableEnv.from("view3"));
        tableUtil.verifyExecPlan("select * from view4");
    }

    @Test
    public void testTableApiExpanding() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableUtil.addDataStream("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$6 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        tableEnv.createTemporaryView("view1", tableEnv.from("t1"));
        tableEnv.createTemporaryView("view2", tableEnv.from("view1"));
        tableEnv.createTemporaryView("view3", tableEnv.from("view2"));
        Table query = tableEnv.from("view3");
        tableUtil.verifyExecPlan(query);
    }

    @Test
    public void testSqlExpanding() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableUtil.addDataStream("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$7 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        Catalog catalog = (Catalog)tableEnv.getCatalog(tableEnv.getCurrentCatalog()).get();
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view1"), (CatalogBaseTable)this.createSqlView("t1"), false);
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view2"), (CatalogBaseTable)this.createSqlView("view1"), false);
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view3"), (CatalogBaseTable)this.createSqlView("view2"), false);
        String query = "SELECT * FROM view3";
        tableUtil.verifyExecPlan(query);
    }

    @Test
    public void testViewExpandingWithMismatchRowType() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        String originTableName = "t1";
        tableUtil.addDataStream(originTableName, (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$8 $outer;
                    private final ExecutionConfig executionConfig$4;
                    private final TypeSerializer[] fieldSerializers$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$4 = executionConfig$4;
                        this.fieldSerializers$4 = fieldSerializers$4;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        CatalogViewImpl aggSqlView = new CatalogViewImpl(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select a, b, count(c) from ", " group by a, b"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{originTableName})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select a, b, count(c) from ", " group by a, b"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{originTableName})), TableSchema.builder().field("a", (DataType)DataTypes.INT().notNull()).field("b", DataTypes.STRING()).field("c", DataTypes.INT()).build(), new HashMap(), "");
        Catalog catalog = (Catalog)tableEnv.getCatalog(tableEnv.getCurrentCatalog()).get();
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view1"), (CatalogBaseTable)aggSqlView, false);
        tableUtil.verifyExecPlan("select * from view1");
    }

    @Test
    public void testViewExpandingWithLateralTableFunction() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableEnv.createTemporarySystemFunction("myFunc", (UserDefinedFunction)new TableFunc0());
        tableEnv.createTemporaryView("source", tableEnv.fromValues(new Object[]{"danny#21", "julian#55", "fabian#30"}).as("f0", new String[0]));
        String createView = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp_view AS\n        |  SELECT f0, f1\n        |  FROM source as S, LATERAL TABLE(myFunc(f0)) as T(f1, f2)\n        |")).stripMargin();
        tableEnv.executeSql(createView);
        tableUtil.verifyExecPlan("select * from tmp_view");
    }

    @Test
    public void testViewExpandingWithBuiltinFunction() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        String createView = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp_view AS\n        |  SELECT CONCAT('a', 'bc', 'def')\n        |")).stripMargin();
        tableEnv.executeSql(createView);
        ObjectIdentifier objectID = ObjectIdentifier.of((String)tableEnv.getCurrentCatalog(), (String)tableEnv.getCurrentDatabase(), (String)"tmp_view");
        CatalogBaseTable view = ((Catalog)tableEnv.getCatalog(objectID.getCatalogName()).get()).getTable(objectID.toObjectPath());
        Assert.assertThat((Object)((CatalogView)view).getExpandedQuery(), (Matcher)CoreMatchers.is((Object)"SELECT `CONCAT`('a', 'bc', 'def')"));
    }

    @Test
    public void testViewExpandingWithUDF() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableEnv.createTemporaryFunction("func", PrimitiveScalarFunction.class);
        String createView = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp_view AS\n        |  SELECT func(1, 2, 'abc')\n        |")).stripMargin();
        tableEnv.executeSql(createView);
        ObjectIdentifier objectID = ObjectIdentifier.of((String)tableEnv.getCurrentCatalog(), (String)tableEnv.getCurrentDatabase(), (String)"tmp_view");
        CatalogBaseTable view = ((Catalog)tableEnv.getCatalog(objectID.getCatalogName()).get()).getTable(objectID.toObjectPath());
        Assert.assertThat((Object)((CatalogView)view).getExpandedQuery(), (Matcher)CoreMatchers.is((Object)"SELECT `default_catalog`.`default_database`.`func`(1, 2, 'abc')"));
    }

    @Test
    public void testExpandQueryWithSystemAlias() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableEnv.createTemporaryView("source", tableEnv.fromValues(new Object[]{"danny#21", "julian#55", "fabian#30"}).as("f0", new String[0]));
        String createView = new StringOps(Predef$.MODULE$.augmentString("\n        |create view tmp_view as\n        |select * from (\n        |  select f0,\n        |  row_number() over (partition by f0 order by f0 desc) as rowNum\n        |  from source)\n        |  where rowNum = 1\n        |")).stripMargin();
        tableEnv.executeSql(createView);
        ObjectIdentifier objectID = ObjectIdentifier.of((String)tableEnv.getCurrentCatalog(), (String)tableEnv.getCurrentDatabase(), (String)"tmp_view");
        CatalogBaseTable view = ((Catalog)tableEnv.getCatalog(objectID.getCatalogName()).get()).getTable(objectID.toObjectPath());
        Assert.assertThat((Object)((CatalogView)view).getExpandedQuery(), (Matcher)CoreMatchers.is((Object)"SELECT *\nFROM (SELECT `source`.`f0`, ROW_NUMBER() OVER (PARTITION BY `source`.`f0` ORDER BY `source`.`f0` DESC) AS `rowNum`\nFROM `default_catalog`.`default_database`.`source`)\nWHERE `rowNum` = 1"));
    }

    private CatalogView createSqlView(String originTable) {
        return new CatalogViewImpl(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select * as c from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{originTable})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select * from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{originTable})), TableSchema.builder().field("a", DataTypes.INT()).field("b", DataTypes.STRING()).field("c", DataTypes.INT()).build(), new HashMap(), "");
    }

    public ViewsExpandingTest(Function1<TableTestBase, TableTestUtil> tableTestUtil) {
        this.tableTestUtil = tableTestUtil;
    }

    public static class PrimitiveScalarFunction
    extends ScalarFunction {
        public long eval(int i, long l, String s) {
            return (long)i + l + (long)s.length();
        }
    }
}

