/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchPhysicalJoinRuleBase$;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchPhysicalSortMergeJoinRule$;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableFunc1;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\u0001\u0003\u0001M\u0011\u0011CU3n_Z,7\u000b[;gM2,G+Z:u\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\u000b\t\fGo\u00195\u000b\u0005\u001dA\u0011\u0001\u00029mC:T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9\u0002\"A\u0003vi&d7/\u0003\u0002\u001a-\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000f\u0001\u0002!\u0019!C\u0005C\u0005!Q\u000f^5m+\u0005\u0011\u0003CA\u000b$\u0013\t!cC\u0001\nCCR\u001c\u0007\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0014\u0001A\u0003%!%A\u0003vi&d\u0007\u0005C\u0003)\u0001\u0011\u0005\u0011&A\u0003tKR,\b\u000fF\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0011)f.\u001b;)\u0005\u001d\n\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0011\u0003\u0015QWO\\5u\u0013\t14G\u0001\u0004CK\u001a|'/\u001a\u0005\u0006q\u0001!\t!K\u0001$i\u0016\u001cHOU3n_Z,\u0007*Y:i'\",hM\u001a7f?>3XM],j]\u0012|w/Q4hQ\t9$\b\u0005\u00023w%\u0011Ah\r\u0002\u0005)\u0016\u001cH\u000fC\u0003?\u0001\u0011\u0005\u0011&\u0001\u0015uKN$(+Z7pm\u0016D\u0015m\u001d5TQV4g\r\\3`\u001bVdG/[(wKJ<\u0016N\u001c3po\u0006;w\r\u000b\u0002>u!)\u0011\t\u0001C\u0001S\u0005qC/Z:u%\u0016lwN^3ICND7\u000b[;gM2,wl\u0014<fe^Kg\u000eZ8x\u0003\u001e<w\fU1si&\fGnS3zQ\t\u0001%\bC\u0003E\u0001\u0011\u0005\u0011&\u0001\u0013uKN$(+Z7pm\u0016D\u0015m\u001d5TQV4g\r\\3`\u0003\u001e<w\fU1si&\fGnS3zQ\t\u0019%\bC\u0003H\u0001\u0011\u0005\u0011&A\u0012uKN$(+Z7pm\u0016D\u0015m\u001d5TQV4g\r\\3`\u0011\u0006\u001c\b.Q4he\u0016<\u0017\r^3)\u0005\u0019S\u0004\"\u0002&\u0001\t\u0003I\u0013!\n;fgR\u0014V-\\8wK\"\u000b7\u000f[*ik\u001a4G.Z0ICND\u0017iZ4sK\u001e\fG/Z02Q\tI%\bC\u0003N\u0001\u0011\u0005\u0011&A\u0013uKN$(+Z7pm\u0016D\u0015m\u001d5TQV4g\r\\3`\u0011\u0006\u001c\b.Q4he\u0016<\u0017\r^3`e!\u0012AJ\u000f\u0005\u0006!\u0002!\t!K\u0001$i\u0016\u001cHOU3n_Z,\u0007*Y:i'\",hM\u001a7f?N{'\u000f^!hOJ,w-\u0019;fQ\ty%\bC\u0003T\u0001\u0011\u0005\u0011&A\u0013uKN$(+Z7pm\u0016D\u0015m\u001d5TQV4g\r\\3`'>\u0014H/Q4he\u0016<\u0017\r^3`c!\u0012!K\u000f\u0005\u0006-\u0002!\t!K\u0001&i\u0016\u001cHOU3n_Z,\u0007*Y:i'\",hM\u001a7f?N{'\u000f^!hOJ,w-\u0019;f?JB#!\u0016\u001e\t\u000be\u0003A\u0011A\u0015\u0002GQ,7\u000f\u001e*f[>4X\rS1tQNCWO\u001a4mK~\u001bvN\u001d;NKJ<WMS8j]\"\u0012\u0001L\u000f\u0005\u00069\u0002!\t!K\u0001(i\u0016\u001cHOU3n_Z,\u0007*Y:i'\",hM\u001a7f?N{'\u000f^'fe\u001e,'j\\5o?2{%\n\u000b\u0002\\u!)q\f\u0001C\u0001S\u00059C/Z:u%\u0016lwN^3ICND7\u000b[;gM2,wlU8si6+'oZ3K_&twLU(KQ\tq&\bC\u0003c\u0001\u0011\u0005\u0011&A\u0014uKN$(+Z7pm\u0016D\u0015m\u001d5TQV4g\r\\3`'>\u0014H/T3sO\u0016Tu.\u001b8`\r>S\u0005FA1;\u0011\u0015)\u0007\u0001\"\u0001*\u0003y!Xm\u001d;SK6|g/\u001a%bg\"\u001c\u0006.\u001e4gY\u0016|\u0006*Y:i\u0015>Lg\u000e\u000b\u0002eu!)\u0001\u000e\u0001C\u0001S\u00059C/Z:u%\u0016lwN^3ICND7\u000b[;gM2,wL\u0011:pC\u0012\u001c\u0017m\u001d;ICND'j\\5oQ\t9'\bC\u0003l\u0001\u0011\u0005\u0011&\u0001\u0012uKN$(+Z7pm\u0016D\u0015m\u001d5TQV4g\r\\3`\u0011\u0006\u001c\bNS8j]~cuJ\u0013\u0015\u0003UjBQA\u001c\u0001\u0005\u0002%\n!\u0005^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWm\u0018%bg\"Tu.\u001b8`%>S\u0005FA7;\u0011\u0015\t\b\u0001\"\u0001*\u0003\t\"Xm\u001d;SK6|g/\u001a%bg\"\u001c\u0006.\u001e4gY\u0016|\u0006*Y:i\u0015>Lgn\u0018$P\u0015\"\u0012\u0001O\u000f\u0005\u0006i\u0002!\t!K\u0001!i\u0016\u001cHOU3n_Z,\u0007*Y:i'\",hM\u001a7f?\"\u000b7\u000f\u001b&pS:|\u0016\u0007\u000b\u0002tu!)q\u000f\u0001C\u0001S\u0005!C/Z:u%\u0016lwN^3ICND7\u000b[;gM2,wLT3ti\u0016$Gj\\8q\u0015>Lg\u000e\u000b\u0002wu!)!\u0010\u0001C\u0001S\u0005)C/Z:u%\u0016lwN^3ICND7\u000b[;gM2,wLS8j]~\u0003\u0016M\u001d;jC2\\U-\u001f\u0015\u0003sjBQ! \u0001\u0005\u0002%\nA\u0004^3tiJ+Wn\u001c<f'&tw\r\\3Fq\u000eD\u0017M\\4f?\u0006;w\r\u000b\u0002}u!1\u0011\u0011\u0001\u0001\u0005\u0002%\n1\u0004^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWmX+oS>t\u0007FA@;\u0011\u0019\t9\u0001\u0001C\u0001S\u0005QB/Z:u%\u0016lwN^3ICND7\u000b[;gM2,wLU1oW\"\u001a\u0011Q\u0001\u001e\t\r\u00055\u0001\u0001\"\u0001*\u0003\u0019\"Xm\u001d;SK6|g/\u001a%bg\"\u001c\u0006.\u001e4gY\u0016|&+\u00198l?B\u000b'\u000f^5bY.+\u00170\r\u0015\u0004\u0003\u0017Q\u0004BBA\n\u0001\u0011\u0005\u0011&\u0001\u0014uKN$(+Z7pm\u0016D\u0015m\u001d5TQV4g\r\\3`%\u0006t7n\u0018)beRL\u0017\r\\&fsJB3!!\u0005;\u0011\u0019\tI\u0002\u0001C\u0001S\u00051C/Z:u%\u0016lwN^3ICND7\u000b[;gM2,wLU1oW~\u0003\u0016M\u001d;jC2\\U-_\u001a)\u0007\u0005]!\b\u0003\u0004\u0002 \u0001!\t!K\u0001&i\u0016\u001cHOU3n_Z,\u0007*Y:i'\",hM\u001a7f?J\u000bgn[0TS:<G.\u001a;p]FB3!!\b;\u0011\u0019\t)\u0003\u0001C\u0001S\u0005)C/Z:u%\u0016lwN^3ICND7\u000b[;gM2,wLU1oW~\u001b\u0016N\\4mKR|gN\r\u0015\u0004\u0003GQ\u0004BBA\u0016\u0001\u0011\u0005\u0011&\u0001\u0011uKN$(+Z7pm\u0016D\u0015m\u001d5TQV4g\r\\3`\u0007>\u0014(/\u001a7bi\u0016\f\u0004fAA\u0015u!1\u0011\u0011\u0007\u0001\u0005\u0002%\n\u0001\u0005^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWmX\"peJ,G.\u0019;fe!\u001a\u0011q\u0006\u001e\t\r\u0005]\u0002\u0001\"\u0001*\u0003\u0001\"Xm\u001d;SK6|g/\u001a%bg\"\u001c\u0006.\u001e4gY\u0016|6i\u001c:sK2\fG/Z\u001a)\u0007\u0005U\"\b")
public class RemoveShuffleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        this.util().addTableSource("x", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"a", "b", "c"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100L)).build());
        this.util().addTableSource("y", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"d", "e", "f"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100L)).build());
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, false);
    }

    @Test
    public void testRemoveHashShuffle_OverWindowAgg() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "NestedLoopJoin,SortMergeJoin,SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT\n        |   SUM(b) sum_b,\n        |   AVG(SUM(b)) OVER (PARTITION BY c) avg_b,\n        |   RANK() OVER (PARTITION BY c ORDER BY c) rn,\n        |   c\n        | FROM x\n        | GROUP BY c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_MultiOverWindowAgg() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "NestedLoopJoin,SortMergeJoin,SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT\n        |   SUM(b) sum_b,\n        |   AVG(SUM(b)) OVER (PARTITION BY a, c) avg_b,\n        |   RANK() OVER (PARTITION BY c ORDER BY a, c) rn,\n        |   c\n        | FROM x\n        | GROUP BY a, c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_OverWindowAgg_PartialKey() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "NestedLoopJoin,SortMergeJoin,SortAgg");
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(BatchPhysicalJoinRuleBase$.MODULE$.TABLE_OPTIMIZER_SHUFFLE_BY_PARTIAL_KEY_ENABLED(), true);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT\n        |   SUM(b) sum_b,\n        |   AVG(SUM(b)) OVER (PARTITION BY c) avg_b,\n        |   RANK() OVER (PARTITION BY c ORDER BY c) rn,\n        |   c\n        | FROM x\n        | GROUP BY a, c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Agg_PartialKey() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "NestedLoopJoin,SortMergeJoin,SortAgg");
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(BatchPhysicalJoinRuleBase$.MODULE$.TABLE_OPTIMIZER_SHUFFLE_BY_PARTIAL_KEY_ENABLED(), true);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        | WITH r AS (SELECT a, c, count(b) as cnt FROM x GROUP BY a, c)\n        | SELECT count(cnt) FROM r group by c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashAggregate() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "SortMergeJoin,NestedLoopJoin,SortAgg");
        this.util().tableEnv().getConfig().getConfiguration().setLong(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, -1L);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT sum(b) FROM r group by a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashAggregate_1() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "SortMergeJoin,NestedLoopJoin,SortAgg");
        this.util().tableEnv().getConfig().getConfiguration().setLong(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, -1L);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT sum(b) FROM r group by a, d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashAggregate_2() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "SortMergeJoin,NestedLoopJoin,SortAgg");
        this.util().tableEnv().getConfig().getConfiguration().setLong(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, -1L);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT sum(b) FROM r group by d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_SortAggregate() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "SortMergeJoin,NestedLoopJoin,HashAgg");
        this.util().tableEnv().getConfig().getConfiguration().setLong(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, -1L);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT sum(b) FROM r group by a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_SortAggregate_1() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "SortMergeJoin,NestedLoopJoin,HashAgg");
        this.util().tableEnv().getConfig().getConfiguration().setLong(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, -1L);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT sum(b) FROM r group by a, d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_SortAggregate_2() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "SortMergeJoin,NestedLoopJoin,HashAgg");
        this.util().tableEnv().getConfig().getConfiguration().setLong(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, -1L);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT sum(b) FROM r group by d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_SortMergeJoin() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "HashJoin,NestedLoopJoin");
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(BatchPhysicalSortMergeJoinRule$.MODULE$.TABLE_OPTIMIZER_SMJ_REMOVE_SORT_ENABLED(), true);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_SortMergeJoin_LOJ() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "HashJoin,NestedLoopJoin");
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(BatchPhysicalSortMergeJoinRule$.MODULE$.TABLE_OPTIMIZER_SMJ_REMOVE_SORT_ENABLED(), true);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x left join (SELECT * FROM y WHERE e = 2) r on a = d)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_SortMergeJoin_ROJ() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "HashJoin,NestedLoopJoin");
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(BatchPhysicalSortMergeJoinRule$.MODULE$.TABLE_OPTIMIZER_SMJ_REMOVE_SORT_ENABLED(), true);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x right join (SELECT * FROM y WHERE e = 2) r on a = d)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_SortMergeJoin_FOJ() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "HashJoin,NestedLoopJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x full join (SELECT * FROM y WHERE e = 2) r on a = d)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashJoin() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "NestedLoopJoin,SortMergeJoin");
        this.util().tableEnv().getConfig().getConfiguration().setLong(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, -1L);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_BroadcastHashJoin() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashJoin_LOJ() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "NestedLoopJoin,SortMergeJoin");
        this.util().tableEnv().getConfig().getConfiguration().setLong(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, -1L);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x left join (SELECT * FROM y WHERE e = 2) r on a = d)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashJoin_ROJ() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "NestedLoopJoin,SortMergeJoin");
        this.util().tableEnv().getConfig().getConfiguration().setLong(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, -1L);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x right join (SELECT * FROM y WHERE e = 2) r on a = d)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashJoin_FOJ() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "NestedLoopJoin,SortMergeJoin");
        this.util().tableEnv().getConfig().getConfiguration().setLong(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, -1L);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x full join (SELECT * FROM y WHERE e = 2) r on a = d)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashJoin_1() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "NestedLoopJoin,SortMergeJoin");
        this.util().tableEnv().getConfig().getConfiguration().setLong(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, -1L);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r1 AS (SELECT a, c, sum(b) FROM x group by a, c),\n        |r2 AS (SELECT a, c, sum(b) FROM x group by a, c)\n        |SELECT * FROM r1, r2 WHERE r1.a = r2.a and r1.c = r2.c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_NestedLoopJoin() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "HashJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Join_PartialKey() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "SortMergeJoin,NestedLoopJoin,SortAgg");
        this.util().tableEnv().getConfig().getConfiguration().setLong(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, -1L);
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(BatchPhysicalJoinRuleBase$.MODULE$.TABLE_OPTIMIZER_SHUFFLE_BY_PARTIAL_KEY_ENABLED(), true);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT d, count(f) as cnt FROM y GROUP BY d)\n        |SELECT * FROM x, r WHERE x.a = r.d AND x.b = r.cnt\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveSingleExchange_Agg() {
        String sqlQuery = "SELECT avg(b) FROM x GROUP BY c  HAVING sum(b) > (SELECT sum(b) * 0.1 FROM x)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Union() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "NestedLoopJoin,SortMergeJoin,SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (\n        |SELECT count(a) as cnt, c FROM x WHERE b > 10 group by c\n        |UNION ALL\n        |SELECT count(d) as cnt, f FROM y WHERE e < 100 group by f)\n        |SELECT r1.c, r1.cnt, r2.c, r2.cnt FROM r r1, r r2 WHERE r1.c = r2.c and r1.cnt < 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Rank() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER(PARTITION BY a ORDER BY b) rk FROM (\n        |   SELECT a, SUM(b) AS b FROM x GROUP BY a\n        | )\n        |) WHERE rk <= 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Rank_PartialKey1() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "SortAgg");
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(BatchPhysicalJoinRuleBase$.MODULE$.TABLE_OPTIMIZER_SHUFFLE_BY_PARTIAL_KEY_ENABLED(), true);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, SUM(b) FROM (\n        | SELECT * FROM (\n        |   SELECT a, b, c, RANK() OVER(PARTITION BY a, c ORDER BY b) rk FROM x)\n        | WHERE rk <= 10\n        |) GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Rank_PartialKey2() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "SortAgg");
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(BatchPhysicalJoinRuleBase$.MODULE$.TABLE_OPTIMIZER_SHUFFLE_BY_PARTIAL_KEY_ENABLED(), false);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, c, RANK() OVER(PARTITION BY a, c ORDER BY b) rk FROM (\n        |   SELECT a, SUM(b) AS b, COUNT(c) AS c FROM x GROUP BY a\n        | )\n        |) WHERE rk <= 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Rank_PartialKey3() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "SortAgg");
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(BatchPhysicalJoinRuleBase$.MODULE$.TABLE_OPTIMIZER_SHUFFLE_BY_PARTIAL_KEY_ENABLED(), true);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, c, RANK() OVER(PARTITION BY a, c ORDER BY b) rk FROM (\n        |   SELECT a, SUM(b) AS b, COUNT(c) AS c FROM x GROUP BY a\n        | )\n        |) WHERE rk <= 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Rank_Singleton1() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER(ORDER BY b) rk FROM (\n        |   SELECT COUNT(a) AS a, SUM(b) AS b FROM x\n        | )\n        |) WHERE rk <= 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Rank_Singleton2() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER(PARTITION BY a ORDER BY b) rk FROM (\n        |   SELECT COUNT(a) AS a, SUM(b) AS b FROM x\n        | )\n        |) WHERE rk <= 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Correlate1() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "SortMergeJoin,NestedLoopJoin,SortAgg");
        this.util().tableEnv().getConfig().getConfiguration().setLong(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, -1L);
        this.util().addFunction("split", new TableFunc1(), BasicTypeInfo.getInfoFor(String.class));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT f, count(f) as cnt FROM y GROUP BY f),\n        |     v as (SELECT f1, f, cnt FROM r, LATERAL TABLE(split(f)) AS T(f1))\n        |SELECT * FROM x, v WHERE c = f\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Correlate2() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "SortMergeJoin,NestedLoopJoin,SortAgg");
        this.util().tableEnv().getConfig().getConfiguration().setLong(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, -1L);
        this.util().addFunction("split", new TableFunc1(), BasicTypeInfo.getInfoFor(String.class));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT f, count(f) as cnt FROM y GROUP BY f),\n        |     v as (SELECT f, f1 FROM r, LATERAL TABLE(split(f)) AS T(f1))\n        |SELECT * FROM x, v WHERE c = f AND f LIKE '%llo%'\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Correlate3() {
        this.util().tableEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, "SortMergeJoin,NestedLoopJoin,SortAgg");
        this.util().tableEnv().getConfig().getConfiguration().setLong(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, -1L);
        this.util().addFunction("split", new TableFunc1(), BasicTypeInfo.getInfoFor(String.class));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT f, count(f) as cnt FROM y GROUP BY f),\n        |     v as (SELECT f1 FROM r, LATERAL TABLE(split(f)) AS T(f1))\n        |SELECT * FROM x, v WHERE c = f1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }
}

