/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TestLegacyFilterableTableSource$;
import org.apache.flink.table.planner.utils.TestLegacyProjectableTableSource;
import org.apache.flink.table.planner.utils.TestLegacyProjectableTableSource$;
import org.apache.flink.table.planner.utils.TestNestedProjectableTableSource;
import org.apache.flink.table.planner.utils.TestNestedProjectableTableSource$;
import org.apache.flink.table.planner.utils.TestPartitionableSourceFactory$;
import org.apache.flink.table.planner.utils.TestTableSource$;
import org.apache.flink.table.runtime.types.TypeInfoDataTypeConverter;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0001'\t)B*Z4bGf$\u0016M\u00197f'>,(oY3UKN$(BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\tQAY1uG\"T!a\u0002\u0005\u0002\tAd\u0017M\u001c\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\t\u0003\u0015)H/\u001b7t\u0013\tIbCA\u0007UC\ndW\rV3ti\n\u000b7/\u001a\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAq\u0001\t\u0001C\u0002\u0013%\u0011%\u0001\u0003vi&dW#\u0001\u0012\u0011\u0005U\u0019\u0013B\u0001\u0013\u0017\u0005I\u0011\u0015\r^2i)\u0006\u0014G.\u001a+fgR,F/\u001b7\t\r\u0019\u0002\u0001\u0015!\u0003#\u0003\u0015)H/\u001b7!\u0011\u001dA\u0003A1A\u0005\n%\n1\u0002^1cY\u0016\u001c6\r[3nCV\t!\u0006\u0005\u0002,]5\tAF\u0003\u0002.\u0015\u0005\u0019\u0011\r]5\n\u0005=b#a\u0003+bE2,7k\u00195f[\u0006Da!\r\u0001!\u0002\u0013Q\u0013\u0001\u0004;bE2,7k\u00195f[\u0006\u0004\u0003\"B\u001a\u0001\t\u0003!\u0014!B:fiV\u0004H#A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\tUs\u0017\u000e\u001e\u0015\u0003eq\u0002\"!\u0010!\u000e\u0003yR!a\u0010\t\u0002\u000b),h.\u001b;\n\u0005\u0005s$A\u0002\"fM>\u0014X\rC\u0003D\u0001\u0011\u0005A'\u0001\u000fuKN$(i\\;oI\u0016$7\u000b\u001e:fC6$\u0016M\u00197f'>,(oY3)\u0005\t+\u0005CA\u001fG\u0013\t9eH\u0001\u0003UKN$\b\"B%\u0001\t\u0003!\u0014A\b;fgR,fNY8v]\u0012,Gm\u0015;sK\u0006lG+\u00192mKN{WO]2fQ\tAU\tC\u0003M\u0001\u0011\u0005A'A\tuKN$8+[7qY\u0016\u0004&o\u001c6fGRD#aS#\t\u000b=\u0003A\u0011\u0001\u001b\u00025Q,7\u000f\u001e)s_*,7\r^,ji\"|W\u000f^%oaV$(+\u001a4)\u00059+\u0005\"\u0002*\u0001\t\u0003!\u0014!\u0005;fgRtUm\u001d;fIB\u0013xN[3di\"\u0012\u0011+\u0012\u0005\u0006+\u0002!\t\u0001N\u0001\u0016i\u0016\u001cHOR5mi\u0016\u00148)\u00198QkNDGi\\<oQ\t!V\tC\u0003Y\u0001\u0011\u0005A'\u0001\ruKN$h)\u001b7uKJ\u001c\u0015M\u001c8piB+8\u000f\u001b#po:D#aV#\t\u000bm\u0003A\u0011\u0001\u001b\u00023Q,7\u000f\u001e$jYR,'\u000fU1si&\fG\u000eU;tQ\u0012{wO\u001c\u0015\u00035\u0016CQA\u0018\u0001\u0005\u0002Q\nq\u0003^3ti\u001aKG\u000e^3s\rVdG.\u001f)vg\"$un\u001e8)\u0005u+\u0005\"B1\u0001\t\u0003!\u0014!\u0007;fgR4\u0015\u000e\u001c;fe\u000e\u000bgN\\8u!V\u001c\b\u000eR8x]JB#\u0001Y#\t\u000b\u0011\u0004A\u0011\u0001\u001b\u00023Q,7\u000f\u001e$jYR,'oQ1o]>$\b+^:i\t><hn\r\u0015\u0003G\u0016CQa\u001a\u0001\u0005\u0002Q\nq\u0005^3ti\u001aKG\u000e^3s!V\u001c\b\u000eR8x]Vs7m\u001c8wKJ$X\rZ#yaJ,7o]5p]\"\u0012a-\u0012\u0005\u0006U\u0002!\t\u0001N\u0001\u001ai\u0016\u001cHOR5mi\u0016\u0014\b+^:i\t><hnV5uQV#g\r\u000b\u0002j\u000b\")Q\u000e\u0001C\u0001i\u0005AB/Z:u!\u0006\u0014H/\u001b;j_:$\u0016M\u00197f'>,(oY3)\u00051,\u0005\"\u00029\u0001\t\u0003!\u0014a\b;fgR\u0004\u0016M\u001d;ji&|g\u000eV1cY\u0016\u001cv.\u001e:dK^KG\u000f[+eM\"\u0012q.\u0012\u0005\u0006g\u0002!\t\u0001N\u0001\"i\u0016\u001cH\u000fV5nK2KG/\u001a:bY\u0016C\bO]3tg&|g\u000eU;tQ\u0012{wO\u001c\u0015\u0003e\u0016CQA\u001e\u0001\u0005\u0002Q\nQ\u0002^3tiR\u000b'\r\\3IS:$\bFA;F\u0001")
public class LegacyTableSourceTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());
    private final TableSchema tableSchema = TableSchema.builder().fields((String[])((Object[])new String[]{"a", "b", "c"}), (DataType[])((Object[])new DataType[]{DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING()})).build();

    private BatchTableTestUtil util() {
        return this.util;
    }

    private TableSchema tableSchema() {
        return this.tableSchema;
    }

    @Before
    public void setup() {
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSourceInternal("ProjectableTable", (TableSource)new TestLegacyProjectableTableSource(true, this.tableSchema(), (TypeInformation<Row>)new RowTypeInfo((TypeInformation[])Predef$.MODULE$.refArrayOps((Object[])this.tableSchema().getFieldDataTypes()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TypeInformation<?> apply(DataType x$1) {
                return TypeInfoDataTypeConverter.fromDataTypeToTypeInfo((DataType)x$1);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TypeInformation.class))), this.tableSchema().getFieldNames()), (Seq<Row>)((Seq)Seq$.MODULE$.empty()), TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$5(), TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$6(), TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable(this.util().tableEnv(), TestLegacyFilterableTableSource$.MODULE$.defaultSchema(), "FilterableTable", true, TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable$default$5(), TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable$default$6());
        TestPartitionableSourceFactory$.MODULE$.createTemporaryTable(this.util().tableEnv(), "PartitionableTable", true);
    }

    @Test
    public void testBoundedStreamTableSource() {
        TestTableSource$.MODULE$.createTemporaryTable(this.util().tableEnv(), true, this.tableSchema(), "MyTable");
        this.util().verifyExecPlan("SELECT * FROM MyTable");
    }

    @Test
    public void testUnboundedStreamTableSource() {
        TestTableSource$.MODULE$.createTemporaryTable(this.util().tableEnv(), false, this.tableSchema(), "MyTable");
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("Only bounded StreamTableSource can be used in batch mode.");
        this.util().verifyExecPlan("SELECT * FROM MyTable");
    }

    @Test
    public void testSimpleProject() {
        this.util().verifyExecPlan("SELECT a, c FROM ProjectableTable");
    }

    @Test
    public void testProjectWithoutInputRef() {
        this.util().verifyExecPlan("SELECT COUNT(1) FROM ProjectableTable");
    }

    @Test
    public void testNestedProject() {
        RowTypeInfo nested1 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.INT()}), (String[])((Object[])new String[]{"name", "value"}));
        RowTypeInfo nested2 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.BOOLEAN()}), (String[])((Object[])new String[]{"num", "flag"}));
        RowTypeInfo deepNested = new RowTypeInfo((TypeInformation[])new RowTypeInfo[]{nested1, nested2}, (String[])((Object[])new String[]{"nested1", "nested2"}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), deepNested, nested1, Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), deepNested, nested1, Types.STRING()}), (String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSourceInternal("T", (TableSource)new TestNestedProjectableTableSource(true, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$5(), TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id,\n        |    deepNested.nested1.name AS nestedName,\n        |    nested.`value` AS nestedValue,\n        |    deepNested.nested2.flag AS nestedFlag,\n        |    deepNested.nested2.num AS nestedNum\n        |FROM T\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testFilterCanPushDown() {
        this.util().verifyExecPlan("SELECT * FROM FilterableTable WHERE amount > 2");
    }

    @Test
    public void testFilterCannotPushDown() {
        this.util().verifyExecPlan("SELECT * FROM FilterableTable WHERE price > 10");
    }

    @Test
    public void testFilterPartialPushDown() {
        this.util().verifyExecPlan("SELECT * FROM FilterableTable WHERE amount > 2 AND price > 10");
    }

    @Test
    public void testFilterFullyPushDown() {
        this.util().verifyExecPlan("SELECT * FROM FilterableTable WHERE amount > 2 AND amount < 10");
    }

    @Test
    public void testFilterCannotPushDown2() {
        this.util().verifyExecPlan("SELECT * FROM FilterableTable WHERE amount > 2 OR price > 10");
    }

    @Test
    public void testFilterCannotPushDown3() {
        this.util().verifyExecPlan("SELECT * FROM FilterableTable WHERE amount > 2 OR amount < 10");
    }

    @Test
    public void testFilterPushDownUnconvertedExpression() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM FilterableTable WHERE\n        |    amount > 2 AND id < 100 AND CAST(amount AS BIGINT) > 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testFilterPushDownWithUdf() {
        this.util().addFunction("myUdf", Func1$.MODULE$);
        this.util().verifyExecPlan("SELECT * FROM FilterableTable WHERE amount > 2 AND myUdf(amount) < 32");
    }

    @Test
    public void testPartitionTableSource() {
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE part2 > 1 and id > 2 AND part1 = 'A' ");
    }

    @Test
    public void testPartitionTableSourceWithUdf() {
        this.util().addFunction("MyUdf", Func1$.MODULE$);
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE id > 2 AND MyUdf(part2) < 3");
    }

    @Test
    public void testTimeLiteralExpressionPushDown() {
        TableSchema schema = TableSchema.builder().field("id", DataTypes.INT()).field("dv", DataTypes.DATE()).field("tv", DataTypes.TIME()).field("tsv", DataTypes.TIMESTAMP((int)3)).build();
        Row row2 = new Row(4);
        row2.setField(0, (Object)BoxesRunTime.boxToInteger((int)1));
        row2.setField(1, (Object)DateTimeTestUtil$.MODULE$.localDate("2017-01-23"));
        row2.setField(2, (Object)DateTimeTestUtil$.MODULE$.localTime("14:23:02"));
        row2.setField(3, (Object)DateTimeTestUtil$.MODULE$.localDateTime("2017-01-24 12:45:01.234"));
        TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable(this.util().tableEnv(), schema, "FilterableTable1", true, (List<Row>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{row2})), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dv", "tv", "tsv"}))));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT id FROM FilterableTable1 WHERE\n         |  tv > TIME '14:25:02' AND\n         |  dv > DATE '2017-02-03' AND\n         |  tsv > TIMESTAMP '2017-02-03 14:25:02.000'\n      "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testTableHint() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE MyTable1 (\n         |  name STRING,\n         |  a bigint,\n         |  b int,\n         |  c double\n         |) with (\n         |  'connector.type' = 'TestFilterableSource',\n         |  'is-bounded' = 'true'\n         |)\n       "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE MySink (\n         |  `a` BIGINT,\n         |  `b` INT,\n         |  `c` DOUBLE\n         |) WITH (\n         |  'connector' = 'filesystem',\n         |  'format' = 'testcsv',\n         |  'path' = '/tmp/test'\n         |)\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into MySink select a,b,c from MyTable1\n        |  /*+ OPTIONS('source.num-element-to-skip'='31') */\n        |")).stripMargin());
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into MySink select a,b,c from MyTable1\n        |  /*+ OPTIONS('source.num-element-to-skip'='32') */\n        |")).stripMargin());
        this.util().verifyExecPlan(stmtSet);
    }
}

