/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.functions.BuiltInFunctionTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.junit.runners.Parameterized;

public class CastFunctionITCase
extends BuiltInFunctionTestBase {
    @Parameterized.Parameters(name="{index}: {0}")
    public static List<BuiltInFunctionTestBase.TestSpec> testData() {
        return Arrays.asList(BuiltInFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.CAST, "implicit with different field names").onFieldsWithData(Row.of((Object[])new Object[]{12, "Hello"})).andDataTypes(new AbstractDataType[]{DataTypes.of((String)"ROW<otherNameInt INT, otherNameString STRING>")}).withFunction(RowToFirstField.class).testResult((Expression)Expressions.call((String)"RowToFirstField", (Object[])new Object[]{Expressions.$((String)"f0")}), "RowToFirstField(f0)", 12, (AbstractDataType<?>)DataTypes.INT()), BuiltInFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.CAST, "implicit with type widening").onFieldsWithData(Row.of((Object[])new Object[]{(byte)12, "Hello"})).andDataTypes(new AbstractDataType[]{DataTypes.of((String)"ROW<i TINYINT, s STRING>")}).withFunction(RowToFirstField.class).testResult((Expression)Expressions.call((String)"RowToFirstField", (Object[])new Object[]{Expressions.$((String)"f0")}), "RowToFirstField(f0)", 12, (AbstractDataType<?>)DataTypes.INT()), BuiltInFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.CAST, "implicit with nested type widening").onFieldsWithData(Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{12, 42}), "Hello"})).andDataTypes(new AbstractDataType[]{DataTypes.of((String)"ROW<r ROW<i1 INT, i2 INT>, s STRING>")}).withFunction(NestedRowToFirstField.class).testResult((Expression)Expressions.call((String)"NestedRowToFirstField", (Object[])new Object[]{Expressions.$((String)"f0")}), "NestedRowToFirstField(f0)", Row.of((Object[])new Object[]{12, 42.0}), (AbstractDataType<?>)DataTypes.of((String)"ROW<i INT, d DOUBLE>")), BuiltInFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.CAST, "explicit with nested rows and implicit nullability change").onFieldsWithData(Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{12, 42, null}), "Hello"})).andDataTypes(new AbstractDataType[]{DataTypes.of((String)"ROW<r ROW<i1 INT, i2 INT, i3 INT>, s STRING>")}).testResult((Expression)Expressions.$((String)"f0").cast(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"r", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"s", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"i", (DataType)DataTypes.INT())})), DataTypes.FIELD((String)"s", (DataType)DataTypes.STRING())})), "CAST(f0 AS ROW<r ROW<s STRING NOT NULL, b BOOLEAN, i INT>, s STRING>)", Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{"12", true, null}), "Hello"}), (AbstractDataType<?>)DataTypes.of((String)"ROW<r ROW<s STRING, b BOOLEAN, i INT>, s STRING>")), BuiltInFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.CAST, "explicit with nested rows and explicit nullability change").onFieldsWithData(Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{12, 42, null}), "Hello"})).andDataTypes(new AbstractDataType[]{DataTypes.of((String)"ROW<r ROW<i1 INT, i2 INT, i3 INT>, s STRING>")}).testTableApiResult((Expression)Expressions.$((String)"f0").cast(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"r", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"s", (DataType)((DataType)DataTypes.STRING().notNull())), DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"i", (DataType)DataTypes.INT())})), DataTypes.FIELD((String)"s", (DataType)DataTypes.STRING())})), Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{"12", true, null}), "Hello"}), (AbstractDataType<?>)DataTypes.of((String)"ROW<r ROW<s STRING NOT NULL, b BOOLEAN, i INT>, s STRING>")), BuiltInFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.CAST, "implicit between structured type and row").onFieldsWithData(12, "Ingo").withFunction(StructuredTypeConstructor.class).withFunction(RowToFirstField.class).testResult((Expression)Expressions.call((String)"RowToFirstField", (Object[])new Object[]{Expressions.call((String)"StructuredTypeConstructor", (Object[])new Object[]{Expressions.row((Object)Expressions.$((String)"f0"), (Object[])new Object[]{Expressions.$((String)"f1")})})}), "RowToFirstField(StructuredTypeConstructor((f0, f1)))", 12, (AbstractDataType<?>)DataTypes.INT()), BuiltInFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.CAST, "explicit between structured type and row").onFieldsWithData(12, "Ingo").withFunction(StructuredTypeConstructor.class).testTableApiResult((Expression)Expressions.call((String)"StructuredTypeConstructor", (Object[])new Object[]{Expressions.row((Object)Expressions.$((String)"f0"), (Object[])new Object[]{Expressions.$((String)"f1")})}).cast(DataTypes.ROW((DataType[])new DataType[]{DataTypes.BIGINT(), DataTypes.STRING()})), Row.of((Object[])new Object[]{12L, "Ingo"}), (AbstractDataType<?>)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BIGINT(), DataTypes.STRING()})));
    }

    public static class UserPojo {
        public final Integer i;
        public final String s;

        public UserPojo(Integer i, String s) {
            this.i = i;
            this.s = s;
        }
    }

    public static class StructuredTypeConstructor
    extends ScalarFunction {
        public UserPojo eval(UserPojo pojo) {
            return pojo;
        }
    }

    public static class NestedRowToFirstField
    extends ScalarFunction {
        @DataTypeHint(value="ROW<i INT, d DOUBLE>")
        public Row eval(@DataTypeHint(value="ROW<r ROW<i INT, d DOUBLE>, s STRING>") Row row2) {
            assert (row2.getField(0) instanceof Row);
            assert (row2.getField(1) instanceof String);
            return (Row)row2.getField(0);
        }
    }

    public static class RowToFirstField
    extends ScalarFunction {
        public Integer eval(@DataTypeHint(value="ROW<i INT, s STRING>") Row row2) {
            assert (row2.getField(0) instanceof Integer);
            assert (row2.getField(1) instanceof String);
            return (Integer)row2.getField(0);
        }
    }
}

