/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.Preconditions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class BuiltInFunctionTestBase {
    @ClassRule
    public static MiniClusterWithClientResource miniClusterResource = new MiniClusterWithClientResource(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(1).build());
    @Parameterized.Parameter
    public TestSpec testSpec;

    @Test
    public void testFunction() {
        Table inputTable;
        TableEnvironment env = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.newInstance().build());
        this.testSpec.functions.forEach(f -> env.createTemporarySystemFunction(f.getSimpleName(), f));
        DataTypeFactory dataTypeFactory = ((TableEnvironmentInternal)env).getCatalogManager().getDataTypeFactory();
        if (this.testSpec.fieldDataTypes == null) {
            inputTable = env.fromValues(new Object[]{Row.of((Object[])this.testSpec.fieldData)});
        } else {
            DataTypes.UnresolvedField[] fields = (DataTypes.UnresolvedField[])IntStream.range(0, this.testSpec.fieldDataTypes.length).mapToObj(i -> DataTypes.FIELD((String)("f" + i), (AbstractDataType)this.testSpec.fieldDataTypes[i])).toArray(DataTypes.UnresolvedField[]::new);
            inputTable = env.fromValues((AbstractDataType)DataTypes.ROW((DataTypes.AbstractField[])fields), new Object[]{Row.of((Object[])this.testSpec.fieldData)});
        }
        for (TestItem testItem : this.testSpec.testItems) {
            try {
                if (testItem instanceof TableApiResultTestItem) {
                    BuiltInFunctionTestBase.testTableApiResult(dataTypeFactory, inputTable, (TableApiResultTestItem)testItem);
                    continue;
                }
                if (testItem instanceof TableApiErrorTestItem) {
                    BuiltInFunctionTestBase.testTableApiError(inputTable, (TableApiErrorTestItem)testItem);
                    continue;
                }
                if (testItem instanceof SqlResultTestItem) {
                    BuiltInFunctionTestBase.testSqlResult(dataTypeFactory, env, inputTable, (SqlResultTestItem)testItem);
                    continue;
                }
                if (!(testItem instanceof SqlErrorTestItem)) continue;
                BuiltInFunctionTestBase.testSqlError(env, inputTable, (SqlErrorTestItem)testItem);
            }
            catch (Throwable t) {
                throw new AssertionError("Failing test item: " + testItem.toString(), t);
            }
        }
    }

    private static void testTableApiResult(DataTypeFactory dataTypeFactory, Table inputTable, TableApiResultTestItem testItem) {
        BuiltInFunctionTestBase.testResult(dataTypeFactory, inputTable.select(new Expression[]{testItem.expression}), testItem);
    }

    private static void testTableApiError(Table inputTable, TableApiErrorTestItem testItem) {
        try {
            TableResult tableResult = inputTable.select(new Expression[]{testItem.expression}).execute();
            if (testItem.expectedDuringValidation) {
                Assert.fail((String)("Error expected: " + testItem.errorMessage));
            }
            try {
                tableResult.await();
                Assert.fail((String)("Error expected: " + testItem.errorMessage));
            }
            catch (AssertionError e) {
                throw e;
            }
            catch (Throwable t) {
                Assert.assertThat((Object)t, (Matcher)FlinkMatchers.containsMessage((String)testItem.errorMessage));
            }
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)FlinkMatchers.containsCause((Throwable)new ValidationException(testItem.errorMessage)));
        }
    }

    private static void testSqlResult(DataTypeFactory dataTypeFactory, TableEnvironment env, Table inputTable, SqlResultTestItem testItem) {
        BuiltInFunctionTestBase.testResult(dataTypeFactory, env.sqlQuery("SELECT " + testItem.expression + " FROM " + inputTable), testItem);
    }

    private static void testSqlError(TableEnvironment env, Table inputTable, SqlErrorTestItem testItem) {
        try {
            TableResult tableResult = env.sqlQuery("SELECT " + testItem.expression + " FROM " + inputTable).execute();
            if (testItem.expectedDuringValidation) {
                Assert.fail((String)("Error expected: " + testItem.errorMessage));
            }
            try {
                tableResult.await();
                Assert.fail((String)("Error expected: " + testItem.errorMessage));
            }
            catch (AssertionError e) {
                throw e;
            }
            catch (Throwable t) {
                Assert.assertThat((Object)t, (Matcher)FlinkMatchers.containsMessage((String)testItem.errorMessage));
            }
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)(t instanceof ValidationException));
            Assert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.containsString((String)testItem.errorMessage));
        }
    }

    private static void testResult(DataTypeFactory dataTypeFactory, Table resultTable, ResultTestItem testItem) {
        DataType expectedDataType = dataTypeFactory.createDataType(testItem.dataType);
        TableResult result = resultTable.execute();
        CloseableIterator iterator = result.collect();
        Assert.assertTrue((boolean)iterator.hasNext());
        Row row2 = (Row)iterator.next();
        Assert.assertFalse((String)"No more rows expected.", (boolean)iterator.hasNext());
        Assert.assertEquals((String)"Only 1 column expected.", (long)1L, (long)row2.getArity());
        Assert.assertEquals((String)"Logical type doesn't match.", (Object)expectedDataType.getLogicalType(), (Object)((DataType)result.getResolvedSchema().getColumnDataTypes().get(0)).getLogicalType());
        Assert.assertEquals((String)"Result doesn't match.", (Object)testItem.result, (Object)row2.getField(0));
    }

    private static class SqlErrorTestItem
    extends ErrorTestItem {
        final String expression;

        private SqlErrorTestItem(String expression, String errorMessage, boolean expectedDuringValidation) {
            super(errorMessage, expectedDuringValidation);
            this.expression = expression;
        }

        public String toString() {
            return "[SQL] " + this.expression;
        }
    }

    private static class SqlResultTestItem
    extends ResultTestItem {
        final String expression;

        SqlResultTestItem(String expression, Object result, AbstractDataType<?> dataType) {
            super(result, dataType);
            this.expression = expression;
        }

        public String toString() {
            return "[SQL] " + this.expression;
        }
    }

    private static class TableApiErrorTestItem
    extends ErrorTestItem {
        final Expression expression;

        TableApiErrorTestItem(Expression expression, String errorMessage, boolean expectedDuringValidation) {
            super(errorMessage, expectedDuringValidation);
            this.expression = expression;
        }

        public String toString() {
            return "[API] " + this.expression.asSummaryString();
        }
    }

    private static class TableApiResultTestItem
    extends ResultTestItem {
        final Expression expression;

        TableApiResultTestItem(Expression expression, Object result, AbstractDataType<?> dataType) {
            super(result, dataType);
            this.expression = expression;
        }

        public String toString() {
            return "[API] " + this.expression.asSummaryString();
        }
    }

    private static class ErrorTestItem
    implements TestItem {
        final String errorMessage;
        boolean expectedDuringValidation;

        ErrorTestItem(String errorMessage, boolean expectedDuringValidation) {
            this.errorMessage = errorMessage;
            this.expectedDuringValidation = expectedDuringValidation;
        }
    }

    private static class ResultTestItem
    implements TestItem {
        final Object result;
        final AbstractDataType<?> dataType;

        ResultTestItem(Object result, AbstractDataType<?> dataType) {
            this.result = result;
            this.dataType = dataType;
        }
    }

    private static interface TestItem {
    }

    protected static class TestSpec {
        @Nullable
        private final BuiltInFunctionDefinition definition;
        @Nullable
        private final String description;
        private final List<Class<? extends UserDefinedFunction>> functions;
        private final List<TestItem> testItems;
        private Object[] fieldData;
        @Nullable
        private AbstractDataType<?>[] fieldDataTypes;

        private TestSpec(BuiltInFunctionDefinition definition, @Nullable String description) {
            this.definition = definition;
            this.description = description;
            this.functions = new ArrayList<Class<? extends UserDefinedFunction>>();
            this.testItems = new ArrayList<TestItem>();
        }

        static TestSpec forFunction(BuiltInFunctionDefinition definition) {
            return TestSpec.forFunction(definition, null);
        }

        static TestSpec forFunction(BuiltInFunctionDefinition definition, String description) {
            return new TestSpec((BuiltInFunctionDefinition)Preconditions.checkNotNull((Object)definition), description);
        }

        static TestSpec forExpression(String description) {
            return new TestSpec(null, (String)Preconditions.checkNotNull((Object)description));
        }

        TestSpec onFieldsWithData(Object ... fieldData) {
            this.fieldData = fieldData;
            return this;
        }

        TestSpec andDataTypes(AbstractDataType<?> ... fieldDataType) {
            this.fieldDataTypes = fieldDataType;
            return this;
        }

        TestSpec withFunction(Class<? extends UserDefinedFunction> functionClass) {
            this.functions.add(functionClass);
            return this;
        }

        TestSpec testTableApiResult(Expression expression, Object result, AbstractDataType<?> dataType) {
            this.testItems.add(new TableApiResultTestItem(expression, result, dataType));
            return this;
        }

        TestSpec testTableApiValidationError(Expression expression, String errorMessage) {
            this.testItems.add(new TableApiErrorTestItem(expression, errorMessage, true));
            return this;
        }

        TestSpec testTableApiRuntimeError(Expression expression, String errorMessage) {
            this.testItems.add(new TableApiErrorTestItem(expression, errorMessage, false));
            return this;
        }

        TestSpec testSqlResult(String expression, Object result, AbstractDataType<?> dataType) {
            this.testItems.add(new SqlResultTestItem(expression, result, dataType));
            return this;
        }

        TestSpec testSqlValidationError(String expression, String errorMessage) {
            this.testItems.add(new SqlErrorTestItem(expression, errorMessage, true));
            return this;
        }

        TestSpec testSqlRuntimeError(String expression, String errorMessage) {
            this.testItems.add(new SqlErrorTestItem(expression, errorMessage, false));
            return this;
        }

        TestSpec testResult(Expression expression, String sqlExpression, Object result, AbstractDataType<?> dataType) {
            return this.testResult(expression, sqlExpression, result, dataType, dataType);
        }

        TestSpec testResult(Expression expression, String sqlExpression, Object result, AbstractDataType<?> tableApiDataType, AbstractDataType<?> sqlDataType) {
            this.testItems.add(new TableApiResultTestItem(expression, result, tableApiDataType));
            this.testItems.add(new SqlResultTestItem(sqlExpression, result, sqlDataType));
            return this;
        }

        public String toString() {
            return (this.definition != null ? this.definition.getName() : "Expression") + (this.description != null ? " : " + this.description : "");
        }
    }
}

