/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.ExpressionTestBase;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.junit.Test;
import scala.Double$;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0001\u001f\tyA)Z2j[\u0006dG+\u001f9f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!A\u0004qY\u0006tg.\u001a:\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0003'\t\tQ!\u001e;jYNL!!\u0006\n\u0003%\u0015C\bO]3tg&|g\u000eV3ti\n\u000b7/\u001a\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003\tAQ\u0001\b\u0001\u0005\u0002u\t1\u0003^3ti\u0012+7-[7bY2KG/\u001a:bYN$\u0012A\b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0005+:LG\u000f\u000b\u0002\u001cKA\u0011a%K\u0007\u0002O)\u0011\u0001\u0006D\u0001\u0006UVt\u0017\u000e^\u0005\u0003U\u001d\u0012A\u0001V3ti\")A\u0006\u0001C\u0001;\u0005\u0011B/Z:u\t\u0016\u001c\u0017.\\1m\u0005>\u0014H-\u001a:tQ\tYS\u0005C\u00030\u0001\u0011\u0005Q$A\ruKN$H)\u001a4bk2$H)Z2j[\u0006d7)Y:uS:<\u0007F\u0001\u0018&\u0011\u0015\u0011\u0004\u0001\"\u0001\u001e\u0003I!Xm\u001d;EK\u000eLW.\u00197DCN$\u0018N\\4)\u0005E*\u0003\"B\u001b\u0001\t\u0003i\u0012!\u0006;fgR$UmY5nC2\f%/\u001b;i[\u0016$\u0018n\u0019\u0015\u0003i\u0015BQ\u0001\u000f\u0001\u0005\u0002u\tQ\u0003^3ti\u0012+7-[7bY\u000e{W\u000e]1sSN|g\u000e\u000b\u00028K!)1\b\u0001C\u0001;\u0005yA/Z:u\r&,G\u000eZ!dG\u0016\u001c8\u000f\u000b\u0002;K!)a\b\u0001C\u0001;\u0005\u0011B/Z:u+:\f'/\u001f)mkNl\u0015N\\;tQ\tiT\u0005C\u0003B\u0001\u0011\u0005Q$A\u0007uKN$\b\u000b\\;t\u001b&tWo\u001d\u0015\u0003\u0001\u0016BQ\u0001\u0012\u0001\u0005\u0002u\tA\u0002^3ti6+H\u000e^5qYfD#aQ\u0013\t\u000b\u001d\u0003A\u0011A\u000f\u0002\u0015Q,7\u000f\u001e#jm&$W\r\u000b\u0002GK!)!\n\u0001C\u0001;\u00059A/Z:u\u001b>$\u0007FA%&\u0011\u0015i\u0005\u0001\"\u0001\u001e\u0003U!Xm\u001d;Fq\u0006\u001cG/[8o\rVt7\r^5p]ND#\u0001T\u0013\t\u000bA\u0003A\u0011A\u000f\u00021Q,7\u000f^!qaJ|\u00070[7bi\u00164UO\\2uS>t7\u000f\u000b\u0002PK!)1\u000b\u0001C\u0001;\u0005aA/Z:u\u0007\u0006\u001cXm\u00165f]\"\u0012!+\n\u0005\u0006-\u0002!\t!H\u0001\ti\u0016\u001cHoQ1ti\"\u0012Q+\n\u0005\u00063\u0002!\t!H\u0001\ri\u0016\u001cH/R9vC2LG/\u001f\u0015\u00031\u0016BQ\u0001\u0018\u0001\u0005\u0002u\ta\u0002^3ti\u000e{W\u000e]1sSN|g\u000e\u000b\u0002\\K!)q\f\u0001C\u0001;\u0005iB/Z:u\u0007>l\u0007/\u0019:f\t\u0016\u001c\u0017.\\1m\u0007>dw+\u001b;i\u001dVdG\u000e\u000b\u0002_K!)!\r\u0001C!G\u0006AA/Z:u\t\u0006$\u0018-F\u0001e!\t)\u0007.D\u0001g\u0015\t9\u0007\"A\u0003usB,7/\u0003\u0002jM\n\u0019!k\\<\t\u000b-\u0004A\u0011\t7\u0002\u0019Q,7\u000f\u001e#bi\u0006$\u0016\u0010]3\u0016\u00035\u0004\"A\u001c9\u000e\u0003=T!a\u001a\u0004\n\u0005E|'\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000bM\u0004A\u0011\t;\u0002'\r|g\u000e^1j]NdUmZ1dsRK\b/Z:\u0016\u0003U\u0004\"a\b<\n\u0005]\u0004#a\u0002\"p_2,\u0017M\u001c")
public class DecimalTypeTest
extends ExpressionTestBase {
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("f3");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("f0");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("f4");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("f1");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("f5");
    private static Symbol symbol$6 = Symbol$.MODULE$.apply("f37");
    private static Symbol symbol$7 = Symbol$.MODULE$.apply("f6");
    private static Symbol symbol$8 = Symbol$.MODULE$.apply("f7");
    private static Symbol symbol$9 = Symbol$.MODULE$.apply("f8");
    private static Symbol symbol$10 = Symbol$.MODULE$.apply("f9");
    private static Symbol symbol$11 = Symbol$.MODULE$.apply("f10");
    private static Symbol symbol$12 = Symbol$.MODULE$.apply("f11");
    private static Symbol symbol$13 = Symbol$.MODULE$.apply("f12");
    private static Symbol symbol$14 = Symbol$.MODULE$.apply("f13");
    private static Symbol symbol$15 = Symbol$.MODULE$.apply("f14");
    private static Symbol symbol$16 = Symbol$.MODULE$.apply("f2");
    private static Symbol symbol$17 = Symbol$.MODULE$.apply("f15");
    private static Symbol symbol$18 = Symbol$.MODULE$.apply("f16");
    private static Symbol symbol$19 = Symbol$.MODULE$.apply("f17");
    private static Symbol symbol$20 = Symbol$.MODULE$.apply("f18");
    private static Symbol symbol$21 = Symbol$.MODULE$.apply("f19");
    private static Symbol symbol$22 = Symbol$.MODULE$.apply("f20");
    private static Symbol symbol$23 = Symbol$.MODULE$.apply("f21");
    private static Symbol symbol$24 = Symbol$.MODULE$.apply("f22");
    private static Symbol symbol$25 = Symbol$.MODULE$.apply("f23");
    private static Symbol symbol$26 = Symbol$.MODULE$.apply("f24");
    private static Symbol symbol$27 = Symbol$.MODULE$.apply("f25");
    private static Symbol symbol$28 = Symbol$.MODULE$.apply("f26");
    private static Symbol symbol$29 = Symbol$.MODULE$.apply("f27");
    private static Symbol symbol$30 = Symbol$.MODULE$.apply("f28");
    private static Symbol symbol$31 = Symbol$.MODULE$.apply("f29");
    private static Symbol symbol$32 = Symbol$.MODULE$.apply("f30");
    private static Symbol symbol$33 = Symbol$.MODULE$.apply("f31");
    private static Symbol symbol$34 = Symbol$.MODULE$.apply("f32");
    private static Symbol symbol$35 = Symbol$.MODULE$.apply("f33");
    private static Symbol symbol$36 = Symbol$.MODULE$.apply("f34");
    private static Symbol symbol$37 = Symbol$.MODULE$.apply("f35");
    private static Symbol symbol$38 = Symbol$.MODULE$.apply("f36");
    private static Symbol symbol$39 = Symbol$.MODULE$.apply("f38");
    private static Symbol symbol$40 = Symbol$.MODULE$.apply("f39");
    private static Symbol symbol$41 = Symbol$.MODULE$.apply("f40");
    private static Symbol symbol$42 = Symbol$.MODULE$.apply("f41");
    private static Symbol symbol$43 = Symbol$.MODULE$.apply("f42");
    private static Symbol symbol$44 = Symbol$.MODULE$.apply("f43");
    private static Symbol symbol$45 = Symbol$.MODULE$.apply("f44");
    private static Symbol symbol$46 = Symbol$.MODULE$.apply("f45");
    private static Symbol symbol$47 = Symbol$.MODULE$.apply("f46");
    private static Symbol symbol$48 = Symbol$.MODULE$.apply("f47");
    private static Symbol symbol$49 = Symbol$.MODULE$.apply("f48");
    private static Symbol symbol$50 = Symbol$.MODULE$.apply("f49");
    private static Symbol symbol$51 = Symbol$.MODULE$.apply("f50");
    private static Symbol symbol$52 = Symbol$.MODULE$.apply("f51");
    private static Symbol symbol$53 = Symbol$.MODULE$.apply("f52");

    @Test
    public void testDecimalLiterals() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.double2Literal(11.2), "11.2", "11.2");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.double2Literal(0.7623533651719233), "0.7623533651719233", "0.7623533651719233");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.scalaDec2Literal(package$.MODULE$.BigDecimal().apply("1234567891234567891")), "1234567891234567891", "1234567891234567891");
        this.testTableApi(org.apache.flink.table.api.package$.MODULE$.scalaDec2Literal(package$.MODULE$.BigDecimal().apply("123456789123456789123456789")), "123456789123456789123456789p", "123456789123456789123456789");
        this.testTableApi(org.apache.flink.table.api.package$.MODULE$.scalaDec2Literal(package$.MODULE$.BigDecimal().apply("12.3456789123456789123456789")), "12.3456789123456789123456789p", "12.3456789123456789123456789");
    }

    @Test
    public void testDecimalBorders() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.double2Literal(Double.MAX_VALUE), ((Object)BoxesRunTime.boxToDouble((double)Double.MAX_VALUE)).toString(), ((Object)BoxesRunTime.boxToDouble((double)Double.MAX_VALUE)).toString());
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.double2Literal(Double$.MODULE$.MinValue()), ((Object)BoxesRunTime.boxToDouble((double)Double$.MODULE$.MinValue())).toString(), ((Object)BoxesRunTime.boxToDouble((double)Double$.MODULE$.MinValue())).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralDoubleExpression(Double$.MODULE$.MinValue()).cast(DataTypes.FLOAT()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS FLOAT)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)Double$.MODULE$.MinValue())})), ((Object)BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY)).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralByteExpression((byte)-128).cast(DataTypes.TINYINT()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS TINYINT)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)-128)})), ((Object)BoxesRunTime.boxToByte((byte)-128)).toString());
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralByteExpression((byte)-128).cast(DataTypes.TINYINT())).$minus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).cast(DataTypes.TINYINT())), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS TINYINT) - CAST(1 AS TINYINT)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)-128)})), ((Object)BoxesRunTime.boxToByte((byte)127)).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralShortExpression((short)Short.MIN_VALUE).cast(DataTypes.SMALLINT()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS SMALLINT)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)Short.MIN_VALUE)})), ((Object)BoxesRunTime.boxToShort((short)Short.MIN_VALUE)).toString());
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(Integer.MIN_VALUE).cast(DataTypes.INT())).$minus(org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS INT) - 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE)})), ((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralLongExpression(Long.MIN_VALUE).cast(DataTypes.BIGINT()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS BIGINT)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MIN_VALUE)})), ((Object)BoxesRunTime.boxToLong((long)Long.MIN_VALUE)).toString());
    }

    @Test
    public void testDefaultDecimalCasting() {
        this.testTableApi((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("123456789123456789123456789").cast(DataTypes.DECIMAL((int)38, (int)0)), "123456789123456789123456789");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).cast(DataTypes.DECIMAL((int)38, (int)0)), "CAST(f3 AS DECIMAL)", "4");
    }

    @Test
    public void testDecimalCasting() {
        this.testSqlApi("CAST(f3 AS DECIMAL(10,2))", "4.20");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$2).cast(DataTypes.DOUBLE()), "CAST(f0 AS DOUBLE)", "1.2345678912345679E8");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).cast(DataTypes.INT()), "CAST(f4 AS INT)", "123456789");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).cast(DataTypes.BIGINT()), "CAST(f4 AS BIGINT)", "123456789");
        this.testTableApi((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).cast(DataTypes.BOOLEAN()), "true");
        this.testTableApi((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$5).cast(DataTypes.BOOLEAN()), "false");
        this.testTableApi((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralScalaDecimalExpression(package$.MODULE$.BigDecimal().apply("123456789.123456789123456789")).cast(DataTypes.DOUBLE()), "1.2345678912345679E8");
        this.testSqlApi("CAST(CAST(f67 AS DECIMAL(10, 5)) AS VARCHAR)", "1.00000");
    }

    @Test
    public void testDecimalArithmetic() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).$plus(org.apache.flink.table.api.package$.MODULE$.int2Literal(12)), "f1 + 12", "123456789123456789123456801");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)12))).$plus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4)), "12 + f1", "123456789123456789123456801");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).$plus(org.apache.flink.table.api.package$.MODULE$.scalaDec2Literal(package$.MODULE$.BigDecimal().apply("12.3"))), "f1 + 12.3", "123456789123456789123456801.3");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.lit((Object)package$.MODULE$.BigDecimal().apply("12.3").bigDecimal())).$plus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4)), "12.3 + f1", "123456789123456789123456801.3");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).$plus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4)), "f1 + f1", "246913578246913578246913578");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).$minus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4)), "f1 - f1", "0");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).$div(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4)), "f1 / f1", "1.00000000");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).$percent(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4)), "MOD(f1, f1)", "0");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$2).unary_$minus(), "-f0", "-123456789.123456789123456789");
    }

    @Test
    public void testDecimalComparison() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).$less(org.apache.flink.table.api.package$.MODULE$.int2Literal(12)), "f1 < 12", "false");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).$greater(org.apache.flink.table.api.package$.MODULE$.int2Literal(12)), "f1 > 12", "true");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.int2Literal(12)), "f1 = 12", "false");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$5).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.int2Literal(0)), "f5 = 0", "true");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.scalaDec2Literal(package$.MODULE$.BigDecimal().apply("123456789123456789123456789"))), "f1 = CAST('123456789123456789123456789' AS DECIMAL(30, 0))", "true");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).$bang$eq$eq(org.apache.flink.table.api.package$.MODULE$.scalaDec2Literal(package$.MODULE$.BigDecimal().apply("123456789123456789123456789"))), "f1 <> CAST('123456789123456789123456789' AS DECIMAL(30, 0))", "false");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).$less(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2)), "f4 < f0", "true");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(12).toExpr()).$less(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4)), "12 < f1", "true");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(12).toExpr()).$greater(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$4)), "12 > f1", "12 > f1", "false");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(12).toExpr()).$minus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$6)), "12 - f37", "10");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(12).toExpr()).$plus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$6)), "12 + f37", "14");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(12).toExpr()).$times(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$6)), "12 * f37", "24");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(12).toExpr()).$div(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$6)), "12 / f37", "6");
    }

    @Test
    public void testFieldAccess() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$7), "f6", "123");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$8), "f7", "123.45");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$9), "f8", "100.00");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$9).$plus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$9)), "f8 + f8", "200.00");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$10), "f9", "100.10");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$10).$plus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$10)), "f9 + f9", "200.20");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$11), "f10", "100.00");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$11).$plus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$11)), "f10 + f10", "200.00");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$12), "f11", "null");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$13), "f12", "null");
    }

    @Test
    public void testUnaryPlusMinus() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).unary_$plus(), "+f6", "123");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$8).unary_$minus(), "-f7", "-f7", "-123.45");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).unary_$plus()).$minus(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$8).unary_$minus())).unary_$minus(), "- (( + f6) - ( - f7))", "-246.45");
    }

    @Test
    public void testPlusMinus() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$14).$plus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$15)), "f13 + f14", "300.2434");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$14).$minus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$15)), "f13 - f14", "-100.0034");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$8).$plus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$16)), "f7 + f2", "165.45");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).$plus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$8)), "f2 + f7", "165.45");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$8).$plus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1)), "f7 + f3", "127.65");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).$plus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$8)), "f3 + f7", "127.65");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$17).$plus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$18)), "f15 + f16", "300.024691358");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$17).$minus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$18)), "f15 - f16", "-100.000000000");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$19).$plus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$20)), "f17 + f18", "10000000000.000000000");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$19).$minus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$20)), "f17 - f18", "10000000000.000000000");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$21).$plus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$21)), "f19 + f19", "null");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$21).$plus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$21))).$minus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$21)), "f19 + f19 - f19", "null");
    }

    @Test
    public void testMultiply() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$22).$times(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$22)), "f20 * f20", "1.0000");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$22).$times(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$23)), "f20 * f21", "2.000000");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$22).$times(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$24)), "f20 * f22", "200.00");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$24).$times(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$22)), "f22 * f20", "200.00");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$22).$times(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$25)), "f20 * f23", "3.14");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$25).$times(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$22)), "f23 * f20", "3.14");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$26).$times(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$26)), "f24 * f24", "1.000000");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$26).$times(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$27)), "f24 * f25", "2.000000");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$28).$times(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$28)), "f26 * f26", "0.00010000000000000");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$29).$times(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$30)), "f27 * f28", "0.000001");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$31).$times(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$31)), "f29 * f29", "null");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$32).$times(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$32)), "f30 * f30", "1.00000000000000000");
    }

    @Test
    public void testDivide() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$33).$div(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$34)), "f31 / f32", "0.333333");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$33).$div(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$35)), "f31 / f33", "0.3333333");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$33).$div(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$36)), "f31 / f34", "f31 / f34", "0.3333333333");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$33).$div(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$37)), "f31 / f35", "0.333333");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$38).$div(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$6)), "f36 / f37", "0.5000000000000");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$6).$div(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$38)), "f37 / f36", "2.00000000000");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$38).$div(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$39)), "f36 / f38", ((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)).toString());
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$39).$div(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$38)), "f38 / f36", ((Object)BoxesRunTime.boxToDouble((double)3.0)).toString());
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$40).$div(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$41)), "f39 / f40", "null");
    }

    @Test
    public void testMod() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$42).$percent(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$43)), "mod(f41, f42)", "3.0000");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$43).$percent(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$42)), "mod(f42, f41)", "2.0000");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$42).$percent(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$44)), "mod(f41, f43)", "3.00");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$44).$percent(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$42)), "mod(f43, f41)", "1.00");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$45).$percent(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$46)), "mod(f44, f45)", ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$45).unary_$minus()).$percent(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$46)), "mod(-f44, f45)", ((Object)BoxesRunTime.boxToInteger((int)-3)).toString());
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$45).$percent(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$46).unary_$minus()), "mod(f44, -f45)", ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$45).unary_$minus()).$percent(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$46).unary_$minus()), "mod(-f44, -f45)", ((Object)BoxesRunTime.boxToInteger((int)-3)).toString());
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$47).$percent(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$48)), "mod(f46, f47)", "3.1234");
    }

    @Test
    public void testExactionFunctions() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.ifThenElse(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$49).$greater(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$50)), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$49), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$50)), "if(f48 > f49, f48, f49)", "3.14");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$49).abs(), "abs(f48)", "3.14");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$49).unary_$minus()).abs(), "abs(-f48)", "3.14");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$49).floor(), "floor(f48)", "3");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$49).ceil(), "ceil(f48)", "4");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$49).sign(), "sign(f48)", "1.00");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$49).unary_$minus()).sign(), "sign(-f48)", "-1.00");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$49).$minus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$49))).sign(), "sign(f48 - f48)", "0.00");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$51).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(0)), "round(f50)", "647");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$51).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(0)), "round(f50,0)", "647");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$51).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "round(f50,1)", "646.6");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$51).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), "f50.round(2)", "round(f50,2)", "646.65");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$51).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(3)), "round(f50,3)", "646.646");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$51).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(4)), "round(f50,4)", "646.646");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$51).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-1)), "round(f50,-1)", "650");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$51).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-2)), "round(f50,-2)", "600");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$51).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-3)), "round(f50,-3)", "1000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$51).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-4)), "round(f50,-4)", "0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$52).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "round(f51,1)", "100.0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$52).unary_$minus()).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "round(-f51,1)", "-100.0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$52).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-1)), "round(f51,-1)", "100");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$52).unary_$minus()).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-1)), "round(-f51,-1)", "-100");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$53).round((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-1)), "round(f52,-1)", "null");
    }

    @Test
    public void testApproximateFunctions() {
    }

    @Test
    public void testCaseWhen() {
        this.testSqlApi("case f53 when 0 then f53 else f54 end", "0.0100");
        this.testSqlApi("case f53 when 0 then f53 else f2 end", "42.0000");
        this.testSqlApi("case f53 when 0 then f23 else f53 end", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.BigDecimal().apply("0.0001").doubleValue())).toString());
    }

    @Test
    public void testCast() {
        this.testSqlApi("cast(f48 as Decimal(8,4))", "3.1400");
        this.testSqlApi("cast(f2 as Decimal(8,4))", "42.0000");
        this.testSqlApi("cast(f3 as Decimal(8,4))", "4.2000");
        this.testSqlApi("cast(f55 as Decimal(8,4))", "3.1400");
        this.testSqlApi("cast(f56 as Decimal(8,1))", "3.2");
        this.testSqlApi("cast(f57 as Decimal(8,1))", "3.2");
        this.testSqlApi("cast(f58 as Decimal(8,1))", "3.2");
        this.testSqlApi("cast(f59 as Decimal(3,2))", "null");
        this.testSqlApi("cast(f60 as VARCHAR(64))", "1.99");
        this.testSqlApi("cast(f61 as DOUBLE)", "1.99");
        this.testSqlApi("cast(f62 as INT)", "1");
    }

    @Test
    public void testEquality() {
        this.testSqlApi("f63=f64", "true");
        this.testSqlApi("f63=f65", "true");
        this.testSqlApi("f63=f66", "true");
        this.testSqlApi("f64=f63", "true");
        this.testSqlApi("f65=f63", "true");
        this.testSqlApi("f66=f63", "true");
        this.testSqlApi("f63 IN(f64)", "true");
        this.testSqlApi("f63 IN(f65)", "true");
        this.testSqlApi("f63 IN(f66)", "true");
        this.testSqlApi("f64 IN(f63)", "true");
        this.testSqlApi("f65 IN(f63)", "true");
        this.testSqlApi("f66 IN(f63)", "true");
        this.testSqlApi("f63 IS DISTINCT FROM f64", "false");
        this.testSqlApi("f64 IS DISTINCT FROM f63", "false");
        this.testSqlApi("f63 IS DISTINCT FROM f65", "false");
        this.testSqlApi("f65 IS DISTINCT FROM f63", "false");
        this.testSqlApi("f63 IS DISTINCT FROM f66", "false");
        this.testSqlApi("f66 IS DISTINCT FROM f63", "false");
        this.testSqlApi("NULLIF(f63,f64)", "null");
        this.testSqlApi("NULLIF(f63,f65)", "null");
        this.testSqlApi("NULLIF(f63,f66)", "null");
        this.testSqlApi("NULLIF(f64,f63)", "null");
        this.testSqlApi("NULLIF(f65,f63)", "null");
        this.testSqlApi("NULLIF(f66,f63)", "null");
        this.testSqlApi("NULLIF(f63,f64)", "null");
        this.testSqlApi("case f63 when f64 then 1 else 0 end", "1");
        this.testSqlApi("case f63 when f65 then 1 else 0 end", "1");
        this.testSqlApi("case f63 when f66 then 1 else 0 end", "1");
        this.testSqlApi("case f64 when f63 then 1 else 0 end", "1");
        this.testSqlApi("case f65 when f64 then 1 else 0 end", "1");
        this.testSqlApi("case f66 when f65 then 1 else 0 end", "1");
    }

    @Test
    public void testComparison() {
        this.testSqlApi("f63 < f64", "false");
        this.testSqlApi("f63 < f65", "false");
        this.testSqlApi("f63 < f66", "false");
        this.testSqlApi("f64 < f63", "false");
        this.testSqlApi("f65 < f63", "false");
        this.testSqlApi("f66 < f63", "false");
        this.testSqlApi("f67 < f68", "true");
        this.testSqlApi("f67 < f69", "true");
        this.testSqlApi("f67 < f70", "true");
        this.testSqlApi("f68 < f67", "false");
        this.testSqlApi("f69 < f67", "false");
        this.testSqlApi("f70 < f67", "false");
        this.testSqlApi("f63 between f64 and 1", "true");
        this.testSqlApi("f64 between f63 and 1", "true");
        this.testSqlApi("f63 between f65 and 1", "true");
        this.testSqlApi("f65 between f63 and 1", "true");
        this.testSqlApi("f63 between f66 and 1", "true");
        this.testSqlApi("f66 between f63 and 1", "true");
        this.testSqlApi("f63 between 0 and f64", "true");
        this.testSqlApi("f64 between 0 and f63", "true");
        this.testSqlApi("f63 between 0 and f65", "true");
        this.testSqlApi("f65 between 0 and f63", "true");
        this.testSqlApi("f63 between 0 and f66", "true");
        this.testSqlApi("f66 between 0 and f63", "true");
    }

    @Test
    public void testCompareDecimalColWithNull() {
        this.testSqlApi("f35>cast(1234567890123.123 as decimal(20,16))", "null");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Row testData() {
        void var1_1;
        Row testData = new Row(71);
        testData.setField(0, (Object)package$.MODULE$.BigDecimal().apply("123456789.123456789123456789").bigDecimal());
        testData.setField(1, (Object)package$.MODULE$.BigDecimal().apply("123456789123456789123456789").bigDecimal());
        testData.setField(2, (Object)BoxesRunTime.boxToInteger((int)42));
        testData.setField(3, (Object)BoxesRunTime.boxToDouble((double)4.2));
        testData.setField(4, (Object)package$.MODULE$.BigDecimal().apply("123456789").bigDecimal());
        testData.setField(5, (Object)package$.MODULE$.BigDecimal().apply("0.000").bigDecimal());
        testData.setField(6, (Object)package$.MODULE$.BigDecimal().apply("123").bigDecimal());
        testData.setField(7, (Object)package$.MODULE$.BigDecimal().apply("123.45").bigDecimal());
        testData.setField(8, (Object)package$.MODULE$.BigDecimal().apply("100.004").bigDecimal());
        testData.setField(9, (Object)package$.MODULE$.BigDecimal().apply("100.1").bigDecimal());
        testData.setField(10, (Object)package$.MODULE$.BigDecimal().apply("100.0040").bigDecimal());
        testData.setField(11, (Object)package$.MODULE$.BigDecimal().apply("123").bigDecimal());
        testData.setField(12, (Object)package$.MODULE$.BigDecimal().apply("123.0000").bigDecimal());
        testData.setField(13, (Object)package$.MODULE$.BigDecimal().apply("100.12").bigDecimal());
        testData.setField(14, (Object)package$.MODULE$.BigDecimal().apply("200.1234").bigDecimal());
        testData.setField(15, (Object)package$.MODULE$.BigDecimal().apply("100.0123456789").bigDecimal());
        testData.setField(16, (Object)package$.MODULE$.BigDecimal().apply("200.0123456789012345678901234567").bigDecimal());
        testData.setField(17, (Object)package$.MODULE$.BigDecimal().apply("1e10").bigDecimal());
        testData.setField(18, (Object)package$.MODULE$.BigDecimal().apply("0").bigDecimal());
        testData.setField(19, (Object)package$.MODULE$.BigDecimal().apply("5e37").bigDecimal());
        testData.setField(20, (Object)package$.MODULE$.BigDecimal().apply("1.00").bigDecimal());
        testData.setField(21, (Object)package$.MODULE$.BigDecimal().apply("2.0000").bigDecimal());
        testData.setField(22, (Object)BoxesRunTime.boxToInteger((int)200));
        testData.setField(23, (Object)BoxesRunTime.boxToDouble((double)3.14));
        testData.setField(24, (Object)package$.MODULE$.BigDecimal().apply("1").bigDecimal());
        testData.setField(25, (Object)package$.MODULE$.BigDecimal().apply("2").bigDecimal());
        testData.setField(26, (Object)package$.MODULE$.BigDecimal().apply("0.01").bigDecimal());
        testData.setField(27, (Object)package$.MODULE$.BigDecimal().apply("0.0000006").bigDecimal());
        testData.setField(28, (Object)package$.MODULE$.BigDecimal().apply("1.0").bigDecimal());
        testData.setField(29, (Object)package$.MODULE$.BigDecimal().apply("1e19").bigDecimal());
        testData.setField(30, (Object)package$.MODULE$.BigDecimal().apply("1.0").bigDecimal());
        testData.setField(31, (Object)package$.MODULE$.BigDecimal().apply("1.00").bigDecimal());
        testData.setField(32, (Object)package$.MODULE$.BigDecimal().apply("3").bigDecimal());
        testData.setField(33, (Object)package$.MODULE$.BigDecimal().apply("3").bigDecimal());
        testData.setField(34, (Object)package$.MODULE$.BigDecimal().apply("3").bigDecimal());
        testData.setField(35, (Object)package$.MODULE$.BigDecimal().apply("3").bigDecimal());
        testData.setField(36, (Object)package$.MODULE$.BigDecimal().apply("1.00").bigDecimal());
        testData.setField(37, (Object)BoxesRunTime.boxToInteger((int)2));
        testData.setField(38, (Object)BoxesRunTime.boxToDouble((double)3.0));
        testData.setField(39, (Object)package$.MODULE$.BigDecimal().apply("1e20").bigDecimal());
        testData.setField(40, (Object)package$.MODULE$.BigDecimal().apply("1e-15").bigDecimal());
        testData.setField(41, (Object)package$.MODULE$.BigDecimal().apply("3.00").bigDecimal());
        testData.setField(42, (Object)package$.MODULE$.BigDecimal().apply("5.00").bigDecimal());
        testData.setField(43, (Object)BoxesRunTime.boxToInteger((int)7));
        testData.setField(44, (Object)package$.MODULE$.BigDecimal().apply("3").bigDecimal());
        testData.setField(45, (Object)package$.MODULE$.BigDecimal().apply("5").bigDecimal());
        testData.setField(46, (Object)package$.MODULE$.BigDecimal().apply("3.1234").bigDecimal());
        testData.setField(47, (Object)package$.MODULE$.BigDecimal().apply("5").bigDecimal());
        testData.setField(48, (Object)package$.MODULE$.BigDecimal().apply("3.14").bigDecimal());
        testData.setField(49, (Object)package$.MODULE$.BigDecimal().apply("2.17").bigDecimal());
        testData.setField(50, (Object)package$.MODULE$.BigDecimal().apply("646.646").bigDecimal());
        testData.setField(51, (Object)package$.MODULE$.BigDecimal().apply("99.99").bigDecimal());
        testData.setField(52, (Object)package$.MODULE$.BigDecimal().apply("1E38").bigDecimal().subtract(package$.MODULE$.BigDecimal().apply("1").bigDecimal()));
        testData.setField(53, (Object)package$.MODULE$.BigDecimal().apply("0.0001").bigDecimal());
        testData.setField(54, (Object)package$.MODULE$.BigDecimal().apply("0.01").bigDecimal());
        testData.setField(55, (Object)"3.14");
        testData.setField(56, (Object)package$.MODULE$.BigDecimal().apply("3.15").bigDecimal());
        testData.setField(57, (Object)BoxesRunTime.boxToDouble((double)3.15));
        testData.setField(58, (Object)"3.15");
        testData.setField(59, (Object)"13.14");
        testData.setField(60, (Object)package$.MODULE$.BigDecimal().apply("1.99").bigDecimal());
        testData.setField(61, (Object)"1.99");
        testData.setField(62, (Object)BoxesRunTime.boxToInteger((int)1));
        testData.setField(63, (Object)package$.MODULE$.BigDecimal().apply("1").bigDecimal());
        testData.setField(64, (Object)package$.MODULE$.BigDecimal().apply("1").bigDecimal());
        testData.setField(65, (Object)BoxesRunTime.boxToInteger((int)1));
        testData.setField(66, (Object)BoxesRunTime.boxToDouble((double)1.0));
        testData.setField(67, (Object)package$.MODULE$.BigDecimal().apply("1").bigDecimal());
        testData.setField(68, (Object)package$.MODULE$.BigDecimal().apply("99").bigDecimal());
        testData.setField(69, (Object)BoxesRunTime.boxToInteger((int)99));
        testData.setField(70, (Object)BoxesRunTime.boxToDouble((double)99.0));
        return var1_1;
    }

    public DataType testDataType() {
        return DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.DECIMAL((int)30, (int)18)), DataTypes.FIELD((String)"f1", (DataType)DataTypes.DECIMAL((int)30, (int)0)), DataTypes.FIELD((String)"f2", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f3", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"f4", (DataType)DataTypes.DECIMAL((int)10, (int)0)), DataTypes.FIELD((String)"f5", (DataType)DataTypes.DECIMAL((int)10, (int)3)), DataTypes.FIELD((String)"f6", (DataType)DataTypes.DECIMAL((int)10, (int)0)), DataTypes.FIELD((String)"f7", (DataType)DataTypes.DECIMAL((int)7, (int)2)), DataTypes.FIELD((String)"f8", (DataType)DataTypes.DECIMAL((int)7, (int)2)), DataTypes.FIELD((String)"f9", (DataType)DataTypes.DECIMAL((int)7, (int)2)), DataTypes.FIELD((String)"f10", (DataType)DataTypes.DECIMAL((int)5, (int)2)), DataTypes.FIELD((String)"f11", (DataType)DataTypes.DECIMAL((int)2, (int)0)), DataTypes.FIELD((String)"f12", (DataType)DataTypes.DECIMAL((int)4, (int)2)), DataTypes.FIELD((String)"f13", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"f14", (DataType)DataTypes.DECIMAL((int)10, (int)4)), DataTypes.FIELD((String)"f15", (DataType)DataTypes.DECIMAL((int)38, (int)10)), DataTypes.FIELD((String)"f16", (DataType)DataTypes.DECIMAL((int)38, (int)28)), DataTypes.FIELD((String)"f17", (DataType)DataTypes.DECIMAL((int)38, (int)10)), DataTypes.FIELD((String)"f18", (DataType)DataTypes.DECIMAL((int)38, (int)28)), DataTypes.FIELD((String)"f19", (DataType)DataTypes.DECIMAL((int)38, (int)0)), DataTypes.FIELD((String)"f20", (DataType)DataTypes.DECIMAL((int)5, (int)2)), DataTypes.FIELD((String)"f21", (DataType)DataTypes.DECIMAL((int)10, (int)4)), DataTypes.FIELD((String)"f22", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f23", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"f24", (DataType)DataTypes.DECIMAL((int)30, (int)6)), DataTypes.FIELD((String)"f25", (DataType)DataTypes.DECIMAL((int)30, (int)10)), DataTypes.FIELD((String)"f26", (DataType)DataTypes.DECIMAL((int)30, (int)20)), DataTypes.FIELD((String)"f27", (DataType)DataTypes.DECIMAL((int)38, (int)10)), DataTypes.FIELD((String)"f28", (DataType)DataTypes.DECIMAL((int)38, (int)10)), DataTypes.FIELD((String)"f29", (DataType)DataTypes.DECIMAL((int)38, (int)0)), DataTypes.FIELD((String)"f30", (DataType)DataTypes.DECIMAL((int)30, (int)20)), DataTypes.FIELD((String)"f31", (DataType)DataTypes.DECIMAL((int)20, (int)2)), DataTypes.FIELD((String)"f32", (DataType)DataTypes.DECIMAL((int)2, (int)1)), DataTypes.FIELD((String)"f33", (DataType)DataTypes.DECIMAL((int)4, (int)3)), DataTypes.FIELD((String)"f34", (DataType)DataTypes.DECIMAL((int)20, (int)10)), DataTypes.FIELD((String)"f35", (DataType)DataTypes.DECIMAL((int)20, (int)16)), DataTypes.FIELD((String)"f36", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"f37", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f38", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"f39", (DataType)DataTypes.DECIMAL((int)30, (int)0)), DataTypes.FIELD((String)"f40", (DataType)DataTypes.DECIMAL((int)30, (int)20)), DataTypes.FIELD((String)"f41", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"f42", (DataType)DataTypes.DECIMAL((int)10, (int)4)), DataTypes.FIELD((String)"f43", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f44", (DataType)DataTypes.DECIMAL((int)1, (int)0)), DataTypes.FIELD((String)"f45", (DataType)DataTypes.DECIMAL((int)1, (int)0)), DataTypes.FIELD((String)"f46", (DataType)DataTypes.DECIMAL((int)10, (int)4)), DataTypes.FIELD((String)"f47", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"f48", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"f49", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"f50", (DataType)DataTypes.DECIMAL((int)10, (int)3)), DataTypes.FIELD((String)"f51", (DataType)DataTypes.DECIMAL((int)4, (int)2)), DataTypes.FIELD((String)"f52", (DataType)DataTypes.DECIMAL((int)38, (int)0)), DataTypes.FIELD((String)"f53", (DataType)DataTypes.DECIMAL((int)8, (int)4)), DataTypes.FIELD((String)"f54", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"f55", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f56", (DataType)DataTypes.DECIMAL((int)8, (int)2)), DataTypes.FIELD((String)"f57", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"f58", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f59", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f60", (DataType)DataTypes.DECIMAL((int)4, (int)2)), DataTypes.FIELD((String)"f61", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f62", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f63", (DataType)DataTypes.DECIMAL((int)8, (int)2)), DataTypes.FIELD((String)"f64", (DataType)DataTypes.DECIMAL((int)8, (int)4)), DataTypes.FIELD((String)"f65", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f66", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"f67", (DataType)DataTypes.DECIMAL((int)1, (int)0)), DataTypes.FIELD((String)"f68", (DataType)DataTypes.DECIMAL((int)2, (int)0)), DataTypes.FIELD((String)"f69", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f70", (DataType)DataTypes.DOUBLE())});
    }

    @Override
    public boolean containsLegacyTypes() {
        return false;
    }
}

