/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;

public class FileSystemTableSourceTest
extends TableTestBase {
    private StreamTableTestUtil util;

    @Before
    public void setup() {
        this.util = this.streamTestUtil(TableConfig.getDefault());
        TableEnvironment tEnv = this.util.getTableEnv();
        String srcTableDdl = "CREATE TABLE MyTable (\n  a bigint,\n  b int,\n  c varchar\n) with (\n 'connector' = 'filesystem', 'format' = 'testcsv', 'path' = '/tmp')";
        tEnv.executeSql(srcTableDdl);
        String sinkTableDdl = "CREATE TABLE MySink (\n  a bigint,\n  b int,\n  c varchar\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        tEnv.executeSql(sinkTableDdl);
    }

    @Test
    public void testFilterPushDown() {
        this.util.verifyRelPlanInsert("insert into MySink select * from MyTable where a > 10");
    }
}

