/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableEnvironmentTest$;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.bridge.scala.StreamStatementSet;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment$;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.factories.TableSourceFactory;
import org.apache.flink.table.factories.TableSourceFactoryContextImpl;
import org.apache.flink.table.module.ModuleEntry;
import org.apache.flink.table.planner.factories.utils.TestCollectionTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.FunctionITCase;
import org.apache.flink.table.planner.runtime.stream.table.FunctionITCase;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.planner.utils.TestTableSourceSinks$;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005f\u0001B\u0001\u0003\u00015\u0011A\u0003V1cY\u0016,eN^5s_:lWM\u001c;UKN$(BA\u0002\u0005\u0003\r\t\u0007/\u001b\u0006\u0003\u000b\u0019\tQ\u0001^1cY\u0016T!a\u0002\u0005\u0002\u000b\u0019d\u0017N\\6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAqA\u0007\u0001C\u0002\u0013\u00051$A\tfqB,7\r^3e\u000bb\u001cW\r\u001d;j_:,\u0012\u0001\b\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\nQA];mKNT!!\t\u0006\u0002\u000b),h.\u001b;\n\u0005\rr\"!E#ya\u0016\u001cG/\u001a3Fq\u000e,\u0007\u000f^5p]\"1Q\u0005\u0001Q\u0001\nq\t!#\u001a=qK\u000e$X\rZ#yG\u0016\u0004H/[8oA!)q\u0005\u0001C\u00017\u00051A\u000f\u001b:po:D#AJ\u0015\u0011\u0005)ZS\"\u0001\u0011\n\u00051\u0002#\u0001\u0002*vY\u0016DqA\f\u0001C\u0002\u0013\u0005q&A\u0002f]Z,\u0012\u0001\r\t\u0003cYj\u0011A\r\u0006\u0003#MR!a\u0001\u001b\u000b\u0005U2\u0011!C:ue\u0016\fW.\u001b8h\u0013\t9$G\u0001\u000eTiJ,\u0017-\\#yK\u000e,H/[8o\u000b:4\u0018N]8o[\u0016tG\u000f\u0003\u0004:\u0001\u0001\u0006I\u0001M\u0001\u0005K:4\b\u0005C\u0004<\u0001\t\u0007I\u0011\u0001\u001f\u0002\u0011Q\f'\r\\3F]Z,\u0012!\u0010\t\u0003}\tk\u0011a\u0010\u0006\u0003#\u0001S!!\u0011\u0002\u0002\r\t\u0014\u0018\u000eZ4f\u0013\t\u0019uH\u0001\fTiJ,\u0017-\u001c+bE2,WI\u001c<je>tW.\u001a8u\u0011\u0019)\u0005\u0001)A\u0005{\u0005IA/\u00192mK\u0016sg\u000f\t\u0005\u0006\u000f\u0002!\t\u0001S\u0001\u0016i\u0016\u001cHoU2b]:{g.\u0012=jgR$\u0016M\u00197f)\u0005I\u0005CA\bK\u0013\tY\u0005C\u0001\u0003V]&$\bF\u0001$N!\tQc*\u0003\u0002PA\t!A+Z:u\u0011\u0015\t\u0006\u0001\"\u0001I\u0003Y!Xm\u001d;SK\u001eL7\u000f^3s\t\u0006$\u0018m\u0015;sK\u0006l\u0007F\u0001)N\u0011\u0015!\u0006\u0001\"\u0001I\u0003=!Xm\u001d;TS6\u0004H.Z)vKJL\bFA*N\u0011\u00159\u0006\u0001\"\u0001I\u0003\u0005\"Xm\u001d;TiJ,\u0017-\u001c+bE2,WI\u001c<je>tW.\u001a8u\u000bb\u0004H.Y5oQ\t1V\nC\u0003[\u0001\u0011\u0005\u0001*\u0001\u001fuKN$8\u000b\u001e:fC6$\u0016M\u00197f\u000b:4\u0018N]8o[\u0016tG/\u0012=fGV$\u0018n\u001c8FqBd\u0017-\u001b8XSRDWI\u001c<QCJ\fG\u000e\\3mSNl\u0007FA-N\u0011\u0015i\u0006\u0001\"\u0001I\u0003u\"Xm\u001d;TiJ,\u0017-\u001c+bE2,WI\u001c<je>tW.\u001a8u\u000bb,7-\u001e;j_:,\u0005\u0010\u001d7bS:<\u0016\u000e\u001e5D_:4\u0007+\u0019:bY2,G.[:nQ\taV\nC\u0003a\u0001\u0011%\u0011-\u0001\u0014wKJLg-\u001f+bE2,WI\u001c<je>tW.\u001a8u\u000bb,7-\u001e;j_:,\u0005\u0010\u001d7bS:$\"!\u00132\t\u000b\r|\u0006\u0019\u00013\u0002\tQ,eN\u001e\t\u00031\u0015L!A\u001a\u0002\u0003!Q\u000b'\r\\3F]ZL'o\u001c8nK:$\b\"\u00025\u0001\t\u0003A\u0015\u0001\t;fgR\u001cF/\u0019;f[\u0016tGoU3u\u000bb,7-\u001e;j_:,\u0005\u0010\u001d7bS:D#aZ'\t\u000b-\u0004A\u0011\u0001%\u0002CQ,7\u000f^!mi\u0016\u0014H+\u00192mKJ+7/\u001a;F[R\u0004\u0018p\u00149uS>t7*Z=)\u0005)l\u0005\"\u00028\u0001\t\u0003A\u0015a\t;fgR\fE\u000e^3s)\u0006\u0014G.\u001a*fg\u0016$\u0018J\u001c<bY&$w\n\u001d;j_:\\U-\u001f\u0015\u0003[6CQ!\u001d\u0001\u0005\u0002!\u000bA\u0005^3ti\u0006cG/\u001a:UC\ndWMU3tKR|\u0005\u000f^5p]\u0006dw\n\u001d;j_:\\U-\u001f\u0015\u0003a6CQ\u0001\u001e\u0001\u0005\u0002!\u000bA\u0005^3ti\u0006cG/\u001a:UC\ndWMU3tKR\u0014V-];je\u0016$w\n\u001d;j_:\\U-\u001f\u0015\u0003g6CQa\u001e\u0001\u0005\u0002!\u000ba\u0005^3ti\u0016CXmY;uKN\u000bHnV5uQ\u000e\u0013X-\u0019;f\u00032$XM\u001d#s_B$\u0016M\u00197fQ\t1X\nC\u0003{\u0001\u0011\u0005\u0001*\u0001\u0017uKN$X\t_3dkR,7+\u001d7XSRD7I]3bi\u0016$%o\u001c9UC\ndW-\u00134O_R,\u00050[:ug\"\u0012\u00110\u0014\u0005\u0006{\u0002!\t\u0001S\u00016i\u0016\u001cH/\u0012=fGV$XmU9m/&$\bn\u0011:fCR,GI]8q)\u0016l\u0007o\u001c:bef$\u0016M\u00197f\u0013\u001atu\u000e^#ySN$8\u000f\u000b\u0002}\u001b\"1\u0011\u0011\u0001\u0001\u0005\u0002!\u000b!\u0006^3ti\u0016CXmY;uKN\u000bHnV5uQ\u000e\u0013X-\u0019;f\tJ|\u0007\u000fV3na>\u0014\u0018M]=UC\ndW\r\u000b\u0002\u0000\u001b\"1\u0011q\u0001\u0001\u0005\u0002!\u000bA\u0006^3ti\u0016CXmY;uKN\u000bHnV5uQ\u0012\u0013x\u000e\u001d+f[B|'/\u0019:z)\u0006\u0014G.Z%g\u000bbL7\u000f^:)\u0007\u0005\u0015Q\n\u0003\u0004\u0002\u000e\u0001!\t\u0001S\u0001*i\u0016\u001cH/\u0012=fGV$XmU9m/&$\b\u000e\u0012:paR+W\u000e]8sCJLH+\u00192mKR;\u0018nY3)\u000f\u0005-Q*!\u0005\u0002\u0014\u0005AQ\r\u001f9fGR,Gm\t\u0002\u0002\u0016A\u0019\u0001$a\u0006\n\u0007\u0005e!AA\nWC2LG-\u0019;j_:,\u0005pY3qi&|g\u000e\u0003\u0004\u0002\u001e\u0001!\t\u0001S\u0001#i\u0016\u001cH\u000f\u0012:paR+W\u000e]8sCJLH+\u00192mK^KG\u000f\u001b$vY2\u0004\u0016\r\u001e5)\u0007\u0005mQ\n\u0003\u0004\u0002$\u0001!\t\u0001S\u0001&i\u0016\u001cH\u000f\u0012:paR+W\u000e]8sCJLH+\u00192mK^KG\u000f[%om\u0006d\u0017\u000e\u001a)bi\"Ds!!\tN\u0003#\t\u0019\u0002\u0003\u0004\u0002*\u0001!\t\u0001S\u0001*i\u0016\u001cH/\u0012=fGV$XmU9m/&$\bn\u0011:fCR,\u0017\t\u001c;fe\u0012\u0013x\u000e\u001d#bi\u0006\u0014\u0017m]3)\u0007\u0005\u001dR\n\u0003\u0004\u00020\u0001!\t\u0001S\u0001%i\u0016\u001cH/\u0012=fGV$XmU9m/&$\bn\u0011:fCR,GI]8q\rVt7\r^5p]\"\u001a\u0011QF'\t\r\u0005U\u0002\u0001\"\u0001I\u0003\u0019\"Xm\u001d;Fq\u0016\u001cW\u000f^3Tc2<\u0016\u000e\u001e5De\u0016\fG/Z+tK\u0012\u0013x\u000e]\"bi\u0006dwn\u001a\u0015\u0004\u0003gi\u0005BBA\u001e\u0001\u0011\u0005\u0001*A\u000fuKN$X\t_3dkR,7+\u001d7XSRDWk]3ECR\f'-Y:fQ\r\tI$\u0014\u0005\u0007\u0003\u0003\u0002A\u0011\u0001%\u0002=Q,7\u000f^#yK\u000e,H/Z*rY^KG\u000f[*i_^\u001c\u0015\r^1m_\u001e\u001c\bfAA \u001b\"1\u0011q\t\u0001\u0005\u0002!\u000bq\u0004^3ti\u0016CXmY;uKN\u000bHnV5uQNCwn\u001e#bi\u0006\u0014\u0017m]3tQ\r\t)%\u0014\u0005\u0007\u0003\u001b\u0002A\u0011\u0001%\u00029Q,7\u000f^#yK\u000e,H/Z*rY^KG\u000f[*i_^$\u0016M\u00197fg\"\u001a\u00111J'\t\r\u0005M\u0003\u0001\"\u0001I\u0003}!Xm\u001d;Fq\u0016\u001cW\u000f^3Tc2<\u0016\u000e\u001e5TQ><h)\u001e8di&|gn\u001d\u0015\u0004\u0003#j\u0005BBA-\u0001\u0011\u0005\u0001*\u0001\u000fuKN$X\t_3dkR,7+\u001d7XSRDGj\\1e\u001b>$W\u000f\\3)\u0007\u0005]S\n\u0003\u0004\u0002`\u0001!\t\u0001S\u0001*i\u0016\u001cH/\u0012=fGV$XmU9m/&$\b\u000eT8bIB\u000b'/Y7fi\u0016\u0014\u0018N_3e\u001b>$W\u000f\\3)\u0007\u0005uS\n\u0003\u0004\u0002f\u0001!\t\u0001S\u0001.i\u0016\u001cH/\u0012=fGV$XmU9m/&$\b\u000eT8bI\u000e\u000b7/Z*f]NLG/\u001b<f\u001b>$W\u000f\\3OC6,\u0007fAA2\u001b\"1\u00111\u000e\u0001\u0005\u0002!\u000b1\u0005^3ti\u0016CXmY;uKN\u000bHnV5uQVsGn\\1e\u001b>$W\u000f\\3Uo&\u001cW\rK\u0002\u0002j5Ca!!\u001d\u0001\t\u0003A\u0015\u0001\b;fgR,\u00050Z2vi\u0016\u001c\u0016\u000f\\,ji\",6/Z'pIVdWm\u001d\u0015\u0004\u0003_j\u0005BBA<\u0001\u0011\u0005\u0001*\u0001\u0013uKN$X\t_3dkR,7+\u001d7XSRDWk]3V]2|\u0017\rZ3e\u001b>$W\u000f\\3tQ\r\t)(\u0014\u0005\u0007\u0003{\u0002A\u0011\u0001%\u0002SQ,7\u000f^#yK\u000e,H/Z*rY^KG\u000f[+tK\u0012+\b\u000f\\5dCR,Wj\u001c3vY\u0016t\u0015-\\3tQ\r\tY(\u0014\u0005\u0007\u0003\u0007\u0003A\u0011\u0001%\u0002;Q,7\u000f^#yK\u000e,H/Z*rY^KG\u000f[*i_^lu\u000eZ;mKND3!!!N\u0011\u0019\tI\t\u0001C\u0001\u0011\u0006\u0001B/Z:u\u0019\u0016<\u0017mY=N_\u0012,H.\u001a\u0015\u0004\u0003\u000fk\u0005BBAH\u0001\u0011\u0005\u0001*\u0001\u0011uKN$X\t_3dkR,7+\u001d7XSRD7I]3bi\u0016$%o\u001c9WS\u0016<\bfAAG\u001b\"1\u0011Q\u0013\u0001\u0005\u0002!\u000b\u0011\u0006^3ti\u0016CXmY;uKN\u000bHnV5uQ\u000e\u0013X-\u0019;f\tJ|\u0007\u000fV3na>\u0014\u0018M]=WS\u0016<\bfAAJ\u001b\"1\u00111\u0014\u0001\u0005\u0002!\u000b\u0001\u0005^3ti\u000e\u0013X-\u0019;f-&,woV5uQ^\u0013xN\\4GS\u0016dG\rT5ti\"\u001a\u0011\u0011T'\t\r\u0005\u0005\u0006\u0001\"\u0001I\u0003M!Xm\u001d;De\u0016\fG/\u001a,jK^$v/[2fQ\r\ty*\u0014\u0005\u0007\u0003O\u0003A\u0011\u0001%\u00021Q,7\u000f\u001e#s_B4\u0016.Z<XSRDg)\u001e7m!\u0006$\b\u000eK\u0002\u0002&6Ca!!,\u0001\t\u0003A\u0015a\u0007;fgR$%o\u001c9WS\u0016<x+\u001b;i!\u0006\u0014H/[1m!\u0006$\b\u000eK\u0002\u0002,6Ca!a-\u0001\t\u0003A\u0015!\u0007;fgR$%o\u001c9WS\u0016<\u0018JZ#ySN$8\u000fV<jG\u0016D3!!-N\u0011\u0019\tI\f\u0001C\u0001\u0011\u0006\tB/Z:u\tJ|\u0007OV5foR;\u0018nY3)\u000f\u0005]V*!\u0005\u0002\u0014!1\u0011q\u0018\u0001\u0005\u0002!\u000b1\u0004^3ti\u0012\u0013x\u000e\u001d,jK^<\u0016\u000e\u001e5J]Z\fG.\u001b3QCRD\u0007fBA_\u001b\u0006E\u00111\u0003\u0005\u0007\u0003\u000b\u0004A\u0011\u0001%\u0002GQ,7\u000f\u001e#s_B4\u0016.Z<XSRD\u0017J\u001c<bY&$\u0007+\u0019;i\u0013\u001a,\u00050[:ug\"\u001a\u00111Y'\t\r\u0005-\u0007\u0001\"\u0001I\u0003\t\"Xm\u001d;Ee>\u0004H+Z7q_J\f'/\u001f,jK^Le-\u0012=jgR\u001cHk^5dK\"\u001a\u0011\u0011Z'\t\r\u0005E\u0007\u0001\"\u0001I\u0003i!Xm\u001d;Ee>\u0004H+Z7q_J\f'/\u001f,jK^$v/[2fQ\u001d\ty-TA\t\u0003'Aa!a6\u0001\t\u0003A\u0015a\u0007;fgR,\u00050Z2vi\u0016\u001c\u0016\u000f\\,ji\"\u001c\u0006n\\<WS\u0016<8\u000fK\u0002\u0002V6Ca!!8\u0001\t\u0003A\u0015a\b;fgR,\u00050Z2vi\u0016\u001c\u0016\u000f\\,ji\",\u0005\u0010\u001d7bS:\u001cV\r\\3di\"\u001a\u00111\\'\t\r\u0005\r\b\u0001\"\u0001I\u0003}!Xm\u001d;Fq\u0016\u001cW\u000f^3Tc2<\u0016\u000e\u001e5FqBd\u0017-\u001b8J]N,'\u000f\u001e\u0015\u0004\u0003Cl\u0005BBAu\u0001\u0011\u0005\u0001*\u0001\u0013uKN$X\t_3dkR,7+\u001d7XSRDWK\\:vaB|'\u000f^3e\u000bb\u0004H.Y5oQ\r\t9/\u0014\u0005\u0007\u0003_\u0004A\u0011\u0001%\u00021Q,7\u000f^#ya2\f\u0017N\\*rY^KG\u000f[*fY\u0016\u001cG\u000fK\u0002\u0002n6Ca!!>\u0001\t\u0003A\u0015\u0001\u0007;fgR,\u0005\u0010\u001d7bS:\u001c\u0016\u000f\\,ji\"Len]3si\"\u001a\u00111_'\t\r\u0005m\b\u0001\"\u0001I\u0003\u0019\"Xm\u001d;Fq\u0016\u001cW\u000f^3Tc2<\u0016\u000e\u001e5FqBd\u0017-\u001b8EKR\f\u0017\u000e\\:TK2,7\r\u001e\u0015\u0004\u0003sl\u0005B\u0002B\u0001\u0001\u0011\u0005\u0001*\u0001\u0015uKN$X\t_3dkR,7+\u001d7XSRDW\t\u001f9mC&tG)\u001a;bS2\u001c\u0018I\u001c3V]&|g\u000eK\u0002\u0002\u00006CaAa\u0002\u0001\t\u0003A\u0015A\n;fgR,\u00050Z2vi\u0016\u001c\u0016\u000f\\,ji\",\u0005\u0010\u001d7bS:$U\r^1jYNLen]3si\"\u001a!QA'\t\u000f\t5\u0001\u0001\"\u0003\u0003\u0010\u00051B/Z:u+:\u001cX\u000f\u001d9peR,G-\u0012=qY\u0006Lg\u000eF\u0002J\u0005#A\u0001Ba\u0005\u0003\f\u0001\u0007!QC\u0001\bKb\u0004H.Y5o!\u0011\u00119B!\b\u000f\u0007=\u0011I\"C\u0002\u0003\u001cA\ta\u0001\u0015:fI\u00164\u0017\u0002\u0002B\u0010\u0005C\u0011aa\u0015;sS:<'b\u0001B\u000e!!1!Q\u0005\u0001\u0005\u0002!\u000bq\u0003^3ti\u0012+7o\u0019:jE\u0016$\u0016M\u00197f\u001fJ4\u0016.Z<)\u0007\t\rR\nC\u0004\u0003,\u0001!IA!\f\u0002\u0013\rDWmY6ECR\fG#B%\u00030\t5\u0003\u0002CA\t\u0005S\u0001\rA!\r\u0011\r\tM\"Q\bB!\u001b\t\u0011)D\u0003\u0003\u00038\te\u0012\u0001B;uS2T!Aa\u000f\u0002\t)\fg/Y\u0005\u0005\u0005\u007f\u0011)D\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\u0011\u0011\u0019E!\u0013\u000e\u0005\t\u0015#b\u0001B$\r\u0005)A/\u001f9fg&!!1\nB#\u0005\r\u0011vn\u001e\u0005\t\u0005\u001f\u0012I\u00031\u0001\u00032\u00051\u0011m\u0019;vC2DqAa\u0015\u0001\t\u0013\u0011)&A\nwC2LG-\u0019;f'\"|w/T8ek2,7\u000fF\u0002J\u0005/B\u0001B!\u0017\u0003R\u0001\u0007!1L\u0001\u0010Kb\u0004Xm\u0019;fI\u0016sGO]5fgB)qB!\u0018\u0003b%\u0019!q\f\t\u0003\u0015q\u0012X\r]3bi\u0016$g\bE\u0004\u0010\u0005G\u0012)Ba\u001a\n\u0007\t\u0015\u0004C\u0001\u0004UkBdWM\r\t\u0005\u0005S\u0012y'\u0004\u0002\u0003l)!!Q\u000eB\u001d\u0003\u0011a\u0017M\\4\n\t\tE$1\u000e\u0002\b\u0005>|G.Z1o\u0011\u001d\u0011)\b\u0001C\u0005\u0005o\n\u0001c\u00195fG.d\u0015n\u001d;N_\u0012,H.Z:\u0015\u0007%\u0013I\b\u0003\u0005\u0002\u0012\tM\u0004\u0019\u0001B>!\u0015y!Q\fB\u000b\u0011\u001d\u0011y\b\u0001C\u0005\u0005\u0003\u000bAc\u00195fG.d\u0015n\u001d;Gk2dWj\u001c3vY\u0016\u001cHcA%\u0003\u0004\"A\u0011\u0011\u0003B?\u0001\u0004\u0011Y\u0006C\u0004\u0003\b\u0002!IA!#\u0002!\rDWmY6UC\ndWmU8ve\u000e,G#B%\u0003\f\n=\u0005\u0002\u0003BG\u0005\u000b\u0003\rA!\u0006\u0002\u0013Q\f'\r\\3OC6,\u0007\u0002\u0003BI\u0005\u000b\u0003\rAa\u001a\u0002#\u0015D\b/Z2u)>\u0014UMQ8v]\u0012,G\rC\u0004\u0003\u0016\u0002!IAa&\u0002\u0019\rDWmY6FqBd\u0017-\u001b8\u0015\u000b%\u0013IJ!(\t\u0011\tm%1\u0013a\u0001\u0005+\t1a]9m\u0011!\u0011yJa%A\u0002\tU\u0011A\u0003:fgVdG\u000fU1uQ\u0002")
public class TableEnvironmentTest {
    private final ExpectedException expectedException = ExpectedException.none();
    private final StreamExecutionEnvironment env = new StreamExecutionEnvironment((org.apache.flink.streaming.api.environment.StreamExecutionEnvironment)new LocalStreamEnvironment());
    private final StreamTableEnvironment tableEnv = StreamTableEnvironment$.MODULE$.create(this.env(), TableTestUtil$.MODULE$.STREAM_SETTING());
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("d");

    public ExpectedException expectedException() {
        return this.expectedException;
    }

    @Rule
    public ExpectedException thrown() {
        return this.expectedException();
    }

    public StreamExecutionEnvironment env() {
        return this.env;
    }

    public StreamTableEnvironment tableEnv() {
        return this.tableEnv;
    }

    @Test
    public void testScanNonExistTable() {
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("Table `MyTable` was not found");
        this.tableEnv().from("MyTable");
    }

    @Test
    public void testRegisterDataStream() {
        Table table = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromElements((Seq)Nil$.MODULE$, (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$4 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tableEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$4)}));
        this.tableEnv().registerTable("MyTable", table);
        Table scanTable = this.tableEnv().from("MyTable");
        RelNode relNode = TableTestUtil$.MODULE$.toRelNode(scanTable);
        String actual = RelOptUtil.toString((RelNode)relNode);
        String expected = "LogicalTableScan(table=[[default_catalog, default_database, MyTable]])\n";
        Assert.assertEquals((Object)expected, (Object)actual);
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("Temporary table '`default_catalog`.`default_database`.`MyTable`' already exists");
        this.tableEnv().createTemporaryView("MyTable", this.env().fromElements((Seq)Nil$.MODULE$, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$5 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }));
    }

    @Test
    public void testSimpleQuery() {
        Table table = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromElements((Seq)Nil$.MODULE$, (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$6 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tableEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$4)}));
        this.tableEnv().registerTable("MyTable", table);
        Table queryTable = this.tableEnv().sqlQuery("SELECT a, c, d FROM MyTable");
        RelNode relNode = TableTestUtil$.MODULE$.toRelNode(queryTable);
        String actual = RelOptUtil.toString((RelNode)relNode, (SqlExplainLevel)SqlExplainLevel.NO_ATTRIBUTES);
        String expected = "LogicalProject\n  LogicalTableScan\n";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testStreamTableEnvironmentExplain() {
        StreamExecutionEnvironment execEnv = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        EnvironmentSettings settings = EnvironmentSettings.newInstance().inStreamingMode().build();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(execEnv, settings);
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable((TableEnvironment)tEnv, "MyTable");
        TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable((TableEnvironment)tEnv, new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING})), "MySink", -1);
        String expected = TableTestUtil$.MODULE$.readFromResource("/explain/testStreamTableEnvironmentExplain.out");
        String actual = tEnv.explainSql("insert into MySink select first from MyTable", new ExplainDetail[0]);
        Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(expected), (Object)TableTestUtil$.MODULE$.replaceStageId(actual));
    }

    @Test
    public void testStreamTableEnvironmentExecutionExplainWithEnvParallelism() {
        StreamExecutionEnvironment execEnv = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        execEnv.setParallelism(4);
        EnvironmentSettings settings = EnvironmentSettings.newInstance().inStreamingMode().build();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(execEnv, settings);
        this.verifyTableEnvironmentExecutionExplain((TableEnvironment)tEnv);
    }

    @Test
    public void testStreamTableEnvironmentExecutionExplainWithConfParallelism() {
        StreamExecutionEnvironment execEnv = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        EnvironmentSettings settings = EnvironmentSettings.newInstance().inStreamingMode().build();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(execEnv, settings);
        Configuration configuration = new Configuration();
        configuration.setInteger("parallelism.default", 4);
        tEnv.getConfig().addConfiguration(configuration);
        this.verifyTableEnvironmentExecutionExplain((TableEnvironment)tEnv);
    }

    private void verifyTableEnvironmentExecutionExplain(TableEnvironment tEnv) {
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable(tEnv, "MyTable");
        TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(tEnv, new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING})), "MySink", -1);
        String expected = TableTestUtil$.MODULE$.readFromResource("/explain/testStreamTableEnvironmentExecutionExplain.out");
        String actual = tEnv.explainSql("insert into MySink select first from MyTable", new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN});
        Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStreamNodeId(expected), (Object)TableTestUtil$.MODULE$.replaceStreamNodeId(actual));
    }

    @Test
    public void testStatementSetExecutionExplain() {
        StreamExecutionEnvironment execEnv = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        execEnv.setParallelism(1);
        EnvironmentSettings settings = EnvironmentSettings.newInstance().inStreamingMode().build();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(execEnv, settings);
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable((TableEnvironment)tEnv, "MyTable");
        TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable((TableEnvironment)tEnv, new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING})), "MySink", -1);
        String expected = TableTestUtil$.MODULE$.readFromResource("/explain/testStatementSetExecutionExplain.out");
        StreamStatementSet statementSet = tEnv.createStatementSet();
        statementSet.addInsertSql("insert into MySink select last from MyTable");
        String actual = statementSet.explain(new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN});
        Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStreamNodeId(expected), (Object)TableTestUtil$.MODULE$.replaceStreamNodeId(actual));
    }

    @Test
    public void testAlterTableResetEmtpyOptionKey() {
        String statement = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE MyTable (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) WITH (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(statement);
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("ALTER TABLE RESET does not support empty key");
        this.tableEnv().executeSql("ALTER TABLE MyTable RESET ()");
    }

    @Test
    public void testAlterTableResetInvalidOptionKey() {
        String statementWithTypo = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE MyTable (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) WITH (\n        |  'connector' = 'datagen',\n        |  'invalid-key' = 'invalid-value'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(statementWithTypo);
        try {
            this.tableEnv().executeSql("explain plan for select * from MyTable where a > 10");
            Assert.fail((String)"Expected an exception");
        }
        catch (Throwable throwable) {
            Assert.assertThat((Object)throwable, (Matcher)FlinkMatchers.containsMessage((String)"Unable to create a source for reading table 'default_catalog.default_database.MyTable'.\n\nTable options are:\n\n'connector'='datagen'\n'invalid-key'='invalid-value'"));
        }
        String alterTableResetStatement = "ALTER TABLE MyTable RESET ('invalid-key')";
        TableResult tableResult = this.tableEnv().executeSql(alterTableResetStatement);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult.getResultKind());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connector"), (Object)"datagen")}))).asJava(), (Object)((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).getTable(ObjectPath.fromString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".MyTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableEnv().getCurrentDatabase()})))).getOptions());
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)this.tableEnv().executeSql("explain plan for select * from MyTable where a > 10").getResultKind());
    }

    @Test
    public void testAlterTableResetOptionalOptionKey() {
        String statement = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE MyTable (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) WITH (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(statement);
        this.checkTableSource("MyTable", Predef$.MODULE$.boolean2Boolean(false));
        String alterTableResetStatement = "ALTER TABLE MyTable RESET ('is-bounded')";
        TableResult tableResult = this.tableEnv().executeSql(alterTableResetStatement);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult.getResultKind());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connector"), (Object)"COLLECTION")}))).asJava(), (Object)((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).getTable(ObjectPath.fromString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".MyTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableEnv().getCurrentDatabase()})))).getOptions());
        this.checkTableSource("MyTable", Predef$.MODULE$.boolean2Boolean(true));
    }

    @Test
    public void testAlterTableResetRequiredOptionKey() {
        String statement = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE MyTable (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) WITH (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(statement);
        String alterTableResetStatement = "ALTER TABLE MyTable RESET ('connector')";
        TableResult tableResult = this.tableEnv().executeSql(alterTableResetStatement);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult.getResultKind());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava(), (Object)((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).getTable(ObjectPath.fromString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".MyTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableEnv().getCurrentDatabase()})))).getOptions());
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("Unable to create a source for reading table 'default_catalog.default_database.MyTable'.");
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)this.tableEnv().executeSql("explain plan for select * from MyTable where a > 10").getResultKind());
    }

    @Test
    public void testExecuteSqlWithCreateAlterDropTable() {
        String createTableStmt = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE tbl1 (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult1 = this.tableEnv().executeSql(createTableStmt);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        Assert.assertTrue((boolean)((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).tableExists(ObjectPath.fromString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".tbl1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableEnv().getCurrentDatabase()})))));
        TableResult tableResult2 = this.tableEnv().executeSql("ALTER TABLE tbl1 SET ('k1' = 'a', 'k2' = 'b')");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult2.getResultKind());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connector"), (Object)"COLLECTION"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"is-bounded"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k1"), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k2"), (Object)"b")}))).asJava(), (Object)((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).getTable(ObjectPath.fromString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".tbl1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableEnv().getCurrentDatabase()})))).getOptions());
        TableResult tableResult3 = this.tableEnv().executeSql("DROP TABLE tbl1");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult3.getResultKind());
        Assert.assertFalse((boolean)((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).tableExists(ObjectPath.fromString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".tbl1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableEnv().getCurrentDatabase()})))));
    }

    @Test
    public void testExecuteSqlWithCreateDropTableIfNotExists() {
        String createTableStmt = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE IF NOT EXISTS tbl1 (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult1 = this.tableEnv().executeSql(createTableStmt);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        TableResult tableResult2 = this.tableEnv().executeSql(createTableStmt);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult2.getResultKind());
        Assert.assertTrue((boolean)((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).tableExists(ObjectPath.fromString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".tbl1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableEnv().getCurrentDatabase()})))));
        TableResult tableResult3 = this.tableEnv().executeSql("DROP TABLE IF EXISTS tbl1");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult3.getResultKind());
        Assert.assertFalse((boolean)((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).tableExists(ObjectPath.fromString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".tbl1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableEnv().getCurrentDatabase()})))));
    }

    @Test
    public void testExecuteSqlWithCreateDropTemporaryTableIfNotExists() {
        String createTableStmt = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY TABLE IF NOT EXISTS tbl1 (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult1 = this.tableEnv().executeSql(createTableStmt);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        TableResult tableResult2 = this.tableEnv().executeSql(createTableStmt);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult2.getResultKind());
        Assert.assertTrue((boolean)Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).contains((Object)"tbl1"));
        TableResult tableResult3 = this.tableEnv().executeSql("DROP TEMPORARY TABLE IF EXISTS tbl1");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult3.getResultKind());
        Assert.assertFalse((boolean)Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).contains((Object)"tbl1"));
    }

    @Test
    public void testExecuteSqlWithCreateDropTemporaryTable() {
        String createTableStmt = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY TABLE tbl1 (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult1 = this.tableEnv().executeSql(createTableStmt);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1"})));
        TableResult tableResult2 = this.tableEnv().executeSql("DROP TEMPORARY TABLE tbl1");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult2.getResultKind());
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)))));
    }

    @Test
    public void testExecuteSqlWithDropTemporaryTableIfExists() {
        String createTableStmt = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY TABLE tbl1 (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult1 = this.tableEnv().executeSql(createTableStmt);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1"})));
        TableResult tableResult2 = this.tableEnv().executeSql("DROP TEMPORARY TABLE IF EXISTS tbl1");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult2.getResultKind());
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)))));
        TableResult tableResult3 = this.tableEnv().executeSql("DROP TEMPORARY TABLE IF EXISTS tbl1");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult3.getResultKind());
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)))));
    }

    @Test(expected=ValidationException.class)
    public void testExecuteSqlWithDropTemporaryTableTwice() {
        String createTableStmt = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY TABLE tbl1 (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult1 = this.tableEnv().executeSql(createTableStmt);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1"})));
        TableResult tableResult2 = this.tableEnv().executeSql("DROP TEMPORARY TABLE tbl1");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult2.getResultKind());
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)))));
        this.tableEnv().executeSql("DROP TEMPORARY TABLE tbl1");
    }

    @Test
    public void testDropTemporaryTableWithFullPath() {
        String createTableStmt = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY TABLE tbl1 (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult1 = this.tableEnv().executeSql(createTableStmt);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1"})));
        TableResult tableResult2 = this.tableEnv().executeSql("DROP TEMPORARY TABLE default_catalog.default_database.tbl1");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult2.getResultKind());
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)))));
    }

    @Test(expected=ValidationException.class)
    public void testDropTemporaryTableWithInvalidPath() {
        String createTableStmt = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY TABLE tbl1 (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult1 = this.tableEnv().executeSql(createTableStmt);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1"})));
        this.tableEnv().executeSql("DROP TEMPORARY TABLE invalid_catalog.invalid_database.tbl1");
    }

    @Test
    public void testExecuteSqlWithCreateAlterDropDatabase() {
        TableResult tableResult1 = this.tableEnv().executeSql("CREATE DATABASE db1 COMMENT 'db1_comment'");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        Assert.assertTrue((boolean)((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).databaseExists("db1"));
        TableResult tableResult2 = this.tableEnv().executeSql("ALTER DATABASE db1 SET ('k1' = 'a', 'k2' = 'b')");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult2.getResultKind());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k1"), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k2"), (Object)"b")}))).asJava(), (Object)((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).getDatabase("db1").getProperties());
        TableResult tableResult3 = this.tableEnv().executeSql("DROP DATABASE db1");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult3.getResultKind());
        Assert.assertFalse((boolean)((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).databaseExists("db1"));
    }

    @Test
    public void testExecuteSqlWithCreateDropFunction() {
        String funcName = FunctionITCase.TestUDF.class.getName();
        String funcName2 = FunctionITCase.SimpleScalarFunction.class.getName();
        TableResult tableResult1 = this.tableEnv().executeSql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE FUNCTION default_database.f1 AS '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{funcName})));
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        Assert.assertTrue((boolean)((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).functionExists(ObjectPath.fromString((String)"default_database.f1")));
        TableResult tableResult2 = this.tableEnv().executeSql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALTER FUNCTION default_database.f1 AS '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{funcName2})));
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult2.getResultKind());
        Assert.assertTrue((boolean)((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).functionExists(ObjectPath.fromString((String)"default_database.f1")));
        TableResult tableResult3 = this.tableEnv().executeSql("DROP FUNCTION default_database.f1");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult3.getResultKind());
        Assert.assertFalse((boolean)((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).functionExists(ObjectPath.fromString((String)"default_database.f1")));
        TableResult tableResult4 = this.tableEnv().executeSql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TEMPORARY SYSTEM FUNCTION f2 AS '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{funcName})));
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult4.getResultKind());
        Assert.assertTrue((boolean)Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listUserDefinedFunctions()).contains((Object)"f2"));
        TableResult tableResult5 = this.tableEnv().executeSql("DROP TEMPORARY SYSTEM FUNCTION f2");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult5.getResultKind());
        Assert.assertFalse((boolean)Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listUserDefinedFunctions()).contains((Object)"f2"));
    }

    @Test
    public void testExecuteSqlWithCreateUseDropCatalog() {
        TableResult tableResult1 = this.tableEnv().executeSql("CREATE CATALOG my_catalog WITH('type'='generic_in_memory')");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        Assert.assertTrue((boolean)this.tableEnv().getCatalog("my_catalog").isPresent());
        Assert.assertEquals((Object)"default_catalog", (Object)this.tableEnv().getCurrentCatalog());
        TableResult tableResult2 = this.tableEnv().executeSql("USE CATALOG my_catalog");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult2.getResultKind());
        Assert.assertEquals((Object)"my_catalog", (Object)this.tableEnv().getCurrentCatalog());
        TableResult tableResult3 = this.tableEnv().executeSql("DROP CATALOG my_catalog");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult3.getResultKind());
        Assert.assertFalse((boolean)this.tableEnv().getCatalog("my_catalog").isPresent());
    }

    @Test
    public void testExecuteSqlWithUseDatabase() {
        TableResult tableResult1 = this.tableEnv().executeSql("CREATE DATABASE db1 COMMENT 'db1_comment'");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        Assert.assertTrue((boolean)((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).databaseExists("db1"));
        Assert.assertEquals((Object)"default_database", (Object)this.tableEnv().getCurrentDatabase());
        TableResult tableResult2 = this.tableEnv().executeSql("USE db1");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult2.getResultKind());
        Assert.assertEquals((Object)"db1", (Object)this.tableEnv().getCurrentDatabase());
    }

    @Test
    public void testExecuteSqlWithShowCatalogs() {
        this.tableEnv().registerCatalog("my_catalog", (Catalog)new GenericInMemoryCatalog("my_catalog"));
        TableResult tableResult = this.tableEnv().executeSql("SHOW CATALOGS");
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"catalog name", (DataType)DataTypes.STRING())}), (Object)tableResult.getResolvedSchema());
        this.checkData(Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{"default_catalog"}), Row.of((Object[])new Object[]{"my_catalog"})}).iterator(), (Iterator<Row>)tableResult.collect());
    }

    @Test
    public void testExecuteSqlWithShowDatabases() {
        TableResult tableResult1 = this.tableEnv().executeSql("CREATE DATABASE db1 COMMENT 'db1_comment'");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        TableResult tableResult2 = this.tableEnv().executeSql("SHOW DATABASES");
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult2.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"database name", (DataType)DataTypes.STRING())}), (Object)tableResult2.getResolvedSchema());
        this.checkData(Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{"default_database"}), Row.of((Object[])new Object[]{"db1"})}).iterator(), (Iterator<Row>)tableResult2.collect());
    }

    @Test
    public void testExecuteSqlWithShowTables() {
        String createTableStmt = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE tbl1 (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult1 = this.tableEnv().executeSql(createTableStmt);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        TableResult tableResult2 = this.tableEnv().executeSql("SHOW TABLES");
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult2.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"table name", (DataType)DataTypes.STRING())}), (Object)tableResult2.getResolvedSchema());
        this.checkData(Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{"tbl1"})}).iterator(), (Iterator<Row>)tableResult2.collect());
    }

    @Test
    public void testExecuteSqlWithShowFunctions() {
        TableResult tableResult = this.tableEnv().executeSql("SHOW FUNCTIONS");
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"function name", (DataType)DataTypes.STRING())}), (Object)tableResult.getResolvedSchema());
        this.checkData(((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listFunctions()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(String x$1) {
                return Row.of((Object[])new Object[]{x$1});
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).toList()).asJava()).iterator(), (Iterator<Row>)tableResult.collect());
        String funcName = FunctionITCase.TestUDF.class.getName();
        TableResult tableResult1 = this.tableEnv().executeSql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE FUNCTION default_database.f1 AS '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{funcName})));
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        TableResult tableResult2 = this.tableEnv().executeSql("SHOW USER FUNCTIONS");
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult2.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"function name", (DataType)DataTypes.STRING())}), (Object)tableResult2.getResolvedSchema());
        this.checkData(Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{"f1"})}).iterator(), (Iterator<Row>)tableResult2.collect());
    }

    @Test
    public void testExecuteSqlWithLoadModule() {
        TableResult result = this.tableEnv().executeSql("LOAD MODULE dummy");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)result.getResultKind());
        this.checkListModules((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"core", "dummy"}));
        this.checkListFullModules((Seq<Tuple2<String, Boolean>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"core", (Object)Predef$.MODULE$.boolean2Boolean(true)), new Tuple2((Object)"dummy", (Object)Predef$.MODULE$.boolean2Boolean(true))}));
        String statement = new StringOps(Predef$.MODULE$.augmentString("\n        |LOAD MODULE dummy WITH (\n        |  'type' = 'dummy'\n        |)\n      ")).stripMargin();
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("Option 'type' = 'dummy' is not supported since module name is used to find module");
        this.tableEnv().executeSql(statement);
    }

    @Test
    public void testExecuteSqlWithLoadParameterizedModule() {
        String statement1 = new StringOps(Predef$.MODULE$.augmentString("\n        |LOAD MODULE dummy WITH (\n        |  'dummy-version' = '1'\n        |)\n      ")).stripMargin();
        TableResult result = this.tableEnv().executeSql(statement1);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)result.getResultKind());
        this.checkListModules((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"core", "dummy"}));
        this.checkListFullModules((Seq<Tuple2<String, Boolean>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"core", (Object)Predef$.MODULE$.boolean2Boolean(true)), new Tuple2((Object)"dummy", (Object)Predef$.MODULE$.boolean2Boolean(true))}));
        String statement2 = new StringOps(Predef$.MODULE$.augmentString("\n        |LOAD MODULE dummy WITH (\n        |  'dummy-version' = '2'\n        |)\n      ")).stripMargin();
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("Could not execute LOAD MODULE `dummy` WITH ('dummy-version' = '2'). A module with name 'dummy' already exists");
        this.tableEnv().executeSql(statement2);
    }

    @Test
    public void testExecuteSqlWithLoadCaseSensitiveModuleName() {
        String statement1 = new StringOps(Predef$.MODULE$.augmentString("\n        |LOAD MODULE Dummy WITH (\n        |  'dummy-version' = '1'\n        |)\n      ")).stripMargin();
        try {
            this.tableEnv().executeSql(statement1);
            Assert.fail((String)"Expected an exception");
        }
        catch (Throwable throwable) {
            Assert.assertThat((Object)throwable, (Matcher)FlinkMatchers.containsMessage((String)"Could not execute LOAD MODULE `Dummy` WITH ('dummy-version' = '1'). Unable to create module 'Dummy'."));
        }
        String statement2 = new StringOps(Predef$.MODULE$.augmentString("\n        |LOAD MODULE dummy WITH (\n        |  'dummy-version' = '2'\n        |)\n      ")).stripMargin();
        TableResult result = this.tableEnv().executeSql(statement2);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)result.getResultKind());
        this.checkListModules((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"core", "dummy"}));
        this.checkListFullModules((Seq<Tuple2<String, Boolean>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"core", (Object)Predef$.MODULE$.boolean2Boolean(true)), new Tuple2((Object)"dummy", (Object)Predef$.MODULE$.boolean2Boolean(true))}));
    }

    @Test
    public void testExecuteSqlWithUnloadModuleTwice() {
        this.tableEnv().executeSql("LOAD MODULE dummy");
        this.checkListModules((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"core", "dummy"}));
        this.checkListFullModules((Seq<Tuple2<String, Boolean>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"core", (Object)Predef$.MODULE$.boolean2Boolean(true)), new Tuple2((Object)"dummy", (Object)Predef$.MODULE$.boolean2Boolean(true))}));
        TableResult result = this.tableEnv().executeSql("UNLOAD MODULE dummy");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)result.getResultKind());
        this.checkListModules((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"core"}));
        this.checkListFullModules((Seq<Tuple2<String, Boolean>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"core", (Object)Predef$.MODULE$.boolean2Boolean(true))}));
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("Could not execute UNLOAD MODULE dummy. No module with name 'dummy' exists");
        this.tableEnv().executeSql("UNLOAD MODULE dummy");
    }

    @Test
    public void testExecuteSqlWithUseModules() {
        this.tableEnv().executeSql("LOAD MODULE dummy");
        this.checkListModules((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"core", "dummy"}));
        this.checkListFullModules((Seq<Tuple2<String, Boolean>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"core", (Object)Predef$.MODULE$.boolean2Boolean(true)), new Tuple2((Object)"dummy", (Object)Predef$.MODULE$.boolean2Boolean(true))}));
        TableResult result1 = this.tableEnv().executeSql("USE MODULES dummy");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)result1.getResultKind());
        this.checkListModules((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dummy"}));
        this.checkListFullModules((Seq<Tuple2<String, Boolean>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"dummy", (Object)Predef$.MODULE$.boolean2Boolean(true)), new Tuple2((Object)"core", (Object)Predef$.MODULE$.boolean2Boolean(false))}));
        TableResult result2 = this.tableEnv().executeSql("USE MODULES dummy, core");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)result2.getResultKind());
        this.checkListModules((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dummy", "core"}));
        this.checkListFullModules((Seq<Tuple2<String, Boolean>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"dummy", (Object)Predef$.MODULE$.boolean2Boolean(true)), new Tuple2((Object)"core", (Object)Predef$.MODULE$.boolean2Boolean(true))}));
        TableResult result3 = this.tableEnv().executeSql("USE MODULES core, dummy");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)result3.getResultKind());
        this.checkListModules((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"core", "dummy"}));
        this.checkListFullModules((Seq<Tuple2<String, Boolean>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"core", (Object)Predef$.MODULE$.boolean2Boolean(true)), new Tuple2((Object)"dummy", (Object)Predef$.MODULE$.boolean2Boolean(true))}));
        TableResult result4 = this.tableEnv().executeSql("USE MODULES core");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)result4.getResultKind());
        this.checkListModules((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"core"}));
        this.checkListFullModules((Seq<Tuple2<String, Boolean>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"core", (Object)Predef$.MODULE$.boolean2Boolean(true)), new Tuple2((Object)"dummy", (Object)Predef$.MODULE$.boolean2Boolean(false))}));
    }

    @Test
    public void testExecuteSqlWithUseUnloadedModules() {
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("Could not execute USE MODULES: [core, dummy]. No module with name 'dummy' exists");
        this.tableEnv().executeSql("USE MODULES core, dummy");
    }

    @Test
    public void testExecuteSqlWithUseDuplicateModuleNames() {
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("Could not execute USE MODULES: [core, core]. Module 'core' appears more than once");
        this.tableEnv().executeSql("USE MODULES core, core");
    }

    @Test
    public void testExecuteSqlWithShowModules() {
        this.validateShowModules((Seq<Tuple2<String, Boolean>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"core", (Object)Predef$.MODULE$.boolean2Boolean(true))}));
        String statement = "LOAD MODULE dummy";
        this.tableEnv().executeSql(statement);
        this.validateShowModules((Seq<Tuple2<String, Boolean>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"core", (Object)Predef$.MODULE$.boolean2Boolean(true)), new Tuple2((Object)"dummy", (Object)Predef$.MODULE$.boolean2Boolean(true))}));
        this.tableEnv().executeSql("USE MODULES dummy");
        this.validateShowModules((Seq<Tuple2<String, Boolean>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"dummy", (Object)Predef$.MODULE$.boolean2Boolean(true)), new Tuple2((Object)"core", (Object)Predef$.MODULE$.boolean2Boolean(false))}));
        this.tableEnv().executeSql("UNLOAD MODULE dummy");
        this.validateShowModules((Seq<Tuple2<String, Boolean>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"core", (Object)Predef$.MODULE$.boolean2Boolean(false))}));
    }

    @Test
    public void testLegacyModule() {
        this.tableEnv().executeSql("LOAD MODULE LegacyModule");
        this.validateShowModules((Seq<Tuple2<String, Boolean>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"core", (Object)Predef$.MODULE$.boolean2Boolean(true)), new Tuple2((Object)"LegacyModule", (Object)Predef$.MODULE$.boolean2Boolean(true))}));
    }

    @Test
    public void testExecuteSqlWithCreateDropView() {
        String createTableStmt = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE tbl1 (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(createTableStmt);
        TableResult viewResult1 = this.tableEnv().executeSql("CREATE VIEW IF NOT EXISTS v1 AS SELECT * FROM tbl1");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)viewResult1.getResultKind());
        Assert.assertTrue((boolean)((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).tableExists(ObjectPath.fromString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".v1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableEnv().getCurrentDatabase()})))));
        TableResult viewResult2 = this.tableEnv().executeSql("DROP VIEW IF EXISTS v1");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)viewResult2.getResultKind());
        Assert.assertFalse((boolean)((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).tableExists(ObjectPath.fromString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".v1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableEnv().getCurrentDatabase()})))));
    }

    @Test
    public void testExecuteSqlWithCreateDropTemporaryView() {
        String createTableStmt = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE tbl1 (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        this.tableEnv().executeSql(createTableStmt);
        TableResult viewResult1 = this.tableEnv().executeSql("CREATE TEMPORARY VIEW IF NOT EXISTS v1 AS SELECT * FROM tbl1");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)viewResult1.getResultKind());
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "v1"})));
        TableResult viewResult2 = this.tableEnv().executeSql("DROP TEMPORARY VIEW IF EXISTS v1");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)viewResult2.getResultKind());
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1"})));
    }

    @Test
    public void testCreateViewWithWrongFieldList() {
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("VIEW definition and input fields not match:\n\tDef fields: [d].\n\tInput fields: [a, b, c].");
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String viewDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW IF NOT EXISTS T3(d) AS SELECT * FROM T1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(viewDDL);
    }

    @Test
    public void testCreateViewTwice() {
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("Could not execute CreateTable in path `default_catalog`.`default_database`.`T3`");
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T2(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String viewWith3ColumnDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW T3(d, e, f) AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        String viewWith2ColumnDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW T3(d, e) AS SELECT a, b FROM T1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(sinkDDL);
        this.tableEnv().executeSql(viewWith3ColumnDDL);
        this.tableEnv().executeSql(viewWith2ColumnDDL);
    }

    @Test
    public void testDropViewWithFullPath() {
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String view1DDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW T2(d, e, f) AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        String view2DDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW T3(x, y, z) AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(view1DDL);
        this.tableEnv().executeSql(view2DDL);
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T1", "T2", "T3"})));
        this.tableEnv().executeSql("DROP VIEW default_catalog.default_database.T2");
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T1", "T3"})));
        this.tableEnv().executeSql("DROP VIEW default_catalog.default_database.T3");
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T1"})));
    }

    @Test
    public void testDropViewWithPartialPath() {
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String view1DDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW T2(d, e, f) AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        String view2DDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW T3(x, y, z) AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(view1DDL);
        this.tableEnv().executeSql(view2DDL);
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T1", "T2", "T3"})));
        this.tableEnv().executeSql("DROP VIEW T2");
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T1", "T3"})));
        this.tableEnv().executeSql("DROP VIEW default_database.T3");
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T1"})));
    }

    @Test
    public void testDropViewIfExistsTwice() {
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String viewDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW T2(d, e, f) AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(viewDDL);
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T1", "T2"})));
        this.tableEnv().executeSql("DROP VIEW IF EXISTS default_catalog.default_database.T2");
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T1"})));
        this.tableEnv().executeSql("DROP VIEW IF EXISTS default_catalog.default_database.T2");
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T1"})));
    }

    @Test(expected=ValidationException.class)
    public void testDropViewTwice() {
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String viewDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW T2(d, e, f) AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(viewDDL);
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T1", "T2"})));
        this.tableEnv().executeSql("DROP VIEW default_catalog.default_database.T2");
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T1"})));
        this.tableEnv().executeSql("DROP VIEW default_catalog.default_database.T2");
    }

    @Test(expected=ValidationException.class)
    public void testDropViewWithInvalidPath() {
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String viewDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW T2(d, e, f) AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(viewDDL);
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T1", "T2"})));
        this.tableEnv().executeSql("DROP VIEW default_catalog1.default_database1.T2");
    }

    @Test
    public void testDropViewWithInvalidPathIfExists() {
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String viewDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW T2(d, e, f) AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(viewDDL);
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T1", "T2"})));
        this.tableEnv().executeSql("DROP VIEW IF EXISTS default_catalog1.default_database1.T2");
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTables()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T1", "T2"})));
    }

    @Test
    public void testDropTemporaryViewIfExistsTwice() {
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int,\n        |  b varchar,\n        |  c int\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String viewDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY VIEW T2(d, e, f) AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(viewDDL);
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTemporaryViews()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T2"})));
        this.tableEnv().executeSql("DROP TEMPORARY VIEW IF EXISTS default_catalog.default_database.T2");
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTemporaryViews()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)))));
        this.tableEnv().executeSql("DROP TEMPORARY VIEW IF EXISTS default_catalog.default_database.T2");
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTemporaryViews()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)))));
    }

    @Test(expected=ValidationException.class)
    public void testDropTemporaryViewTwice() {
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  a int not null,\n        |  b varchar,\n        |  c int,\n        |  ts AS to_timestamp(b),\n        |  WATERMARK FOR ts AS ts - INTERVAL '1' SECOND\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String viewDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY VIEW T2(d, e, f) AS SELECT a, b, c FROM T1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(viewDDL);
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTemporaryViews()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T2"})));
        this.tableEnv().executeSql("DROP TEMPORARY VIEW default_catalog.default_database.T2");
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.tableEnv().listTemporaryViews()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)))));
        this.tableEnv().executeSql("DROP TEMPORARY VIEW default_catalog.default_database.T2");
    }

    @Test
    public void testExecuteSqlWithShowViews() {
        String createTableStmt = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE tbl1 (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult1 = this.tableEnv().executeSql(createTableStmt);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        TableResult tableResult2 = this.tableEnv().executeSql("CREATE VIEW view1 AS SELECT * FROM tbl1");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult2.getResultKind());
        TableResult tableResult3 = this.tableEnv().executeSql("SHOW VIEWS");
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult3.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"view name", (DataType)DataTypes.STRING())}), (Object)tableResult3.getResolvedSchema());
        this.checkData(Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{"view1"})}).iterator(), (Iterator<Row>)tableResult3.collect());
        TableResult tableResult4 = this.tableEnv().executeSql("CREATE TEMPORARY VIEW view2 AS SELECT * FROM tbl1");
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult4.getResultKind());
        TableResult tableResult5 = this.tableEnv().executeSql("SHOW VIEWS");
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult5.getResultKind());
        this.checkData(Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{"view1"}), Row.of((Object[])new Object[]{"view2"})}).iterator(), (Iterator<Row>)tableResult5.collect());
    }

    @Test
    public void testExecuteSqlWithExplainSelect() {
        String createTableStmt = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE MyTable (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult1 = this.tableEnv().executeSql(createTableStmt);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        this.checkExplain("explain plan for select * from MyTable where a > 10", "/explain/testExecuteSqlWithExplainSelect.out");
    }

    @Test
    public void testExecuteSqlWithExplainInsert() {
        String createTableStmt1 = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE MyTable (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult1 = this.tableEnv().executeSql(createTableStmt1);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        String createTableStmt2 = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE MySink (\n        |  d bigint,\n        |  e int\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult2 = this.tableEnv().executeSql(createTableStmt2);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult2.getResultKind());
        this.checkExplain("explain plan for insert into MySink select a, b from MyTable where a > 10", "/explain/testExecuteSqlWithExplainInsert.out");
        this.checkExplain("explain plan for insert into MySink(d) select a from MyTable where a > 10", "/explain/testExecuteSqlWithExplainInsertPartialColumn.out");
    }

    @Test
    public void testExecuteSqlWithUnsupportedExplain() {
        String createTableStmt = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE MyTable (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult1 = this.tableEnv().executeSql(createTableStmt);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        this.testUnsupportedExplain("explain plan excluding attributes for select * from MyTable");
        this.testUnsupportedExplain("explain plan including all attributes for select * from MyTable");
        this.testUnsupportedExplain("explain plan with type for select * from MyTable");
        this.testUnsupportedExplain("explain plan without implementation for select * from MyTable");
        this.testUnsupportedExplain("explain plan as xml for select * from MyTable");
        this.testUnsupportedExplain("explain plan as json for select * from MyTable");
    }

    @Test
    public void testExplainSqlWithSelect() {
        String createTableStmt = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE MyTable (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult1 = this.tableEnv().executeSql(createTableStmt);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        String actual = this.tableEnv().explainSql("select * from MyTable where a > 10", new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE});
        String expected = TableTestUtil$.MODULE$.readFromResource("/explain/testExplainSqlWithSelect.out");
        Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(expected), (Object)TableTestUtil$.MODULE$.replaceStageId(actual));
    }

    @Test
    public void testExplainSqlWithInsert() {
        String createTableStmt1 = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE MyTable (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult1 = this.tableEnv().executeSql(createTableStmt1);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        String createTableStmt2 = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE MySink (\n        |  d bigint,\n        |  e int\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult2 = this.tableEnv().executeSql(createTableStmt2);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult2.getResultKind());
        String actual = this.tableEnv().explainSql("insert into MySink select a, b from MyTable where a > 10", new ExplainDetail[0]);
        String expected = TableTestUtil$.MODULE$.readFromResource("/explain/testExplainSqlWithInsert.out");
        Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(expected), (Object)TableTestUtil$.MODULE$.replaceStageId(actual));
    }

    @Test
    public void testExecuteSqlWithExplainDetailsSelect() {
        String createTableStmt = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE MyTable (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult1 = this.tableEnv().executeSql(createTableStmt);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        this.checkExplain("explain changelog_mode, estimated_cost, json_execution_plan select * from MyTable where a > 10", "/explain/testExecuteSqlWithExplainDetailsSelect.out");
    }

    @Test
    public void testExecuteSqlWithExplainDetailsAndUnion() {
        String createTableStmt = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE MyTable (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult1 = this.tableEnv().executeSql(createTableStmt);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        String createTableStmt2 = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE MyTable2 (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult3 = this.tableEnv().executeSql(createTableStmt2);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult3.getResultKind());
        this.checkExplain("explain changelog_mode, estimated_cost, json_execution_plan select * from MyTable union all select * from MyTable2", "/explain/testExecuteSqlWithExplainDetailsAndUnion.out");
    }

    @Test
    public void testExecuteSqlWithExplainDetailsInsert() {
        String createTableStmt1 = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE MyTable (\n        |  a bigint,\n        |  b int,\n        |  c varchar\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult1 = this.tableEnv().executeSql(createTableStmt1);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult1.getResultKind());
        String createTableStmt2 = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE MySink (\n        |  d bigint,\n        |  e int\n        |) with (\n        |  'connector' = 'COLLECTION',\n        |  'is-bounded' = 'false'\n        |)\n      ")).stripMargin();
        TableResult tableResult2 = this.tableEnv().executeSql(createTableStmt2);
        Assert.assertEquals((Object)ResultKind.SUCCESS, (Object)tableResult2.getResultKind());
        this.checkExplain("explain changelog_mode, estimated_cost, json_execution_plan insert into MySink select a, b from MyTable where a > 10", "/explain/testExecuteSqlWithExplainDetailsInsert.out");
    }

    private void testUnsupportedExplain(String explain2) {
        try {
            this.tableEnv().executeSql(explain2);
            Assert.fail((String)"This should not happen");
        }
        catch (Throwable throwable) {
            Assert.fail((String)new StringBuilder().append((Object)"This should not happen, ").append((Object)throwable.getMessage()).toString());
        }
        catch (SqlParserException sqlParserException) {
            Assert.assertTrue((boolean)sqlParserException.getMessage().contains("Was expecting:\n    \"FOR\" ..."));
        }
        catch (TableException tableException) {
            Assert.assertTrue((boolean)tableException.getMessage().contains("Only default behavior is supported now"));
        }
    }

    @Test
    public void testDescribeTableOrView() {
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T1(\n        |  f0 char(10),\n        |  f1 varchar(10),\n        |  f2 string,\n        |  f3 BOOLEAN,\n        |  f4 BINARY(10),\n        |  f5 VARBINARY(10),\n        |  f6 BYTES,\n        |  f7 DECIMAL(10, 3),\n        |  f8 TINYINT,\n        |  f9 SMALLINT,\n        |  f10 INTEGER,\n        |  f11 BIGINT,\n        |  f12 FLOAT,\n        |  f13 DOUBLE,\n        |  f14 DATE,\n        |  f15 TIME,\n        |  f16 TIMESTAMP,\n        |  f17 TIMESTAMP(3),\n        |  f18 TIMESTAMP WITHOUT TIME ZONE,\n        |  f19 TIMESTAMP(3) WITH LOCAL TIME ZONE,\n        |  f20 TIMESTAMP WITH LOCAL TIME ZONE,\n        |  f21 ARRAY<INT>,\n        |  f22 MAP<INT, STRING>,\n        |  f23 ROW<f0 INT, f1 STRING>,\n        |  f24 int not null,\n        |  f25 varchar not null,\n        |  f26 row<f0 int not null, f1 int> not null,\n        |  f27 AS LOCALTIME,\n        |  f28 AS CURRENT_TIME,\n        |  f29 AS LOCALTIMESTAMP,\n        |  f30 AS CURRENT_TIMESTAMP,\n        |  f31 AS CURRENT_ROW_TIMESTAMP(),\n        |  ts AS to_timestamp(f25),\n        |  PRIMARY KEY(f24, f26) NOT ENFORCED,\n        |  WATERMARK FOR ts AS ts - INTERVAL '1' SECOND\n        |) with (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin();
        String viewDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW IF NOT EXISTS T2(d, e, f) AS SELECT f24, f25, f26 FROM T1\n      ")).stripMargin();
        this.tableEnv().executeSql(sourceDDL);
        this.tableEnv().executeSql(viewDDL);
        List<Object> expectedResult1 = Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{"f0", "CHAR(10)", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f1", "VARCHAR(10)", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f2", "STRING", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f3", "BOOLEAN", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f4", "BINARY(10)", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f5", "VARBINARY(10)", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f6", "BYTES", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f7", "DECIMAL(10, 3)", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f8", "TINYINT", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f9", "SMALLINT", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f10", "INT", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f11", "BIGINT", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f12", "FLOAT", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f13", "DOUBLE", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f14", "DATE", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f15", "TIME(0)", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f16", "TIMESTAMP(6)", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f17", "TIMESTAMP(3)", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f18", "TIMESTAMP(6)", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f19", "TIMESTAMP_LTZ(3)", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f20", "TIMESTAMP_LTZ(6)", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f21", "ARRAY<INT>", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f22", "MAP<INT, STRING>", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f23", "ROW<`f0` INT, `f1` STRING>", BoxesRunTime.boxToBoolean((boolean)true), null, null, null}), Row.of((Object[])new Object[]{"f24", "INT", BoxesRunTime.boxToBoolean((boolean)false), "PRI(f24, f26)", null, null}), Row.of((Object[])new Object[]{"f25", "STRING", BoxesRunTime.boxToBoolean((boolean)false), null, null, null}), Row.of((Object[])new Object[]{"f26", "ROW<`f0` INT NOT NULL, `f1` INT>", BoxesRunTime.boxToBoolean((boolean)false), "PRI(f24, f26)", null, null}), Row.of((Object[])new Object[]{"f27", "TIME(0)", BoxesRunTime.boxToBoolean((boolean)false), null, "AS LOCALTIME", null}), Row.of((Object[])new Object[]{"f28", "TIME(0)", BoxesRunTime.boxToBoolean((boolean)false), null, "AS CURRENT_TIME", null}), Row.of((Object[])new Object[]{"f29", "TIMESTAMP(3)", BoxesRunTime.boxToBoolean((boolean)false), null, "AS LOCALTIMESTAMP", null}), Row.of((Object[])new Object[]{"f30", "TIMESTAMP_LTZ(3)", BoxesRunTime.boxToBoolean((boolean)false), null, "AS CURRENT_TIMESTAMP", null}), Row.of((Object[])new Object[]{"f31", "TIMESTAMP_LTZ(3)", BoxesRunTime.boxToBoolean((boolean)false), null, "AS CURRENT_ROW_TIMESTAMP()", null}), Row.of((Object[])new Object[]{"ts", "TIMESTAMP(3) *ROWTIME*", BoxesRunTime.boxToBoolean((boolean)true), null, "AS TO_TIMESTAMP(`f25`)", "`ts` - INTERVAL '1' SECOND"})});
        TableResult tableResult1 = this.tableEnv().executeSql("describe T1");
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult1.getResultKind());
        this.checkData(expectedResult1.iterator(), (Iterator<Row>)tableResult1.collect());
        TableResult tableResult2 = this.tableEnv().executeSql("desc T1");
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult2.getResultKind());
        this.checkData(expectedResult1.iterator(), (Iterator<Row>)tableResult2.collect());
        List<Object> expectedResult2 = Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{"d", "INT", BoxesRunTime.boxToBoolean((boolean)false), null, null, null}), Row.of((Object[])new Object[]{"e", "STRING", BoxesRunTime.boxToBoolean((boolean)false), null, null, null}), Row.of((Object[])new Object[]{"f", "ROW<`f0` INT NOT NULL, `f1` INT>", BoxesRunTime.boxToBoolean((boolean)false), null, null, null})});
        TableResult tableResult3 = this.tableEnv().executeSql("describe T2");
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult3.getResultKind());
        this.checkData(expectedResult2.iterator(), (Iterator<Row>)tableResult3.collect());
        TableResult tableResult4 = this.tableEnv().executeSql("desc T2");
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult4.getResultKind());
        this.checkData(expectedResult2.iterator(), (Iterator<Row>)tableResult4.collect());
        String temporaryViewDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY VIEW IF NOT EXISTS T2(x, y) AS SELECT f24, f25 FROM T1\n      ")).stripMargin();
        this.tableEnv().executeSql(temporaryViewDDL);
        List<Object> expectedResult3 = Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{"x", "INT", BoxesRunTime.boxToBoolean((boolean)false), null, null, null}), Row.of((Object[])new Object[]{"y", "STRING", BoxesRunTime.boxToBoolean((boolean)false), null, null, null})});
        TableResult tableResult5 = this.tableEnv().executeSql("describe T2");
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult5.getResultKind());
        this.checkData(expectedResult3.iterator(), (Iterator<Row>)tableResult5.collect());
        TableResult tableResult6 = this.tableEnv().executeSql("desc T2");
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult6.getResultKind());
        this.checkData(expectedResult3.iterator(), (Iterator<Row>)tableResult6.collect());
    }

    private void checkData(Iterator<Row> expected, Iterator<Row> actual) {
        while (expected.hasNext() && actual.hasNext()) {
            Assert.assertEquals((Object)expected.next(), (Object)actual.next());
        }
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expected.hasNext()), (Object)BoxesRunTime.boxToBoolean((boolean)actual.hasNext()));
    }

    private void validateShowModules(Seq<Tuple2<String, Boolean>> expectedEntries) {
        TableResult showModules = this.tableEnv().executeSql("SHOW MODULES");
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)showModules.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"module name", (DataType)DataTypes.STRING())}), (Object)showModules.getResolvedSchema());
        TableResult showFullModules = this.tableEnv().executeSql("SHOW FULL MODULES");
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)showFullModules.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.physical((String[])((String[])((Object[])new String[]{"module name", "used"})), (DataType[])((DataType[])((Object[])new DataType[]{DataTypes.STRING(), DataTypes.BOOLEAN()}))), (Object)showFullModules.getResolvedSchema());
        this.checkData((Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(((IterableLike)((TraversableLike)expectedEntries.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Boolean> entry) {
                return Predef$.MODULE$.Boolean2boolean((Boolean)entry._2());
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Tuple2<String, Boolean> entry) {
                return Row.of((Object[])new Object[]{entry._1()});
            }
        }, Seq$.MODULE$.canBuildFrom())).iterator()).asJava(), (Iterator<Row>)showModules.collect());
        this.checkData((Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(((IterableLike)expectedEntries.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Tuple2<String, Boolean> entry) {
                return Row.of((Object[])new Object[]{entry._1(), entry._2()});
            }
        }, Seq$.MODULE$.canBuildFrom())).iterator()).asJava(), (Iterator<Row>)showFullModules.collect());
    }

    private void checkListModules(Seq<String> expected) {
        String[] actual = this.tableEnv().listModules();
        ((TraversableLike)expected.zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$1) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, actual){
            public static final long serialVersionUID = 0L;
            private final String[] actual$1;

            public final void apply(Tuple2<String, Object> x$2) {
                Tuple2<String, Object> tuple2 = x$2;
                if (tuple2 != null) {
                    String module = (String)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Assert.assertEquals((Object)module, (Object)this.actual$1[i]);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.actual$1 = actual$1;
            }
        });
    }

    private void checkListFullModules(Seq<Tuple2<String, Boolean>> expected) {
        ModuleEntry[] actual = this.tableEnv().listFullModules();
        ((TraversableLike)expected.zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Tuple2<String, Boolean>, Object> check$ifrefutable$2) {
                Tuple2<Tuple2<String, Boolean>, Object> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, actual){
            public static final long serialVersionUID = 0L;
            private final ModuleEntry[] actual$2;

            public final void apply(Tuple2<Tuple2<String, Boolean>, Object> x$3) {
                Tuple2<Tuple2<String, Boolean>, Object> tuple2 = x$3;
                if (tuple2 != null) {
                    Tuple2 elem = (Tuple2)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Assert.assertEquals((Object)new ModuleEntry((String)elem._1(), Predef$.MODULE$.Boolean2boolean((Boolean)elem._2())), (Object)this.actual$2[i]);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.actual$2 = actual$2;
            }
        });
    }

    private void checkTableSource(String tableName, Boolean expectToBeBounded) {
        CatalogBaseTable resolvedCatalogTable = ((Catalog)this.tableEnv().getCatalog(this.tableEnv().getCurrentCatalog()).get()).getTable(ObjectPath.fromString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableEnv().getCurrentDatabase(), tableName}))));
        TableSourceFactoryContextImpl context = new TableSourceFactoryContextImpl(ObjectIdentifier.of((String)this.tableEnv().getCurrentCatalog(), (String)this.tableEnv().getCurrentDatabase(), (String)tableName), (CatalogTable)resolvedCatalogTable, (ReadableConfig)new Configuration(), false);
        TableSource source = TableFactoryUtil.findAndCreateTableSource((TableSourceFactory.Context)context);
        Assert.assertTrue((boolean)(source instanceof TestCollectionTableFactory.CollectionTableSource));
        Assert.assertEquals((Object)expectToBeBounded, (Object)BoxesRunTime.boxToBoolean((boolean)((TestCollectionTableFactory.CollectionTableSource)source).isBounded()));
    }

    private void checkExplain(String sql, String resultPath) {
        TableResult tableResult2 = this.tableEnv().executeSql(sql);
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult2.getResultKind());
        CloseableIterator it = tableResult2.collect();
        Assert.assertTrue((boolean)it.hasNext());
        Row row2 = (Row)it.next();
        Assert.assertEquals((long)1L, (long)row2.getArity());
        String actual = TableTestUtil$.MODULE$.replaceStreamNodeId(row2.getField(0).toString().trim());
        String expected = TableTestUtil$.MODULE$.replaceStreamNodeId(TableTestUtil$.MODULE$.readFromResource(resultPath).trim());
        Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(expected), (Object)TableTestUtil$.MODULE$.replaceStageId(actual));
        Assert.assertFalse((boolean)it.hasNext());
    }
}

