/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.aggfunctions;

import java.math.BigDecimal;
import java.math.MathContext;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.aggfunctions.DecimalAvgAccumulator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u001f\t)B)Z2j[\u0006d\u0017I^4BO\u001e4UO\\2uS>t'BA\u0002\u0005\u00031\twm\u001a4v]\u000e$\u0018n\u001c8t\u0015\t)a!A\u0005gk:\u001cG/[8og*\u0011q\u0001C\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u0013)\tQA\u001a7j].T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\u0011\t\"\u0003\u0006\u000f\u000e\u0003\u0011I!a\u0005\u0003\u0003#\u0005;wM]3hCR,g)\u001e8di&|g\u000e\u0005\u0002\u001655\taC\u0003\u0002\u00181\u0005!Q.\u0019;i\u0015\u0005I\u0012\u0001\u00026bm\u0006L!a\u0007\f\u0003\u0015\tKw\rR3dS6\fG\u000e\u0005\u0002\u001e=5\t!!\u0003\u0002 \u0005\t)B)Z2j[\u0006d\u0017I^4BG\u000e,X.\u001e7bi>\u0014\b\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002\u000f\r|g\u000e^3yiB\u0011QcI\u0005\u0003IY\u00111\"T1uQ\u000e{g\u000e^3yi\")a\u0005\u0001C\u0001O\u00051A(\u001b8jiz\"\"\u0001K\u0015\u0011\u0005u\u0001\u0001\"B\u0011&\u0001\u0004\u0011\u0003\"B\u0016\u0001\t\u0003b\u0013!E2sK\u0006$X-Q2dk6,H.\u0019;peR\tA\u0004C\u0003/\u0001\u0011\u0005q&\u0001\u0006bG\u000e,X.\u001e7bi\u0016$2\u0001\r\u001c9!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u0011)f.\u001b;\t\u000b]j\u0003\u0019\u0001\u000f\u0002\u0007\u0005\u001c7\rC\u0003:[\u0001\u0007!(A\u0003wC2,X\r\u0005\u00022w%\u0011AH\r\u0002\u0004\u0003:L\b\"\u0002 \u0001\t\u0003y\u0014a\u0002:fiJ\f7\r\u001e\u000b\u0004a\u0001\u000b\u0005\"B\u001c>\u0001\u0004a\u0002\"B\u001d>\u0001\u0004Q\u0004\"B\"\u0001\t\u0003\"\u0015\u0001C4fiZ\u000bG.^3\u0015\u0005Q)\u0005\"B\u001cC\u0001\u0004a\u0002\"B$\u0001\t\u0003A\u0015!B7fe\u001e,Gc\u0001\u0019J\u0015\")qG\u0012a\u00019!)1J\u0012a\u0001\u0019\u0006\u0019\u0011\u000e^:\u0011\u00075\u0003F$D\u0001O\u0015\ty\u0005$\u0001\u0003mC:<\u0017BA)O\u0005!IE/\u001a:bE2,\u0007\"B*\u0001\t\u0003!\u0016\u0001\u0005:fg\u0016$\u0018iY2v[Vd\u0017\r^8s)\t\u0001T\u000bC\u00038%\u0002\u0007A\u0004C\u0003X\u0001\u0011\u0005\u0003,\u0001\nhKR\f5mY;nk2\fGo\u001c:UsB,G#A-\u0011\u0007i\u000bG$D\u0001\\\u0015\taV,\u0001\u0005usB,\u0017N\u001c4p\u0015\tqv,\u0001\u0004d_6lwN\u001c\u0006\u0003A\"\t1!\u00199j\u0013\t\u00117LA\bUsB,\u0017J\u001c4pe6\fG/[8o\u0001")
public class DecimalAvgAggFunction
extends AggregateFunction<BigDecimal, DecimalAvgAccumulator> {
    private final MathContext context;

    public DecimalAvgAccumulator createAccumulator() {
        return new DecimalAvgAccumulator();
    }

    public void accumulate(DecimalAvgAccumulator acc, Object value) {
        if (value != null) {
            BigDecimal v = (BigDecimal)value;
            acc.f0 = ((BigDecimal)acc.f0).add(v);
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) + 1L));
        }
    }

    public void retract(DecimalAvgAccumulator acc, Object value) {
        if (value != null) {
            BigDecimal v = (BigDecimal)value;
            acc.f0 = ((BigDecimal)acc.f0).subtract(v);
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) - 1L));
        }
    }

    public BigDecimal getValue(DecimalAvgAccumulator acc) {
        return BoxesRunTime.unboxToLong((Object)acc.f1) == 0L ? null : ((BigDecimal)acc.f0).divide(BigDecimal.valueOf(BoxesRunTime.unboxToLong((Object)acc.f1)), this.context);
    }

    public void merge(DecimalAvgAccumulator acc, Iterable<DecimalAvgAccumulator> its) {
        for (DecimalAvgAccumulator a : its) {
            acc.f0 = ((BigDecimal)acc.f0).add((BigDecimal)a.f0);
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) + BoxesRunTime.unboxToLong((Object)a.f1)));
        }
    }

    public void resetAccumulator(DecimalAvgAccumulator acc) {
        acc.f0 = BigDecimal.ZERO;
        acc.f1 = BoxesRunTime.boxToLong((long)0L);
    }

    public TypeInformation<DecimalAvgAccumulator> getAccumulatorType() {
        return new TupleTypeInfo(DecimalAvgAccumulator.class, new TypeInformation[]{BasicTypeInfo.BIG_DEC_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
    }

    public DecimalAvgAggFunction(MathContext context) {
        this.context = context;
    }
}

