/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.file.testutils.catalog;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.connector.file.table.FileSystemConnectorOptions;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogPropertiesUtil;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogMaterializedTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionAlreadyExistsException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionSpecInvalidException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.exceptions.TablePartitionedException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.expressions.DefaultSqlFactory;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.SqlFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.file.testutils.TestFileSystemTableFactory;
import org.apache.flink.table.file.testutils.catalog.JsonSerdeUtil;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class TestFileSystemCatalog
extends AbstractCatalog {
    public static final String SCHEMA_PATH = "schema";
    public static final String DATA_PATH = "data";
    private static final String SCHEMA_FILE_EXTENSION = ".json";
    private final String catalogPathStr;
    private Path catalogPath;
    private FileSystem fs;

    public TestFileSystemCatalog(String pathStr, String name, String defaultDatabase) {
        super(name, defaultDatabase);
        this.catalogPathStr = pathStr;
    }

    @VisibleForTesting
    public String getCatalogPathStr() {
        return this.catalogPathStr;
    }

    public Optional<Factory> getFactory() {
        return Optional.of(new TestFileSystemTableFactory());
    }

    public void open() throws CatalogException {
        try {
            this.catalogPath = new Path(this.catalogPathStr);
            this.fs = this.catalogPath.getFileSystem();
            if (!this.fs.exists(this.catalogPath)) {
                throw new CatalogException(String.format("Catalog %s path %s does not exist.", this.getName(), this.catalogPath));
            }
            if (!this.fs.getFileStatus(this.catalogPath).isDir()) {
                throw new CatalogException(String.format("Failed to open catalog path. The given path %s is not a directory.", this.catalogPath));
            }
        }
        catch (IOException e) {
            throw new CatalogException(String.format("Checking catalog path %s exists occur exception.", this.catalogPath), (Throwable)e);
        }
    }

    public void close() throws CatalogException {
    }

    public List<String> listDatabases() throws CatalogException {
        try {
            FileStatus[] fileStatuses = this.fs.listStatus(this.catalogPath);
            return Arrays.stream(fileStatuses).filter(FileStatus::isDir).map(fileStatus -> fileStatus.getPath().getName()).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new CatalogException("Listing database occur exception.", (Throwable)e);
        }
    }

    public CatalogDatabase getDatabase(String databaseName) throws DatabaseNotExistException, CatalogException {
        if (this.databaseExists(databaseName)) {
            return new CatalogDatabaseImpl(Collections.emptyMap(), null);
        }
        throw new DatabaseNotExistException(this.getName(), databaseName);
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"The database name cannot be null or empty.");
        return this.listDatabases().contains(databaseName);
    }

    public void createDatabase(String name, CatalogDatabase database, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        if (this.databaseExists(name)) {
            if (ignoreIfExists) {
                return;
            }
            throw new DatabaseAlreadyExistException(this.getName(), name);
        }
        if (!CollectionUtil.isNullOrEmpty((Map)database.getProperties())) {
            throw new CatalogException("TestFilesystem catalog doesn't support to create database with options.");
        }
        Path dbPath = new Path(this.catalogPath, name);
        try {
            this.fs.mkdirs(dbPath);
        }
        catch (IOException e) {
            throw new CatalogException(String.format("Creating database %s occur exception.", name), (Throwable)e);
        }
    }

    public void dropDatabase(String databaseName, boolean ignoreIfNotExists, boolean cascade) throws DatabaseNotExistException, DatabaseNotEmptyException, CatalogException {
        if (!this.databaseExists(databaseName)) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        List<String> tables = this.listTables(databaseName);
        if (!tables.isEmpty() && !cascade) {
            throw new DatabaseNotEmptyException(this.getName(), databaseName);
        }
        if (databaseName.equals(this.getDefaultDatabase())) {
            throw new IllegalArgumentException("TestFilesystem catalog doesn't support to drop the default database.");
        }
        Path dbPath = new Path(this.catalogPath, databaseName);
        try {
            this.fs.delete(dbPath, true);
        }
        catch (IOException e) {
            throw new CatalogException(String.format("Dropping database %s occur exception.", databaseName), (Throwable)e);
        }
    }

    public void alterDatabase(String name, CatalogDatabase newDatabase, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        throw new UnsupportedOperationException("alterDatabase is not implemented.");
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        Path dbPath = new Path(this.catalogPath, databaseName);
        try {
            return Arrays.stream(this.fs.listStatus(dbPath)).filter(FileStatus::isDir).map(fileStatus -> fileStatus.getPath().getName()).filter(name -> this.tableExists(new ObjectPath(databaseName, name))).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new CatalogException(String.format("Listing table in database %s occur exception.", dbPath), (Throwable)e);
        }
    }

    public List<String> listViews(String databaseName) throws DatabaseNotExistException, CatalogException {
        return Collections.emptyList();
    }

    public CatalogBaseTable getTable(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        Path tableSchemaPath = this.tableSchemaFilePath(this.inferTableSchemaPath(this.catalogPathStr, tablePath), tablePath.getObjectName());
        Path tableDataPath = this.inferTableDataPath(this.catalogPathStr, tablePath);
        try {
            FileSystemTableInfo tableInfo = JsonSerdeUtil.fromJson(this.readFileUtf8(tableSchemaPath), FileSystemTableInfo.class);
            return this.deserializeTable(tableInfo.getTableKind(), tableInfo.getCatalogTableInfo(), tableDataPath.toString());
        }
        catch (IOException e) {
            throw new CatalogException(String.format("Getting table %s occur exception.", tablePath), (Throwable)e);
        }
    }

    @Internal
    public static boolean isFileSystemTable(Map<String, String> properties) {
        String connector = properties.get(FactoryUtil.CONNECTOR.key());
        return StringUtils.isNullOrWhitespaceOnly((String)connector) || "test-filesystem".equalsIgnoreCase(connector);
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        Path path = this.inferTablePath(this.catalogPathStr, tablePath);
        Path tableSchemaFilePath = this.tableSchemaFilePath(this.inferTableSchemaPath(this.catalogPathStr, tablePath), tablePath.getObjectName());
        try {
            return this.fs.exists(path) && this.fs.exists(tableSchemaFilePath);
        }
        catch (IOException e) {
            throw new CatalogException(String.format("Checking table %s exists occur exception.", tablePath), (Throwable)e);
        }
    }

    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        if (!this.tableExists(tablePath)) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new TableNotExistException(this.getName(), tablePath);
        }
        Path path = this.inferTablePath(this.catalogPathStr, tablePath);
        try {
            this.fs.delete(path, true);
        }
        catch (IOException e) {
            throw new CatalogException(String.format("Dropping table %s occur exception.", tablePath), (Throwable)e);
        }
    }

    public void renameTable(ObjectPath tablePath, String newTableName, boolean ignoreIfNotExists) throws TableNotExistException, TableAlreadyExistException, CatalogException {
        throw new UnsupportedOperationException("renameTable is not implemented.");
    }

    public void createTable(ObjectPath tablePath, CatalogBaseTable catalogTable, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        if (!this.databaseExists(tablePath.getDatabaseName())) {
            throw new DatabaseNotExistException(this.getName(), tablePath.getDatabaseName());
        }
        if (this.tableExists(tablePath)) {
            if (ignoreIfExists) {
                return;
            }
            throw new TableAlreadyExistException(this.getName(), tablePath);
        }
        if (catalogTable instanceof CatalogView) {
            throw new UnsupportedOperationException("TestFilesystem catalog doesn't support to CREATE VIEW.");
        }
        Tuple4<Path, Path, Path, String> tableSchemaTuple = this.getTableJsonInfo(tablePath, catalogTable);
        Path path = (Path)tableSchemaTuple.f0;
        Path tableSchemaPath = (Path)tableSchemaTuple.f1;
        Path tableDataPath = (Path)tableSchemaTuple.f2;
        String jsonSchema = (String)tableSchemaTuple.f3;
        try {
            if (!this.fs.exists(path)) {
                this.fs.mkdirs(path);
            }
            if (!this.fs.exists(tableSchemaPath)) {
                this.fs.mkdirs(tableSchemaPath);
            }
            if (TestFileSystemCatalog.isFileSystemTable(catalogTable.getOptions()) && !this.fs.exists(tableDataPath)) {
                this.fs.mkdirs(tableDataPath);
            }
            Path tableSchemaFilePath = this.tableSchemaFilePath(tableSchemaPath, tablePath.getObjectName());
            try (FSDataOutputStream os = this.fs.create(tableSchemaFilePath, FileSystem.WriteMode.NO_OVERWRITE);){
                os.write(jsonSchema.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            throw new CatalogException(String.format("Create table %s occur exception.", tablePath), (Throwable)e);
        }
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        throw new UnsupportedOperationException("alterTable is not implemented");
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, List<TableChange> tableChanges, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        if (ignoreIfNotExists && !this.tableExists(tablePath)) {
            return;
        }
        Tuple4<Path, Path, Path, String> tableSchemaInfo = this.getTableJsonInfo(tablePath, newTable);
        Path tableSchemaPath = (Path)tableSchemaInfo.f1;
        String jsonSchema = (String)tableSchemaInfo.f3;
        try {
            if (!this.fs.exists(tableSchemaPath)) {
                throw new CatalogException(String.format("Table %s schema file %s doesn't exists.", tablePath, tableSchemaPath));
            }
            Path tableSchemaFilePath = this.tableSchemaFilePath(tableSchemaPath, tablePath.getObjectName());
            try (FSDataOutputStream os = this.fs.create(tableSchemaFilePath, FileSystem.WriteMode.OVERWRITE);){
                os.write(jsonSchema.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            throw new CatalogException(String.format("Altering table %s occur exception.", tablePath), (Throwable)e);
        }
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        return Collections.emptyList();
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, CatalogException {
        return Collections.emptyList();
    }

    public List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath tablePath, List<Expression> filters) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        return Collections.emptyList();
    }

    public CatalogPartition getPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
    }

    public boolean partitionExists(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return false;
    }

    public void createPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition partition, boolean ignoreIfExists) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, PartitionAlreadyExistsException, CatalogException {
        throw new UnsupportedOperationException("createPartition is not implemented.");
    }

    public void dropPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException("dropPartition is not implemented.");
    }

    public void alterPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition newPartition, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException("alterPartition is not implemented.");
    }

    public List<String> listFunctions(String dbName) throws DatabaseNotExistException, CatalogException {
        return Collections.emptyList();
    }

    public CatalogFunction getFunction(ObjectPath functionPath) throws FunctionNotExistException, CatalogException {
        throw new FunctionNotExistException(this.getName(), functionPath);
    }

    public boolean functionExists(ObjectPath functionPath) throws CatalogException {
        return false;
    }

    public void createFunction(ObjectPath functionPath, CatalogFunction function, boolean ignoreIfExists) throws FunctionAlreadyExistException, DatabaseNotExistException, CatalogException {
        throw new UnsupportedOperationException("createFunction is not implemented.");
    }

    public void alterFunction(ObjectPath functionPath, CatalogFunction newFunction, boolean ignoreIfNotExists) throws FunctionNotExistException, CatalogException {
        throw new UnsupportedOperationException("alterFunction is not implemented.");
    }

    public void dropFunction(ObjectPath functionPath, boolean ignoreIfNotExists) throws FunctionNotExistException, CatalogException {
        throw new UnsupportedOperationException("dropFunction is not implemented.");
    }

    public CatalogTableStatistics getTableStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getTableColumnStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public CatalogTableStatistics getPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public void alterTableStatistics(ObjectPath tablePath, CatalogTableStatistics tableStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        throw new UnsupportedOperationException("alterTableStatistics is not implemented.");
    }

    public void alterTableColumnStatistics(ObjectPath tablePath, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException, TablePartitionedException {
        throw new UnsupportedOperationException("alterTableColumnStatistics is not implemented.");
    }

    public void alterPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogTableStatistics partitionStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException("alterPartitionStatistics is not implemented.");
    }

    public void alterPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException("alterPartitionColumnStatistics is not implemented.");
    }

    private Tuple4<Path, Path, Path, String> getTableJsonInfo(ObjectPath tablePath, CatalogBaseTable catalogTable) {
        Path path = this.inferTablePath(this.catalogPathStr, tablePath);
        Path tableSchemaPath = this.inferTableSchemaPath(this.catalogPathStr, tablePath);
        Path tableDataPathStr = this.inferTableDataPath(this.catalogPathStr, tablePath);
        ResolvedCatalogBaseTable resolvedCatalogBaseTable = (ResolvedCatalogBaseTable)catalogTable;
        Map<String, String> catalogTableInfo = this.serializeTable(resolvedCatalogBaseTable);
        CatalogBaseTable.TableKind tableKind = catalogTable.getTableKind();
        FileSystemTableInfo tableInfo = new FileSystemTableInfo(tableKind, catalogTableInfo);
        String jsonSchema = JsonSerdeUtil.toJson(tableInfo);
        return Tuple4.of((Object)path, (Object)tableSchemaPath, (Object)tableDataPathStr, (Object)jsonSchema);
    }

    private String readFileUtf8(Path path) throws IOException {
        try (FSDataInputStream in = path.getFileSystem().open(path);){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            String string = builder.toString();
            return string;
        }
    }

    private Path inferTablePath(String catalogPath, ObjectPath tablePath) {
        return new Path(String.format("%s/%s/%s", catalogPath, tablePath.getDatabaseName(), tablePath.getObjectName()));
    }

    private Path inferTableDataPath(String catalogPath, ObjectPath tablePath) {
        return new Path(String.format("%s/%s/%s/%s", catalogPath, tablePath.getDatabaseName(), tablePath.getObjectName(), DATA_PATH));
    }

    private Path inferTableSchemaPath(String catalogPath, ObjectPath tablePath) {
        return new Path(String.format("%s/%s/%s/%s", catalogPath, tablePath.getDatabaseName(), tablePath.getObjectName(), SCHEMA_PATH));
    }

    private Path tableSchemaFilePath(Path tableSchemaPath, String tableName) {
        return new Path(tableSchemaPath, tableName + "_schema.json");
    }

    private Map<String, String> serializeTable(ResolvedCatalogBaseTable<?> resolvedCatalogBaseTable) {
        DefaultSqlFactory sqlFactory = DefaultSqlFactory.INSTANCE;
        if (resolvedCatalogBaseTable instanceof ResolvedCatalogTable) {
            return CatalogPropertiesUtil.serializeCatalogTable((ResolvedCatalogTable)((ResolvedCatalogTable)resolvedCatalogBaseTable), (SqlFactory)sqlFactory);
        }
        if (resolvedCatalogBaseTable instanceof ResolvedCatalogMaterializedTable) {
            return CatalogPropertiesUtil.serializeCatalogMaterializedTable((ResolvedCatalogMaterializedTable)((ResolvedCatalogMaterializedTable)resolvedCatalogBaseTable), (SqlFactory)sqlFactory);
        }
        throw new IllegalArgumentException("Unknown kind of resolved catalog base table: " + resolvedCatalogBaseTable.getClass());
    }

    private CatalogBaseTable deserializeTable(CatalogBaseTable.TableKind tableKind, Map<String, String> properties, String tableDataPath) {
        if (CatalogBaseTable.TableKind.TABLE == tableKind) {
            CatalogTable catalogTable = CatalogPropertiesUtil.deserializeCatalogTable(properties);
            HashMap<String, String> options = new HashMap<String, String>(catalogTable.getOptions());
            if (TestFileSystemCatalog.isFileSystemTable(catalogTable.getOptions())) {
                options.put(FileSystemConnectorOptions.PATH.key(), tableDataPath);
            }
            return catalogTable.copy(options);
        }
        if (CatalogBaseTable.TableKind.MATERIALIZED_TABLE == tableKind) {
            CatalogMaterializedTable catalogMaterializedTable = CatalogPropertiesUtil.deserializeCatalogMaterializedTable(properties);
            HashMap<String, String> options = new HashMap<String, String>(catalogMaterializedTable.getOptions());
            if (TestFileSystemCatalog.isFileSystemTable(catalogMaterializedTable.getOptions())) {
                options.put(FileSystemConnectorOptions.PATH.key(), tableDataPath);
            }
            return catalogMaterializedTable.copy(options);
        }
        throw new IllegalArgumentException("Unknown catalog base table kind: " + tableKind);
    }

    public static class FileSystemTableInfo {
        private final CatalogBaseTable.TableKind tableKind;
        private final Map<String, String> catalogTableInfo;

        @JsonCreator
        public FileSystemTableInfo(@JsonProperty(value="tableKind") CatalogBaseTable.TableKind tableKind, @JsonProperty(value="catalogTableInfo") Map<String, String> catalogTableInfo) {
            this.tableKind = tableKind;
            this.catalogTableInfo = catalogTableInfo;
        }

        public CatalogBaseTable.TableKind getTableKind() {
            return this.tableKind;
        }

        public Map<String, String> getCatalogTableInfo() {
            return this.catalogTableInfo;
        }
    }
}

