/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.ArgumentTrait;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.StateHint;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.DataTypeExtractor;
import org.apache.flink.table.types.extraction.DataTypeTemplate;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.extraction.FunctionArgumentTemplate;
import org.apache.flink.table.types.extraction.FunctionResultTemplate;
import org.apache.flink.table.types.extraction.FunctionSignatureTemplate;
import org.apache.flink.table.types.extraction.FunctionTemplate;
import org.apache.flink.table.types.extraction.TemplateUtils;
import org.apache.flink.table.types.inference.StaticArgumentTrait;
import org.apache.flink.types.Row;

abstract class BaseMappingExtractor {
    private static final EnumSet<StaticArgumentTrait> SCALAR_TRAITS = EnumSet.of(StaticArgumentTrait.SCALAR);
    protected final DataTypeFactory typeFactory;
    protected final String methodName;
    private final SignatureExtraction signatureExtraction;
    protected final ResultExtraction outputExtraction;
    protected final MethodVerification outputVerification;

    public BaseMappingExtractor(DataTypeFactory typeFactory, String methodName, SignatureExtraction signatureExtraction, ResultExtraction outputExtraction, MethodVerification outputVerification) {
        this.typeFactory = typeFactory;
        this.methodName = methodName;
        this.signatureExtraction = signatureExtraction;
        this.outputExtraction = outputExtraction;
        this.outputVerification = outputVerification;
    }

    Map<FunctionSignatureTemplate, FunctionResultTemplate.FunctionOutputTemplate> extractOutputMapping() {
        try {
            return this.extractResultMappings(this.outputExtraction, FunctionTemplate::getOutputTemplate, this.outputVerification);
        }
        catch (Throwable t) {
            throw ExtractionUtils.extractionError(t, "Error in extracting a signature to output mapping.", new Object[0]);
        }
    }

    static SignatureExtraction createArgumentsFromParametersExtraction(int offset, @Nullable Class<?> contextClass) {
        return (extractor, method) -> {
            List<ArgumentParameter> args = BaseMappingExtractor.extractArgumentParameters(method, offset, contextClass);
            EnumSet<StaticArgumentTrait>[] argumentTraits = BaseMappingExtractor.extractArgumentTraits(args);
            List<FunctionArgumentTemplate> argumentTemplates = BaseMappingExtractor.extractArgumentTemplates(extractor.typeFactory, extractor.getFunctionClass(), args);
            String[] argumentNames = BaseMappingExtractor.extractArgumentNames(method, args);
            boolean[] argumentOptionals = BaseMappingExtractor.extractArgumentOptionals(args);
            return FunctionSignatureTemplate.of(argumentTemplates, method.isVarArgs(), argumentTraits, argumentNames, argumentOptionals);
        };
    }

    static SignatureExtraction createArgumentsFromParametersExtraction(int offset) {
        return BaseMappingExtractor.createArgumentsFromParametersExtraction(offset, null);
    }

    static ResultExtraction createStateFromParametersExtraction() {
        return (extractor, method) -> {
            List<StateParameter> stateParameters = BaseMappingExtractor.extractStateParameters(method);
            return BaseMappingExtractor.createStateTemplateFromParameters(extractor, method, stateParameters);
        };
    }

    static ResultExtraction createStateFromGenericInClassOrParametersExtraction(Class<? extends UserDefinedFunction> baseClass, int genericPos) {
        return (extractor, method) -> {
            List<StateParameter> stateParameters = BaseMappingExtractor.extractStateParameters(method);
            if (stateParameters.isEmpty()) {
                DataType dataType = DataTypeExtractor.extractFromGeneric(extractor.typeFactory, baseClass, genericPos, extractor.getFunctionClass());
                LinkedHashMap<String, FunctionResultTemplate.FunctionStateTemplate.StateInfoTemplate> state = new LinkedHashMap<String, FunctionResultTemplate.FunctionStateTemplate.StateInfoTemplate>();
                state.put("acc", FunctionResultTemplate.FunctionStateTemplate.StateInfoTemplate.of(dataType, null));
                return FunctionResultTemplate.ofState(state);
            }
            return BaseMappingExtractor.createStateTemplateFromParameters(extractor, method, stateParameters);
        };
    }

    protected abstract Set<FunctionTemplate> extractGlobalFunctionTemplates();

    protected abstract Set<FunctionTemplate> extractLocalFunctionTemplates(Method var1);

    protected abstract List<Method> collectMethods(String var1);

    protected abstract Class<?> getFunctionClass();

    protected abstract String getHintType();

    protected static Class<?>[] assembleParameters(@Nullable FunctionResultTemplate.FunctionStateTemplate state, FunctionSignatureTemplate arguments) {
        return (Class[])Stream.concat(Optional.ofNullable(state).map(FunctionResultTemplate.FunctionStateTemplate::toClassList).orElse(List.of()).stream(), arguments.toClassList().stream()).toArray(Class[]::new);
    }

    protected static ValidationException createMethodNotFoundError(String methodName, Class<?>[] parameters, @Nullable Class<?> returnType, String pattern) {
        return ExtractionUtils.extractionError("Considering all hints, the method should comply with the signature:\n%s%s", ExtractionUtils.createMethodSignatureString(methodName, parameters, returnType), pattern.isEmpty() ? "" : "\nPattern: " + pattern);
    }

    protected <T extends FunctionResultTemplate> Map<FunctionSignatureTemplate, T> extractResultMappings(ResultExtraction resultExtraction, Function<FunctionTemplate, FunctionResultTemplate> accessor, @Nullable MethodVerification verification) {
        Set<FunctionTemplate> global = this.extractGlobalFunctionTemplates();
        Set<FunctionResultTemplate> globalResultOnly = TemplateUtils.findResultOnlyTemplates(global, accessor);
        LinkedHashMap collectedMappings = new LinkedHashMap();
        List<Method> methods = this.collectMethods(this.methodName);
        if (methods.isEmpty()) {
            throw ExtractionUtils.extractionError("Could not find a publicly accessible method named '%s'.", this.methodName);
        }
        for (Method method : methods) {
            try {
                Method correctMethod = BaseMappingExtractor.correctVarArgMethod(method);
                Map<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappingsPerMethod = this.collectMethodMappings(correctMethod, global, globalResultOnly, resultExtraction, accessor);
                this.verifyMappingForMethod(correctMethod, collectedMappingsPerMethod, verification);
                collectedMappingsPerMethod.forEach((signature, result) -> this.putMapping(collectedMappings, (FunctionSignatureTemplate)signature, (FunctionResultTemplate)result));
            }
            catch (Throwable t) {
                throw ExtractionUtils.extractionError(t, "Unable to extract a type inference from method:\n%s", method.toString());
            }
        }
        return collectedMappings;
    }

    protected static void checkNoState(@Nullable FunctionResultTemplate.FunctionStateTemplate state) {
        if (state != null) {
            throw ExtractionUtils.extractionError("State is not supported for this kind of function.", new Object[0]);
        }
    }

    protected static void checkSingleState(@Nullable FunctionResultTemplate.FunctionStateTemplate state) {
        if (state == null || state.toClassList().size() != 1) {
            throw ExtractionUtils.extractionError("Aggregating functions need exactly one state entry for the accumulator.", new Object[0]);
        }
    }

    protected static void checkScalarArgumentsOnly(FunctionSignatureTemplate arguments) {
        EnumSet[] argumentTraits = arguments.argumentTraits;
        IntStream.range(0, argumentTraits.length).forEach(pos -> {
            if (!argumentTraits[pos].equals(SCALAR_TRAITS)) {
                throw ExtractionUtils.extractionError("Only scalar arguments are supported at this location. But argument '%s' declared the following traits: %s", arguments.argumentNames[pos], argumentTraits[pos]);
            }
        });
    }

    private static FunctionResultTemplate.FunctionStateTemplate createStateTemplateFromParameters(BaseMappingExtractor extractor, Method method, List<StateParameter> stateParameters) {
        String[] argumentNames = BaseMappingExtractor.extractStateNames(method, stateParameters);
        if (argumentNames == null) {
            throw ExtractionUtils.extractionError("Unable to extract names for all state entries.", new Object[0]);
        }
        List dataTypes = stateParameters.stream().map(s -> DataTypeExtractor.extractFromMethodParameter(extractor.typeFactory, extractor.getFunctionClass(), s.method, s.pos)).collect(Collectors.toList());
        LinkedHashMap state = IntStream.range(0, argumentNames.length).mapToObj(i -> {
            DataType dataType = (DataType)dataTypes.get(i);
            StateHint hint = ((StateParameter)stateParameters.get((int)i)).parameter.getAnnotation(StateHint.class);
            return Map.entry(argumentNames[i], FunctionResultTemplate.FunctionStateTemplate.StateInfoTemplate.of(dataType, hint));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (o, n) -> o, LinkedHashMap::new));
        return FunctionResultTemplate.ofState(state);
    }

    private Map<FunctionSignatureTemplate, FunctionResultTemplate> collectMethodMappings(Method method, Set<FunctionTemplate> global, Set<FunctionResultTemplate> globalResultOnly, ResultExtraction resultExtraction, Function<FunctionTemplate, FunctionResultTemplate> accessor) {
        LinkedHashMap<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappingsPerMethod = new LinkedHashMap<FunctionSignatureTemplate, FunctionResultTemplate>();
        Set<FunctionTemplate> local = this.extractLocalFunctionTemplates(method);
        Set<FunctionResultTemplate> localResultOnly = TemplateUtils.findResultOnlyTemplates(local, accessor);
        Set<FunctionTemplate> explicitMappings = TemplateUtils.findResultMappingTemplates(global, local, accessor);
        FunctionResultTemplate resultOnly = TemplateUtils.findResultOnlyTemplate(globalResultOnly, localResultOnly, explicitMappings, accessor, this.getHintType());
        Set<FunctionSignatureTemplate> inputOnly = TemplateUtils.findInputOnlyTemplates(global, local, accessor);
        this.putExplicitMappings(collectedMappingsPerMethod, explicitMappings, inputOnly, accessor);
        this.putUniqueResultMappings(collectedMappingsPerMethod, resultOnly, inputOnly, method);
        this.putExtractedResultMappings(collectedMappingsPerMethod, inputOnly, resultExtraction, method);
        return collectedMappingsPerMethod;
    }

    private static Method correctVarArgMethod(Method method) {
        int paramCount = method.getParameterCount();
        Class<?>[] paramClasses = method.getParameterTypes();
        if (paramCount > 0 && paramClasses[paramCount - 1].getName().equals("scala.collection.Seq")) {
            Type[] paramTypes = method.getGenericParameterTypes();
            ParameterizedType seqType = (ParameterizedType)paramTypes[paramCount - 1];
            Type varArgType = seqType.getActualTypeArguments()[0];
            return ExtractionUtils.collectMethods(method.getDeclaringClass(), method.getName()).stream().filter(Method::isVarArgs).filter(candidate -> candidate.getParameterCount() == paramCount).filter(candidate -> {
                Type[] candidateParamTypes = candidate.getGenericParameterTypes();
                for (int i = 0; i < paramCount - 1; ++i) {
                    if (candidateParamTypes[i] == paramTypes[i]) continue;
                    return false;
                }
                Class<?> candidateVarArgType = candidate.getParameterTypes()[paramCount - 1];
                return candidateVarArgType.isArray() && (varArgType == Object.class || candidateVarArgType.getComponentType() == varArgType);
            }).findAny().orElse(method);
        }
        return method;
    }

    private void putExplicitMappings(Map<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappings, Set<FunctionTemplate> explicitMappings, Set<FunctionSignatureTemplate> signatureOnly, Function<FunctionTemplate, FunctionResultTemplate> accessor) {
        explicitMappings.forEach(t -> Stream.concat(signatureOnly.stream(), Stream.of(t.getSignatureTemplate())).forEach(v -> this.putMapping(collectedMappings, (FunctionSignatureTemplate)v, (FunctionResultTemplate)accessor.apply((FunctionTemplate)t))));
    }

    private void putUniqueResultMappings(Map<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappings, @Nullable FunctionResultTemplate uniqueResult, Set<FunctionSignatureTemplate> signatureOnly, Method method) {
        if (uniqueResult == null) {
            return;
        }
        if (!signatureOnly.isEmpty()) {
            signatureOnly.forEach(s -> this.putMapping(collectedMappings, (FunctionSignatureTemplate)s, uniqueResult));
        } else {
            this.putMapping(collectedMappings, this.signatureExtraction.extract(this, method), uniqueResult);
        }
    }

    private void putExtractedResultMappings(Map<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappings, Set<FunctionSignatureTemplate> inputOnly, ResultExtraction resultExtraction, Method method) {
        if (!collectedMappings.isEmpty()) {
            return;
        }
        FunctionResultTemplate result = resultExtraction.extract(this, method);
        if (!inputOnly.isEmpty()) {
            inputOnly.forEach(signature -> this.putMapping(collectedMappings, (FunctionSignatureTemplate)signature, result));
        } else {
            FunctionSignatureTemplate signature2 = this.signatureExtraction.extract(this, method);
            this.putMapping(collectedMappings, signature2, result);
        }
    }

    private void putMapping(Map<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappings, FunctionSignatureTemplate signature, FunctionResultTemplate result) {
        FunctionResultTemplate existingResult = collectedMappings.get(signature);
        if (existingResult == null) {
            collectedMappings.put(signature, result);
        } else if (!existingResult.equals(result)) {
            throw ExtractionUtils.extractionError(String.format("%s hints with same input definition but different result types are not allowed.", this.getHintType()), new Object[0]);
        }
    }

    private void verifyMappingForMethod(Method method, Map<FunctionSignatureTemplate, FunctionResultTemplate> collectedMappingsPerMethod, @Nullable MethodVerification verification) {
        if (verification == null) {
            return;
        }
        collectedMappingsPerMethod.forEach((signature, result) -> {
            if (result instanceof FunctionResultTemplate.FunctionStateTemplate) {
                FunctionResultTemplate.FunctionStateTemplate stateTemplate = (FunctionResultTemplate.FunctionStateTemplate)result;
                verification.verify(method, stateTemplate, (FunctionSignatureTemplate)signature, null);
            } else if (result instanceof FunctionResultTemplate.FunctionOutputTemplate) {
                FunctionResultTemplate.FunctionOutputTemplate outputTemplate = (FunctionResultTemplate.FunctionOutputTemplate)result;
                verification.verify(method, null, (FunctionSignatureTemplate)signature, outputTemplate);
            }
        });
    }

    private static List<ArgumentParameter> extractArgumentParameters(Method method, int offset, @Nullable Class<?> contextClass) {
        Parameter[] parameters = method.getParameters();
        return IntStream.range(0, parameters.length).mapToObj(pos -> {
            Parameter parameter = parameters[pos];
            return new ArgumentParameter(parameter, method, pos);
        }).skip(offset).filter(arg -> contextClass == null || arg.parameter.getType() != contextClass).filter(arg -> arg.parameter.getAnnotation(StateHint.class) == null).collect(Collectors.toList());
    }

    private static List<StateParameter> extractStateParameters(Method method) {
        Parameter[] parameters = method.getParameters();
        return IntStream.range(0, parameters.length).mapToObj(pos -> {
            Parameter parameter = parameters[pos];
            return new StateParameter(parameter, method, pos);
        }).filter(arg -> arg.parameter.getAnnotation(StateHint.class) != null).collect(Collectors.toList());
    }

    private static List<FunctionArgumentTemplate> extractArgumentTemplates(DataTypeFactory typeFactory, Class<?> extractedClass, List<ArgumentParameter> args) {
        return args.stream().map(arg -> BaseMappingExtractor.tryExtractInputGroupArgument(arg).orElseGet(() -> BaseMappingExtractor.extractArgumentByKind(typeFactory, extractedClass, arg))).collect(Collectors.toList());
    }

    private static Optional<FunctionArgumentTemplate> tryExtractInputGroupArgument(ArgumentParameter arg) {
        DataTypeHint dataTypehint = arg.parameter.getAnnotation(DataTypeHint.class);
        ArgumentHint argumentHint = arg.parameter.getAnnotation(ArgumentHint.class);
        if (dataTypehint != null && argumentHint != null) {
            throw ExtractionUtils.extractionError("Argument and data type hints cannot be declared at the same time at position %d.", arg.pos);
        }
        if (argumentHint != null) {
            DataTypeTemplate template = DataTypeTemplate.fromAnnotation(argumentHint);
            if (template.inputGroup != null) {
                return Optional.of(FunctionArgumentTemplate.ofInputGroup(template.inputGroup));
            }
        } else if (dataTypehint != null) {
            DataTypeTemplate template = DataTypeTemplate.fromAnnotation(dataTypehint, null);
            if (template.inputGroup != null) {
                return Optional.of(FunctionArgumentTemplate.ofInputGroup(template.inputGroup));
            }
        }
        return Optional.empty();
    }

    private static FunctionArgumentTemplate extractArgumentByKind(DataTypeFactory typeFactory, Class<?> extractedClass, ArgumentParameter arg) {
        Parameter parameter = arg.parameter;
        ArgumentHint argumentHint = parameter.getAnnotation(ArgumentHint.class);
        int pos = arg.pos;
        Set<ArgumentTrait> rootTrait = Optional.ofNullable(argumentHint).map(hint -> Arrays.stream(hint.value()).filter(ArgumentTrait::isRoot).collect(Collectors.toSet())).orElse(Set.of(ArgumentTrait.SCALAR));
        if (rootTrait.size() != 1) {
            throw ExtractionUtils.extractionError("Incorrect argument kind at position %d. Argument kind must be one of: %s", pos, Arrays.stream(ArgumentTrait.values()).filter(ArgumentTrait::isRoot).collect(Collectors.toList()));
        }
        if (rootTrait.contains((Object)ArgumentTrait.SCALAR)) {
            return BaseMappingExtractor.extractScalarArgument(typeFactory, extractedClass, arg);
        }
        if (rootTrait.contains((Object)ArgumentTrait.ROW_SEMANTIC_TABLE) || rootTrait.contains((Object)ArgumentTrait.SET_SEMANTIC_TABLE)) {
            return BaseMappingExtractor.extractTableArgument(typeFactory, argumentHint, extractedClass, arg);
        }
        throw ExtractionUtils.extractionError("Unknown argument kind.", new Object[0]);
    }

    private static FunctionArgumentTemplate extractTableArgument(DataTypeFactory typeFactory, ArgumentHint argumentHint, Class<?> extractedClass, ArgumentParameter arg) {
        try {
            DataType type = DataTypeExtractor.extractFromMethodParameter(typeFactory, extractedClass, arg.method, arg.pos);
            return FunctionArgumentTemplate.ofDataType(type);
        }
        catch (Throwable t) {
            Class<?> paramClass = arg.parameter.getType();
            Class<?> argClass = argumentHint.type().bridgedTo();
            if (argClass == Row.class || argClass == RowData.class) {
                return FunctionArgumentTemplate.ofTable(argClass);
            }
            if (paramClass == Row.class || paramClass == RowData.class) {
                return FunctionArgumentTemplate.ofTable(paramClass);
            }
            throw t;
        }
    }

    private static FunctionArgumentTemplate extractScalarArgument(DataTypeFactory typeFactory, Class<?> extractedClass, ArgumentParameter arg) {
        DataType type = DataTypeExtractor.extractFromMethodParameter(typeFactory, extractedClass, arg.method, arg.pos);
        if (arg.parameter.isVarArgs()) {
            if (type instanceof CollectionDataType) {
                return FunctionArgumentTemplate.ofDataType(((CollectionDataType)type).getElementDataType());
            }
            if (type.equals(DataTypes.BYTES())) {
                return FunctionArgumentTemplate.ofDataType((DataType)((DataType)DataTypes.TINYINT().notNull()).bridgedTo(Byte.TYPE));
            }
        }
        return FunctionArgumentTemplate.ofDataType(type);
    }

    private static EnumSet<StaticArgumentTrait>[] extractArgumentTraits(List<ArgumentParameter> args) {
        return (EnumSet[])args.stream().map(arg -> {
            ArgumentHint argumentHint = arg.parameter.getAnnotation(ArgumentHint.class);
            if (argumentHint == null) {
                return SCALAR_TRAITS;
            }
            List traits = Arrays.stream(argumentHint.value()).map(ArgumentTrait::toStaticTrait).collect(Collectors.toList());
            return EnumSet.copyOf(traits);
        }).toArray(EnumSet[]::new);
    }

    @Nullable
    private static String[] extractArgumentNames(Method method, List<ArgumentParameter> args) {
        List<String> methodParameterNames = ExtractionUtils.extractMethodParameterNames(method);
        if (methodParameterNames != null) {
            return (String[])args.stream().map(arg -> (String)methodParameterNames.get(arg.pos)).toArray(String[]::new);
        }
        return null;
    }

    @Nullable
    private static String[] extractStateNames(Method method, List<StateParameter> state) {
        List<String> methodParameterNames = ExtractionUtils.extractMethodParameterNames(method);
        if (methodParameterNames != null) {
            return (String[])state.stream().map(arg -> (String)methodParameterNames.get(arg.pos)).toArray(String[]::new);
        }
        return null;
    }

    private static boolean[] extractArgumentOptionals(List<ArgumentParameter> args) {
        Boolean[] argumentOptionals = (Boolean[])args.stream().map(arg -> arg.parameter.getAnnotation(ArgumentHint.class)).map(hint -> {
            if (hint == null) {
                return false;
            }
            return hint.isOptional();
        }).toArray(Boolean[]::new);
        return ArrayUtils.toPrimitive((Boolean[])argumentOptionals);
    }

    static interface MethodVerification {
        public void verify(Method var1, @Nullable FunctionResultTemplate.FunctionStateTemplate var2, FunctionSignatureTemplate var3, @Nullable FunctionResultTemplate.FunctionOutputTemplate var4);
    }

    static interface ResultExtraction {
        @Nullable
        public FunctionResultTemplate extract(BaseMappingExtractor var1, Method var2);
    }

    static interface SignatureExtraction {
        public FunctionSignatureTemplate extract(BaseMappingExtractor var1, Method var2);
    }

    private static class StateParameter {
        final Parameter parameter;
        final Method method;
        final int pos;

        private StateParameter(Parameter parameter, Method method, int pos) {
            this.parameter = parameter;
            this.method = method;
            this.pos = pos;
        }
    }

    private static class ArgumentParameter {
        final Parameter parameter;
        final Method method;
        final int pos;

        private ArgumentParameter(Parameter parameter, Method method, int pos) {
            this.parameter = parameter;
            this.method = method;
            this.pos = pos;
        }
    }
}

