/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector.source;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.table.connector.ParallelismProvider;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.data.RowData;

@PublicEvolving
public interface SourceProvider
extends ScanTableSource.ScanRuntimeProvider,
ParallelismProvider {
    public static SourceProvider of(Source<RowData, ?, ?> source) {
        return SourceProvider.of(source, null);
    }

    public static SourceProvider of(final Source<RowData, ?, ?> source, final @Nullable Integer sourceParallelism) {
        return new SourceProvider(){

            @Override
            public Source<RowData, ?, ?> createSource() {
                return source;
            }

            @Override
            public boolean isBounded() {
                return Boundedness.BOUNDED.equals((Object)source.getBoundedness());
            }

            @Override
            public Optional<Integer> getParallelism() {
                return Optional.ofNullable(sourceParallelism);
            }
        };
    }

    public Source<RowData, ?, ?> createSource();
}

